/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.impl.number.parse;

import org.graalvm.shadowed.com.ibm.icu.impl.StaticUnicodeSets;
import org.graalvm.shadowed.com.ibm.icu.impl.StringSegment;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.ParsedNumber;
import org.graalvm.shadowed.com.ibm.icu.impl.number.parse.SymbolMatcher;
import org.graalvm.shadowed.com.ibm.icu.text.DecimalFormatSymbols;

public class PlusSignMatcher
extends SymbolMatcher {
    private static final PlusSignMatcher DEFAULT = new PlusSignMatcher(false);
    private static final PlusSignMatcher DEFAULT_ALLOW_TRAILING = new PlusSignMatcher(true);
    private final boolean allowTrailing;

    public static PlusSignMatcher getInstance(DecimalFormatSymbols symbols, boolean allowTrailing) {
        String symbolString = symbols.getPlusSignString();
        if (PlusSignMatcher.DEFAULT.uniSet.contains(symbolString)) {
            return allowTrailing ? DEFAULT_ALLOW_TRAILING : DEFAULT;
        }
        return new PlusSignMatcher(symbolString, allowTrailing);
    }

    private PlusSignMatcher(String symbolString, boolean allowTrailing) {
        super(symbolString, PlusSignMatcher.DEFAULT.uniSet);
        this.allowTrailing = allowTrailing;
    }

    private PlusSignMatcher(boolean allowTrailing) {
        super(StaticUnicodeSets.Key.PLUS_SIGN);
        this.allowTrailing = allowTrailing;
    }

    @Override
    protected boolean isDisabled(ParsedNumber result2) {
        return !this.allowTrailing && result2.seenNumber();
    }

    @Override
    protected void accept(StringSegment segment, ParsedNumber result2) {
        result2.setCharsConsumed(segment);
    }

    public String toString() {
        return "<PlusSignMatcher>";
    }
}

