/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.CellAttributes;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.FormatClause;
import org.jetbrains.kotlinx.dataframe.api.FormattedFrame;
import org.jetbrains.kotlinx.dataframe.api.FormattingDSL;
import org.jetbrains.kotlinx.dataframe.api.RGBColor;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPathKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u001a \u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0000\u001a0\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0015\u001a\u00020\b*\u00020\u0001H\u0000\u001am\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u0019*\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00190\u001a2A\u0010\u001b\u001a=\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001cj\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u0019`!\u00a2\u0006\u0002\b\"H\u0000\u00a8\u0006#"}, d2={"componentWise", "Lorg/jetbrains/kotlinx/dataframe/api/RGBColor;", "color1", "color2", "f", "Lkotlin/Function2;", "", "encHex", "", "v", "encRgb", "r", "g", "b", "linearGradient", "x", "", "minValue", "minColor", "maxValue", "maxColor", "encode", "formatImpl", "Lorg/jetbrains/kotlinx/dataframe/api/FormattedFrame;", "T", "C", "Lorg/jetbrains/kotlinx/dataframe/api/FormatClause;", "formatter", "Lkotlin/Function3;", "Lorg/jetbrains/kotlinx/dataframe/api/FormattingDSL;", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/api/CellAttributes;", "Lorg/jetbrains/kotlinx/dataframe/api/RowColFormatter;", "Lkotlin/ExtensionFunctionType;", "core"})
@SourceDebugExtension(value={"SMAP\nformat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 format.kt\norg/jetbrains/kotlinx/dataframe/impl/api/FormatKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1603#2,9:65\n1855#2:74\n1856#2:76\n1612#2:77\n1#3:75\n*S KotlinDebug\n*F\n+ 1 format.kt\norg/jetbrains/kotlinx/dataframe/impl/api/FormatKt\n*L\n52#1:65,9\n52#1:74\n52#1:76\n52#1:77\n52#1:75\n*E\n"})
public final class FormatKt {
    @NotNull
    public static final String encRgb(short r, short g, short b) {
        return '#' + FormatKt.encHex(r) + FormatKt.encHex(g) + FormatKt.encHex(b);
    }

    @NotNull
    public static final String encHex(short v) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Integer.toString(v / 16, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        String string2 = Integer.toString(v % 16, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return stringBuilder2.append(string2).toString();
    }

    @NotNull
    public static final String encode(@NotNull RGBColor $this$encode) {
        Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
        return FormatKt.encRgb($this$encode.getR(), $this$encode.getG(), $this$encode.getB());
    }

    @NotNull
    public static final RGBColor componentWise(@NotNull RGBColor color1, @NotNull RGBColor color2, @NotNull Function2<? super Short, ? super Short, Short> f) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color2");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return new RGBColor(((Number)f.invoke((Object)color1.getR(), (Object)color2.getR())).shortValue(), ((Number)f.invoke((Object)color1.getG(), (Object)color2.getG())).shortValue(), ((Number)f.invoke((Object)color1.getB(), (Object)color2.getB())).shortValue());
    }

    @NotNull
    public static final RGBColor linearGradient(double x, double minValue, @NotNull RGBColor minColor, double maxValue, @NotNull RGBColor maxColor) {
        Intrinsics.checkNotNullParameter((Object)minColor, (String)"minColor");
        Intrinsics.checkNotNullParameter((Object)maxColor, (String)"maxColor");
        if (x < minValue) {
            return minColor;
        }
        if (x > maxValue) {
            return maxColor;
        }
        double t = (x - minValue) / (maxValue - minValue);
        return FormatKt.componentWise(minColor, maxColor, (Function2<? super Short, ? super Short, Short>)((Function2)new Function2<Short, Short, Short>(t){
            final /* synthetic */ double $t;
            {
                this.$t = $t;
                super(2);
            }

            @NotNull
            public final Short invoke(short cmin, short cmax) {
                return (short)((double)cmin + this.$t * (double)(cmax - cmin));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> FormattedFrame<T> formatImpl(@NotNull FormatClause<T, C> $this$formatImpl, @NotNull Function3<? super FormattingDSL, ? super DataRow<? extends T>, ? super DataColumn<? extends C>, ? extends CellAttributes> formatter) {
        Set set;
        Intrinsics.checkNotNullParameter($this$formatImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter(formatter, (String)"formatter");
        if ($this$formatImpl.getColumns() != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = DataFrameGetKt.getColumnsWithPaths($this$formatImpl.getDf(), $this$formatImpl.getColumns());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ColumnWithPath it = (ColumnWithPath)element$iv$iv;
                boolean bl2 = false;
                if ((ColumnWithPathKt.getDepth(it) == 0 ? it.getName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = null;
        }
        Set columns2 = set;
        return new FormattedFrame<T>($this$formatImpl.getDf(), (Function3)new Function3<FormattingDSL, DataRow<? extends T>, DataColumn<?>, CellAttributes>($this$formatImpl, columns2, formatter){
            final /* synthetic */ FormatClause<T, C> $this_formatImpl;
            final /* synthetic */ Set<String> $columns;
            final /* synthetic */ Function3<FormattingDSL, DataRow<? extends T>, DataColumn<? extends C>, CellAttributes> $formatter;
            {
                this.$this_formatImpl = $receiver;
                this.$columns = $columns;
                this.$formatter = $formatter;
                super(3);
            }

            @Nullable
            public final CellAttributes invoke(@NotNull FormattingDSL $this$$receiver, @NotNull DataRow<? extends T> row, @NotNull DataColumn<?> col2) {
                CellAttributes cellAttributes;
                CellAttributes oldAttributes;
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                Intrinsics.checkNotNullParameter(row, (String)"row");
                Intrinsics.checkNotNullParameter(col2, (String)"col");
                Function3<FormattingDSL, DataRow<T>, DataColumn<C>, CellAttributes> function3 = this.$this_formatImpl.getOldFormatter();
                CellAttributes cellAttributes2 = oldAttributes = function3 != null ? (CellAttributes)function3.invoke((Object)FormattingDSL.INSTANCE, row, CastKt.cast(col2)) : null;
                if (this.$columns == null || this.$columns.contains(col2.name())) {
                    R value = row.get((ColumnReference)col2);
                    cellAttributes = this.$this_formatImpl.getFilter() == null || ((Boolean)this.$this_formatImpl.getFilter().invoke(row, value)).booleanValue() ? org.jetbrains.kotlinx.dataframe.api.FormatKt.and(oldAttributes, (CellAttributes)this.$formatter.invoke((Object)FormattingDSL.INSTANCE, CastKt.cast(row), CastKt.cast(col2))) : oldAttributes;
                } else {
                    cellAttributes = oldAttributes;
                }
                return cellAttributes;
            }
        });
    }
}

