/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lgit4idea/log/action/GitCreateNewBranchFromCommitAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "collectData", "Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data;", "suggestBranchName", "", "repository", "Lgit4idea/repo/GitRepository;", "branches", "", "Lcom/intellij/vcs/log/VcsRef;", "Data", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCreateNewBranchFromCommitAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCreateNewBranchFromCommitAction.kt\ngit4idea/log/action/GitCreateNewBranchFromCommitAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n774#2:82\n865#2,2:83\n1557#2:85\n1628#2,3:86\n*S KotlinDebug\n*F\n+ 1 GitCreateNewBranchFromCommitAction.kt\ngit4idea/log/action/GitCreateNewBranchFromCommitAction\n*L\n69#1:82\n69#1:83,2\n70#1:85\n70#1:86,3\n*E\n"})
public final class GitCreateNewBranchFromCommitAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Data data2 = this.collectData(e);
        if (data2 instanceof Data.Enabled) {
            Project project = ((Data.Enabled)data2).getRepository().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Collection collection = CollectionsKt.listOf((Object)((Data.Enabled)data2).getRepository());
            String string = ((Data.Enabled)data2).getHash().toString();
            Object[] objectArray = new Object[]{((Data.Enabled)data2).getHash().toShortString()};
            String string2 = GitBundle.message("action.Git.New.Branch.dialog.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(project, collection, string, string2, ((Data.Enabled)data2).getName());
        } else if (!(data2 instanceof Data.Disabled) && !Intrinsics.areEqual((Object)data2, (Object)Data.Invisible.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Data data2 = this.collectData(e);
        if (data2 instanceof Data.Invisible) {
            e.getPresentation().setEnabledAndVisible(false);
        } else if (data2 instanceof Data.Disabled) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription(((Data.Disabled)data2).getDescription());
        } else {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    private final Data collectData(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return Data.Invisible.INSTANCE;
        }
        Project project2 = project;
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(...)");
        GitRepositoryManager manager = gitRepositoryManager;
        if (manager.getRepositories().isEmpty()) {
            return Data.Invisible.INSTANCE;
        }
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (selection != null && VcsLogCommitSelectionUtils.isNotEmpty((VcsLogCommitSelection)selection)) {
            if (VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)selection) > 1) {
                String string = GitBundle.message("action.New.Branch.disabled.several.commits.description", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return new Data.Disabled(string);
            }
            CommitId commit = (CommitId)CollectionsKt.first((List)selection.getCommits());
            GitRepository repository = (GitRepository)manager.getRepositoryForRootQuick(commit.getRoot());
            if (repository != null) {
                String initialName = this.suggestBranchName(repository, (List)e.getData(VcsLogDataKeys.VCS_LOG_BRANCHES));
                Hash hash = commit.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
                return new Data.Enabled(repository, hash, initialName);
            }
        }
        return Data.Invisible.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final String suggestBranchName(GitRepository repository, List<? extends VcsRef> branches) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List list = branches;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsRef it = (VcsRef)element$iv$iv;
            boolean bl = false;
            if (!it.getType().isBranch()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingBranches = (List)destination$iv$iv;
        Iterable $this$map$iv = existingBranches;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GitBranch branch;
            String string;
            void it;
            VcsRef bl = (VcsRef)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            if (repository.getBranches().findBranchByName(it.getName()) == null) {
                string = null;
            } else if (branch.isRemote()) {
                Intrinsics.checkNotNull((Object)branch, (String)"null cannot be cast to non-null type git4idea.GitRemoteBranch");
                string = ((GitRemoteBranch)branch).getNameForRemoteOperations();
            } else {
                string = branch.getName();
            }
            collection.add(string);
        }
        List suggestedNames = (List)destination$iv$iv2;
        return (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)suggestedNames));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data;", "", "<init>", "()V", "Invisible", "Disabled", "Enabled", "Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data$Disabled;", "Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data$Enabled;", "Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data$Invisible;", "intellij.vcs.git"})
    private static abstract class Data {
        private Data() {
        }

        public /* synthetic */ Data(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data$Disabled;", "Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data;", "description", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Disabled
        extends Data {
            @NotNull
            private final String description;

            public Disabled(@NotNull String description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                super(null);
                this.description = description;
            }

            @NotNull
            public final String getDescription() {
                return this.description;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data$Enabled;", "Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data;", "repository", "Lgit4idea/repo/GitRepository;", "hash", "Lcom/intellij/vcs/log/Hash;", "name", "", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/Hash;Ljava/lang/String;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getName", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Enabled
        extends Data {
            @NotNull
            private final GitRepository repository;
            @NotNull
            private final Hash hash;
            @Nullable
            private final String name;

            public Enabled(@NotNull GitRepository repository, @NotNull Hash hash, @Nullable String name) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                super(null);
                this.repository = repository;
                this.hash = hash;
                this.name = name;
            }

            @NotNull
            public final GitRepository getRepository() {
                return this.repository;
            }

            @NotNull
            public final Hash getHash() {
                return this.hash;
            }

            @Nullable
            public final String getName() {
                return this.name;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data$Invisible;", "Lgit4idea/log/action/GitCreateNewBranchFromCommitAction$Data;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git"})
        public static final class Invisible
        extends Data {
            @NotNull
            public static final Invisible INSTANCE = new Invisible();

            private Invisible() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Invisible";
            }

            public int hashCode() {
                return 858783411;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Invisible)) {
                    return false;
                }
                Invisible cfr_ignored_0 = (Invisible)other;
                return true;
            }
        }
    }
}

