/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class FreezableArrayList<T>
extends ArrayList<T> {
    public FreezableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public FreezableArrayList() {
    }

    FreezableArrayList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            FreezableArrayList.$$$reportNull$$$0(0);
        }
        super(c);
    }

    @NotNull
    List<T> freeze() {
        this.modCount = -1;
        FreezableArrayList freezableArrayList = this;
        if (freezableArrayList == null) {
            FreezableArrayList.$$$reportNull$$$0(1);
        }
        return freezableArrayList;
    }

    private void checkForFrozen() {
        if (this.modCount == -1) {
            throw new UnsupportedOperationException("This list is unmodifiable. For a temporary workaround, please run IDE in non-internal mode.");
        }
    }

    @Override
    public T set(int index, T element) {
        this.checkForFrozen();
        return super.set(index, element);
    }

    @Override
    public boolean add(T t) {
        this.checkForFrozen();
        return super.add(t);
    }

    @Override
    public void add(int index, T element) {
        this.checkForFrozen();
        super.add(index, element);
    }

    @Override
    public T remove(int index) {
        this.checkForFrozen();
        return (T)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.checkForFrozen();
        return super.remove(o);
    }

    @Override
    public void clear() {
        this.checkForFrozen();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.checkForFrozen();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.checkForFrozen();
        return super.addAll(index, c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.checkForFrozen();
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkForFrozen();
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkForFrozen();
        return super.retainAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter2) {
        this.checkForFrozen();
        return super.removeIf(filter2);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.checkForFrozen();
        super.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.checkForFrozen();
        super.sort(c);
    }

    public @Unmodifiable List<T> emptyOrFrozen() {
        return this.isEmpty() ? ContainerUtil.emptyList() : (ContainerUtil.Options.RETURN_REALLY_UNMODIFIABLE_COLLECTION_FROM_METHODS_MARKED_UNMODIFIABLE ? this.freeze() : this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FreezableArrayList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FreezableArrayList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "freeze";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

