/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.MeasurableIndexStore;
import com.intellij.util.io.PersistentMapBase;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.StorageLockContext;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentHashMap<Key, Value>
implements AppendablePersistentMap<Key, Value>,
MeasurableIndexStore {
    @NotNull
    private final PersistentMapBase<Key, Value> myImpl;

    PersistentHashMap(@NotNull PersistentMapBuilder<Key, Value> builder, boolean checkInheritedMembers) throws IOException {
        if (builder == null) {
            PersistentHashMap.$$$reportNull$$$0(0);
        }
        if (checkInheritedMembers) {
            builder.withReadonly(false);
            builder.inlineValues(false);
        }
        this.myImpl = builder.build().myImpl;
    }

    public PersistentHashMap(@NotNull PersistentMapBase<Key, Value> impl) {
        if (impl == null) {
            PersistentHashMap.$$$reportNull$$$0(1);
        }
        this.myImpl = impl;
    }

    @Override
    public void closeAndClean() throws IOException {
        this.myImpl.closeAndDelete();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public PersistentHashMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        if (file == null) {
            PersistentHashMap.$$$reportNull$$$0(2);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(3);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(4);
        }
        this(PersistentMapBuilder.newBuilder(file.toPath(), keyDescriptor, valueExternalizer), true);
    }

    public PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer) throws IOException {
        if (file == null) {
            PersistentHashMap.$$$reportNull$$$0(5);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(6);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(7);
        }
        this(PersistentMapBuilder.newBuilder(file, keyDescriptor, valueExternalizer), true);
    }

    public PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize) throws IOException {
        if (file == null) {
            PersistentHashMap.$$$reportNull$$$0(8);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(9);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(10);
        }
        this(PersistentMapBuilder.newBuilder(file, keyDescriptor, valueExternalizer).withInitialSize(initialSize), true);
    }

    public PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version) throws IOException {
        if (file == null) {
            PersistentHashMap.$$$reportNull$$$0(11);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(12);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(13);
        }
        this(PersistentMapBuilder.newBuilder(file, keyDescriptor, valueExternalizer).withInitialSize(initialSize).withVersion(version), true);
    }

    @ApiStatus.Internal
    public PersistentHashMap(@NotNull Path file, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int initialSize, int version, @Nullable StorageLockContext lockContext) throws IOException {
        if (file == null) {
            PersistentHashMap.$$$reportNull$$$0(14);
        }
        if (keyDescriptor == null) {
            PersistentHashMap.$$$reportNull$$$0(15);
        }
        if (valueExternalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(16);
        }
        this(PersistentMapBuilder.newBuilder(file, keyDescriptor, valueExternalizer).withInitialSize(initialSize).withVersion(version).withStorageLockContext(lockContext), true);
    }

    public void dropMemoryCaches() {
        this.force();
    }

    @Override
    public void put(Key key, Value value) throws IOException {
        this.myImpl.put(key, value);
    }

    @NotNull
    public PersistentMapBase<Key, Value> getImpl() {
        PersistentMapBase<Key, Value> persistentMapBase = this.myImpl;
        if (persistentMapBase == null) {
            PersistentHashMap.$$$reportNull$$$0(17);
        }
        return persistentMapBase;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void appendData(Key key, @NotNull ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentHashMap.$$$reportNull$$$0(18);
        }
        this.myImpl.appendData(key, appender);
    }

    @Override
    public void appendData(Key key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        if (appender == null) {
            PersistentHashMap.$$$reportNull$$$0(19);
        }
        this.myImpl.appendData(key, appender);
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor) throws IOException {
        if (processor == null) {
            PersistentHashMap.$$$reportNull$$$0(20);
        }
        return this.myImpl.processKeys(processor);
    }

    @Override
    public boolean isClosed() {
        return this.myImpl.isClosed();
    }

    @Override
    public boolean isDirty() {
        return this.myImpl.isDirty();
    }

    @Override
    public void markDirty() throws IOException {
        this.myImpl.markDirty();
    }

    public void markCorrupted() {
        this.myImpl.markCorrupted();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public Collection<Key> getAllKeysWithExistingMapping() throws IOException {
        ArrayList result2 = new ArrayList();
        this.myImpl.processExistingKeys(new CommonProcessors.CollectProcessor(result2));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            PersistentHashMap.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    public void consumeKeysWithExistingMapping(@NotNull Consumer<? super Key> consumer) throws IOException {
        if (consumer == null) {
            PersistentHashMap.$$$reportNull$$$0(22);
        }
        this.myImpl.processExistingKeys(key -> {
            consumer.accept((Object)key);
            return true;
        });
    }

    public boolean processKeysWithExistingMapping(@NotNull Processor<? super Key> processor) throws IOException {
        if (processor == null) {
            PersistentHashMap.$$$reportNull$$$0(23);
        }
        return this.myImpl.processExistingKeys(processor);
    }

    @Override
    public Value get(Key key) throws IOException {
        return this.myImpl.get(key);
    }

    @Override
    public boolean containsMapping(Key key) throws IOException {
        return this.myImpl.containsKey(key);
    }

    @Override
    public void remove(Key key) throws IOException {
        this.myImpl.remove(key);
    }

    @Override
    public void force() throws UncheckedIOException {
        try {
            this.myImpl.force();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int keysCountApproximately() {
        return this.myImpl.keysCount();
    }

    @Override
    public void close() throws IOException {
        this.myImpl.close();
    }

    public String toString() {
        return this.myImpl.toString();
    }

    public static <K, V> PersistentHashMap<K, V> canonicalize(@NotNull PersistentHashMap<K, V> originalMap, @NotNull PersistentHashMap<K, V> targetCanonicalMap, @NotNull Function<? super List<K>, ? extends List<K>> stableKeysSorter, @NotNull Function<? super V, ? extends V> valueCanonicalizer) throws IOException {
        if (originalMap == null) {
            PersistentHashMap.$$$reportNull$$$0(24);
        }
        if (targetCanonicalMap == null) {
            PersistentHashMap.$$$reportNull$$$0(25);
        }
        if (stableKeysSorter == null) {
            PersistentHashMap.$$$reportNull$$$0(26);
        }
        if (valueCanonicalizer == null) {
            PersistentHashMap.$$$reportNull$$$0(27);
        }
        PersistentMapBase.canonicalize(originalMap.myImpl, targetCanonicalMap.myImpl, stableKeysSorter, valueCanonicalizer);
        return targetCanonicalMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentHashMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMap";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCanonicalMap";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stableKeysSorter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueCanonicalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentHashMap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getImpl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeysWithExistingMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: 
            case 21: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "consumeKeysWithExistingMapping";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processKeysWithExistingMapping";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canonicalize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static interface ValueDataAppender
    extends AppendablePersistentMap.ValueDataAppender {
    }
}

