/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserConflictsNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.NoneChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0014J\u0014\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/SimpleChangesGroupingPolicy;", "", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGroupRootValueFor", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "createGroupRootNode", "value", "isMergeConflict", "", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "Companion", "Factory", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class DefaultChangesGroupingPolicy
extends SimpleChangesGroupingPolicy<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Object CONFLICTS_NODE_FLAG = new Object();

    public DefaultChangesGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    protected Object getGroupRootValueFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (this.isMergeConflict(nodePath, node)) {
            return CONFLICTS_NODE_FLAG;
        }
        return null;
    }

    @Override
    @NotNull
    protected ChangesBrowserNode<?> createGroupRootNode(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean bl = Intrinsics.areEqual((Object)value, (Object)CONFLICTS_NODE_FLAG);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ChangesBrowserConflictsNode conflictsRoot = new ChangesBrowserConflictsNode(this.project);
        conflictsRoot.markAsHelperNode();
        return conflictsRoot;
    }

    private final boolean isMergeConflict(StaticFilePath nodePath, ChangesBrowserNode<?> node) {
        if (node instanceof ChangesGroupingPolicy.CompatibilityPlaceholderChangesBrowserNode) {
            VirtualFile virtualFile = nodePath.resolve();
            if (virtualFile == null) {
                return false;
            }
            VirtualFile vFile = virtualFile;
            FileStatus fileStatus = ChangeListManager.getInstance((Project)this.project).getStatus(vFile);
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
            FileStatus status = fileStatus;
            return this.isMergeConflict(status);
        }
        if (node instanceof ChangesBrowserChangeNode) {
            FileStatus fileStatus = ((Change)((ChangesBrowserChangeNode)node).getUserObject()).getFileStatus();
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
            return this.isMergeConflict(fileStatus);
        }
        return false;
    }

    private final boolean isMergeConflict(FileStatus status) {
        return status == FileStatus.MERGED_WITH_CONFLICTS || status == FileStatus.MERGED_WITH_BOTH_CONFLICTS || status == FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultChangesGroupingPolicy$Companion;", "", "<init>", "()V", "CONFLICTS_NODE_FLAG", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "forLocalChanges", "", "<init>", "(Z)V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        private final boolean forLocalChanges;

        @JvmOverloads
        public Factory(boolean forLocalChanges) {
            this.forLocalChanges = forLocalChanges;
        }

        public /* synthetic */ Factory(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        @Override
        @NotNull
        public ChangesGroupingPolicy createGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return this.forLocalChanges ? (ChangesGroupingPolicy)new DefaultChangesGroupingPolicy(project, model) : (ChangesGroupingPolicy)NoneChangesGroupingPolicy.INSTANCE;
        }

        @JvmOverloads
        public Factory() {
            this(false, 1, null);
        }
    }
}

