/*******************************************************************************
* Copyright 2024 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include <cstdint>
#include <vector>

namespace dnnl {
namespace impl {
namespace gpu {
namespace intel {
namespace jit {
namespace v2 {
namespace conv {

// clang-format off
const std::vector<uint64_t> &get_plan_registry_data() {
    static std::vector<uint64_t> data = {
        0x000000c00000002f, 0x6302020000000500, 0x0505680404640303, 0x000000056e090977, 0x00000f776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300,
        0x0000650000000000, 0x0000000062000000, 0x6701010000000600, 0x0707640606690202, 0x066f0a0a77080868, 0x6864696f67000000, 0x0000010000000f77, 0x6100000006000000,
        0x0000640000000000, 0x0000000065000000, 0x6300000000006600, 0x0000620000000000, 0x0900000005000000, 0x640b0b630a0a6e09, 0x0005770d0d680c0c, 0x0f776864636e0000,
        0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0000000000000000, 0x0700000007000000, 0x0000000200000000,
        0x0000010101000004, 0x0000800000001000, 0x2002020000000300, 0x0000100a0a000000, 0x02000000040d0d00, 0x0000080202000000, 0x04000000020a0a00, 0x0000000009000000,
        0x00000000010d0000, 0x0000000000020c00, 0x010001000000030b, 0x0000000001000000, 0x0000010000000000, 0x000e000000000e00, 0x0000100602030000, 0x000c000000000000,
        0x4000000602030000, 0x000c000000000000, 0x0000000605030000, 0x000e000000000001, 0x0000000004000000, 0x0103100300000004, 0x0000000010060203, 0x0000000c00000000,
        0x0004000000000400, 0x0203010310030000, 0x0000000040000006, 0x1003000000100000, 0x0000000000000106, 0x0a030000000e0000, 0x0000000000001006, 0x0a030000000c0000,
        0x0000000040000006, 0x0d030000000c0000, 0x0000000100000006, 0x04000000000e0000, 0x060a030103000000, 0x0000000000000010, 0x0004000000000c00, 0x00060a0301030000,
        0x0000000000004000, 0x000602030000000c, 0x0000000000010000, 0x0000060000000010, 0x0000001006020300, 0x0000000600000000, 0x0010000000000000, 0x0300000006000000,
        0x000000000010060a, 0x0000000000060000, 0x00000000c0000000, 0x0363020200000005, 0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001,
        0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000,
        0x000000010000000f, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000, 0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e,
        0x000005770d0d680c, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0000000000000000,
        0x0007000000070000, 0x0400000002000000, 0x0000000101010000, 0x0000008000000010, 0x0020020200000003, 0x000000100a0a0000, 0x0002000000040d0d, 0x0000000802020000,
        0x0004000000020a0a, 0x0000000000090000, 0x0000000000010d00, 0x0b0000000000020c, 0x0001000100000003, 0x0000000000010000, 0x0000000100000000, 0x00000e000000000e,
        0x0000001006020300, 0x00000c0000000000, 0x0040000006020300, 0x00000c0000000000, 0x0100000006050300, 0x00000e0000000000, 0x0400000000040000, 0x0301031003000000,
        0x0000000000100602, 0x000000000c000000, 0x0000040000000004, 0x0602030103100300, 0x0000000000400000, 0x0610030000001000, 0x0000000000000001, 0x060a030000000e00,
        0x0000000000000010, 0x060a030000000c00, 0x0000000000400000, 0x060d030000000c00, 0x0000000001000000, 0x0004000000000e00, 0x10060a0301030000, 0x0000000000000000,
        0x000004000000000c, 0x0000060a03010300, 0x0c00000000000040, 0x0000060203000000, 0x1000000000000100, 0x0000000600000000, 0x0000000010060203, 0x0000000006000000,
        0x0000100000000000, 0x0a03000000060000, 0x0000000000001006, 0x0000000000000600, 0x0004000000010000, 0x067cb99c78040000, 0xb3b03c0c06a03c8c, 0x0500000000c03eee,
        0x0303630202000000, 0x0977050568040464, 0x636e000000056e09, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000,
        0x0600000000006200, 0x0202670101000000, 0x0868070764060669, 0x0000066f0a0a7708, 0x0f776864696f6700, 0x0000000001000000, 0x0000610000000600, 0x0000000064000000,
        0x6600000000006500, 0x0000630000000000, 0x0000000062000000, 0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x00000f776864636e, 0x0500000000000100,
        0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x0000000000000000, 0x0000070000000700, 0x0004000000020000, 0x1000000001010100,
        0x0300000080000000, 0x0000040202000000, 0x0d000000400a0a00, 0x000001000000100d, 0x0400000008020200, 0x0000000009000000, 0x00000000010d0000, 0x0000000000020c00,
        0x010001000000030b, 0x0000000001000000, 0x0000010000000000, 0x000e000000000e00, 0x0000100602030000, 0x000c000000000000, 0x4000000602030000, 0x000c000000000000,
        0x0000000605030000, 0x000e000000000001, 0x0000000004000000, 0x0103100300000004, 0x0000000010060203, 0x0000000c00000000, 0x0004000000000400, 0x0203010310030000,
        0x0000000040000006, 0x1003000000100000, 0x0000000000000106, 0x0a030000000e0000, 0x0000000000001006, 0x0a030000000c0000, 0x0000000040000006, 0x0d030000000c0000,
        0x0000000100000006, 0x04000000000e0000, 0x060a030103000000, 0x0000000000000010, 0x0004000000000c00, 0x00060a0301030000, 0x0000000000004000, 0x000602030000000c,
        0x0000000000010000, 0x0000060000000010, 0x0000001006020300, 0x0000000600000000, 0x0010000000000000, 0x0300000006000000, 0x000000000010060a, 0x0000000000060000,
        0x00000000c0000000, 0x0363020200000005, 0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063,
        0x0000006500000000, 0x0000000000620000, 0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x000000010000000f, 0x0061000000060000,
        0x0000006400000000, 0x0000000000650000, 0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c, 0x000f776864636e00,
        0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0000000000000000, 0x0007000000070000, 0x0400000002000000,
        0x0000000101010000, 0x0000008000000010, 0x0004020200000003, 0x000000400a0a0000, 0x0001000000100d0d, 0x0000000802020000, 0x0000000900000004, 0x000000010d000000,
        0x00000000020c0000, 0x0001000000030b00, 0x0000000100000001, 0x0001000000000000, 0x0e000000000e0000, 0x0010060203000000, 0x0c00000000000000, 0x0000060203000000,
        0x0c00000000000040, 0x0000060503000000, 0x0e00000000000100, 0x0000000400000000, 0x0310030000000400, 0x0000001006020301, 0x00000c0000000000, 0x0400000000040000,
        0x0301031003000000, 0x0000004000000602, 0x0300000010000000, 0x0000000000010610, 0x030000000e000000, 0x000000000010060a, 0x030000000c000000, 0x000000400000060a,
        0x030000000c000000, 0x000001000000060d, 0x000000000e000000, 0x0a03010300000004, 0x0000000000001006, 0x04000000000c0000, 0x060a030103000000, 0x0000000000400000,
        0x0602030000000c00, 0x0000000001000000, 0x0006000000001000, 0x0000100602030000, 0x0000060000000000, 0x1000000000000000, 0x0000000600000000, 0x0000000010060a03,
        0x0000000006000000, 0x0000000100000000, 0x3b069fd200000004, 0x3cbd6e813cbd6e86, 0x000000c03e90630c, 0x6302020000000500, 0x0505680404640303, 0x000000056e090977,
        0x00000f776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x6701010000000600, 0x0707640606690202,
        0x066f0a0a77080868, 0x6864696f67000000, 0x0000010000000f77, 0x6100000006000000, 0x0000640000000000, 0x0000000065000000, 0x6300000000006600, 0x0000620000000000,
        0x0900000005000000, 0x640b0b630a0a6e09, 0x0005770d0d680c0c, 0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400,
        0x0000620000000000, 0x0000000000000000, 0x0700000007000000, 0x0000000200000000, 0x0000010101000004, 0x0000800000001000, 0x0402020000000300, 0x0000100909000000,
        0x02000000200a0a00, 0x0000020202000000, 0x04000000020a0a00, 0x0000000009000000, 0x00000000010d0000, 0x0000000000020c00, 0x010001000000030b, 0x0000000001000000,
        0x0000010000000000, 0x000e000000000c00, 0x0000100602030000, 0x000c000000000000, 0x4000000602030000, 0x000c000000000000, 0x0000000609030000, 0x000e000000000001,
        0x0000000004000000, 0x0000040000000004, 0x0303000000040000, 0x0203010305030403, 0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400,
        0x0503040303030000, 0x4000000602030103, 0x000e000000000000, 0x000010060a030000, 0x000c000000000000, 0x400000060a030000, 0x000e000000000000, 0x0000000004000000,
        0x0000040000000004, 0x0b03000000040000, 0x0a0301030d030c03, 0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0d030c030b030000,
        0x400000060a030103, 0x000c000000000000, 0x0000000602030000, 0x0010000000000001, 0x0300000006000000, 0x0000000000100602, 0x0000000000060000, 0x0000001000000000,
        0x060a030000000600, 0x0000000000000010, 0x0000000000000006, 0x000500000000c000, 0x6403036302020000, 0x0909770505680404, 0x64636e000000056e, 0x00010000000f7768,
        0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062, 0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77,
        0x000f776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065, 0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005,
        0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000,
        0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000010101, 0x0003000000800000, 0x0000000402020000, 0x0a0a000000100909, 0x0000000200000020,
        0x0a0a000000020202, 0x0000000400000002, 0x0d00000000000009, 0x020c000000000001, 0x00030b0000000000, 0x0000000100010000, 0x0000000000000001, 0x000c000000010000,
        0x030000000e000000, 0x0000000000100602, 0x030000000c000000, 0x0000004000000602, 0x030000000c000000, 0x0000010000000609, 0x000000000e000000, 0x0000040000000004,
        0x0400000000040000, 0x0304030303000000, 0x0010060203010305, 0x0c00000000000000, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030503040303,
        0x0000004000000602, 0x030000000e000000, 0x000000000010060a, 0x030000000c000000, 0x000000400000060a, 0x000000000e000000, 0x0000040000000004, 0x0400000000040000,
        0x030c030b03000000, 0x0010060a0301030d, 0x0c00000000000000, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030d030c030b, 0x000000400000060a,
        0x030000000c000000, 0x0000010000000602, 0x0000000010000000, 0x1006020300000006, 0x0600000000000000, 0x0000000000000000, 0x0006000000001000, 0x000010060a030000,
        0x0000060000000000, 0x0001000000000000, 0x8740000000040000, 0xe2e739a3edde3ae7, 0x00c03eb77c9b3a23, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505,
        0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701,
        0x0a0a770808680707, 0x696f67000000066f, 0x010000000f776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300,
        0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000,
        0x6200000000006500, 0x0000000000000000, 0x0000070000000000, 0x0002000000000700, 0x0101010000040000, 0x8000000010000000, 0x0200000003000000, 0x100a0a0000000202,
        0x0000100d0d000000, 0x1002020000000100, 0x0900000004000000, 0x010d000000000000, 0x00020c0000000000, 0x0000030b00000000, 0x0100000001000100, 0x0000000000000000,
        0x00000e0000000100, 0x02030000000e0000, 0x0000000000001006, 0x02030000000c0000, 0x0000000040000006, 0x05030000000c0000, 0x0000000100000006, 0x04000000000e0000,
        0x0000000400000000, 0x1006020301031003, 0x0000000000000000, 0x000004000000000c, 0x1003000000040000, 0x4000000602030103, 0x0010000000000000, 0x0000010610030000,
        0x000e000000000000, 0x000010060a030000, 0x000c000000000000, 0x400000060a030000, 0x000c000000000000, 0x000000060d030000, 0x000e000000000001, 0x0300000004000000,
        0x00000010060a0301, 0x00000c0000000000, 0x0103000000040000, 0x0000400000060a03, 0x0000000c00000000, 0x0001000000060203, 0x0000001000000000, 0x0602030000000600,
        0x0000000000000010, 0x0000000000000006, 0x0600000000100000, 0x0010060a03000000, 0x0006000000000000, 0xc000000000000000, 0x0000000500000000, 0x0404640303630202,
        0x056e090977050568, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000600000000,
        0x0606690202670101, 0x0a77080868070764, 0x6f67000000066f0a, 0x0000000f77686469, 0x0006000000000001, 0x0000000000610000, 0x0065000000000064, 0x0000006600000000,
        0x0000000000630000, 0x0005000000000062, 0x630a0a6e09090000, 0x0d0d680c0c640b0b, 0x64636e0000000577, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061,
        0x0000006400000000, 0x0000000000650000, 0x0000000000000062, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000, 0x0000001000000001, 0x0000000300000080,
        0x0a0a000000020202, 0x00100d0d00000010, 0x0202000000010000, 0x0000000400000010, 0x0d00000000000009, 0x020c000000000001, 0x00030b0000000000, 0x0000000100010000,
        0x0000000000000001, 0x000e000000010000, 0x030000000e000000, 0x0000000000100602, 0x030000000c000000, 0x0000004000000602, 0x030000000c000000, 0x0000010000000605,
        0x000000000e000000, 0x0000040000000004, 0x0602030103100300, 0x0000000000000010, 0x0004000000000c00, 0x0300000004000000, 0x0000060203010310, 0x1000000000000040,
        0x0001061003000000, 0x0e00000000000000, 0x0010060a03000000, 0x0c00000000000000, 0x0000060a03000000, 0x0c00000000000040, 0x0000060d03000000, 0x0e00000000000100,
        0x0000000400000000, 0x000010060a030103, 0x000c000000000000, 0x0300000004000000, 0x00400000060a0301, 0x00000c0000000000, 0x0100000006020300, 0x0000100000000000,
        0x0203000000060000, 0x0000000000001006, 0x0000000000000600, 0x0000000010000000, 0x10060a0300000006, 0x0600000000000000, 0x0000000000000000, 0x0000000400000001,
        0xb826c953b90453f7, 0x3e2a03923ac2d366, 0x00000500000000c0, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000,
        0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f,
        0x0600000000000100, 0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63,
        0x636e00000005770d, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0000000000006200, 0x0700000000000000,
        0x0000000007000000, 0x0100000400000002, 0x0000100000000101, 0x0000030000008000, 0x0a00000008020200, 0x040d0d000000200a, 0x0200000002000000, 0x080a0a0000000202,
        0x0900000004000000, 0x010d000000000000, 0x00020c0000000000, 0x0000030b00000000, 0x0100000001000100, 0x0000000000000000, 0x00000e0000000100, 0x02030000000e0000,
        0x0000000000001006, 0x02030000000c0000, 0x0000000040000006, 0x05030000000c0000, 0x0000000100000006, 0x04000000000e0000, 0x0000000400000000, 0x1006020301031003,
        0x0000000000000000, 0x000004000000000c, 0x1003000000040000, 0x4000000602030103, 0x0010000000000000, 0x0000010610030000, 0x000e000000000000, 0x000010060a030000,
        0x000c000000000000, 0x400000060a030000, 0x000c000000000000, 0x000000060d030000, 0x000e000000000001, 0x0300000004000000, 0x00000010060a0301, 0x00000c0000000000,
        0x0103000000040000, 0x0000400000060a03, 0x0000000c00000000, 0x0001000000060203, 0x0000001000000000, 0x0602030000000600, 0x0000000000000010, 0x0000000000000006,
        0x0600000000100000, 0x0010060a03000000, 0x0006000000000000, 0xc000000000000000, 0x0000000500000000, 0x0404640303630202, 0x056e090977050568, 0x776864636e000000,
        0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000600000000, 0x0606690202670101, 0x0a77080868070764,
        0x6f67000000066f0a, 0x0000000f77686469, 0x0006000000000001, 0x0000000000610000, 0x0065000000000064, 0x0000006600000000, 0x0000000000630000, 0x0005000000000062,
        0x630a0a6e09090000, 0x0d0d680c0c640b0b, 0x64636e0000000577, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000,
        0x0000000000000062, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000, 0x0000001000000001, 0x0000000300000080, 0x0a0a000000080202, 0x00040d0d00000020,
        0x0202000000020000, 0x00080a0a00000002, 0x0009000000040000, 0x00010d0000000000, 0x0000020c00000000, 0x000000030b000000, 0x0001000000010001, 0x0000000000000000,
        0x0000000e00000001, 0x0602030000000e00, 0x0000000000000010, 0x0602030000000c00, 0x0000000000400000, 0x0605030000000c00, 0x0000000001000000, 0x0004000000000e00,
        0x0300000004000000, 0x0010060203010310, 0x0c00000000000000, 0x0000000400000000, 0x0310030000000400, 0x0040000006020301, 0x0000100000000000, 0x0000000106100300,
        0x00000e0000000000, 0x00000010060a0300, 0x00000c0000000000, 0x00400000060a0300, 0x00000c0000000000, 0x01000000060d0300, 0x00000e0000000000, 0x0103000000040000,
        0x0000000010060a03, 0x0000000c00000000, 0x0301030000000400, 0x000000400000060a, 0x030000000c000000, 0x0000010000000602, 0x0000000010000000, 0x1006020300000006,
        0x0600000000000000, 0x0000000000000000, 0x0006000000001000, 0x000010060a030000, 0x0000060000000000, 0x0001000000000000, 0x1041000000040000, 0x35803c02365739ea,
        0x00c03e2ffd1b3b82, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505, 0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000,
        0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707, 0x696f67000000066f, 0x010000000f776864, 0x0000060000000000,
        0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300, 0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005,
        0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000000000000000, 0x0000070000000000, 0x0002000000000700,
        0x0101010000040000, 0x8000000010000000, 0x0200000003000000, 0x200a0a0000000402, 0x0000080d0d000000, 0x0202020000000200, 0x0000100a0a000000, 0x0000090000000400,
        0x0000010d00000000, 0x000000020c000000, 0x01000000030b0000, 0x0000000000000000, 0x0000000000000000, 0xc000000000000000, 0x0000000500000000, 0x0404640303630202,
        0x056e090977050568, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000600000000,
        0x0606690202670101, 0x0a77080868070764, 0x6f67000000066f0a, 0x0000000f77686469, 0x0006000000000001, 0x0000000000610000, 0x0065000000000064, 0x0000006600000000,
        0x0000000000630000, 0x0005000000000062, 0x630a0a6e09090000, 0x0d0d680c0c640b0b, 0x64636e0000000577, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061,
        0x0000006400000000, 0x0000000000650000, 0x0000000000000062, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000, 0x0000001000000001, 0x0000000300000080,
        0x0a0a000000040202, 0x00080d0d00000020, 0x0202000000020000, 0x00100a0a00000002, 0x0009000000040000, 0x00010d0000000000, 0x0000020c00000000, 0x000000030b000000,
        0x0000000000000001, 0x0000000000000000, 0x0000000000000000, 0x0000000400000001, 0xbb0e996b3b1ffb36, 0x3d6ee687ba0e9919, 0x00000500000000c0, 0x0464030363020200,
        0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000060000000000,
        0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000, 0x6500000000006400, 0x0000660000000000,
        0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100,
        0x0000640000000000, 0x0000000065000000, 0x0000000000006200, 0x0700000000000000, 0x0000000007000000, 0x0100000400000002, 0x0000100000000101, 0x0000030000008000,
        0x0a00000008020200, 0x020d0d000000100a, 0x0a00000001000000, 0x000004000000100a, 0x0000000000000900, 0x0c0000000000010d, 0x030b000000000002, 0x0000000001000000,
        0x0000000000000000, 0x0000000000000000, 0x00000000c0000000, 0x0363020200000005, 0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001,
        0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000,
        0x000000010000000f, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000, 0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e,
        0x000005770d0d680c, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0000000000000000,
        0x0007000000070000, 0x0400000002000000, 0x0000000101010000, 0x0000008000000010, 0x0008020200000003, 0x000000100a0a0000, 0x0001000000020d0d, 0x000000100a0a0000,
        0x0000000900000004, 0x000000010d000000, 0x00000000020c0000, 0x0001000000030b00, 0x0000000000000000, 0x0000000000000000, 0x0001000000000000, 0x94e5000000040000,
        0x9b0a37d0b0783941, 0x00c03dce3b7f3750, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505, 0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500,
        0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707, 0x696f67000000066f, 0x010000000f776864,
        0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300, 0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b,
        0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000000000000000, 0x0000070000000000,
        0x0002000000000700, 0x0101010000040000, 0x8000000010000000, 0x0200000003000000, 0x0409090000000802, 0x0000200a0a000000, 0x0802020000000200, 0x0000040a0a000000,
        0x0000090000000400, 0x0000010d00000000, 0x000000020c000000, 0x01000000030b0000, 0x0000000000000000, 0x0000000000000000, 0xc000000000000000, 0x0000000500000000,
        0x0404640303630202, 0x056e090977050568, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065,
        0x0000000600000000, 0x0606690202670101, 0x0a77080868070764, 0x6f67000000066f0a, 0x0000000f77686469, 0x0006000000000001, 0x0000000000610000, 0x0065000000000064,
        0x0000006600000000, 0x0000000000630000, 0x0005000000000062, 0x630a0a6e09090000, 0x0d0d680c0c640b0b, 0x64636e0000000577, 0x00010000000f7768, 0x0000000500000000,
        0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0000000000000062, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000, 0x0000001000000001,
        0x0000000300000080, 0x0909000000080202, 0x00200a0a00000004, 0x0202000000020000, 0x00040a0a00000008, 0x0009000000040000, 0x00010d0000000000, 0x0000020c00000000,
        0x000000030b000000, 0x0000000000000001, 0x0000000000000000, 0x0000000000000000, 0x0000000400000001, 0x38872c983a3e3f94, 0x3e22044737873dda, 0x00000500000000c0,
        0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500,
        0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000, 0x6500000000006400,
        0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864, 0x0000050000000000,
        0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0000000000006200, 0x0700000000000000, 0x0000000007000000, 0x0100000400000002, 0x0000100000000101,
        0x0000030000008000, 0x0900000002020200, 0x100a0a0000001009, 0x0200000001000000, 0x0000040000000802, 0x0000000000000900, 0x0c0000000000010d, 0x030b000000000002,
        0x0000000001000000, 0x0000000000000000, 0x0000000000000000, 0x00000000c0000000, 0x0363020200000005, 0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463,
        0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808,
        0x776864696f670000, 0x000000010000000f, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000, 0x0063000000000066, 0x0000006200000000, 0x0909000000050000,
        0x0c640b0b630a0a6e, 0x000005770d0d680c, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000,
        0x0000000000000000, 0x0007000000070000, 0x0400000002000000, 0x0000000101010000, 0x0000008000000010, 0x0002020200000003, 0x0000001009090000, 0x0001000000100a0a,
        0x0000000802020000, 0x0000000900000004, 0x000000010d000000, 0x00000000020c0000, 0x0001000000030b00, 0x0000000000000000, 0x0000000000000000, 0x0001000000000000,
        0x7df1000000040000, 0xd9e9392cdb3b39e3, 0x00a03d40fa04392c, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505, 0x03776864636e0000, 0x0000000001000000,
        0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707, 0x696f67000000066f,
        0x0100000003776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300, 0x0000050000000000, 0x0b630a0a6e090900,
        0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000377, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000030000000000,
        0x0f000000010e0e00, 0x011010000000010f, 0x0700000000000000, 0x0000000007000000, 0x0100000400000002, 0x0000100000000301, 0x0000030000010000, 0x0900000010020200,
        0x200a0a0000000809, 0x0400000000000000, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x000001000000030a, 0x0000000000000000, 0x0000000000000000,
        0x0010000000000300, 0x000001060e030000, 0x0010000000000000, 0x000001060f030000, 0x0010000000000000, 0x0000010610030000, 0x0000a00000000000, 0x0202000000050000,
        0x0568040464030363, 0x0000056e09097705, 0x0003776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000,
        0x0101000000060000, 0x0764060669020267, 0x6f0a0a7708086807, 0x64696f6700000006, 0x0001000000037768, 0x0000000600000000, 0x0064000000000061, 0x0000006500000000,
        0x0000000000660000, 0x0062000000000063, 0x0000000500000000, 0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000, 0x0000000100000003, 0x0061000000050000,
        0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000300000000, 0x0f0f000000010e0e, 0x0001101000000001, 0x0007000000000000, 0x0200000000070000,
        0x0101000004000000, 0x0000001000000003, 0x0000000300000100, 0x0909000000100202, 0x00200a0a00000008, 0x0004000000000000, 0x0000000000080000, 0x0000000000010700,
        0x0a00000000000206, 0x0000000100000003, 0x0000000000000000, 0x0000000000000000, 0x0000100000000003, 0x00000001060e0300, 0x0000100000000000, 0x00000001060f0300,
        0x0000100000000000, 0x0000000106100300, 0x0000000100000000, 0x3940413400000004, 0x3a85e1ff3b9717b2, 0x000000a0bb466b5c, 0x6302020000000500, 0x0505680404640303,
        0x000000056e090977, 0x000003776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x6701010000000600,
        0x0707640606690202, 0x066f0a0a77080868, 0x6864696f67000000, 0x0000010000000377, 0x6100000006000000, 0x0000640000000000, 0x0000000065000000, 0x6300000000006600,
        0x0000620000000000, 0x0900000005000000, 0x640b0b630a0a6e09, 0x0005770d0d680c0c, 0x03776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000,
        0x6500000000006400, 0x0000620000000000, 0x0e00000003000000, 0x010f0f000000010e, 0x0000011010000000, 0x0000070000000000, 0x0002000000000700, 0x0301010000040000,
        0x0000000010000000, 0x0200000003000001, 0x0805050000001002, 0x0000200a0a000000, 0x0402020000000200, 0x0000040505000000, 0x0000080000000400, 0x0000010700000000,
        0x0000000206000000, 0x01000000030a0000, 0x0000000000000000, 0x0000000000000000, 0x0000000003000000, 0x01060e0300000010, 0x0000000000000000, 0x01060f0300000010,
        0x0000000000000000, 0x0106100300000010, 0xa000000000000000, 0x0000000500000000, 0x0404640303630202, 0x056e090977050568, 0x776864636e000000, 0x0000000100000003,
        0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000600000000, 0x0606690202670101, 0x0a77080868070764, 0x6f67000000066f0a,
        0x0000000377686469, 0x0006000000000001, 0x0000000000610000, 0x0065000000000064, 0x0000006600000000, 0x0000000000630000, 0x0005000000000062, 0x630a0a6e09090000,
        0x0d0d680c0c640b0b, 0x64636e0000000577, 0x0001000000037768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0003000000000062,
        0x000000010e0e0000, 0x1010000000010f0f, 0x0000000000000001, 0x0000000700000007, 0x0000040000000200, 0x0010000000030101, 0x0003000001000000, 0x0000001002020000,
        0x0a0a000000080505, 0x0000000200000020, 0x0505000000040202, 0x0000000400000004, 0x0700000000000008, 0x0206000000000001, 0x00030a0000000000, 0x0000000000010000,
        0x0000000000000000, 0x0003000000000000, 0x0300000010000000, 0x000000000001060e, 0x0300000010000000, 0x000000000001060f, 0x0300000010000000, 0x0000000000010610,
        0x0004000000010000, 0x3f733a8f0cb60000, 0x7da63b048a823b21, 0x0500000000a0bb13, 0x0303630202000000, 0x0977050568040464, 0x636e000000056e09, 0x010000000f776864,
        0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0600000000006200, 0x0202670101000000, 0x0868070764060669, 0x0000066f0a0a7708,
        0x0f776864696f6700, 0x0000000001000000, 0x0000610000000600, 0x0000000064000000, 0x6600000000006500, 0x0000630000000000, 0x0000000062000000, 0x6e09090000000500,
        0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x00000f776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000,
        0x010e0e0000000300, 0x0000010f0f000000, 0x0000000001101000, 0x0700000007000000, 0x0000000200000000, 0x0000010101000004, 0x0000800000001000, 0x2002020000000300,
        0x0000040909000000, 0x02000000080a0a00, 0x0000020202000000, 0x0400000010050500, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x010001000000030a,
        0x0000000001000000, 0x0000010000000000, 0x0010000000000f00, 0x000001060e030000, 0x0010000000000000, 0x000001060f030000, 0x0010000000000000, 0x0000010610030000,
        0x000e000000000000, 0x000010060a030000, 0x000c000000000000, 0x400000060a030000, 0x000c000000000000, 0x0000000609030000, 0x000e000000000001, 0x0000000004000000,
        0x0000040000000004, 0x0b03000000040000, 0x0a0301030d030c03, 0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0d030c030b030000,
        0x400000060a030103, 0x000c000000000000, 0x0000000602030000, 0x000e000000000001, 0x0000100602030000, 0x000c000000000000, 0x4000000602030000, 0x000e000000000000,
        0x0000000004000000, 0x0000040000000004, 0x0303000000040000, 0x0203010305030403, 0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400,
        0x0503040303030000, 0x4000000602030103, 0x0010000000000000, 0x0300000006000000, 0x0000000000100602, 0x0000000000060000, 0x0000001000000000, 0x060a030000000600,
        0x0000000000000010, 0x0000000000000006, 0x000500000000a000, 0x6403036302020000, 0x0909770505680404, 0x64636e000000056e, 0x00010000000f7768, 0x0000000500000000,
        0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062, 0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77, 0x000f776864696f67,
        0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065, 0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a,
        0x6e00000005770d0d, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x00010e0e00000003,
        0x000000010f0f0000, 0x0000000000011010, 0x0007000000070000, 0x0400000002000000, 0x0000000101010000, 0x0000008000000010, 0x0020020200000003, 0x0000000409090000,
        0x0002000000080a0a, 0x0000000202020000, 0x0004000000100505, 0x0000000000080000, 0x0000000000010700, 0x0a00000000000206, 0x0001000100000003, 0x0000000000010000,
        0x0000000100000000, 0x000010000000000f, 0x00000001060e0300, 0x0000100000000000, 0x00000001060f0300, 0x0000100000000000, 0x0000000106100300, 0x00000e0000000000,
        0x00000010060a0300, 0x00000c0000000000, 0x00400000060a0300, 0x00000c0000000000, 0x0100000006090300, 0x00000e0000000000, 0x0400000000040000, 0x0000000400000000,
        0x030b030000000400, 0x060a0301030d030c, 0x0000000000000010, 0x0004000000000c00, 0x0000000004000000, 0x0000040000000004, 0x030d030c030b0300, 0x00400000060a0301,
        0x00000c0000000000, 0x0100000006020300, 0x00000e0000000000, 0x0000001006020300, 0x00000c0000000000, 0x0040000006020300, 0x00000e0000000000, 0x0400000000040000,
        0x0000000400000000, 0x0303030000000400, 0x0602030103050304, 0x0000000000000010, 0x0004000000000c00, 0x0000000004000000, 0x0000040000000004, 0x0305030403030300,
        0x0040000006020301, 0x0000100000000000, 0x0203000000060000, 0x0000000000001006, 0x0000000000000600, 0x0000000010000000, 0x10060a0300000006, 0x0600000000000000,
        0x0000000000000000, 0x0000000400000001, 0x3e0385a63d333d1c, 0xbe170e393d7e33ff, 0x00000500000000a0, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005,
        0x0000010000000377, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406,
        0x67000000066f0a0a, 0x000003776864696f, 0x0600000000000100, 0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200,
        0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x0100000003776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000,
        0x0300000000006200, 0x0000010e0e000000, 0x10000000010f0f00, 0x0000000000000110, 0x0000070000000700, 0x0004000000020000, 0x1000000003010100, 0x0300000100000000,
        0x0000100202000000, 0x0a00000008090900, 0x000001000000200a, 0x0400000010020200, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x000001000000030a,
        0x0000000000000000, 0x0000000000000000, 0x0010000000000300, 0x000001060e030000, 0x0010000000000000, 0x000001060f030000, 0x0010000000000000, 0x0000010610030000,
        0x0000a00000000000, 0x0202000000050000, 0x0568040464030363, 0x0000056e09097705, 0x0003776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000,
        0x0065000000000064, 0x0000006200000000, 0x0101000000060000, 0x0764060669020267, 0x6f0a0a7708086807, 0x64696f6700000006, 0x0001000000037768, 0x0000000600000000,
        0x0064000000000061, 0x0000006500000000, 0x0000000000660000, 0x0062000000000063, 0x0000000500000000, 0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000,
        0x0000000100000003, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000300000000, 0x0f0f000000010e0e, 0x0001101000000001,
        0x0007000000000000, 0x0200000000070000, 0x0101000004000000, 0x0000001000000003, 0x0000000300000100, 0x0909000000100202, 0x00200a0a00000008, 0x0202000000010000,
        0x0000000400000010, 0x0700000000000008, 0x0206000000000001, 0x00030a0000000000, 0x0000000000010000, 0x0000000000000000, 0x0003000000000000, 0x0300000010000000,
        0x000000000001060e, 0x0300000010000000, 0x000000000001060f, 0x0300000010000000, 0x0000000000010610, 0x0004000000010000, 0xd71e3afefc530000, 0x45f23af7de0c3b17,
        0x0500000000a0bb5a, 0x0303630202000000, 0x0977050568040464, 0x636e000000056e09, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000,
        0x0000000065000000, 0x0600000000006200, 0x0202670101000000, 0x0868070764060669, 0x0000066f0a0a7708, 0x0f776864696f6700, 0x0000000001000000, 0x0000610000000600,
        0x0000000064000000, 0x6600000000006500, 0x0000630000000000, 0x0000000062000000, 0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x00000f776864636e,
        0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x010e0e0000000300, 0x0000010f0f000000, 0x0000000001101000,
        0x0700000007000000, 0x0000000200000000, 0x0000010101000004, 0x0000800000001000, 0x1002020000000300, 0x0000020909000000, 0x01000000200a0a00, 0x0000020909000000,
        0x0000080000000400, 0x0000010700000000, 0x0000000206000000, 0x01000000030a0000, 0x0000010000000100, 0x0100000000000000, 0x000000000f000000, 0x01060e0300000010,
        0x0000000000000000, 0x01060f0300000010, 0x0000000000000000, 0x0106100300000010, 0x0000000000000000, 0x10060a030000000e, 0x0000000000000000, 0x00060a030000000c,
        0x0000000000004000, 0x000609030000000c, 0x0000000000010000, 0x000004000000000e, 0x0400000000040000, 0x0000000400000000, 0x01030d030c030b03, 0x0000000010060a03,
        0x0000000c00000000, 0x0004000000000400, 0x0000000004000000, 0x0c030b0300000004, 0x00060a0301030d03, 0x0000000000004000, 0x000602030000000c, 0x0000000000010000,
        0x100602030000000e, 0x0000000000000000, 0x000602030000000c, 0x0000000000004000, 0x000004000000000e, 0x0400000000040000, 0x0000000400000000, 0x0103050304030303,
        0x0000000010060203, 0x0000000c00000000, 0x0004000000000400, 0x0000000004000000, 0x0403030300000004, 0x0006020301030503, 0x0000000000004000, 0x0000060000000010,
        0x0000001006020300, 0x0000000600000000, 0x0010000000000000, 0x0300000006000000, 0x000000000010060a, 0x0000000000060000, 0x00000000a0000000, 0x0363020200000005,
        0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000,
        0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x000000010000000f, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000,
        0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005,
        0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0e0e000000030000, 0x00010f0f00000001, 0x0000000110100000, 0x0000000700000000, 0x0000020000000007,
        0x0001010100000400, 0x0080000000100000, 0x0202000000030000, 0x0002090900000010, 0x000000200a0a0000, 0x0002090900000001, 0x0008000000040000, 0x0001070000000000,
        0x0000020600000000, 0x000000030a000000, 0x0001000000010001, 0x0000000000000000, 0x0000000f00000001, 0x060e030000001000, 0x0000000000000001, 0x060f030000001000,
        0x0000000000000001, 0x0610030000001000, 0x0000000000000001, 0x060a030000000e00, 0x0000000000000010, 0x060a030000000c00, 0x0000000000400000, 0x0609030000000c00,
        0x0000000001000000, 0x0004000000000e00, 0x0000000004000000, 0x0000040000000004, 0x030d030c030b0300, 0x00000010060a0301, 0x00000c0000000000, 0x0400000000040000,
        0x0000000400000000, 0x030b030000000400, 0x060a0301030d030c, 0x0000000000400000, 0x0602030000000c00, 0x0000000001000000, 0x0602030000000e00, 0x0000000000000010,
        0x0602030000000c00, 0x0000000000400000, 0x0004000000000e00, 0x0000000004000000, 0x0000040000000004, 0x0305030403030300, 0x0000001006020301, 0x00000c0000000000,
        0x0400000000040000, 0x0000000400000000, 0x0303030000000400, 0x0602030103050304, 0x0000000000400000, 0x0006000000001000, 0x0000100602030000, 0x0000060000000000,
        0x1000000000000000, 0x0000000600000000, 0x0000000010060a03, 0x0000000006000000, 0x0000000100000000, 0x3cd1ac3a00000004, 0x3c00eb453ddbbdd5, 0x00000040bd8fad56,
        0x6302020000000500, 0x0505680404640303, 0x000000056e090977, 0x00000f776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000,
        0x0000000062000000, 0x6701010000000600, 0x0707640606690202, 0x066f0a0a77080868, 0x6864696f67000000, 0x0000010000000f77, 0x6100000006000000, 0x0000640000000000,
        0x0000000065000000, 0x6300000000006600, 0x0000620000000000, 0x0900000005000000, 0x640b0b630a0a6e09, 0x0005770d0d680c0c, 0x0f776864636e0000, 0x0000000001000000,
        0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0000000000000000, 0x0700000007000000, 0x0000000200000000, 0x0000010101000004,
        0x0000800000001000, 0x0802020000000300, 0x0000100909000000, 0x02000000100a0a00, 0x0000020909000000, 0x04000000080a0a00, 0x0000000008000000, 0x0000000001070000,
        0x0000000000020600, 0x0100010000000302, 0x0000000001000000, 0x0000010000000000, 0x000e000000000c00, 0x0000100602030000, 0x000c000000000000, 0x4000000602030000,
        0x000c000000000000, 0x0000000609030000, 0x000e000000000001, 0x0000000004000000, 0x0000040000000004, 0x0303000000040000, 0x0203010305030403, 0x0000000000001006,
        0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0503040303030000, 0x4000000602030103, 0x000e000000000000, 0x000010060a030000, 0x000c000000000000,
        0x400000060a030000, 0x000c000000000000, 0x0000000602030000, 0x000e000000000001, 0x0000000004000000, 0x0000040000000004, 0x0b03000000040000, 0x0a0301030d030c03,
        0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0d030c030b030000, 0x400000060a030103, 0x0010000000000000, 0x0300000006000000,
        0x0000000000100602, 0x0000000000060000, 0x0000001000000000, 0x060a030000000600, 0x0000000000000010, 0x0000000000000006, 0x0005000000004000, 0x6403036302020000,
        0x0909770505680404, 0x64636e000000056e, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062,
        0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77, 0x000f776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065,
        0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000,
        0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000010101, 0x0003000000800000,
        0x0000000802020000, 0x0a0a000000100909, 0x0000000200000010, 0x0a0a000000020909, 0x0000000400000008, 0x0700000000000008, 0x0206000000000001, 0x0003020000000000,
        0x0000000100010000, 0x0000000000000001, 0x000c000000010000, 0x030000000e000000, 0x0000000000100602, 0x030000000c000000, 0x0000004000000602, 0x030000000c000000,
        0x0000010000000609, 0x000000000e000000, 0x0000040000000004, 0x0400000000040000, 0x0304030303000000, 0x0010060203010305, 0x0c00000000000000, 0x0000000400000000,
        0x0004000000000400, 0x0300000004000000, 0x0301030503040303, 0x0000004000000602, 0x030000000e000000, 0x000000000010060a, 0x030000000c000000, 0x000000400000060a,
        0x030000000c000000, 0x0000010000000602, 0x000000000e000000, 0x0000040000000004, 0x0400000000040000, 0x030c030b03000000, 0x0010060a0301030d, 0x0c00000000000000,
        0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030d030c030b, 0x000000400000060a, 0x0000000010000000, 0x1006020300000006, 0x0600000000000000,
        0x0000000000000000, 0x0006000000001000, 0x000010060a030000, 0x0000060000000000, 0x0001000000000000, 0xd6b8000000040000, 0x3f923db05dd73e05, 0x0040bf27a5103eb6,
        0x0200000005000000, 0x6804046403036302, 0x00056e0909770505, 0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400,
        0x0000620000000000, 0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707, 0x696f67000000066f, 0x010000000f776864, 0x0000060000000000, 0x6400000000006100,
        0x0000650000000000, 0x0000000066000000, 0x6200000000006300, 0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000f77,
        0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000000000000000, 0x0000070000000000, 0x0002000000000700, 0x0101010000040000,
        0x8000000010000000, 0x0200000003000000, 0x4009090000000202, 0x0000100a0a000000, 0x040a0a0000000200, 0x0000080d0d000000, 0x0000080000000400, 0x0000010700000000,
        0x0000000206000000, 0x0100000003020000, 0x0000010000000100, 0x0100000000000000, 0x000000000c000000, 0x100602030000000e, 0x0000000000000000, 0x000602030000000c,
        0x0000000000004000, 0x000609030000000c, 0x0000000000010000, 0x000004000000000e, 0x0400000000040000, 0x0000000400000000, 0x0103050304030303, 0x0000000010060203,
        0x0000000c00000000, 0x0004000000000400, 0x0000000004000000, 0x0403030300000004, 0x0006020301030503, 0x0000000000004000, 0x10060a030000000e, 0x0000000000000000,
        0x00060a030000000c, 0x0000000000004000, 0x000602030000000c, 0x0000000000010000, 0x000004000000000e, 0x0400000000040000, 0x0000000400000000, 0x01030d030c030b03,
        0x0000000010060a03, 0x0000000c00000000, 0x0004000000000400, 0x0000000004000000, 0x0c030b0300000004, 0x00060a0301030d03, 0x0000000000004000, 0x0000060000000010,
        0x0000001006020300, 0x0000000600000000, 0x0010000000000000, 0x0300000006000000, 0x000000000010060a, 0x0000000000060000, 0x0000000040000000, 0x0363020200000005,
        0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000,
        0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x000000010000000f, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000,
        0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005,
        0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0000000000000000, 0x0007000000070000, 0x0400000002000000, 0x0000000101010000, 0x0000008000000010,
        0x0002020200000003, 0x0000004009090000, 0x0002000000100a0a, 0x000000040a0a0000, 0x0004000000080d0d, 0x0000000000080000, 0x0000000000010700, 0x0200000000000206,
        0x0001000100000003, 0x0000000000010000, 0x0000000100000000, 0x00000e000000000c, 0x0000001006020300, 0x00000c0000000000, 0x0040000006020300, 0x00000c0000000000,
        0x0100000006090300, 0x00000e0000000000, 0x0400000000040000, 0x0000000400000000, 0x0303030000000400, 0x0602030103050304, 0x0000000000000010, 0x0004000000000c00,
        0x0000000004000000, 0x0000040000000004, 0x0305030403030300, 0x0040000006020301, 0x00000e0000000000, 0x00000010060a0300, 0x00000c0000000000, 0x00400000060a0300,
        0x00000c0000000000, 0x0100000006020300, 0x00000e0000000000, 0x0400000000040000, 0x0000000400000000, 0x030b030000000400, 0x060a0301030d030c, 0x0000000000000010,
        0x0004000000000c00, 0x0000000004000000, 0x0000040000000004, 0x030d030c030b0300, 0x00400000060a0301, 0x0000100000000000, 0x0203000000060000, 0x0000000000001006,
        0x0000000000000600, 0x0000000010000000, 0x10060a0300000006, 0x0600000000000000, 0x0000000000000000, 0x0000000400000001, 0x3e8753e43d97edf1, 0xbeb6d0e43e2d156f,
        0x0000050000000040, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000,
        0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000,
        0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864,
        0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0000000000006200, 0x0700000000000000, 0x0000000007000000, 0x0100000400000002,
        0x0000100000000101, 0x0000030000008000, 0x0900000004020200, 0x400a0a0000000809, 0x0a00000002000000, 0x080d0d000000020a, 0x0800000004000000, 0x0107000000000000,
        0x0002060000000000, 0x0000030200000000, 0x0100000001000100, 0x0000000000000000, 0x00000c0000000100, 0x02030000000e0000, 0x0000000000001006, 0x02030000000c0000,
        0x0000000040000006, 0x09030000000c0000, 0x0000000100000006, 0x04000000000e0000, 0x0000000400000000, 0x0004000000000400, 0x0503040303030000, 0x0000100602030103,
        0x000c000000000000, 0x0000000004000000, 0x0000040000000004, 0x0303000000040000, 0x0203010305030403, 0x0000000040000006, 0x0a030000000e0000, 0x0000000000001006,
        0x0a030000000c0000, 0x0000000040000006, 0x02030000000c0000, 0x0000000100000006, 0x04000000000e0000, 0x0000000400000000, 0x0004000000000400, 0x0d030c030b030000,
        0x000010060a030103, 0x000c000000000000, 0x0000000004000000, 0x0000040000000004, 0x0b03000000040000, 0x0a0301030d030c03, 0x0000000040000006, 0x0600000000100000,
        0x0010060203000000, 0x0006000000000000, 0x0000000000000000, 0x0000060000000010, 0x00000010060a0300, 0x0000000600000000, 0x0000400000000000, 0x0202000000050000,
        0x0568040464030363, 0x0000056e09097705, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000,
        0x0101000000060000, 0x0764060669020267, 0x6f0a0a7708086807, 0x64696f6700000006, 0x00010000000f7768, 0x0000000600000000, 0x0064000000000061, 0x0000006500000000,
        0x0000000000660000, 0x0062000000000063, 0x0000000500000000, 0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000,
        0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000000000000, 0x0000000700000000, 0x0000020000000007, 0x0001010100000400, 0x0080000000100000,
        0x0202000000030000, 0x0008090900000004, 0x000000400a0a0000, 0x00020a0a00000002, 0x000000080d0d0000, 0x0000000800000004, 0x0000000107000000, 0x0000000002060000,
        0x0001000000030200, 0x0000000100000001, 0x0001000000000000, 0x0e000000000c0000, 0x0010060203000000, 0x0c00000000000000, 0x0000060203000000, 0x0c00000000000040,
        0x0000060903000000, 0x0e00000000000100, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030503040303, 0x0000000000100602, 0x000000000c000000,
        0x0000040000000004, 0x0400000000040000, 0x0304030303000000, 0x0000060203010305, 0x0e00000000000040, 0x0010060a03000000, 0x0c00000000000000, 0x0000060a03000000,
        0x0c00000000000040, 0x0000060203000000, 0x0e00000000000100, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030d030c030b, 0x000000000010060a,
        0x000000000c000000, 0x0000040000000004, 0x0400000000040000, 0x030c030b03000000, 0x0000060a0301030d, 0x1000000000000040, 0x0000000600000000, 0x0000000010060203,
        0x0000000006000000, 0x0000100000000000, 0x0a03000000060000, 0x0000000000001006, 0x0000000000000600, 0x0004000000010000, 0x075b3d81e72e0000, 0xbff2bd352a6f3eda,
        0x050000000040becd, 0x0303630202000000, 0x0977050568040464, 0x636e000000056e09, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000,
        0x0000000065000000, 0x0600000000006200, 0x0202670101000000, 0x0868070764060669, 0x0000066f0a0a7708, 0x0f776864696f6700, 0x0000000001000000, 0x0000610000000600,
        0x0000000064000000, 0x6600000000006500, 0x0000630000000000, 0x0000000062000000, 0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x00000f776864636e,
        0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x0000000000000000, 0x0000070000000700, 0x0004000000020000,
        0x1000000001010100, 0x0300000080000000, 0x0000020202000000, 0x0a00000010090900, 0x000001000000200a, 0x04000000040d0d00, 0x0000000008000000, 0x0000000001070000,
        0x0000000000020600, 0x0100010000000302, 0x0000000001000000, 0x0000010000000000, 0x000e000000000c00, 0x0000100602030000, 0x000c000000000000, 0x4000000602030000,
        0x000c000000000000, 0x0000000609030000, 0x000e000000000001, 0x0000000004000000, 0x0000040000000004, 0x0303000000040000, 0x0203010305030403, 0x0000000000001006,
        0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0503040303030000, 0x4000000602030103, 0x000e000000000000, 0x000010060a030000, 0x000c000000000000,
        0x400000060a030000, 0x000c000000000000, 0x0000000602030000, 0x000e000000000001, 0x0000000004000000, 0x0000040000000004, 0x0b03000000040000, 0x0a0301030d030c03,
        0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0d030c030b030000, 0x400000060a030103, 0x0010000000000000, 0x0300000006000000,
        0x0000000000100602, 0x0000000000060000, 0x0000001000000000, 0x060a030000000600, 0x0000000000000010, 0x0000000000000006, 0x0005000000004000, 0x6403036302020000,
        0x0909770505680404, 0x64636e000000056e, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062,
        0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77, 0x000f776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065,
        0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000,
        0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000010101, 0x0003000000800000,
        0x0000000202020000, 0x0a0a000000100909, 0x0000000100000020, 0x0004000000040d0d, 0x0000000000080000, 0x0000000000010700, 0x0200000000000206, 0x0001000100000003,
        0x0000000000010000, 0x0000000100000000, 0x00000e000000000c, 0x0000001006020300, 0x00000c0000000000, 0x0040000006020300, 0x00000c0000000000, 0x0100000006090300,
        0x00000e0000000000, 0x0400000000040000, 0x0000000400000000, 0x0303030000000400, 0x0602030103050304, 0x0000000000000010, 0x0004000000000c00, 0x0000000004000000,
        0x0000040000000004, 0x0305030403030300, 0x0040000006020301, 0x00000e0000000000, 0x00000010060a0300, 0x00000c0000000000, 0x00400000060a0300, 0x00000c0000000000,
        0x0100000006020300, 0x00000e0000000000, 0x0400000000040000, 0x0000000400000000, 0x030b030000000400, 0x060a0301030d030c, 0x0000000000000010, 0x0004000000000c00,
        0x0000000004000000, 0x0000040000000004, 0x030d030c030b0300, 0x00400000060a0301, 0x0000100000000000, 0x0203000000060000, 0x0000000000001006, 0x0000000000000600,
        0x0000000010000000, 0x10060a0300000006, 0x0600000000000000, 0x0000000000000000, 0x0000000400000001, 0x3de6e0ad3a5e1cce, 0xbf537e6c3e427e66, 0x00000500000000a0,
        0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500,
        0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000, 0x6500000000006400,
        0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864, 0x0000050000000000,
        0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0300000000006200, 0x0000010e0e000000, 0x10000000010f0f00, 0x0000000000000110, 0x0000070000000700,
        0x0004000000020000, 0x1000000001010100, 0x0300000080000000, 0x0000100202000000, 0x0a00000008050500, 0x000002000000020a, 0x0500000004020200, 0x0000040000001005,
        0x0000000000000800, 0x0600000000000107, 0x030a000000000002, 0x0000010001000000, 0x0000000000000100, 0x1000000001000000, 0x0000001000000000, 0x0000000001060e03,
        0x0000001000000000, 0x0000000001060f03, 0x0000001000000000, 0x0000000001061003, 0x0000000e00000000, 0x0000000010060a03, 0x0000000c00000000, 0x0000400000060a03,
        0x0000000c00000000, 0x0001000000060d03, 0x0000000e00000000, 0x0301030000000400, 0x000000000010060a, 0x000000000c000000, 0x0a03010300000004, 0x0000000040000006,
        0x02030000000c0000, 0x0000000100000006, 0x02030000000e0000, 0x0000000000001006, 0x02030000000c0000, 0x0000000040000006, 0x05030000000c0000, 0x0000000100000006,
        0x04000000000e0000, 0x0602030103000000, 0x0000000000000010, 0x0004000000000c00, 0x0006020301030000, 0x0000000000004000, 0x0000060000000010, 0x0000001006020300,
        0x0000000600000000, 0x0010000000000000, 0x0300000006000000, 0x000000000010060a, 0x0000000000060000, 0x00000000a0000000, 0x0363020200000005, 0x7705056804046403,
        0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0267010100000006,
        0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x000000010000000f, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000, 0x0063000000000066,
        0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000,
        0x0065000000000064, 0x0000006200000000, 0x0e0e000000030000, 0x00010f0f00000001, 0x0000000110100000, 0x0000000700000000, 0x0000020000000007, 0x0001010100000400,
        0x0080000000100000, 0x0202000000030000, 0x0008050500000010, 0x000000020a0a0000, 0x0004020200000002, 0x0000001005050000, 0x0000000800000004, 0x0000000107000000,
        0x0000000002060000, 0x0001000000030a00, 0x0000000100000001, 0x0001000000000000, 0x1000000000100000, 0x0001060e03000000, 0x1000000000000000, 0x0001060f03000000,
        0x1000000000000000, 0x0001061003000000, 0x0e00000000000000, 0x0010060a03000000, 0x0c00000000000000, 0x0000060a03000000, 0x0c00000000000040, 0x0000060d03000000,
        0x0e00000000000100, 0x0000000400000000, 0x000010060a030103, 0x000c000000000000, 0x0300000004000000, 0x00400000060a0301, 0x00000c0000000000, 0x0100000006020300,
        0x00000e0000000000, 0x0000001006020300, 0x00000c0000000000, 0x0040000006020300, 0x00000c0000000000, 0x0100000006050300, 0x00000e0000000000, 0x0103000000040000,
        0x0000000010060203, 0x0000000c00000000, 0x0301030000000400, 0x0000004000000602, 0x0000000010000000, 0x1006020300000006, 0x0600000000000000, 0x0000000000000000,
        0x0006000000001000, 0x000010060a030000, 0x0000060000000000, 0x0001000000000000, 0x3ce7000000040000, 0xc4803dfb08a93c89, 0x0040be3ba2db3d2e, 0x0200000005000000,
        0x6804046403036302, 0x00056e0909770505, 0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000,
        0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707, 0x696f67000000066f, 0x010000000f776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000,
        0x0000000066000000, 0x6200000000006300, 0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000,
        0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000000000000000, 0x0000070000000000, 0x0002000000000700, 0x0101010000040000, 0x8000000010000000,
        0x0200000003000000, 0x0409090000000202, 0x0000400a0a000000, 0x100a0a0000000100, 0x0800000004000000, 0x0107000000000000, 0x0002060000000000, 0x0000030200000000,
        0x0000000000000100, 0x0000000000000000, 0x0000000000000000, 0x0005000000004000, 0x6403036302020000, 0x0909770505680404, 0x64636e000000056e, 0x00010000000f7768,
        0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062, 0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77,
        0x000f776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065, 0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005,
        0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000,
        0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000010101, 0x0003000000800000, 0x0000000202020000, 0x0a0a000000040909, 0x0000000100000040,
        0x0004000000100a0a, 0x0000000000080000, 0x0000000000010700, 0x0200000000000206, 0x0000000100000003, 0x0000000000000000, 0x0000000000000000, 0x0000000100000000,
        0x3cc30d0a00000004, 0x3daee9823d771bfe, 0x00000040be98993c, 0x6302020000000500, 0x0505680404640303, 0x000000056e090977, 0x00000f776864636e, 0x0500000000000100,
        0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x6701010000000600, 0x0707640606690202, 0x066f0a0a77080868, 0x6864696f67000000,
        0x0000010000000f77, 0x6100000006000000, 0x0000640000000000, 0x0000000065000000, 0x6300000000006600, 0x0000620000000000, 0x0900000005000000, 0x640b0b630a0a6e09,
        0x0005770d0d680c0c, 0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0000000000000000,
        0x0700000007000000, 0x0000000200000000, 0x0000010101000004, 0x0000800000001000, 0x0402020000000300, 0x0000080909000000, 0x02000000400a0a00, 0x0000080909000000,
        0x04000000080a0a00, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x0100010000000302, 0x0000000001000000, 0x0000010000000000, 0x000e000000000c00,
        0x0000100602030000, 0x000c000000000000, 0x4000000602030000, 0x000c000000000000, 0x0000000609030000, 0x000e000000000001, 0x0000000004000000, 0x0000040000000004,
        0x0303000000040000, 0x0203010305030403, 0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0503040303030000, 0x4000000602030103,
        0x000e000000000000, 0x000010060a030000, 0x000c000000000000, 0x400000060a030000, 0x000c000000000000, 0x0000000602030000, 0x000e000000000001, 0x0000000004000000,
        0x0000040000000004, 0x0b03000000040000, 0x0a0301030d030c03, 0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0d030c030b030000,
        0x400000060a030103, 0x0010000000000000, 0x0300000006000000, 0x0000000000100602, 0x0000000000060000, 0x0000001000000000, 0x060a030000000600, 0x0000000000000010,
        0x0000000000000006, 0x0005000000004000, 0x6403036302020000, 0x0909770505680404, 0x64636e000000056e, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061,
        0x0000006400000000, 0x0000000000650000, 0x0006000000000062, 0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77, 0x000f776864696f67, 0x0000000000010000,
        0x0000006100000006, 0x0000000000640000, 0x0066000000000065, 0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d,
        0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0000000000000000, 0x0000000700000007,
        0x0000040000000200, 0x0010000000010101, 0x0003000000800000, 0x0000000402020000, 0x0a0a000000080909, 0x0000000200000040, 0x0a0a000000080909, 0x0000000400000008,
        0x0700000000000008, 0x0206000000000001, 0x0003020000000000, 0x0000000100010000, 0x0000000000000001, 0x000c000000010000, 0x030000000e000000, 0x0000000000100602,
        0x030000000c000000, 0x0000004000000602, 0x030000000c000000, 0x0000010000000609, 0x000000000e000000, 0x0000040000000004, 0x0400000000040000, 0x0304030303000000,
        0x0010060203010305, 0x0c00000000000000, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030503040303, 0x0000004000000602, 0x030000000e000000,
        0x000000000010060a, 0x030000000c000000, 0x000000400000060a, 0x030000000c000000, 0x0000010000000602, 0x000000000e000000, 0x0000040000000004, 0x0400000000040000,
        0x030c030b03000000, 0x0010060a0301030d, 0x0c00000000000000, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030d030c030b, 0x000000400000060a,
        0x0000000010000000, 0x1006020300000006, 0x0600000000000000, 0x0000000000000000, 0x0006000000001000, 0x000010060a030000, 0x0000060000000000, 0x0001000000000000,
        0xe7b2000000040000, 0x30603ea337d63d3b, 0x00c0bebd2e603e94, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505, 0x0f776864636e0000, 0x0000000001000000,
        0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707, 0x696f67000000066f,
        0x010000000f776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300, 0x0000050000000000, 0x0b630a0a6e090900,
        0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000000000000000,
        0x0000070000000000, 0x0002000000000700, 0x0101010000040000, 0x8000000010000000, 0x0200000003000000, 0x100a0a0000000802, 0x0000040d0d000000, 0x080a0a0000000100,
        0x0900000004000000, 0x010d000000000000, 0x00020c0000000000, 0x0000030b00000000, 0x0000000000000100, 0x0000000000000000, 0x0000000000000000, 0x000500000000c000,
        0x6403036302020000, 0x0909770505680404, 0x64636e000000056e, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000,
        0x0006000000000062, 0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77, 0x000f776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000,
        0x0066000000000065, 0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000f77686463, 0x0005000000000001,
        0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000010101,
        0x0003000000800000, 0x0000000802020000, 0x0d0d000000100a0a, 0x0000000100000004, 0x0004000000080a0a, 0x0000000000090000, 0x0000000000010d00, 0x0b0000000000020c,
        0x0000000100000003, 0x0000000000000000, 0x0000000000000000, 0x0000000100000000, 0x3a00cdb600000004, 0x3a9c15083a9c156d, 0x000000403da52315, 0x6302020000000500,
        0x0505680404640303, 0x000000056e090977, 0x00000f776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000,
        0x6701010000000600, 0x0707640606690202, 0x066f0a0a77080868, 0x6864696f67000000, 0x0000010000000f77, 0x6100000006000000, 0x0000640000000000, 0x0000000065000000,
        0x6300000000006600, 0x0000620000000000, 0x0900000005000000, 0x640b0b630a0a6e09, 0x0005770d0d680c0c, 0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500,
        0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0000000000000000, 0x0700000007000000, 0x0000000200000000, 0x0000010101000004, 0x0000800000001000,
        0x1002020000000300, 0x0000040909000000, 0x02000000100a0a00, 0x0000040a0a000000, 0x04000000100d0d00, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600,
        0x0000010000000302, 0x0000000000000000, 0x0000000000000000, 0x0000400000000000, 0x0202000000050000, 0x0568040464030363, 0x0000056e09097705, 0x000f776864636e00,
        0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0101000000060000, 0x0764060669020267, 0x6f0a0a7708086807,
        0x64696f6700000006, 0x00010000000f7768, 0x0000000600000000, 0x0064000000000061, 0x0000006500000000, 0x0000000000660000, 0x0062000000000063, 0x0000000500000000,
        0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065,
        0x0000000000000000, 0x0000000700000000, 0x0000020000000007, 0x0001010100000400, 0x0080000000100000, 0x0202000000030000, 0x0004090900000010, 0x000000100a0a0000,
        0x00040a0a00000002, 0x000000100d0d0000, 0x0000000800000004, 0x0000000107000000, 0x0000000002060000, 0x0001000000030200, 0x0000000000000000, 0x0000000000000000,
        0x0001000000000000, 0x963e000000040000, 0xea763d82bceb3ca8, 0x0040bd7808373d3a, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505, 0x0f776864636e0000,
        0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707,
        0x696f67000000066f, 0x010000000f776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300, 0x0000050000000000,
        0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500,
        0x0000000000000000, 0x0000070000000000, 0x0002000000000700, 0x0101010000040000, 0x8000000010000000, 0x0200000003000000, 0x200a0a0000000402, 0x0000020d0d000000,
        0x0000040000000000, 0x0000000000000800, 0x0600000000000107, 0x0302000000000002, 0x0000010001000000, 0x0000000000000100, 0x0e00000001000000, 0x0000000e00000000,
        0x0000000010060203, 0x0000000c00000000, 0x0000400000060203, 0x0000000c00000000, 0x0001000000060503, 0x0000000e00000000, 0x0004000000000400, 0x0203010310030000,
        0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0006020301031003, 0x0000000000004000, 0x0106100300000010, 0x0000000000000000, 0x10060a030000000e,
        0x0000000000000000, 0x00060a030000000c, 0x0000000000004000, 0x000602030000000c, 0x0000000000010000, 0x00060d030000000c, 0x0000000000010000, 0x000004000000000e,
        0x0010060a03010300, 0x0c00000000000000, 0x0000000400000000, 0x400000060a030103, 0x0010000000000000, 0x0300000006000000, 0x0000000000100602, 0x0000000000060000,
        0x0000001000000000, 0x060a030000000600, 0x0000000000000010, 0x0000000000000006, 0x0005000000004000, 0x6403036302020000, 0x0909770505680404, 0x64636e000000056e,
        0x00010000000f7768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062, 0x6902026701010000, 0x0808680707640606,
        0x000000066f0a0a77, 0x000f776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065, 0x0000006300000000, 0x0000000000620000,
        0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000,
        0x0000000000620000, 0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000010101, 0x0003000000800000, 0x0000000402020000, 0x0d0d000000200a0a,
        0x0000000000000002, 0x0000000800000004, 0x0000000107000000, 0x0000000002060000, 0x0001000000030200, 0x0000000100000001, 0x0001000000000000, 0x0e000000000e0000,
        0x0010060203000000, 0x0c00000000000000, 0x0000060203000000, 0x0c00000000000040, 0x0000060503000000, 0x0e00000000000100, 0x0000000400000000, 0x0310030000000400,
        0x0000001006020301, 0x00000c0000000000, 0x0400000000040000, 0x0301031003000000, 0x0000004000000602, 0x0300000010000000, 0x0000000000010610, 0x030000000e000000,
        0x000000000010060a, 0x030000000c000000, 0x000000400000060a, 0x030000000c000000, 0x0000010000000602, 0x030000000c000000, 0x000001000000060d, 0x000000000e000000,
        0x0a03010300000004, 0x0000000000001006, 0x04000000000c0000, 0x060a030103000000, 0x0000000000400000, 0x0006000000001000, 0x0000100602030000, 0x0000060000000000,
        0x1000000000000000, 0x0000000600000000, 0x0000000010060a03, 0x0000000006000000, 0x0000000100000000, 0x3b560cb100000004, 0x3bdd31a53dd286b5, 0x000000a0be854c43,
        0x6302020000000500, 0x0505680404640303, 0x000000056e090977, 0x000003776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000,
        0x0000000062000000, 0x6701010000000600, 0x0707640606690202, 0x066f0a0a77080868, 0x6864696f67000000, 0x0000010000000377, 0x6100000006000000, 0x0000640000000000,
        0x0000000065000000, 0x6300000000006600, 0x0000620000000000, 0x0900000005000000, 0x640b0b630a0a6e09, 0x0005770d0d680c0c, 0x03776864636e0000, 0x0000000001000000,
        0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0e00000003000000, 0x010f0f000000010e, 0x0000011010000000, 0x0000070000000000,
        0x0002000000000700, 0x0301010000040000, 0x0000000010000000, 0x0200000003000001, 0x0805050000001002, 0x0000200a0a000000, 0x0802020000000200, 0x0000040505000000,
        0x0000080000000400, 0x0000010700000000, 0x0000000206000000, 0x01000000030a0000, 0x0000000000000000, 0x0000000000000000, 0x0000000003000000, 0x01060e0300000010,
        0x0000000000000000, 0x01060f0300000010, 0x0000000000000000, 0x0106100300000010, 0xa000000000000000, 0x0000000500000000, 0x0404640303630202, 0x056e090977050568,
        0x776864636e000000, 0x0000000100000003, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000600000000, 0x0606690202670101,
        0x0a77080868070764, 0x6f67000000066f0a, 0x0000000377686469, 0x0006000000000001, 0x0000000000610000, 0x0065000000000064, 0x0000006600000000, 0x0000000000630000,
        0x0005000000000062, 0x630a0a6e09090000, 0x0d0d680c0c640b0b, 0x64636e0000000577, 0x0001000000037768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000,
        0x0000000000650000, 0x0003000000000062, 0x000000010e0e0000, 0x1010000000010f0f, 0x0000000000000001, 0x0000000700000007, 0x0000040000000200, 0x0010000000030101,
        0x0003000001000000, 0x0000001002020000, 0x0a0a000000080505, 0x0000000200000020, 0x0505000000080202, 0x0000000400000004, 0x0700000000000008, 0x0206000000000001,
        0x00030a0000000000, 0x0000000000010000, 0x0000000000000000, 0x0003000000000000, 0x0300000010000000, 0x000000000001060e, 0x0300000010000000, 0x000000000001060f,
        0x0300000010000000, 0x0000000000010610, 0x0004000000010000, 0x99d33aa4ebe40000, 0x6e073acf25553b39, 0x050000000040bb2e, 0x0303630202000000, 0x0977050568040464,
        0x636e000000056e09, 0x0100000003776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0600000000006200, 0x0202670101000000,
        0x0868070764060669, 0x0000066f0a0a7708, 0x03776864696f6700, 0x0000000001000000, 0x0000610000000600, 0x0000000064000000, 0x6600000000006500, 0x0000630000000000,
        0x0000000062000000, 0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x000003776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300,
        0x0000650000000000, 0x0000000062000000, 0x0000000000000000, 0x0000070000000700, 0x0004000000020000, 0x1000000003010100, 0x0300000100000000, 0x0000400202000000,
        0x0d000000200a0a00, 0x000002000000100d, 0x0d000000040a0a00, 0x000004000000040d, 0x0000000000000800, 0x0600000000000107, 0x0302000000000002, 0x0000010001000000,
        0x0000030000000100, 0x0d00000001010100, 0x0000000e00000000, 0x0000000040060203, 0x0000000c00000000, 0x0001000000060203, 0x0000000c00000000, 0x0001000000060503,
        0x0000000e00000000, 0x0010030000000400, 0x0203010300000004, 0x0000000000004006, 0x04000000000c0000, 0x0004001003000000, 0x0006020301030000, 0x0000000000010000,
        0x0106100300000010, 0x0000000000000000, 0x40060a030000000e, 0x0000000000000000, 0x00060a030000000c, 0x0000000000010000, 0x00060d030000000c, 0x0000000000010000,
        0x000004000000000e, 0x0040060a03010300, 0x0c00000000000000, 0x0000000400000000, 0x000000060a030103, 0x0010000000000001, 0x0300000006000000, 0x0000000000400602,
        0x0000000000060000, 0x0000001000000000, 0x060a030000000600, 0x0000000000000040, 0x0000000000000006, 0x0005000000004000, 0x6403036302020000, 0x0909770505680404,
        0x64636e000000056e, 0x0001000000037768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062, 0x6902026701010000,
        0x0808680707640606, 0x000000066f0a0a77, 0x0003776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065, 0x0000006300000000,
        0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000377686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063,
        0x0000006500000000, 0x0000000000620000, 0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000030101, 0x0003000001000000, 0x0000004002020000,
        0x0d0d000000200a0a, 0x0000000200000010, 0x0d0d000000040a0a, 0x0000000400000004, 0x0700000000000008, 0x0206000000000001, 0x0003020000000000, 0x0000000100010000,
        0x0000000300000001, 0x000d000000010101, 0x030000000e000000, 0x0000000000400602, 0x030000000c000000, 0x0000010000000602, 0x030000000c000000, 0x0000010000000605,
        0x000000000e000000, 0x0400100300000004, 0x0602030103000000, 0x0000000000000040, 0x0004000000000c00, 0x0000040010030000, 0x0000060203010300, 0x1000000000000100,
        0x0001061003000000, 0x0e00000000000000, 0x0040060a03000000, 0x0c00000000000000, 0x0000060a03000000, 0x0c00000000000100, 0x0000060d03000000, 0x0e00000000000100,
        0x0000000400000000, 0x000040060a030103, 0x000c000000000000, 0x0300000004000000, 0x01000000060a0301, 0x0000100000000000, 0x0203000000060000, 0x0000000000004006,
        0x0000000000000600, 0x0000000010000000, 0x40060a0300000006, 0x0600000000000000, 0x0000000000000000, 0x0000000400000001, 0x3dbbbfef3ce08d45, 0xbd82d1debc46d4aa,
        0x00000500000000a0, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000,
        0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000,
        0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864,
        0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0300000000006200, 0x0000010e0e000000, 0x10000000010f0f00, 0x0000000000000110,
        0x0000070000000700, 0x0004000000020000, 0x1000000001010100, 0x0300000080000000, 0x0000200202000000, 0x0a00000008090900, 0x000001000000040a, 0x0400000010020200,
        0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x010001000000030a, 0x0000000001000000, 0x0000010000000000, 0x0010000000000f00, 0x000001060e030000,
        0x0010000000000000, 0x000001060f030000, 0x0010000000000000, 0x0000010610030000, 0x000e000000000000, 0x000010060a030000, 0x000c000000000000, 0x400000060a030000,
        0x000c000000000000, 0x0000000609030000, 0x000e000000000001, 0x0000000004000000, 0x0000040000000004, 0x0b03000000040000, 0x0a0301030d030c03, 0x0000000000001006,
        0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0d030c030b030000, 0x400000060a030103, 0x000c000000000000, 0x0000000602030000, 0x000e000000000001,
        0x0000100602030000, 0x000c000000000000, 0x4000000602030000, 0x000e000000000000, 0x0000000004000000, 0x0000040000000004, 0x0303000000040000, 0x0203010305030403,
        0x0000000000001006, 0x04000000000c0000, 0x0000000400000000, 0x0004000000000400, 0x0503040303030000, 0x4000000602030103, 0x0010000000000000, 0x0300000006000000,
        0x0000000000100602, 0x0000000000060000, 0x0000001000000000, 0x060a030000000600, 0x0000000000000010, 0x0000000000000006, 0x000500000000a000, 0x6403036302020000,
        0x0909770505680404, 0x64636e000000056e, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062,
        0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77, 0x000f776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065,
        0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000,
        0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x00010e0e00000003, 0x000000010f0f0000, 0x0000000000011010, 0x0007000000070000, 0x0400000002000000,
        0x0000000101010000, 0x0000008000000010, 0x0020020200000003, 0x0000000809090000, 0x0001000000040a0a, 0x0000001002020000, 0x0000000800000004, 0x0000000107000000,
        0x0000000002060000, 0x0001000000030a00, 0x0000000100000001, 0x0001000000000000, 0x10000000000f0000, 0x0001060e03000000, 0x1000000000000000, 0x0001060f03000000,
        0x1000000000000000, 0x0001061003000000, 0x0e00000000000000, 0x0010060a03000000, 0x0c00000000000000, 0x0000060a03000000, 0x0c00000000000040, 0x0000060903000000,
        0x0e00000000000100, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030d030c030b, 0x000000000010060a, 0x000000000c000000, 0x0000040000000004,
        0x0400000000040000, 0x030c030b03000000, 0x0000060a0301030d, 0x0c00000000000040, 0x0000060203000000, 0x0e00000000000100, 0x0010060203000000, 0x0c00000000000000,
        0x0000060203000000, 0x0e00000000000040, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030503040303, 0x0000000000100602, 0x000000000c000000,
        0x0000040000000004, 0x0400000000040000, 0x0304030303000000, 0x0000060203010305, 0x1000000000000040, 0x0000000600000000, 0x0000000010060203, 0x0000000006000000,
        0x0000100000000000, 0x0a03000000060000, 0x0000000000001006, 0x0000000000000600, 0x0004000000010000, 0x3a713da7178f0000, 0xfef03e1232033e35, 0x050000000040bf17,
        0x0303630202000000, 0x0977050568040464, 0x636e000000056e09, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000,
        0x0600000000006200, 0x0202670101000000, 0x0868070764060669, 0x0000066f0a0a7708, 0x0f776864696f6700, 0x0000000001000000, 0x0000610000000600, 0x0000000064000000,
        0x6600000000006500, 0x0000630000000000, 0x0000000062000000, 0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x00000f776864636e, 0x0500000000000100,
        0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x0000000000000000, 0x0000070000000700, 0x0004000000020000, 0x1000000001010100,
        0x0300000080000000, 0x0000100202000000, 0x0a00000004090900, 0x000001000000100a, 0x04000000080a0a00, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600,
        0x0000010000000302, 0x0000000000000000, 0x0000000000000000, 0x0000400000000000, 0x0202000000050000, 0x0568040464030363, 0x0000056e09097705, 0x000f776864636e00,
        0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0101000000060000, 0x0764060669020267, 0x6f0a0a7708086807,
        0x64696f6700000006, 0x00010000000f7768, 0x0000000600000000, 0x0064000000000061, 0x0000006500000000, 0x0000000000660000, 0x0062000000000063, 0x0000000500000000,
        0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065,
        0x0000000000000000, 0x0000000700000000, 0x0000020000000007, 0x0001010100000400, 0x0080000000100000, 0x0202000000030000, 0x0004090900000010, 0x000000100a0a0000,
        0x00080a0a00000001, 0x0008000000040000, 0x0001070000000000, 0x0000020600000000, 0x0000000302000000, 0x0000000000000001, 0x0000000000000000, 0x0000000000000000,
        0x0000000400000001, 0x3d6bcfeb3cba2631, 0xbdbf98f73d6bcfe4, 0x0000050000000040, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000377,
        0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a,
        0x000003776864696f, 0x0600000000000100, 0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000,
        0x0d680c0c640b0b63, 0x636e00000005770d, 0x0100000003776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0000000000006200,
        0x0700000000000000, 0x0000000007000000, 0x0100000400000002, 0x0000100000000301, 0x0000030000010000, 0x0a00000040020200, 0x400d0d000000100a, 0x0a00000001000000,
        0x000004000000040a, 0x0000000000000800, 0x0600000000000107, 0x0302000000000002, 0x0000010001000000, 0x0000030000000100, 0x0d00000001010100, 0x0000000e00000000,
        0x0000000040060203, 0x0000000c00000000, 0x0001000000060203, 0x0000000c00000000, 0x0001000000060503, 0x0000000e00000000, 0x0010030000000400, 0x0203010300000004,
        0x0000000000004006, 0x04000000000c0000, 0x0004001003000000, 0x0006020301030000, 0x0000000000010000, 0x0106100300000010, 0x0000000000000000, 0x40060a030000000e,
        0x0000000000000000, 0x00060a030000000c, 0x0000000000010000, 0x00060d030000000c, 0x0000000000010000, 0x000004000000000e, 0x0040060a03010300, 0x0c00000000000000,
        0x0000000400000000, 0x000000060a030103, 0x0010000000000001, 0x0300000006000000, 0x0000000000400602, 0x0000000000060000, 0x0000001000000000, 0x060a030000000600,
        0x0000000000000040, 0x0000000000000006, 0x0005000000004000, 0x6403036302020000, 0x0909770505680404, 0x64636e000000056e, 0x0001000000037768, 0x0000000500000000,
        0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062, 0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77, 0x0003776864696f67,
        0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065, 0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a,
        0x6e00000005770d0d, 0x0000000377686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0000000000000000,
        0x0000000700000007, 0x0000040000000200, 0x0010000000030101, 0x0003000001000000, 0x0000004002020000, 0x0d0d000000100a0a, 0x0000000100000040, 0x0004000000040a0a,
        0x0000000000080000, 0x0000000000010700, 0x0200000000000206, 0x0001000100000003, 0x0003000000010000, 0x0000000101010000, 0x00000e000000000d, 0x0000004006020300,
        0x00000c0000000000, 0x0100000006020300, 0x00000c0000000000, 0x0100000006050300, 0x00000e0000000000, 0x1003000000040000, 0x0301030000000400, 0x0000000000400602,
        0x000000000c000000, 0x0400100300000004, 0x0602030103000000, 0x0000000001000000, 0x0610030000001000, 0x0000000000000001, 0x060a030000000e00, 0x0000000000000040,
        0x060a030000000c00, 0x0000000001000000, 0x060d030000000c00, 0x0000000001000000, 0x0004000000000e00, 0x40060a0301030000, 0x0000000000000000, 0x000004000000000c,
        0x0000060a03010300, 0x1000000000000100, 0x0000000600000000, 0x0000000040060203, 0x0000000006000000, 0x0000100000000000, 0x0a03000000060000, 0x0000000000004006,
        0x0000000000000600, 0x0004000000010000, 0xb36e3cc0324e0000, 0x75ed3d435b0b3d8a, 0x050000000040bd60, 0x0303630202000000, 0x0977050568040464, 0x636e000000056e09,
        0x0100000003776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0600000000006200, 0x0202670101000000, 0x0868070764060669,
        0x0000066f0a0a7708, 0x03776864696f6700, 0x0000000001000000, 0x0000610000000600, 0x0000000064000000, 0x6600000000006500, 0x0000630000000000, 0x0000000062000000,
        0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x000003776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000,
        0x0000000062000000, 0x0000000000000000, 0x0000070000000700, 0x0004000000020000, 0x1000000003010100, 0x0300000100000000, 0x0000400202000000, 0x0a00000040090900,
        0x000002000000100a, 0x0d000000040a0a00, 0x000004000000040d, 0x0000000000000800, 0x0600000000000107, 0x0302000000000002, 0x0000010001000000, 0x0000030000000100,
        0x0b00000001010100, 0x0000000e00000000, 0x0000000040060203, 0x0000000c00000000, 0x0001000000060203, 0x0000000c00000000, 0x0001000000060903, 0x0000000e00000000,
        0x0003030000000400, 0x0400040300000004, 0x0004000503000000, 0x4006020301030000, 0x0000000000000000, 0x000004000000000c, 0x0000000400030300, 0x0300000004000403,
        0x0103000000040005, 0x0001000000060203, 0x0000000e00000000, 0x0000000040060a03, 0x0000000c00000000, 0x0001000000060a03, 0x0000000e00000000, 0x000b030000000400,
        0x04000c0300000004, 0x0004000d03000000, 0x40060a0301030000, 0x0000000000000000, 0x000004000000000c, 0x00000004000b0300, 0x0300000004000c03, 0x010300000004000d,
        0x0001000000060a03, 0x0000001000000000, 0x0602030000000600, 0x0000000000000040, 0x0000000000000006, 0x0600000000100000, 0x0040060a03000000, 0x0006000000000000,
        0x4000000000000000, 0x0000000500000000, 0x0404640303630202, 0x056e090977050568, 0x776864636e000000, 0x0000000100000003, 0x0061000000050000, 0x0000006300000000,
        0x0000000000640000, 0x0062000000000065, 0x0000000600000000, 0x0606690202670101, 0x0a77080868070764, 0x6f67000000066f0a, 0x0000000377686469, 0x0006000000000001,
        0x0000000000610000, 0x0065000000000064, 0x0000006600000000, 0x0000000000630000, 0x0005000000000062, 0x630a0a6e09090000, 0x0d0d680c0c640b0b, 0x64636e0000000577,
        0x0001000000037768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0000000000000062, 0x0007000000000000, 0x0200000000070000,
        0x0101000004000000, 0x0000001000000003, 0x0000000300000100, 0x0909000000400202, 0x00100a0a00000040, 0x0a0a000000020000, 0x00040d0d00000004, 0x0008000000040000,
        0x0001070000000000, 0x0000020600000000, 0x0000000302000000, 0x0001000000010001, 0x0101000000030000, 0x0000000b00000001, 0x0602030000000e00, 0x0000000000000040,
        0x0602030000000c00, 0x0000000001000000, 0x0609030000000c00, 0x0000000001000000, 0x0004000000000e00, 0x0000040003030000, 0x0000000400040300, 0x0300000004000503,
        0x0000004006020301, 0x00000c0000000000, 0x0303000000040000, 0x0004030000000400, 0x0400050300000004, 0x0602030103000000, 0x0000000001000000, 0x060a030000000e00,
        0x0000000000000040, 0x060a030000000c00, 0x0000000001000000, 0x0004000000000e00, 0x000004000b030000, 0x00000004000c0300, 0x0300000004000d03, 0x00000040060a0301,
        0x00000c0000000000, 0x0b03000000040000, 0x000c030000000400, 0x04000d0300000004, 0x060a030103000000, 0x0000000001000000, 0x0006000000001000, 0x0000400602030000,
        0x0000060000000000, 0x1000000000000000, 0x0000000600000000, 0x0000000040060a03, 0x0000000006000000, 0x0000000100000000, 0x3d6ef9f800000004, 0x3d05975e3de6c0c1,
        0x00000040be0c9351, 0x6302020000000500, 0x0505680404640303, 0x000000056e090977, 0x000003776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300,
        0x0000650000000000, 0x0000000062000000, 0x6701010000000600, 0x0707640606690202, 0x066f0a0a77080868, 0x6864696f67000000, 0x0000010000000377, 0x6100000006000000,
        0x0000640000000000, 0x0000000065000000, 0x6300000000006600, 0x0000620000000000, 0x0900000005000000, 0x640b0b630a0a6e09, 0x0005770d0d680c0c, 0x03776864636e0000,
        0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0000000000000000, 0x0700000007000000, 0x0000000200000000,
        0x0000030101000004, 0x0001000000001000, 0x4002020000000300, 0x0000080909000000, 0x02000000400a0a00, 0x0000020a0a000000, 0x04000000040d0d00, 0x0000000008000000,
        0x0000000001070000, 0x0000000000020600, 0x0100010000000302, 0x0300000001000000, 0x0000010101000000, 0x000e000000000b00, 0x0000400602030000, 0x000c000000000000,
        0x0000000602030000, 0x000c000000000001, 0x0000000609030000, 0x000e000000000001, 0x0300000004000000, 0x0403000000040003, 0x0005030000000400, 0x0203010300000004,
        0x0000000000004006, 0x04000000000c0000, 0x0004000303000000, 0x0000040004030000, 0x0000000400050300, 0x0000000602030103, 0x000e000000000001, 0x000040060a030000,
        0x000c000000000000, 0x000000060a030000, 0x000e000000000001, 0x0300000004000000, 0x0c0300000004000b, 0x000d030000000400, 0x0a03010300000004, 0x0000000000004006,
        0x04000000000c0000, 0x0004000b03000000, 0x000004000c030000, 0x00000004000d0300, 0x000000060a030103, 0x0010000000000001, 0x0300000006000000, 0x0000000000400602,
        0x0000000000060000, 0x0000001000000000, 0x060a030000000600, 0x0000000000000040, 0x0000000000000006, 0x0005000000004000, 0x6403036302020000, 0x0909770505680404,
        0x64636e000000056e, 0x0001000000037768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0006000000000062, 0x6902026701010000,
        0x0808680707640606, 0x000000066f0a0a77, 0x0003776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000, 0x0066000000000065, 0x0000006300000000,
        0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000377686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063,
        0x0000006500000000, 0x0000000000620000, 0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000030101, 0x0003000001000000, 0x0000004002020000,
        0x0a0a000000080909, 0x0000000200000040, 0x0d0d000000020a0a, 0x0000000400000004, 0x0700000000000008, 0x0206000000000001, 0x0003020000000000, 0x0000000100010000,
        0x0000000300000001, 0x000b000000010101, 0x030000000e000000, 0x0000000000400602, 0x030000000c000000, 0x0000010000000602, 0x030000000c000000, 0x0000010000000609,
        0x000000000e000000, 0x0400030300000004, 0x0004000403000000, 0x0000040005030000, 0x0040060203010300, 0x0c00000000000000, 0x0000000400000000, 0x0300000004000303,
        0x0503000000040004, 0x0301030000000400, 0x0000010000000602, 0x030000000e000000, 0x000000000040060a, 0x030000000c000000, 0x000001000000060a, 0x000000000e000000,
        0x04000b0300000004, 0x0004000c03000000, 0x000004000d030000, 0x0040060a03010300, 0x0c00000000000000, 0x0000000400000000, 0x0300000004000b03, 0x0d0300000004000c,
        0x0301030000000400, 0x000001000000060a, 0x0000000010000000, 0x4006020300000006, 0x0600000000000000, 0x0000000000000000, 0x0006000000001000, 0x000040060a030000,
        0x0000060000000000, 0x0001000000000000, 0xd64e000000040000, 0xcf5d3d2acf5c3cd4, 0x0040bd6c6edd3d2a, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505,
        0x03776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701,
        0x0a0a770808680707, 0x696f67000000066f, 0x0100000003776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300,
        0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000377, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000,
        0x6200000000006500, 0x0000000000000000, 0x0000070000000000, 0x0002000000000700, 0x0301010000040000, 0x0000000010000000, 0x0200000003000001, 0x2009090000002002,
        0x0000100a0a000000, 0x0409090000000200, 0x0000040a0a000000, 0x0000080000000400, 0x0000010700000000, 0x0000000206000000, 0x0100000003020000, 0x0000010000000100,
        0x0101010000000300, 0x000000000b000000, 0x400602030000000e, 0x0000000000000000, 0x000602030000000c, 0x0000000000010000, 0x000609030000000c, 0x0000000000010000,
        0x000004000000000e, 0x0000000400030300, 0x0300000004000403, 0x0103000000040005, 0x0000000040060203, 0x0000000c00000000, 0x0003030000000400, 0x0400040300000004,
        0x0004000503000000, 0x0006020301030000, 0x0000000000010000, 0x40060a030000000e, 0x0000000000000000, 0x00060a030000000c, 0x0000000000010000, 0x000004000000000e,
        0x00000004000b0300, 0x0300000004000c03, 0x010300000004000d, 0x0000000040060a03, 0x0000000c00000000, 0x000b030000000400, 0x04000c0300000004, 0x0004000d03000000,
        0x00060a0301030000, 0x0000000000010000, 0x0000060000000010, 0x0000004006020300, 0x0000000600000000, 0x0010000000000000, 0x0300000006000000, 0x000000000040060a,
        0x0000000000060000, 0x0000000040000000, 0x0363020200000005, 0x7705056804046403, 0x6e000000056e0909, 0x0000000377686463, 0x0005000000000001, 0x0000000000610000,
        0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x0000000100000003,
        0x0061000000060000, 0x0000006400000000, 0x0000000000650000, 0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c,
        0x0003776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0000000000000000, 0x0007000000070000,
        0x0400000002000000, 0x0000000301010000, 0x0000010000000010, 0x0020020200000003, 0x0000002009090000, 0x0002000000100a0a, 0x0000000409090000, 0x0004000000040a0a,
        0x0000000000080000, 0x0000000000010700, 0x0200000000000206, 0x0001000100000003, 0x0003000000010000, 0x0000000101010000, 0x00000e000000000b, 0x0000004006020300,
        0x00000c0000000000, 0x0100000006020300, 0x00000c0000000000, 0x0100000006090300, 0x00000e0000000000, 0x0303000000040000, 0x0004030000000400, 0x0400050300000004,
        0x0602030103000000, 0x0000000000000040, 0x0004000000000c00, 0x0000040003030000, 0x0000000400040300, 0x0300000004000503, 0x0100000006020301, 0x00000e0000000000,
        0x00000040060a0300, 0x00000c0000000000, 0x01000000060a0300, 0x00000e0000000000, 0x0b03000000040000, 0x000c030000000400, 0x04000d0300000004, 0x060a030103000000,
        0x0000000000000040, 0x0004000000000c00, 0x000004000b030000, 0x00000004000c0300, 0x0300000004000d03, 0x01000000060a0301, 0x0000100000000000, 0x0203000000060000,
        0x0000000000004006, 0x0000000000000600, 0x0000000010000000, 0x40060a0300000006, 0x0600000000000000, 0x0000000000000000, 0x0000000400000001, 0x3d0f61453cedd32e,
        0xbe0370fd3d1b8f8f, 0x00000500000000a0, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000377, 0x6100000005000000, 0x0000630000000000,
        0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x000003776864696f, 0x0600000000000100,
        0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d,
        0x0100000003776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0300000000006200, 0x0000010e0e000000, 0x10000000010f0f00,
        0x0000000000000110, 0x0000070000000700, 0x0004000000020000, 0x1000000003010100, 0x0300000100000000, 0x0000100202000000, 0x0a00000008090900, 0x000001000000200a,
        0x0400000010050500, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x000001000000030a, 0x0000000000000000, 0x0000000000000000, 0x0010000000000300,
        0x000001060e030000, 0x0010000000000000, 0x000001060f030000, 0x0010000000000000, 0x0000010610030000, 0x0000a00000000000, 0x0202000000050000, 0x0568040464030363,
        0x0000056e09097705, 0x0003776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0101000000060000,
        0x0764060669020267, 0x6f0a0a7708086807, 0x64696f6700000006, 0x0001000000037768, 0x0000000600000000, 0x0064000000000061, 0x0000006500000000, 0x0000000000660000,
        0x0062000000000063, 0x0000000500000000, 0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000, 0x0000000100000003, 0x0061000000050000, 0x0000006300000000,
        0x0000000000640000, 0x0062000000000065, 0x0000000300000000, 0x0f0f000000010e0e, 0x0001101000000001, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000,
        0x0000001000000003, 0x0000000300000100, 0x0909000000100202, 0x00200a0a00000008, 0x0505000000010000, 0x0000000400000010, 0x0700000000000008, 0x0206000000000001,
        0x00030a0000000000, 0x0000000000010000, 0x0000000000000000, 0x0003000000000000, 0x0300000010000000, 0x000000000001060e, 0x0300000010000000, 0x000000000001060f,
        0x0300000010000000, 0x0000000000010610, 0x0004000000010000, 0x88023ab9f49a0000, 0x3abf3b0251353b27, 0x050000000040bb5c, 0x0303630202000000, 0x0977050568040464,
        0x636e000000056e09, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0600000000006200, 0x0202670101000000,
        0x0868070764060669, 0x0000066f0a0a7708, 0x0f776864696f6700, 0x0000000001000000, 0x0000610000000600, 0x0000000064000000, 0x6600000000006500, 0x0000630000000000,
        0x0000000062000000, 0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x00000f776864636e, 0x0500000000000100, 0x0000000061000000, 0x6400000000006300,
        0x0000650000000000, 0x0000000062000000, 0x0000000000000000, 0x0000070000000700, 0x0004000000020000, 0x1000000001010100, 0x0300000080000000, 0x0000020202000000,
        0x0a00000008090900, 0x000001000000100a, 0x04000000100a0a00, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x0000010000000302, 0x0000000000000000,
        0x0000000000000000, 0x0000400000000000, 0x0202000000050000, 0x0568040464030363, 0x0000056e09097705, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005,
        0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0101000000060000, 0x0764060669020267, 0x6f0a0a7708086807, 0x64696f6700000006, 0x00010000000f7768,
        0x0000000600000000, 0x0064000000000061, 0x0000006500000000, 0x0000000000660000, 0x0062000000000063, 0x0000000500000000, 0x0b0b630a0a6e0909, 0x05770d0d680c0c64,
        0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000000000000, 0x0000000700000000,
        0x0000020000000007, 0x0001010100000400, 0x0080000000100000, 0x0202000000030000, 0x0008090900000002, 0x000000100a0a0000, 0x00100a0a00000001, 0x0008000000040000,
        0x0001070000000000, 0x0000020600000000, 0x0000000302000000, 0x0000000000000001, 0x0000000000000000, 0x0000000000000000, 0x0000000400000001, 0x3d4e0d723c5165b6,
        0xbdd5c5613d37cbd8, 0x0000050000000040, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000377, 0x6100000005000000, 0x0000630000000000,
        0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x000003776864696f, 0x0600000000000100,
        0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d,
        0x0100000003776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0000000000006200, 0x0700000000000000, 0x0000000007000000,
        0x0100000400000002, 0x0000100000000301, 0x0000030000010000, 0x0900000020020200, 0x100a0a0000000809, 0x0900000001000000, 0x0000040000000209, 0x0000000000000800,
        0x0600000000000107, 0x0302000000000002, 0x0000000001000000, 0x0000000000000000, 0x0000000000000000, 0x0000000040000000, 0x0363020200000005, 0x7705056804046403,
        0x6e000000056e0909, 0x0000000377686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0267010100000006,
        0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x0000000100000003, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000, 0x0063000000000066,
        0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c, 0x0003776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000,
        0x0065000000000064, 0x0000006200000000, 0x0000000000000000, 0x0007000000070000, 0x0400000002000000, 0x0000000301010000, 0x0000010000000010, 0x0020020200000003,
        0x0000000809090000, 0x0001000000100a0a, 0x0000000209090000, 0x0000000800000004, 0x0000000107000000, 0x0000000002060000, 0x0001000000030200, 0x0000000000000000,
        0x0000000000000000, 0x0001000000000000, 0x8bdd000000040000, 0x0d013b4797e23a03, 0x0040bab0835c394f, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505,
        0x03776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701,
        0x0a0a770808680707, 0x696f67000000066f, 0x0100000003776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300,
        0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000377, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000,
        0x6200000000006500, 0x0000000000000000, 0x0000070000000000, 0x0002000000000700, 0x0301010000040000, 0x0000000010000000, 0x0200000003000001, 0x100a0a0000002002,
        0x0000080d0d000000, 0x080a0a0000000200, 0x0000020d0d000000, 0x0000080000000400, 0x0000010700000000, 0x0000000206000000, 0x0100000003020000, 0x0000000000000000,
        0x0000000000000000, 0x4000000000000000, 0x0000000500000000, 0x0404640303630202, 0x056e090977050568, 0x776864636e000000, 0x0000000100000003, 0x0061000000050000,
        0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000600000000, 0x0606690202670101, 0x0a77080868070764, 0x6f67000000066f0a, 0x0000000377686469,
        0x0006000000000001, 0x0000000000610000, 0x0065000000000064, 0x0000006600000000, 0x0000000000630000, 0x0005000000000062, 0x630a0a6e09090000, 0x0d0d680c0c640b0b,
        0x64636e0000000577, 0x0001000000037768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0000000000000062, 0x0007000000000000,
        0x0200000000070000, 0x0101000004000000, 0x0000001000000003, 0x0000000300000100, 0x0a0a000000200202, 0x00080d0d00000010, 0x0a0a000000020000, 0x00020d0d00000008,
        0x0008000000040000, 0x0001070000000000, 0x0000020600000000, 0x0000000302000000, 0x0000000000000001, 0x0000000000000000, 0x0000000000000000, 0x0000000400000001,
        0x3b128e503a3dcc33, 0xbac24eb53a574a5c, 0x0000050000000040, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000377, 0x6100000005000000,
        0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x000003776864696f,
        0x0600000000000100, 0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63,
        0x636e00000005770d, 0x0100000003776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0000000000006200, 0x0700000000000000,
        0x0000000007000000, 0x0100000400000002, 0x0000100000000301, 0x0000030000010000, 0x0900000020020200, 0x100a0a0000000809, 0x0900000002000000, 0x080a0a0000000209,
        0x0800000004000000, 0x0107000000000000, 0x0002060000000000, 0x0000030200000000, 0x0000000000000100, 0x0000000000000000, 0x0000000000000000, 0x0005000000004000,
        0x6403036302020000, 0x0909770505680404, 0x64636e000000056e, 0x0001000000037768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000,
        0x0006000000000062, 0x6902026701010000, 0x0808680707640606, 0x000000066f0a0a77, 0x0003776864696f67, 0x0000000000010000, 0x0000006100000006, 0x0000000000640000,
        0x0066000000000065, 0x0000006300000000, 0x0000000000620000, 0x0a6e090900000005, 0x680c0c640b0b630a, 0x6e00000005770d0d, 0x0000000377686463, 0x0005000000000001,
        0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0000000000000000, 0x0000000700000007, 0x0000040000000200, 0x0010000000030101,
        0x0003000001000000, 0x0000002002020000, 0x0a0a000000080909, 0x0000000200000010, 0x0a0a000000020909, 0x0000000400000008, 0x0700000000000008, 0x0206000000000001,
        0x0003020000000000, 0x0000000000010000, 0x0000000000000000, 0x0000000000000000, 0x0004000000010000, 0x433f3a5a59a90000, 0x0c0d3acddd903ac9, 0x0500000000a0bae9,
        0x0303630202000000, 0x0977050568040464, 0x636e000000056e09, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000,
        0x0600000000006200, 0x0202670101000000, 0x0868070764060669, 0x0000066f0a0a7708, 0x0f776864696f6700, 0x0000000001000000, 0x0000610000000600, 0x0000000064000000,
        0x6600000000006500, 0x0000630000000000, 0x0000000062000000, 0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x00000f776864636e, 0x0500000000000100,
        0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x010e0e0000000300, 0x0000010f0f000000, 0x0000000001101000, 0x0700000007000000,
        0x0000000200000000, 0x0000010101000004, 0x0000800000001000, 0x2002020000000300, 0x0000020505000000, 0x02000000080a0a00, 0x0000080202000000, 0x0400000002050500,
        0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x000001000000030a, 0x0000000000000000, 0x0000000000000000, 0x0010000000000300, 0x000001060e030000,
        0x0010000000000000, 0x000001060f030000, 0x0010000000000000, 0x0000010610030000, 0x0000a00000000000, 0x0202000000050000, 0x0568040464030363, 0x0000056e09097705,
        0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0101000000060000, 0x0764060669020267,
        0x6f0a0a7708086807, 0x64696f6700000006, 0x00010000000f7768, 0x0000000600000000, 0x0064000000000061, 0x0000006500000000, 0x0000000000660000, 0x0062000000000063,
        0x0000000500000000, 0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000,
        0x0062000000000065, 0x0000000300000000, 0x0f0f000000010e0e, 0x0001101000000001, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000, 0x0000001000000001,
        0x0000000300000080, 0x0505000000200202, 0x00080a0a00000002, 0x0202000000020000, 0x0002050500000008, 0x0008000000040000, 0x0001070000000000, 0x0000020600000000,
        0x000000030a000000, 0x0000000000000001, 0x0000000000000000, 0x0000000300000000, 0x060e030000001000, 0x0000000000000001, 0x060f030000001000, 0x0000000000000001,
        0x0610030000001000, 0x0000000000000001, 0x0000000400000001, 0x3c6ad92d3cb62c02, 0xbd4e37f53d1fc78b, 0x00000500000000c0, 0x0464030363020200, 0x6e09097705056804,
        0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100,
        0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000,
        0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000,
        0x0000000065000000, 0x0000000000006200, 0x0700000000000000, 0x0000000007000000, 0x0100000400000002, 0x0000100000000101, 0x0000030000008000, 0x0900000008020200,
        0x400a0a0000000209, 0x0a00000001000000, 0x000004000000040a, 0x0000000000000900, 0x0c0000000000010d, 0x030b000000000002, 0x0000010001000000, 0x0000000000000100,
        0x0c00000001000000, 0x0000000e00000000, 0x0000000010060203, 0x0000000c00000000, 0x0000400000060203, 0x0000000c00000000, 0x0001000000060903, 0x0000000e00000000,
        0x0004000000000400, 0x0000000004000000, 0x0403030300000004, 0x1006020301030503, 0x0000000000000000, 0x000004000000000c, 0x0400000000040000, 0x0000000400000000,
        0x0103050304030303, 0x0000400000060203, 0x0000000e00000000, 0x0000000010060a03, 0x0000000c00000000, 0x0000400000060a03, 0x0000000e00000000, 0x0004000000000400,
        0x0000000004000000, 0x0c030b0300000004, 0x10060a0301030d03, 0x0000000000000000, 0x000004000000000c, 0x0400000000040000, 0x0000000400000000, 0x01030d030c030b03,
        0x0000400000060a03, 0x0000000c00000000, 0x0001000000060203, 0x0000001000000000, 0x0602030000000600, 0x0000000000000010, 0x0000000000000006, 0x0600000000100000,
        0x0010060a03000000, 0x0006000000000000, 0xc000000000000000, 0x0000000500000000, 0x0404640303630202, 0x056e090977050568, 0x776864636e000000, 0x000000010000000f,
        0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000600000000, 0x0606690202670101, 0x0a77080868070764, 0x6f67000000066f0a,
        0x0000000f77686469, 0x0006000000000001, 0x0000000000610000, 0x0065000000000064, 0x0000006600000000, 0x0000000000630000, 0x0005000000000062, 0x630a0a6e09090000,
        0x0d0d680c0c640b0b, 0x64636e0000000577, 0x00010000000f7768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0000000000000062,
        0x0007000000000000, 0x0200000000070000, 0x0101000004000000, 0x0000001000000001, 0x0000000300000080, 0x0909000000080202, 0x00400a0a00000002, 0x0a0a000000010000,
        0x0000000400000004, 0x0d00000000000009, 0x020c000000000001, 0x00030b0000000000, 0x0000000100010000, 0x0000000000000001, 0x000c000000010000, 0x030000000e000000,
        0x0000000000100602, 0x030000000c000000, 0x0000004000000602, 0x030000000c000000, 0x0000010000000609, 0x000000000e000000, 0x0000040000000004, 0x0400000000040000,
        0x0304030303000000, 0x0010060203010305, 0x0c00000000000000, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030503040303, 0x0000004000000602,
        0x030000000e000000, 0x000000000010060a, 0x030000000c000000, 0x000000400000060a, 0x000000000e000000, 0x0000040000000004, 0x0400000000040000, 0x030c030b03000000,
        0x0010060a0301030d, 0x0c00000000000000, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030d030c030b, 0x000000400000060a, 0x030000000c000000,
        0x0000010000000602, 0x0000000010000000, 0x1006020300000006, 0x0600000000000000, 0x0000000000000000, 0x0006000000001000, 0x000010060a030000, 0x0000060000000000,
        0x0001000000000000, 0xfc3a000000040000, 0x079d38f80c4b3a9c, 0x00403cf54cd53978, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505, 0x03776864636e0000,
        0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707,
        0x696f67000000066f, 0x0100000003776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300, 0x0000050000000000,
        0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000377, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500,
        0x0000000000000000, 0x0000070000000000, 0x0002000000000700, 0x0301010000040000, 0x0000000010000000, 0x0200000003000001, 0x0809090000004002, 0x0000100a0a000000,
        0x080a0a0000000200, 0x0000020d0d000000, 0x0000080000000400, 0x0000010700000000, 0x0000000206000000, 0x0100000003020000, 0x0000010000000100, 0x0101010000000300,
        0x000000000b000000, 0x400602030000000e, 0x0000000000000000, 0x000602030000000c, 0x0000000000010000, 0x000609030000000c, 0x0000000000010000, 0x000004000000000e,
        0x0000000400030300, 0x0300000004000403, 0x0103000000040005, 0x0000000040060203, 0x0000000c00000000, 0x0003030000000400, 0x0400040300000004, 0x0004000503000000,
        0x0006020301030000, 0x0000000000010000, 0x40060a030000000e, 0x0000000000000000, 0x00060a030000000c, 0x0000000000010000, 0x000004000000000e, 0x00000004000b0300,
        0x0300000004000c03, 0x010300000004000d, 0x0000000040060a03, 0x0000000c00000000, 0x000b030000000400, 0x04000c0300000004, 0x0004000d03000000, 0x00060a0301030000,
        0x0000000000010000, 0x0000060000000010, 0x0000004006020300, 0x0000000600000000, 0x0010000000000000, 0x0300000006000000, 0x000000000040060a, 0x0000000000060000,
        0x0000000040000000, 0x0363020200000005, 0x7705056804046403, 0x6e000000056e0909, 0x0000000377686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063,
        0x0000006500000000, 0x0000000000620000, 0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x0000000100000003, 0x0061000000060000,
        0x0000006400000000, 0x0000000000650000, 0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c, 0x0003776864636e00,
        0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0000000000000000, 0x0007000000070000, 0x0400000002000000,
        0x0000000301010000, 0x0000010000000010, 0x0040020200000003, 0x0000000809090000, 0x0002000000100a0a, 0x000000080a0a0000, 0x0004000000020d0d, 0x0000000000080000,
        0x0000000000010700, 0x0200000000000206, 0x0001000100000003, 0x0003000000010000, 0x0000000101010000, 0x00000e000000000b, 0x0000004006020300, 0x00000c0000000000,
        0x0100000006020300, 0x00000c0000000000, 0x0100000006090300, 0x00000e0000000000, 0x0303000000040000, 0x0004030000000400, 0x0400050300000004, 0x0602030103000000,
        0x0000000000000040, 0x0004000000000c00, 0x0000040003030000, 0x0000000400040300, 0x0300000004000503, 0x0100000006020301, 0x00000e0000000000, 0x00000040060a0300,
        0x00000c0000000000, 0x01000000060a0300, 0x00000e0000000000, 0x0b03000000040000, 0x000c030000000400, 0x04000d0300000004, 0x060a030103000000, 0x0000000000000040,
        0x0004000000000c00, 0x000004000b030000, 0x00000004000c0300, 0x0300000004000d03, 0x01000000060a0301, 0x0000100000000000, 0x0203000000060000, 0x0000000000004006,
        0x0000000000000600, 0x0000000010000000, 0x40060a0300000006, 0x0600000000000000, 0x0000000000000000, 0x0000000400000001, 0x3c30fb453c2968c2, 0xbcdc3e433c81cf89,
        0x0000050000000040, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000,
        0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000,
        0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864,
        0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0000000000006200, 0x0700000000000000, 0x0000000007000000, 0x0100000400000002,
        0x0000100000000101, 0x0000030000008000, 0x0900000010020200, 0x100a0a0000000409, 0x0a00000002000000, 0x040d0d000000020a, 0x0800000004000000, 0x0107000000000000,
        0x0002060000000000, 0x0000030200000000, 0x0100000001000100, 0x0000000000000000, 0x00000c0000000100, 0x02030000000e0000, 0x0000000000001006, 0x02030000000c0000,
        0x0000000040000006, 0x09030000000c0000, 0x0000000100000006, 0x04000000000e0000, 0x0000000400000000, 0x0004000000000400, 0x0503040303030000, 0x0000100602030103,
        0x000c000000000000, 0x0000000004000000, 0x0000040000000004, 0x0303000000040000, 0x0203010305030403, 0x0000000040000006, 0x0a030000000e0000, 0x0000000000001006,
        0x0a030000000c0000, 0x0000000040000006, 0x02030000000c0000, 0x0000000100000006, 0x04000000000e0000, 0x0000000400000000, 0x0004000000000400, 0x0d030c030b030000,
        0x000010060a030103, 0x000c000000000000, 0x0000000004000000, 0x0000040000000004, 0x0b03000000040000, 0x0a0301030d030c03, 0x0000000040000006, 0x0600000000100000,
        0x0010060203000000, 0x0006000000000000, 0x0000000000000000, 0x0000060000000010, 0x00000010060a0300, 0x0000000600000000, 0x0000400000000000, 0x0202000000050000,
        0x0568040464030363, 0x0000056e09097705, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000,
        0x0101000000060000, 0x0764060669020267, 0x6f0a0a7708086807, 0x64696f6700000006, 0x00010000000f7768, 0x0000000600000000, 0x0064000000000061, 0x0000006500000000,
        0x0000000000660000, 0x0062000000000063, 0x0000000500000000, 0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000,
        0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000000000000, 0x0000000700000000, 0x0000020000000007, 0x0001010100000400, 0x0080000000100000,
        0x0202000000030000, 0x0004090900000010, 0x000000100a0a0000, 0x00020a0a00000002, 0x000000040d0d0000, 0x0000000800000004, 0x0000000107000000, 0x0000000002060000,
        0x0001000000030200, 0x0000000100000001, 0x0001000000000000, 0x0e000000000c0000, 0x0010060203000000, 0x0c00000000000000, 0x0000060203000000, 0x0c00000000000040,
        0x0000060903000000, 0x0e00000000000100, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030503040303, 0x0000000000100602, 0x000000000c000000,
        0x0000040000000004, 0x0400000000040000, 0x0304030303000000, 0x0000060203010305, 0x0e00000000000040, 0x0010060a03000000, 0x0c00000000000000, 0x0000060a03000000,
        0x0c00000000000040, 0x0000060203000000, 0x0e00000000000100, 0x0000000400000000, 0x0004000000000400, 0x0300000004000000, 0x0301030d030c030b, 0x000000000010060a,
        0x000000000c000000, 0x0000040000000004, 0x0400000000040000, 0x030c030b03000000, 0x0000060a0301030d, 0x1000000000000040, 0x0000000600000000, 0x0000000010060203,
        0x0000000006000000, 0x0000100000000000, 0x0a03000000060000, 0x0000000000001006, 0x0000000000000600, 0x0004000000010000, 0x991e3d1d6a1b0000, 0xba823e0699173e06,
        0x0500000000a0be68, 0x0303630202000000, 0x0977050568040464, 0x636e000000056e09, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000,
        0x0000000065000000, 0x0600000000006200, 0x0202670101000000, 0x0868070764060669, 0x0000066f0a0a7708, 0x0f776864696f6700, 0x0000000001000000, 0x0000610000000600,
        0x0000000064000000, 0x6600000000006500, 0x0000630000000000, 0x0000000062000000, 0x6e09090000000500, 0x0c0c640b0b630a0a, 0x00000005770d0d68, 0x00000f776864636e,
        0x0500000000000100, 0x0000000061000000, 0x6400000000006300, 0x0000650000000000, 0x0000000062000000, 0x010e0e0000000300, 0x0000010f0f000000, 0x0000000001101000,
        0x0700000007000000, 0x0000000200000000, 0x0000010101000004, 0x0000800000001000, 0x2002020000000300, 0x0000020909000000, 0x02000000080a0a00, 0x0000100202000000,
        0x0400000004090900, 0x0000000008000000, 0x0000000001070000, 0x0000000000020600, 0x000001000000030a, 0x0000000000000000, 0x0000000000000000, 0x0010000000000300,
        0x000001060e030000, 0x0010000000000000, 0x000001060f030000, 0x0010000000000000, 0x0000010610030000, 0x0000a00000000000, 0x0202000000050000, 0x0568040464030363,
        0x0000056e09097705, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0101000000060000,
        0x0764060669020267, 0x6f0a0a7708086807, 0x64696f6700000006, 0x00010000000f7768, 0x0000000600000000, 0x0064000000000061, 0x0000006500000000, 0x0000000000660000,
        0x0062000000000063, 0x0000000500000000, 0x0b0b630a0a6e0909, 0x05770d0d680c0c64, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000,
        0x0000000000640000, 0x0062000000000065, 0x0000000300000000, 0x0f0f000000010e0e, 0x0001101000000001, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000,
        0x0000001000000001, 0x0000000300000080, 0x0909000000200202, 0x00080a0a00000002, 0x0202000000020000, 0x0004090900000010, 0x0008000000040000, 0x0001070000000000,
        0x0000020600000000, 0x000000030a000000, 0x0000000000000001, 0x0000000000000000, 0x0000000300000000, 0x060e030000001000, 0x0000000000000001, 0x060f030000001000,
        0x0000000000000001, 0x0610030000001000, 0x0000000000000001, 0x0000000400000001, 0x3d6c3ce53c0da252, 0xbd6580293c5b91cd, 0x0000050000000040, 0x0464030363020200,
        0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000060000000000,
        0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000, 0x6500000000006400, 0x0000660000000000,
        0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100,
        0x0000640000000000, 0x0000000065000000, 0x0000000000006200, 0x0700000000000000, 0x0000000007000000, 0x0100000400000002, 0x0000100000000101, 0x0000030000008000,
        0x0a00000020020200, 0x040d0d000000100a, 0x0a00000002000000, 0x100d0d000000040a, 0x0800000004000000, 0x0107000000000000, 0x0002060000000000, 0x0000030200000000,
        0x0100000001000100, 0x0000000000000000, 0x00000e0000000100, 0x02030000000e0000, 0x0000000000001006, 0x02030000000c0000, 0x0000000040000006, 0x05030000000c0000,
        0x0000000100000006, 0x04000000000e0000, 0x0000000400000000, 0x1006020301031003, 0x0000000000000000, 0x000004000000000c, 0x1003000000040000, 0x4000000602030103,
        0x0010000000000000, 0x0000010610030000, 0x000e000000000000, 0x000010060a030000, 0x000c000000000000, 0x400000060a030000, 0x000c000000000000, 0x0000000602030000,
        0x000c000000000001, 0x000000060d030000, 0x000e000000000001, 0x0300000004000000, 0x00000010060a0301, 0x00000c0000000000, 0x0103000000040000, 0x0000400000060a03,
        0x0000001000000000, 0x0602030000000600, 0x0000000000000010, 0x0000000000000006, 0x0600000000100000, 0x0010060a03000000, 0x0006000000000000, 0x4000000000000000,
        0x0000000500000000, 0x0404640303630202, 0x056e090977050568, 0x776864636e000000, 0x000000010000000f, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000,
        0x0062000000000065, 0x0000000600000000, 0x0606690202670101, 0x0a77080868070764, 0x6f67000000066f0a, 0x0000000f77686469, 0x0006000000000001, 0x0000000000610000,
        0x0065000000000064, 0x0000006600000000, 0x0000000000630000, 0x0005000000000062, 0x630a0a6e09090000, 0x0d0d680c0c640b0b, 0x64636e0000000577, 0x00010000000f7768,
        0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000, 0x0000000000000062, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000,
        0x0000001000000001, 0x0000000300000080, 0x0a0a000000200202, 0x00040d0d00000010, 0x0a0a000000020000, 0x00100d0d00000004, 0x0008000000040000, 0x0001070000000000,
        0x0000020600000000, 0x0000000302000000, 0x0001000000010001, 0x0000000000000000, 0x0000000e00000001, 0x0602030000000e00, 0x0000000000000010, 0x0602030000000c00,
        0x0000000000400000, 0x0605030000000c00, 0x0000000001000000, 0x0004000000000e00, 0x0300000004000000, 0x0010060203010310, 0x0c00000000000000, 0x0000000400000000,
        0x0310030000000400, 0x0040000006020301, 0x0000100000000000, 0x0000000106100300, 0x00000e0000000000, 0x00000010060a0300, 0x00000c0000000000, 0x00400000060a0300,
        0x00000c0000000000, 0x0100000006020300, 0x00000c0000000000, 0x01000000060d0300, 0x00000e0000000000, 0x0103000000040000, 0x0000000010060a03, 0x0000000c00000000,
        0x0301030000000400, 0x000000400000060a, 0x0000000010000000, 0x1006020300000006, 0x0600000000000000, 0x0000000000000000, 0x0006000000001000, 0x000010060a030000,
        0x0000060000000000, 0x0001000000000000, 0x748e000000040000, 0x49d73e8b86133d92, 0x00a0be9c1c613dfc, 0x0200000005000000, 0x6804046403036302, 0x00056e0909770505,
        0x0f776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000, 0x0100000006000000, 0x6406066902026701,
        0x0a0a770808680707, 0x696f67000000066f, 0x010000000f776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000, 0x0000000066000000, 0x6200000000006300,
        0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000,
        0x6200000000006500, 0x0000030000000000, 0x0f000000010e0e00, 0x011010000000010f, 0x0700000000000000, 0x0000000007000000, 0x0100000400000002, 0x0000100000000101,
        0x0000030000008000, 0x0900000020020200, 0x020a0a0000000809, 0x0200000001000000, 0x0000040000000202, 0x0000000000000800, 0x0600000000000107, 0x030a000000000002,
        0x0000000001000000, 0x0000000000000000, 0x0300000000000000, 0x0000001000000000, 0x0000000001060e03, 0x0000001000000000, 0x0000000001060f03, 0x0000001000000000,
        0x0000000001061003, 0x00000000a0000000, 0x0363020200000005, 0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000,
        0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x000000010000000f,
        0x0061000000060000, 0x0000006400000000, 0x0000000000650000, 0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c,
        0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0e0e000000030000, 0x00010f0f00000001,
        0x0000000110100000, 0x0000000700000000, 0x0000020000000007, 0x0001010100000400, 0x0080000000100000, 0x0202000000030000, 0x0008090900000020, 0x000000020a0a0000,
        0x0002020200000001, 0x0008000000040000, 0x0001070000000000, 0x0000020600000000, 0x000000030a000000, 0x0000000000000001, 0x0000000000000000, 0x0000000300000000,
        0x060e030000001000, 0x0000000000000001, 0x060f030000001000, 0x0000000000000001, 0x0610030000001000, 0x0000000000000001, 0x0000000400000001, 0x3e024f75b91386a1,
        0xbeaf2c843d0726a4, 0x00000500000000a0, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005, 0x0000010000000f77, 0x6100000005000000, 0x0000630000000000,
        0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406, 0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100,
        0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200, 0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d,
        0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000, 0x0300000000006200, 0x0000010e0e000000, 0x10000000010f0f00,
        0x0000000000000110, 0x0000070000000700, 0x0004000000020000, 0x1000000001010100, 0x0300000080000000, 0x0000200202000000, 0x0a00000004090900, 0x000002000000020a,
        0x0500000008020200, 0x0000040000000405, 0x0000000000000800, 0x0600000000000107, 0x030a000000000002, 0x0000000001000000, 0x0000000000000000, 0x0300000000000000,
        0x0000001000000000, 0x0000000001060e03, 0x0000001000000000, 0x0000000001060f03, 0x0000001000000000, 0x0000000001061003, 0x00000000a0000000, 0x0363020200000005,
        0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001, 0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000,
        0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000, 0x000000010000000f, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000,
        0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e, 0x000005770d0d680c, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005,
        0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0e0e000000030000, 0x00010f0f00000001, 0x0000000110100000, 0x0000000700000000, 0x0000020000000007,
        0x0001010100000400, 0x0080000000100000, 0x0202000000030000, 0x0004090900000020, 0x000000020a0a0000, 0x0008020200000002, 0x0000000405050000, 0x0000000800000004,
        0x0000000107000000, 0x0000000002060000, 0x0001000000030a00, 0x0000000000000000, 0x0000000000000000, 0x1000000000030000, 0x0001060e03000000, 0x1000000000000000,
        0x0001060f03000000, 0x1000000000000000, 0x0001061003000000, 0x0001000000000000, 0xe3ad000000040000, 0x49343d47cbd43c69, 0x0040be3a0b8c3d1f, 0x0200000005000000,
        0x6804046403036302, 0x00056e0909770505, 0x03776864636e0000, 0x0000000001000000, 0x0000610000000500, 0x0000000063000000, 0x6500000000006400, 0x0000620000000000,
        0x0100000006000000, 0x6406066902026701, 0x0a0a770808680707, 0x696f67000000066f, 0x0100000003776864, 0x0000060000000000, 0x6400000000006100, 0x0000650000000000,
        0x0000000066000000, 0x6200000000006300, 0x0000050000000000, 0x0b630a0a6e090900, 0x770d0d680c0c640b, 0x6864636e00000005, 0x0000010000000377, 0x6100000005000000,
        0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000000000000000, 0x0000070000000000, 0x0002000000000700, 0x0301010000040000, 0x0000000010000000,
        0x0200000003000001, 0x100a0a0000002002, 0x0000080d0d000000, 0x100a0a0000000200, 0x0000020d0d000000, 0x0000080000000400, 0x0000010700000000, 0x0000000206000000,
        0x0100000003020000, 0x0000000000000000, 0x0000000000000000, 0x4000000000000000, 0x0000000500000000, 0x0404640303630202, 0x056e090977050568, 0x776864636e000000,
        0x0000000100000003, 0x0061000000050000, 0x0000006300000000, 0x0000000000640000, 0x0062000000000065, 0x0000000600000000, 0x0606690202670101, 0x0a77080868070764,
        0x6f67000000066f0a, 0x0000000377686469, 0x0006000000000001, 0x0000000000610000, 0x0065000000000064, 0x0000006600000000, 0x0000000000630000, 0x0005000000000062,
        0x630a0a6e09090000, 0x0d0d680c0c640b0b, 0x64636e0000000577, 0x0001000000037768, 0x0000000500000000, 0x0063000000000061, 0x0000006400000000, 0x0000000000650000,
        0x0000000000000062, 0x0007000000000000, 0x0200000000070000, 0x0101000004000000, 0x0000001000000003, 0x0000000300000100, 0x0a0a000000200202, 0x00080d0d00000010,
        0x0a0a000000020000, 0x00020d0d00000010, 0x0008000000040000, 0x0001070000000000, 0x0000020600000000, 0x0000000302000000, 0x0000000000000001, 0x0000000000000000,
        0x0000000000000000, 0x0000000400000001, 0x3b0733433a7879d5, 0xbaecc0e53a844b52, 0x00000500000000a0, 0x0464030363020200, 0x6e09097705056804, 0x6864636e00000005,
        0x0000010000000f77, 0x6100000005000000, 0x0000630000000000, 0x0000000064000000, 0x6200000000006500, 0x0000060000000000, 0x0669020267010100, 0x7708086807076406,
        0x67000000066f0a0a, 0x00000f776864696f, 0x0600000000000100, 0x0000000061000000, 0x6500000000006400, 0x0000660000000000, 0x0000000063000000, 0x0500000000006200,
        0x0a0a6e0909000000, 0x0d680c0c640b0b63, 0x636e00000005770d, 0x010000000f776864, 0x0000050000000000, 0x6300000000006100, 0x0000640000000000, 0x0000000065000000,
        0x0300000000006200, 0x0000010e0e000000, 0x10000000010f0f00, 0x0000000000000110, 0x0000070000000700, 0x0004000000020000, 0x1000000001010100, 0x0300000080000000,
        0x0000100202000000, 0x0a00000004050500, 0x000002000000020a, 0x0500000008020200, 0x0000040000000405, 0x0000000000000800, 0x0600000000000107, 0x030a000000000002,
        0x0000010001000000, 0x0000000000000100, 0x1000000001000000, 0x0000001000000000, 0x0000000001060e03, 0x0000001000000000, 0x0000000001060f03, 0x0000001000000000,
        0x0000000001061003, 0x0000000e00000000, 0x0000000010060a03, 0x0000000c00000000, 0x0000400000060a03, 0x0000000c00000000, 0x0001000000060d03, 0x0000000e00000000,
        0x0301030000000400, 0x000000000010060a, 0x000000000c000000, 0x0a03010300000004, 0x0000000040000006, 0x02030000000c0000, 0x0000000100000006, 0x02030000000e0000,
        0x0000000000001006, 0x02030000000c0000, 0x0000000040000006, 0x05030000000c0000, 0x0000000100000006, 0x04000000000e0000, 0x0602030103000000, 0x0000000000000010,
        0x0004000000000c00, 0x0006020301030000, 0x0000000000004000, 0x0000060000000010, 0x0000001006020300, 0x0000000600000000, 0x0010000000000000, 0x0300000006000000,
        0x000000000010060a, 0x0000000000060000, 0x00000000a0000000, 0x0363020200000005, 0x7705056804046403, 0x6e000000056e0909, 0x0000000f77686463, 0x0005000000000001,
        0x0000000000610000, 0x0064000000000063, 0x0000006500000000, 0x0000000000620000, 0x0267010100000006, 0x6807076406066902, 0x00066f0a0a770808, 0x776864696f670000,
        0x000000010000000f, 0x0061000000060000, 0x0000006400000000, 0x0000000000650000, 0x0063000000000066, 0x0000006200000000, 0x0909000000050000, 0x0c640b0b630a0a6e,
        0x000005770d0d680c, 0x000f776864636e00, 0x0000000000010000, 0x0000006100000005, 0x0000000000630000, 0x0065000000000064, 0x0000006200000000, 0x0e0e000000030000,
        0x00010f0f00000001, 0x0000000110100000, 0x0000000700000000, 0x0000020000000007, 0x0001010100000400, 0x0080000000100000, 0x0202000000030000, 0x0004050500000010,
        0x000000020a0a0000, 0x0008020200000002, 0x0000000405050000, 0x0000000800000004, 0x0000000107000000, 0x0000000002060000, 0x0001000000030a00, 0x0000000100000001,
        0x0001000000000000, 0x1000000000100000, 0x0001060e03000000, 0x1000000000000000, 0x0001060f03000000, 0x1000000000000000, 0x0001061003000000, 0x0e00000000000000,
        0x0010060a03000000, 0x0c00000000000000, 0x0000060a03000000, 0x0c00000000000040, 0x0000060d03000000, 0x0e00000000000100, 0x0000000400000000, 0x000010060a030103,
        0x000c000000000000, 0x0300000004000000, 0x00400000060a0301, 0x00000c0000000000, 0x0100000006020300, 0x00000e0000000000, 0x0000001006020300, 0x00000c0000000000,
        0x0040000006020300, 0x00000c0000000000, 0x0100000006050300, 0x00000e0000000000, 0x0103000000040000, 0x0000000010060203, 0x0000000c00000000, 0x0301030000000400,
        0x0000004000000602, 0x0000000010000000, 0x1006020300000006, 0x0600000000000000, 0x0000000000000000, 0x0006000000001000, 0x000010060a030000, 0x0000060000000000,
        0x0001000000000000, 0x3c1e000000040000, 0x26f53d3b501f3c90, 0x0000be832ba13cf5
    };
    return data;
};
// clang-format on

} // namespace conv
} // namespace v2
} // namespace jit
} // namespace intel
} // namespace gpu
} // namespace impl
} // namespace dnnl
