/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.widgets;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;

public class WidgetOperator
extends Operator {
    protected Widget widget;

    public WidgetOperator(Widget widget) {
        this.widget = widget;
    }

    public WidgetOperator(WidgetOperator widgetOperator, WidgetChooser widgetChooser) {
        this(widgetOperator, widgetChooser, 0);
    }

    public WidgetOperator(WidgetOperator widgetOperator, int n) {
        this(widgetOperator, null, n);
    }

    public WidgetOperator(WidgetOperator widgetOperator, WidgetChooser widgetChooser, int n) {
        this(WidgetOperator.waitWidget(widgetOperator.getWidget(), widgetChooser, n));
        this.copyEnvironment(widgetOperator);
    }

    public WidgetOperator(TopComponentOperator topComponentOperator, WidgetChooser widgetChooser) {
        this(topComponentOperator, widgetChooser, 0);
    }

    public WidgetOperator(TopComponentOperator topComponentOperator, int n) {
        this(topComponentOperator, null, n);
    }

    public WidgetOperator(TopComponentOperator topComponentOperator, WidgetChooser widgetChooser, int n) {
        this(WidgetOperator.waitWidget((Widget)WidgetOperator.waitScene(topComponentOperator), widgetChooser, n));
        this.copyEnvironment((Operator)topComponentOperator);
    }

    private static Scene waitScene(TopComponentOperator topComponentOperator) {
        Component component = topComponentOperator.waitSubComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component.getClass().getName().endsWith("SceneComponent");
            }

            public String getDescription() {
                return "SceneComponent";
            }
        });
        try {
            Field[] fieldArray = component.getClass().getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                Class<?> clazz = field.getType();
                if (!Scene.class.isAssignableFrom(clazz)) continue;
                field.setAccessible(true);
                return (Scene)field.get(component);
            }
        }
        catch (Exception exception) {
            throw new JemmyException("Exception while getting Scene field from " + component, (Throwable)exception);
        }
        throw new JemmyException("Scene field not found in " + component);
    }

    private static Widget waitWidget(final Widget widget, final WidgetChooser widgetChooser, final int n) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return WidgetOperator.findWidget(widget, widgetChooser, n);
                }

                public String getDescription() {
                    return (n > 0 ? n + "-th " : "") + (widgetChooser == null ? "Widget " : widgetChooser.getDescription()) + " displayed";
                }
            });
            Timeouts timeouts = JemmyProperties.getCurrentTimeouts().cloneThis();
            timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("WidgetOperator.WaitWidgetTimeout"));
            waiter.setTimeouts(timeouts);
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (Widget)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    public static Widget findWidget(final Widget widget, final WidgetChooser widgetChooser, final int n) {
        return (Widget)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("findWidget"){

            public Object launch() {
                return WidgetOperator.findWidget(widget, widgetChooser, n, new Counter());
            }
        });
    }

    private static Widget findWidget(Widget widget, WidgetChooser widgetChooser, int n, Counter counter) {
        List list = widget.getChildren();
        for (Widget widget2 : list) {
            if (widgetChooser != null && !widgetChooser.checkWidget(widget2)) continue;
            if (n == counter.getValue()) {
                return widget2;
            }
            counter.increase();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Widget widget2;
            widget2 = WidgetOperator.findWidget((Widget)iterator.next(), widgetChooser, n, counter);
            if (widget2 == null) continue;
            return widget2;
        }
        return null;
    }

    private Scene getScene() {
        return (Scene)this.runMapping(new Operator.MapAction("widget.getScene()"){

            public Object map() {
                return WidgetOperator.this.widget.getScene();
            }
        });
    }

    public WidgetOperator getSceneOperator() {
        return new WidgetOperator((Widget)this.getScene());
    }

    public List<WidgetOperator> getChildren() {
        List list = (List)this.runMapping(new Operator.MapAction("widget.getChildren"){

            public Object map() {
                return WidgetOperator.this.widget.getChildren();
            }
        });
        ArrayList<WidgetOperator> arrayList = new ArrayList<WidgetOperator>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new WidgetOperator((Widget)iterator.next()));
        }
        return arrayList;
    }

    public WidgetOperator getParent() {
        Widget widget = (Widget)this.runMapping(new Operator.MapAction("widget.getParentWidget"){

            public Object map() {
                return WidgetOperator.this.widget.getParentWidget();
            }
        });
        if (widget == null) {
            return null;
        }
        return new WidgetOperator(widget);
    }

    public Component getSource() {
        return this.getViewOperator().getSource();
    }

    public JComponentOperator getViewOperator() {
        return new JComponentOperator((JComponent)this.runMapping(new Operator.MapAction("widget.getScene().getView()"){

            public Object map() {
                return WidgetOperator.this.widget.getScene().getView();
            }
        }));
    }

    public Widget getWidget() {
        return this.widget;
    }

    public Point getCenter() {
        return (Point)this.runMapping(new Operator.MapAction("getCenter"){

            public Object map() {
                Rectangle rectangle = WidgetOperator.this.widget.convertLocalToScene(WidgetOperator.this.widget.getBounds());
                Rectangle rectangle2 = WidgetOperator.this.widget.getScene().convertSceneToView(rectangle);
                return new Point(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2);
            }
        });
    }

    public Point getLocation() {
        return (Point)this.runMapping(new Operator.MapAction("widget.getLocation()"){

            public Object map() {
                return WidgetOperator.this.widget.getLocation();
            }
        });
    }

    public Rectangle getBounds() {
        return (Rectangle)this.runMapping(new Operator.MapAction("widget.getBounds()"){

            public Object map() {
                return WidgetOperator.this.widget.getBounds();
            }
        });
    }

    public String toString() {
        return this.widget.getClass().getName() + "[" + this.getLocation() + "," + this.getBounds() + "]";
    }

    public void printDump() {
        this.printDump("");
    }

    private void printDump(String string) {
        this.getOutput().printLine(string + (Object)((Object)this));
        string = string + "    ";
        List list = this.widget.getChildren();
        for (Widget widget : list) {
            WidgetOperator widgetOperator = WidgetOperator.createOperator(widget);
            widgetOperator.copyEnvironment(this);
            widgetOperator.printDump(string);
        }
    }

    public static WidgetOperator createOperator(Widget widget) {
        Class<?> clazz = widget.getClass();
        while (Widget.class.isAssignableFrom(clazz)) {
            String string = clazz.getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            try {
                return (WidgetOperator)((Object)new ClassReference("org.netbeans.jellytools.widgets." + string2 + "Operator").newInstance(new Object[]{widget}, new Class[]{clazz}));
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Class<?> clazz2 = Class.forName("org.netbeans.jellytools.widgets." + string2 + "Operator", true, Thread.currentThread().getContextClassLoader());
                    return (WidgetOperator)((Object)clazz2.getConstructor(clazz).newInstance(widget));
                }
                catch (Exception exception) {
                    clazz = clazz.getSuperclass();
                }
            }
            catch (Exception exception) {
                throw new JemmyException("Exception while creating operator.", (Throwable)exception);
            }
        }
        return new WidgetOperator(widget);
    }

    public void performPopupAction(String string) {
        Point point = this.getCenter();
        this.getViewOperator().clickForPopup(point.x, point.y);
        JPopupMenuOperator jPopupMenuOperator = new JPopupMenuOperator();
        jPopupMenuOperator.setComparator(this.getComparator());
        jPopupMenuOperator.pushMenu(string, "|", this.getComparator());
    }

    public void performPopupActionNoBlock(String string) {
        Point point = this.getCenter();
        this.getViewOperator().clickForPopup(point.x, point.y);
        JPopupMenuOperator jPopupMenuOperator = new JPopupMenuOperator();
        jPopupMenuOperator.setComparator(this.getComparator());
        jPopupMenuOperator.pushMenuNoBlock(string, "|", this.getComparator());
    }

    public void clickMouse(int n) {
        Point point = this.getCenter();
        this.getViewOperator().clickMouse(point.x, point.y, n);
    }

    public void dragNDrop(int n, int n2) {
        Point point = this.getCenter();
        this.dragNDrop(point.x, point.y, point.x + n, point.y + n2);
    }

    public void dragNDrop(WidgetOperator widgetOperator) {
        Point point = this.getCenter();
        Point point2 = widgetOperator.getCenter();
        this.dragNDrop(point.x, point.y, point2.x, point2.y);
    }

    public void dragNDrop(int n, int n2, int n3, int n4) {
        this.getViewOperator().dragNDrop(n, n2, n3, n4);
    }

    static {
        Timeouts.initDefault((String)"WidgetOperator.WaitWidgetTimeout", (long)30000L);
    }

    private static final class Counter {
        int counter = 0;

        public void increase() {
            ++this.counter;
        }

        public int getValue() {
            return this.counter;
        }
    }

    public static interface WidgetChooser {
        public boolean checkWidget(Widget var1);

        public String getDescription();
    }
}

