from unittest import TestCase, main

from ugrd.initramfs_generator import InitramfsGenerator
from zenlib.logging import loggify


@loggify
class TestUGRD(TestCase):
    def test_fullauto(self):
        generator = InitramfsGenerator(logger=self.logger, config="tests/fullauto.toml")
        generator.build()

    def test_xz(self):
        generator = InitramfsGenerator(logger=self.logger, config="tests/fullauto.toml", cpio_compression="xz")
        generator.build()

    def test_zstd(self):
        generator = InitramfsGenerator(logger=self.logger, config="tests/fullauto.toml", cpio_compression="zstd")
        generator.build()

    def test_bad_config(self):
        with self.assertRaises(ValueError):
            InitramfsGenerator(logger=self.logger, config="tests/bad_config.toml")

    def test_no_root(self):
        generator = InitramfsGenerator(
            logger=self.logger, config="tests/fullauto.toml", test_no_rootfs=True, test_flag="Restarting init"
        )
        generator.build()


if __name__ == "__main__":
    main()
