#include "utils/chunk.hpp"
#include "catch2/catch_test_macros.hpp"
#include <vector>

TEST_CASE("chunk 5") {
  const std::vector<int> input = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
  const auto output = utils::chunk(input, 5);

  CHECK( output.size() == 2 );
  CHECK( output.at(0).size() == 5  );
  CHECK( output.at(1).size() == 5  );

  CHECK( output.at(0).at(0) == 1  );
  CHECK( output.at(0).at(1) == 2  );

  CHECK( output.at(1).at(0) == 6  );
  CHECK( output.at(1).at(1) == 7  );
}

TEST_CASE("chunk 7") {
  const std::vector<int> input = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
  const auto output = utils::chunk(input, 7);

  CHECK( output.size() == 2 );
  CHECK( output.at(0).size() == 7  );
  CHECK( output.at(1).size() == 3  );

  CHECK( output.at(0).at(0) == 1  );
  CHECK( output.at(0).at(1) == 2  );

  CHECK( output.at(1).at(0) == 8  );
  CHECK( output.at(1).at(1) == 9  );
}

TEST_CASE("chunk 1") {
  const std::vector<int> input = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
  const auto output = utils::chunk(input, 1);

  CHECK( output.size() == 10 );
  CHECK( output.at(0).size() == 1  );
  CHECK( output.at(1).size() == 1  );

  CHECK( output.at(0).at(0) == 1  );
  CHECK( output.at(1).at(0) == 2  );
  CHECK( output.at(2).at(0) == 3  );
  CHECK( output.at(3).at(0) == 4  );
  CHECK( output.at(8).at(0) == 9  );
  CHECK( output.at(9).at(0) == 10  );
}
