//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cAnimation.hpp
// Project: Shooting Star
// Author: Tuomas Peippo <tuomas.peippo@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#include "cFont.hpp"

#include <stdexcept>
#include <stdarg.h>
#include <GL/glu.h>
#include <stdio.h>
#include <GL/glx.h>
#include "Debug.hpp"

using namespace ShootingStar;
using namespace DontUse;

//! Constructor
cFont::cFont (string font):
mListBase (0)
{
	Display *disp;
	XFontStruct *fontInfo;

	dbgInfo () << "Loading font: " << font << endl;
      
	disp = XOpenDisplay (NULL);

	fontInfo =
		XLoadQueryFont (disp, font.c_str ());
	// "-adobe-helvetica-medium-r-normal--18-*-*-*-p-*-iso8859-1"
	
	if (fontInfo == NULL)
	{			// No specified font found...trying fixed

		fontInfo = XLoadQueryFont (disp, "fixed");

		if (fontInfo == NULL)
		{
			dbgError () << "No fonts found!" << endl;
			throw runtime_error ("Loading font failed");
		}
	}

	mListBase = glGenLists (96);
	glXUseXFont (fontInfo->fid, 32, 96, mListBase);

	XFreeFont (disp, fontInfo);
	XCloseDisplay (disp);
}

//! Desturctor
cFont::~cFont (void)
{
	if ( mListBase != 0 )
		glDeleteLists (mListBase, 96);		
}

void 
cFont::PrintString (string text)
{
  	dbg::assertion (DBG_ASSERTION (mListBase != 0));
	if (text.empty ())
		return;

	glPushAttrib (GL_LIST_BIT);

	glListBase (mListBase - 32);
	glCallLists (text.size (), GL_UNSIGNED_BYTE, text.c_str ());

	glPopAttrib ();
}

void 
cFont::Print (const char *pFormat, ...)
{
	char buffer[255];
	
	va_list argumentList;
	va_start (argumentList, pFormat);

	// Format string to buffer
	vsnprintf (buffer, 255, pFormat, argumentList);
	
	va_end (argumentList);
	
	PrintString (buffer);
}

//==============================================================================
// EOF
//==============================================================================
