//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cOwnable.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cOwnable_hpp
#define cOwnable_hpp
//==============================================================================
// Includes
#include "Types.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! Ownable
//------------------------------------------------------------------------------
class cOwnable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cOwnable (void);
		//! Destructor
		~cOwnable (void);
	
	// Public methods
	public:
		//! Sets the owner of this object (use zero for no owner)
		void SetOwner (ObjectID owner) { mOwner = owner; };
		//! Returns the owner of this object
		ObjectID GetOwner (void) { return mOwner; };
	
	// Member variables
	private:
		ObjectID mOwner;	//!< ID of the owner object
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cOwnable_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
