//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cPositionable.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cPositionable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//==============================================================================
//! Constructor
/*!
	Position and rotation are _NOT_ set to zero in constructor so newly created 
	objects	can be anywhere.
*/
//------------------------------------------------------------------------------
cPositionable::cPositionable (void)
{
	// Empty
};
//==============================================================================

//==============================================================================
//! Destructor
//------------------------------------------------------------------------------
cPositionable::~cPositionable (void)
{
	// Empty
};
//==============================================================================

//==============================================================================
//! Return direction vector
cVector2f
cPositionable::GetDirection (float angle) const
{
	return cVector2f (	cos (D2R (GetRotation () + angle)),
						sin (D2R (GetRotation () + angle)));
}
//==============================================================================

//==============================================================================
// EOF
//==============================================================================
