//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cBurnable.hpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cBurnable_hpp
#define cBurnable_hpp
//==============================================================================
// Includes
#include "cHurtable.hpp"
#include "cPointer.hpp"
#include "cBurningEffect.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//! Burnable
class cBurnable : public cHurtable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cBurnable (void);
		//! Destructor
		virtual ~cBurnable (void);
	
	// Public methods
	public:
		virtual void Update (Uint32 deltaTime);
		void Burn (Uint32 time, ObjectID burner);
	
	// Member variables
	private:
		cPointer<cBurningEffect> mEffect;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cBurnable_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
