# Go API client for insights

BitBucket Server Code Insights API

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```golang
import sw "./insights"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```golang
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `sw.ContextServerIndex` of type `int`.

```golang
ctx := context.WithValue(context.Background(), sw.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `sw.ContextServerVariables` of type `map[string]string`.

```golang
ctx := context.WithValue(context.Background(), sw.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identifield by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `sw.ContextOperationServerIndices` and `sw.ContextOperationServerVariables` context maps.

```
ctx := context.WithValue(context.Background(), sw.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), sw.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rest*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*InsightsApi* | [**CreateAnnotations**](docs/InsightsApi.md#createannotations) | **Post** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}/annotations | Add annotations to the given report.
*InsightsApi* | [**DeleteAnnotations**](docs/InsightsApi.md#deleteannotations) | **Delete** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}/annotations | Delete annotations
*InsightsApi* | [**DeleteReport**](docs/InsightsApi.md#deletereport) | **Delete** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey} | Delete a report for the given commit. Also deletes any annotations associated with this report.
*InsightsApi* | [**GetAnnotations**](docs/InsightsApi.md#getannotations) | **Get** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/annotations | Retrieve the specified commit&#39;s annotations.
*InsightsApi* | [**GetReport**](docs/InsightsApi.md#getreport) | **Get** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey} | Retrieve the specified report.
*InsightsApi* | [**GetReportAnnotations**](docs/InsightsApi.md#getreportannotations) | **Get** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}/annotations | Retrieve the specified report&#39;s annotations.
*InsightsApi* | [**GetReports**](docs/InsightsApi.md#getreports) | **Get** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reposts | Get reports list for specified commit
*InsightsApi* | [**UpdateAnnotation**](docs/InsightsApi.md#updateannotation) | **Put** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey}/annotations/{externalId} | Create an annotation with the given external ID, or replace it if it already exists.
*InsightsApi* | [**UpdateReport**](docs/InsightsApi.md#updatereport) | **Put** /insights/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/reports/{reportKey} | Create a new insight report, or replace the existing one.


## Documentation For Models

 - [Annotation](docs/Annotation.md)
 - [AnnotationsList](docs/AnnotationsList.md)
 - [Error](docs/Error.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Report](docs/Report.md)
 - [ReportsListResponse](docs/ReportsListResponse.md)


## Documentation For Authorization



### basicAuth

- **Type**: HTTP basic authentication

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextBasicAuth, sw.BasicAuth{
    UserName: "username",
    Password: "password",
})
r, err := client.Service.Operation(auth, args)
```


### bearerAuth

- **Type**: HTTP Bearer token authentication

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextAccessToken, "BEARERTOKENSTRING")
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



