//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiwindowsceneresizingrestrictions?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIWindowSceneResizingRestrictions(pub NSInteger);
impl UIWindowSceneResizingRestrictions {
    /// App has no preference on user resize
    #[doc(alias = "UIWindowSceneResizingRestrictionsUnspecified")]
    pub const Unspecified: Self = Self(0);
    /// The user cannot resize the scene
    #[doc(alias = "UIWindowSceneResizingRestrictionsNone")]
    pub const None: Self = Self(1);
    /// User resizes are restricted to the current aspect ratio
    #[doc(alias = "UIWindowSceneResizingRestrictionsUniform")]
    pub const Uniform: Self = Self(2);
    /// User resizes are only restricted by the system and other restrictions put in place
    #[doc(alias = "UIWindowSceneResizingRestrictionsFreeform")]
    pub const Freeform: Self = Self(3);
}

unsafe impl Encode for UIWindowSceneResizingRestrictions {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIWindowSceneResizingRestrictions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiwindowscenegeometry?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIWindowSceneGeometry;
);

extern_conformance!(
    unsafe impl NSCopying for UIWindowSceneGeometry {}
);

unsafe impl CopyingHelper for UIWindowSceneGeometry {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIWindowSceneGeometry {}
);

impl UIWindowSceneGeometry {
    extern_methods!(
        /// Geometry objects are readonly and should only be created by the framework. To set a window scene's geometry, see UIWindowSceneGeometryPreferences and -[UIWindowScene requestGeometryUpdateWithPreferences:].
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(systemFrame))]
        #[unsafe(method_family = none)]
        pub unsafe fn systemFrame(&self) -> CGRect;

        #[cfg(feature = "UIOrientation")]
        #[unsafe(method(interfaceOrientation))]
        #[unsafe(method_family = none)]
        pub unsafe fn interfaceOrientation(&self) -> UIInterfaceOrientation;

        #[cfg(feature = "objc2-core-foundation")]
        /// The current app specified minimumSize. A value of 0,0 is returned if a minimum is not set by the application
        #[unsafe(method(minimumSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn minimumSize(&self) -> CGSize;

        #[cfg(feature = "objc2-core-foundation")]
        /// The current app specified maximumSize. A value of CGFLOAT_MAX,CGFLOAT_MAX is returned if a maximum is not set by the application
        #[unsafe(method(maximumSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn maximumSize(&self) -> CGSize;

        /// The current app specified resizingRestriction. Default value UIWindowSceneResizingRestrictionsUnspecified
        #[unsafe(method(resizingRestrictions))]
        #[unsafe(method_family = none)]
        pub unsafe fn resizingRestrictions(&self) -> UIWindowSceneResizingRestrictions;
    );
}
