﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/amplifybackend/model/ServiceName.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace AmplifyBackend {
namespace Model {
namespace ServiceNameMapper {

static const int S3_HASH = HashingUtils::HashString("S3");

ServiceName GetServiceNameForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == S3_HASH) {
    return ServiceName::S3;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<ServiceName>(hashCode);
  }

  return ServiceName::NOT_SET;
}

Aws::String GetNameForServiceName(ServiceName enumValue) {
  switch (enumValue) {
    case ServiceName::NOT_SET:
      return {};
    case ServiceName::S3:
      return "S3";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace ServiceNameMapper
}  // namespace Model
}  // namespace AmplifyBackend
}  // namespace Aws
