﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appmesh/model/HttpGatewayRoute.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace AppMesh {
namespace Model {

HttpGatewayRoute::HttpGatewayRoute(JsonView jsonValue) { *this = jsonValue; }

HttpGatewayRoute& HttpGatewayRoute::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("action")) {
    m_action = jsonValue.GetObject("action");
    m_actionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("match")) {
    m_match = jsonValue.GetObject("match");
    m_matchHasBeenSet = true;
  }
  return *this;
}

JsonValue HttpGatewayRoute::Jsonize() const {
  JsonValue payload;

  if (m_actionHasBeenSet) {
    payload.WithObject("action", m_action.Jsonize());
  }

  if (m_matchHasBeenSet) {
    payload.WithObject("match", m_match.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace AppMesh
}  // namespace Aws
