﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/backup/model/ListRestoreTestingPlansResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Backup::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRestoreTestingPlansResult::ListRestoreTestingPlansResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListRestoreTestingPlansResult& ListRestoreTestingPlansResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RestoreTestingPlans")) {
    Aws::Utils::Array<JsonView> restoreTestingPlansJsonList = jsonValue.GetArray("RestoreTestingPlans");
    for (unsigned restoreTestingPlansIndex = 0; restoreTestingPlansIndex < restoreTestingPlansJsonList.GetLength();
         ++restoreTestingPlansIndex) {
      m_restoreTestingPlans.push_back(restoreTestingPlansJsonList[restoreTestingPlansIndex].AsObject());
    }
    m_restoreTestingPlansHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
