/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v4.23.4
// source: staging/src/k8s.io/kubelet/pkg/apis/pluginregistration/v1alpha1/api.proto

package v1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PluginInfo is the message sent from a plugin to the Kubelet pluginwatcher for plugin registration
type PluginInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Type of the Plugin. CSIPlugin or DevicePlugin
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Plugin name that uniquely identifies the plugin for the given plugin type.
	// For DevicePlugin, this is the resource name that the plugin manages and
	// should follow the extended resource name convention.
	// For CSI, this is the CSI driver registrar name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Optional endpoint location. If found set by Kubelet component,
	// Kubelet component will use this endpoint for specific requests.
	// This allows the plugin to register using one endpoint and possibly use
	// a different socket for control operations. CSI uses this model to delegate
	// its registration external from the plugin.
	Endpoint string `protobuf:"bytes,3,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Plugin service API versions the plugin supports.
	// For DevicePlugin, this maps to the deviceplugin API versions the
	// plugin supports at the given socket.
	// The Kubelet component communicating with the plugin should be able
	// to choose any preferred version from this list, or returns an error
	// if none of the listed versions is supported.
	SupportedVersions []string `protobuf:"bytes,4,rep,name=supported_versions,json=supportedVersions,proto3" json:"supported_versions,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *PluginInfo) Reset() {
	*x = PluginInfo{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginInfo) ProtoMessage() {}

func (x *PluginInfo) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PluginInfo.ProtoReflect.Descriptor instead.
func (*PluginInfo) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescGZIP(), []int{0}
}

func (x *PluginInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *PluginInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PluginInfo) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *PluginInfo) GetSupportedVersions() []string {
	if x != nil {
		return x.SupportedVersions
	}
	return nil
}

// RegistrationStatus is the message sent from Kubelet pluginwatcher to the plugin for notification on registration status
type RegistrationStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True if plugin gets registered successfully at Kubelet
	PluginRegistered bool `protobuf:"varint,1,opt,name=plugin_registered,json=pluginRegistered,proto3" json:"plugin_registered,omitempty"`
	// Error message in case plugin fails to register, empty string otherwise
	Error         string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegistrationStatus) Reset() {
	*x = RegistrationStatus{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegistrationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegistrationStatus) ProtoMessage() {}

func (x *RegistrationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegistrationStatus.ProtoReflect.Descriptor instead.
func (*RegistrationStatus) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescGZIP(), []int{1}
}

func (x *RegistrationStatus) GetPluginRegistered() bool {
	if x != nil {
		return x.PluginRegistered
	}
	return false
}

func (x *RegistrationStatus) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// RegistrationStatusResponse is sent by plugin to kubelet in response to RegistrationStatus RPC
type RegistrationStatusResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegistrationStatusResponse) Reset() {
	*x = RegistrationStatusResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegistrationStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegistrationStatusResponse) ProtoMessage() {}

func (x *RegistrationStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegistrationStatusResponse.ProtoReflect.Descriptor instead.
func (*RegistrationStatusResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescGZIP(), []int{2}
}

// InfoRequest is the empty request message from Kubelet
type InfoRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InfoRequest) Reset() {
	*x = InfoRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InfoRequest) ProtoMessage() {}

func (x *InfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InfoRequest.ProtoReflect.Descriptor instead.
func (*InfoRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescGZIP(), []int{3}
}

var File_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto protoreflect.FileDescriptor

var file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDesc = string([]byte{
	0x0a, 0x49, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x31, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x70, 0x6c, 0x75,
	0x67, 0x69, 0x6e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x7f, 0x0a, 0x0a, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x2d, 0x0a, 0x12, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0x57, 0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x65, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x1c, 0x0a, 0x1a, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x0d, 0x0a, 0x0b, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x32, 0xd2, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x1f, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0x00, 0x12, 0x74, 0x0a, 0x18, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x26, 0x2e, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x2e, 0x2e, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x35, 0x5a, 0x33, 0x6b,
	0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b,
	0x67, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescOnce sync.Once
	file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescData []byte
)

func file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescGZIP() []byte {
	file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescOnce.Do(func() {
		file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDesc)))
	})
	return file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDescData
}

var file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_goTypes = []any{
	(*PluginInfo)(nil),                 // 0: pluginregistration.PluginInfo
	(*RegistrationStatus)(nil),         // 1: pluginregistration.RegistrationStatus
	(*RegistrationStatusResponse)(nil), // 2: pluginregistration.RegistrationStatusResponse
	(*InfoRequest)(nil),                // 3: pluginregistration.InfoRequest
}
var file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_depIdxs = []int32{
	3, // 0: pluginregistration.Registration.GetInfo:input_type -> pluginregistration.InfoRequest
	1, // 1: pluginregistration.Registration.NotifyRegistrationStatus:input_type -> pluginregistration.RegistrationStatus
	0, // 2: pluginregistration.Registration.GetInfo:output_type -> pluginregistration.PluginInfo
	2, // 3: pluginregistration.Registration.NotifyRegistrationStatus:output_type -> pluginregistration.RegistrationStatusResponse
	2, // [2:4] is the sub-list for method output_type
	0, // [0:2] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_init() }
func file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_init() {
	if File_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_goTypes,
		DependencyIndexes: file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_depIdxs,
		MessageInfos:      file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_msgTypes,
	}.Build()
	File_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto = out.File
	file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_goTypes = nil
	file_staging_src_k8s_io_kubelet_pkg_apis_pluginregistration_v1alpha1_api_proto_depIdxs = nil
}
