/* PR c/102989 */
/* { dg-do run { target bitint575 } } */
/* { dg-options "-fsanitize=signed-integer-overflow,shift -fsanitize-recover=signed-integer-overflow,shift" } */

__attribute__((noipa)) int
foo (_BitInt(575) *p, _BitInt(575) *q, int n)
{
  q[0] = p[0] + p[1];
  q[1] = p[2] - p[3];
  q[2] = p[4] * p[5];
  q[3] = p[6] / p[7];
  q[4] = p[8] << n;
  q[5] = p[9] >> n;
  return n;
}

int
main ()
{
  static _BitInt(575) p[] = {
    61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174782wb, 1wb,
    -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1wb,
    248661618204893321077691124073410420050228075398673858720231988446579748506266687766527wb, 248661618204893321077691124073410420050228075398673858720231988446579748506266687766529wb,
    -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, 1wb,
    0wb, 1wb,
    61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1wb,
    -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, 1wb,
    248661618204893321077691124073410420050228075398673858720231988446579748506266687766527wb, 248661618204893321077691124073410420050228075398673858720231988446579748506266687766530wb,
    -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1, -1wb,
    0wb, 1wb
  };
  _BitInt(575) q[6];
  foo (p, q, 574);
  foo (p + 10, q, 575);
}

/* These print unsigned integer overflow even when it is signed.  */
/* { dg-output "signed integer overflow: <unknown> \\+ <unknown> cannot be represented in type '_BitInt\\\(575\\\)'\[^\n\r]*(\n|\r\n|\r)" } */
/* { dg-output "\[^\n\r]*signed integer overflow: <unknown> - <unknown> cannot be represented in type '_BitInt\\\(575\\\)'\[^\n\r]*(\n|\r\n|\r)" } */
/* { dg-output "\[^\n\r]*signed integer overflow: <unknown> \\* <unknown> cannot be represented in type '_BitInt\\\(575\\\)'\[^\n\r]*(\n|\r\n|\r)" } */
/* Inaccurate.  */
/* { dg-output "\[^\n\r]*division by zero\[^\n\r]*(\n|\r\n|\r)" } */
/* The wording is totally incorrect, but at least it is diagnosed.  */
/* { dg-output "\[^\n\r]*shift exponent 575 is too large for \[0-9]*-bit type '_BitInt\\\(575\\\)'\[^\n\r]*(\n|\r\n|\r)" } */
/* { dg-output "\[^\n\r]*shift exponent 575 is too large for \[0-9]*-bit type '_BitInt\\\(575\\\)'" } */
