/*
Copyright 2019 HAProxy Technologies

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package types

import (
	stderrors "errors"
	"strings"
)

type InspectDelay struct {
	Timeout string
	Comment string
}

func (f *InspectDelay) Parse(parts []string, comment string) error {
	if comment != "" {
		f.Comment = comment
	}
	if len(parts) < 3 {
		return stderrors.New("not enough params")
	}
	f.Timeout = parts[2]
	return nil
}

func (f *InspectDelay) String() string {
	var result strings.Builder

	result.WriteString("inspect-delay")
	result.WriteString(" ")
	result.WriteString(f.Timeout)

	if f.Comment != "" {
		result.WriteString(" # ")
		result.WriteString(f.Comment)
	}

	return result.String()
}

func (f *InspectDelay) GetComment() string {
	return f.Comment
}
