/*
 * Subset of Influx API covered by Influx CLI
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * API version: 2.0.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package api

import (
	"encoding/json"
	"time"
)

// Bucket struct for Bucket
type Bucket struct {
	Links       *BucketLinks `json:"links,omitempty" yaml:"links,omitempty"`
	Id          *string      `json:"id,omitempty" yaml:"id,omitempty"`
	Type        *string      `json:"type,omitempty" yaml:"type,omitempty"`
	Name        string       `json:"name" yaml:"name"`
	Description *string      `json:"description,omitempty" yaml:"description,omitempty"`
	OrgID       *string      `json:"orgID,omitempty" yaml:"orgID,omitempty"`
	Rp          *string      `json:"rp,omitempty" yaml:"rp,omitempty"`
	SchemaType  *SchemaType  `json:"schemaType,omitempty" yaml:"schemaType,omitempty"`
	CreatedAt   *time.Time   `json:"createdAt,omitempty" yaml:"createdAt,omitempty"`
	UpdatedAt   *time.Time   `json:"updatedAt,omitempty" yaml:"updatedAt,omitempty"`
	// Retention rules to expire or retain data. The InfluxDB `/api/v2` API uses `RetentionRules` to configure the [retention period]({{% INFLUXDB_DOCS_URL %}}/reference/glossary/#retention-period).  #### InfluxDB Cloud  - `retentionRules` is required.  #### InfluxDB OSS  - `retentionRules` isn't required.
	RetentionRules []RetentionRule `json:"retentionRules" yaml:"retentionRules"`
	Labels         *[]Label        `json:"labels,omitempty" yaml:"labels,omitempty"`
}

// NewBucket instantiates a new Bucket object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBucket(name string, retentionRules []RetentionRule) *Bucket {
	this := Bucket{}
	var type_ string = "user"
	this.Type = &type_
	this.Name = name
	this.RetentionRules = retentionRules
	return &this
}

// NewBucketWithDefaults instantiates a new Bucket object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBucketWithDefaults() *Bucket {
	this := Bucket{}
	var type_ string = "user"
	this.Type = &type_
	return &this
}

// GetLinks returns the Links field value if set, zero value otherwise.
func (o *Bucket) GetLinks() BucketLinks {
	if o == nil || o.Links == nil {
		var ret BucketLinks
		return ret
	}
	return *o.Links
}

// GetLinksOk returns a tuple with the Links field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetLinksOk() (*BucketLinks, bool) {
	if o == nil || o.Links == nil {
		return nil, false
	}
	return o.Links, true
}

// HasLinks returns a boolean if a field has been set.
func (o *Bucket) HasLinks() bool {
	if o != nil && o.Links != nil {
		return true
	}

	return false
}

// SetLinks gets a reference to the given BucketLinks and assigns it to the Links field.
func (o *Bucket) SetLinks(v BucketLinks) {
	o.Links = &v
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *Bucket) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *Bucket) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *Bucket) SetId(v string) {
	o.Id = &v
}

// GetType returns the Type field value if set, zero value otherwise.
func (o *Bucket) GetType() string {
	if o == nil || o.Type == nil {
		var ret string
		return ret
	}
	return *o.Type
}

// GetTypeOk returns a tuple with the Type field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetTypeOk() (*string, bool) {
	if o == nil || o.Type == nil {
		return nil, false
	}
	return o.Type, true
}

// HasType returns a boolean if a field has been set.
func (o *Bucket) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// SetType gets a reference to the given string and assigns it to the Type field.
func (o *Bucket) SetType(v string) {
	o.Type = &v
}

// GetName returns the Name field value
func (o *Bucket) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *Bucket) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *Bucket) SetName(v string) {
	o.Name = v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *Bucket) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *Bucket) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *Bucket) SetDescription(v string) {
	o.Description = &v
}

// GetOrgID returns the OrgID field value if set, zero value otherwise.
func (o *Bucket) GetOrgID() string {
	if o == nil || o.OrgID == nil {
		var ret string
		return ret
	}
	return *o.OrgID
}

// GetOrgIDOk returns a tuple with the OrgID field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetOrgIDOk() (*string, bool) {
	if o == nil || o.OrgID == nil {
		return nil, false
	}
	return o.OrgID, true
}

// HasOrgID returns a boolean if a field has been set.
func (o *Bucket) HasOrgID() bool {
	if o != nil && o.OrgID != nil {
		return true
	}

	return false
}

// SetOrgID gets a reference to the given string and assigns it to the OrgID field.
func (o *Bucket) SetOrgID(v string) {
	o.OrgID = &v
}

// GetRp returns the Rp field value if set, zero value otherwise.
func (o *Bucket) GetRp() string {
	if o == nil || o.Rp == nil {
		var ret string
		return ret
	}
	return *o.Rp
}

// GetRpOk returns a tuple with the Rp field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetRpOk() (*string, bool) {
	if o == nil || o.Rp == nil {
		return nil, false
	}
	return o.Rp, true
}

// HasRp returns a boolean if a field has been set.
func (o *Bucket) HasRp() bool {
	if o != nil && o.Rp != nil {
		return true
	}

	return false
}

// SetRp gets a reference to the given string and assigns it to the Rp field.
func (o *Bucket) SetRp(v string) {
	o.Rp = &v
}

// GetSchemaType returns the SchemaType field value if set, zero value otherwise.
func (o *Bucket) GetSchemaType() SchemaType {
	if o == nil || o.SchemaType == nil {
		var ret SchemaType
		return ret
	}
	return *o.SchemaType
}

// GetSchemaTypeOk returns a tuple with the SchemaType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetSchemaTypeOk() (*SchemaType, bool) {
	if o == nil || o.SchemaType == nil {
		return nil, false
	}
	return o.SchemaType, true
}

// HasSchemaType returns a boolean if a field has been set.
func (o *Bucket) HasSchemaType() bool {
	if o != nil && o.SchemaType != nil {
		return true
	}

	return false
}

// SetSchemaType gets a reference to the given SchemaType and assigns it to the SchemaType field.
func (o *Bucket) SetSchemaType(v SchemaType) {
	o.SchemaType = &v
}

// GetCreatedAt returns the CreatedAt field value if set, zero value otherwise.
func (o *Bucket) GetCreatedAt() time.Time {
	if o == nil || o.CreatedAt == nil {
		var ret time.Time
		return ret
	}
	return *o.CreatedAt
}

// GetCreatedAtOk returns a tuple with the CreatedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetCreatedAtOk() (*time.Time, bool) {
	if o == nil || o.CreatedAt == nil {
		return nil, false
	}
	return o.CreatedAt, true
}

// HasCreatedAt returns a boolean if a field has been set.
func (o *Bucket) HasCreatedAt() bool {
	if o != nil && o.CreatedAt != nil {
		return true
	}

	return false
}

// SetCreatedAt gets a reference to the given time.Time and assigns it to the CreatedAt field.
func (o *Bucket) SetCreatedAt(v time.Time) {
	o.CreatedAt = &v
}

// GetUpdatedAt returns the UpdatedAt field value if set, zero value otherwise.
func (o *Bucket) GetUpdatedAt() time.Time {
	if o == nil || o.UpdatedAt == nil {
		var ret time.Time
		return ret
	}
	return *o.UpdatedAt
}

// GetUpdatedAtOk returns a tuple with the UpdatedAt field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetUpdatedAtOk() (*time.Time, bool) {
	if o == nil || o.UpdatedAt == nil {
		return nil, false
	}
	return o.UpdatedAt, true
}

// HasUpdatedAt returns a boolean if a field has been set.
func (o *Bucket) HasUpdatedAt() bool {
	if o != nil && o.UpdatedAt != nil {
		return true
	}

	return false
}

// SetUpdatedAt gets a reference to the given time.Time and assigns it to the UpdatedAt field.
func (o *Bucket) SetUpdatedAt(v time.Time) {
	o.UpdatedAt = &v
}

// GetRetentionRules returns the RetentionRules field value
func (o *Bucket) GetRetentionRules() []RetentionRule {
	if o == nil {
		var ret []RetentionRule
		return ret
	}

	return o.RetentionRules
}

// GetRetentionRulesOk returns a tuple with the RetentionRules field value
// and a boolean to check if the value has been set.
func (o *Bucket) GetRetentionRulesOk() (*[]RetentionRule, bool) {
	if o == nil {
		return nil, false
	}
	return &o.RetentionRules, true
}

// SetRetentionRules sets field value
func (o *Bucket) SetRetentionRules(v []RetentionRule) {
	o.RetentionRules = v
}

// GetLabels returns the Labels field value if set, zero value otherwise.
func (o *Bucket) GetLabels() []Label {
	if o == nil || o.Labels == nil {
		var ret []Label
		return ret
	}
	return *o.Labels
}

// GetLabelsOk returns a tuple with the Labels field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Bucket) GetLabelsOk() (*[]Label, bool) {
	if o == nil || o.Labels == nil {
		return nil, false
	}
	return o.Labels, true
}

// HasLabels returns a boolean if a field has been set.
func (o *Bucket) HasLabels() bool {
	if o != nil && o.Labels != nil {
		return true
	}

	return false
}

// SetLabels gets a reference to the given []Label and assigns it to the Labels field.
func (o *Bucket) SetLabels(v []Label) {
	o.Labels = &v
}

func (o Bucket) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Links != nil {
		toSerialize["links"] = o.Links
	}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	if o.Type != nil {
		toSerialize["type"] = o.Type
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.OrgID != nil {
		toSerialize["orgID"] = o.OrgID
	}
	if o.Rp != nil {
		toSerialize["rp"] = o.Rp
	}
	if o.SchemaType != nil {
		toSerialize["schemaType"] = o.SchemaType
	}
	if o.CreatedAt != nil {
		toSerialize["createdAt"] = o.CreatedAt
	}
	if o.UpdatedAt != nil {
		toSerialize["updatedAt"] = o.UpdatedAt
	}
	if true {
		toSerialize["retentionRules"] = o.RetentionRules
	}
	if o.Labels != nil {
		toSerialize["labels"] = o.Labels
	}
	return json.Marshal(toSerialize)
}

type NullableBucket struct {
	value *Bucket
	isSet bool
}

func (v NullableBucket) Get() *Bucket {
	return v.value
}

func (v *NullableBucket) Set(val *Bucket) {
	v.value = val
	v.isSet = true
}

func (v NullableBucket) IsSet() bool {
	return v.isSet
}

func (v *NullableBucket) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBucket(val *Bucket) *NullableBucket {
	return &NullableBucket{value: val, isSet: true}
}

func (v NullableBucket) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBucket) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
