/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import twitter4j.Annotations;
import twitter4j.GeoLocation;
import twitter4j.HashtagEntity;
import twitter4j.MediaEntity;
import twitter4j.Place;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserMentionEntity;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.HashtagEntityJSONImpl;
import twitter4j.internal.json.MediaEntityJSONImpl;
import twitter4j.internal.json.PlaceJSONImpl;
import twitter4j.internal.json.ResponseListImpl;
import twitter4j.internal.json.TwitterResponseImpl;
import twitter4j.internal.json.URLEntityJSONImpl;
import twitter4j.internal.json.UserJSONImpl;
import twitter4j.internal.json.UserMentionEntityJSONImpl;
import twitter4j.internal.json.z_T4JInternalJSONImplFactory;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.z_T4JInternalParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StatusJSONImpl
extends TwitterResponseImpl
implements Status,
Serializable {
    private static final Logger logger = Logger.getLogger(class$twitter4j$internal$json$StatusJSONImpl == null ? (class$twitter4j$internal$json$StatusJSONImpl = StatusJSONImpl.class$("twitter4j.internal.json.StatusJSONImpl")) : class$twitter4j$internal$json$StatusJSONImpl);
    private static final long serialVersionUID = 7548618898682727465L;
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private long inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private GeoLocation geoLocation = null;
    private Place place = null;
    private long retweetCount;
    private boolean wasRetweetedByMe;
    private String[] contributors = null;
    private long[] contributorsIDs;
    private Annotations annotations = null;
    private Status retweetedStatus;
    private UserMentionEntity[] userMentionEntities;
    private URLEntity[] urlEntities;
    private HashtagEntity[] hashtagEntities;
    private MediaEntity[] mediaEntities;
    private Status myRetweetedStatus;
    private User user = null;
    static /* synthetic */ Class class$twitter4j$internal$json$StatusJSONImpl;

    StatusJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    StatusJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = z_T4JInternalParseUtil.getLong("id", json);
        this.text = z_T4JInternalParseUtil.getUnescapedString("text", json);
        this.source = z_T4JInternalParseUtil.getUnescapedString("source", json);
        this.createdAt = z_T4JInternalParseUtil.getDate("created_at", json);
        this.isTruncated = z_T4JInternalParseUtil.getBoolean("truncated", json);
        this.inReplyToStatusId = z_T4JInternalParseUtil.getLong("in_reply_to_status_id", json);
        this.inReplyToUserId = z_T4JInternalParseUtil.getLong("in_reply_to_user_id", json);
        this.isFavorited = z_T4JInternalParseUtil.getBoolean("favorited", json);
        this.inReplyToScreenName = z_T4JInternalParseUtil.getUnescapedString("in_reply_to_screen_name", json);
        this.retweetCount = z_T4JInternalParseUtil.getLong("retweet_count", json);
        try {
            if (!json.isNull("user")) {
                this.user = new UserJSONImpl(json.getJSONObject("user"));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        this.geoLocation = z_T4JInternalJSONImplFactory.createGeoLocation(json);
        if (!json.isNull("place")) {
            try {
                this.place = new PlaceJSONImpl(json.getJSONObject("place"));
            }
            catch (JSONException ignore) {
                ignore.printStackTrace();
                logger.warn(new StringBuffer().append("failed to parse place:").append(json).toString());
            }
        }
        if (!json.isNull("retweeted_status")) {
            try {
                this.retweetedStatus = new StatusJSONImpl(json.getJSONObject("retweeted_status"));
            }
            catch (JSONException ignore) {
                ignore.printStackTrace();
                logger.warn(new StringBuffer().append("failed to parse retweeted_status:").append(json).toString());
            }
        }
        if (!json.isNull("contributors")) {
            try {
                JSONArray contributorsArray = json.getJSONArray("contributors");
                this.contributorsIDs = new long[contributorsArray.length()];
                for (int i = 0; i < contributorsArray.length(); ++i) {
                    this.contributorsIDs[i] = Long.parseLong(contributorsArray.getString(i));
                }
            }
            catch (NumberFormatException ignore) {
                ignore.printStackTrace();
                logger.warn(new StringBuffer().append("failed to parse contributors:").append(json).toString());
            }
            catch (JSONException ignore) {
                ignore.printStackTrace();
                logger.warn(new StringBuffer().append("failed to parse contributors:").append(json).toString());
            }
        } else {
            this.contributors = null;
        }
        if (!json.isNull("entities")) {
            try {
                JSONObject entities = json.getJSONObject("entities");
                JSONArray userMentionsArray = entities.getJSONArray("user_mentions");
                int len = userMentionsArray.length();
                this.userMentionEntities = new UserMentionEntity[len];
                for (int i = 0; i < len; ++i) {
                    this.userMentionEntities[i] = new UserMentionEntityJSONImpl(userMentionsArray.getJSONObject(i));
                }
                JSONArray urlsArray = entities.getJSONArray("urls");
                len = urlsArray.length();
                this.urlEntities = new URLEntity[len];
                for (int i = 0; i < len; ++i) {
                    this.urlEntities[i] = new URLEntityJSONImpl(urlsArray.getJSONObject(i));
                }
                JSONArray hashtagsArray = entities.getJSONArray("hashtags");
                len = hashtagsArray.length();
                this.hashtagEntities = new HashtagEntity[len];
                for (int i = 0; i < len; ++i) {
                    this.hashtagEntities[i] = new HashtagEntityJSONImpl(hashtagsArray.getJSONObject(i));
                }
                JSONArray mediaArray = entities.getJSONArray("media");
                len = mediaArray.length();
                this.mediaEntities = new MediaEntity[len];
                for (int i = 0; i < len; ++i) {
                    this.mediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
                }
            }
            catch (JSONException ignore) {
                // empty catch block
            }
        }
        if (!json.isNull("annotations")) {
            try {
                JSONArray annotationsArray = json.getJSONArray("annotations");
                this.annotations = new Annotations(annotationsArray);
            }
            catch (JSONException ignore) {
                // empty catch block
            }
        }
        if (!json.isNull("current_user_retweet")) {
            try {
                this.myRetweetedStatus = new StatusJSONImpl(json.getJSONObject("current_user_retweet"));
                this.wasRetweetedByMe = true;
            }
            catch (JSONException ignore) {
                ignore.printStackTrace();
                logger.warn(new StringBuffer().append("failed to parse current_user_retweet:").append(json).toString());
            }
        }
    }

    @Override
    public int compareTo(Status that) {
        long delta = this.id - that.getId();
        if (delta < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (delta > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)delta;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    public long getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Override
    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    @Override
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public long[] getContributors() {
        if (this.contributors != null) {
            this.contributorsIDs = new long[this.contributors.length];
            for (int i = 0; i < this.contributors.length; ++i) {
                try {
                    this.contributorsIDs[i] = Long.parseLong(this.contributors[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    logger.warn(new StringBuffer().append("failed to parse contributors:").append(nfe).toString());
                }
            }
            this.contributors = null;
        }
        return this.contributorsIDs;
    }

    @Override
    public Annotations getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isFavorited() {
        return this.isFavorited;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isRetweet() {
        return this.retweetedStatus != null;
    }

    @Override
    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    @Override
    public long getRetweetCount() {
        return this.retweetCount;
    }

    @Override
    public boolean isRetweetedByMe() {
        return this.wasRetweetedByMe;
    }

    @Override
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    @Override
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    @Override
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    @Override
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    static ResponseList<Status> createStatusList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<Status> statuses = new ResponseListImpl<Status>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                StatusJSONImpl status = new StatusJSONImpl(json);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(status, json);
                }
                statuses.add(status);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(statuses, list);
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).getId() == this.id;
    }

    public String toString() {
        return new StringBuffer().append("StatusJSONImpl{createdAt=").append(this.createdAt).append(", id=").append(this.id).append(", text='").append(this.text).append('\'').append(", source='").append(this.source).append('\'').append(", isTruncated=").append(this.isTruncated).append(", inReplyToStatusId=").append(this.inReplyToStatusId).append(", inReplyToUserId=").append(this.inReplyToUserId).append(", isFavorited=").append(this.isFavorited).append(", inReplyToScreenName='").append(this.inReplyToScreenName).append('\'').append(", geoLocation=").append(this.geoLocation).append(", place=").append(this.place).append(", retweetCount=").append(this.retweetCount).append(", wasRetweetedByMe=").append(this.wasRetweetedByMe).append(", contributors=").append(this.contributorsIDs == null ? null : Arrays.asList(new long[][]{this.contributorsIDs})).append(", annotations=").append(this.annotations).append(", retweetedStatus=").append(this.retweetedStatus).append(", userMentionEntities=").append(this.userMentionEntities == null ? null : Arrays.asList(this.userMentionEntities)).append(", urlEntities=").append(this.urlEntities == null ? null : Arrays.asList(this.urlEntities)).append(", hashtagEntities=").append(this.hashtagEntities == null ? null : Arrays.asList(this.hashtagEntities)).append(", user=").append(this.user).append('}').toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Status)x0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

