/* wav file header stuff - needed to coerce Xing to run... */
/* Borrowed from lwcast */
#include <liveice.h>


struct wavhead {
	u_long        main_chunk;     /* 'RIFF' */
	u_long        length;         /* Length of rest of file */
	u_long        chunk_type;     /* 'WAVE' */
	
	u_long        sub_chunk;      /* 'fmt ' */
	long        sc_len;         /* length of sub_chunk, =16 (rest of chunk) */
	u_short       format;         /* should be 1 for PCM-code */
	u_short       modus;          /* 1 Mono, 2 Stereo */
	u_long        sample_fq;      /* frequence of sample */
	u_long        byte_p_sec;
	u_short       byte_p_spl;     /* samplesize; 1 or 2 bytes */
	u_short       bit_p_spl;      /* 8, 12 or 16 bit */ 
	u_long        data_chunk;     /* 'data' */
	long        data_length;    /* samplecount (lenth of rest of block?)*/
};


void write_wav_header(FILE *outfile,int sample_rate,int stereo)
{
	struct wavhead tmp;
	char blankbuff[256];  /* attempt to keep xing happy */
	memset(blankbuff,0,256);

	memcpy(&tmp.main_chunk,"RIFF",4);
	tmp.length = -1;
	memcpy(&tmp.chunk_type,"WAVE",4);
	memcpy(&tmp.sub_chunk,"fmt ",4);
	tmp.sc_len = 16;
	tmp.format = 1;
	tmp.modus = (stereo ? 2 : 1);
	tmp.sample_fq = sample_rate;
	tmp.byte_p_sec = sample_rate * 2 * (stereo ? 2 : 1) ;
	tmp.byte_p_spl = (stereo ? 4 : 2);
	tmp.bit_p_spl = 16;
	memcpy(&tmp.data_chunk,"data",4);
	tmp.data_length = -1;
	memcpy(blankbuff,&tmp,sizeof(tmp));
	fwrite(&tmp,256,1,outfile);
}
