/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.descriptor.value.CssValueValidatorStub;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CssValueDescriptorMapper {
    private static final Logger LOG = Logger.getInstance(CssValueDescriptorMapper.class);
    @Nullable
    private final PsiElement myStartElement;
    @Nullable
    private final PsiElement myStopElement;

    public CssValueDescriptorMapper(@Nullable CssTermList termList) {
        this(CssPsiUtil.getFirstDeepestTerm(termList), CssPsiUtil.getLastDeepestTerm(termList));
    }

    public CssValueDescriptorMapper(@Nullable PsiElement startElement, @Nullable PsiElement stopElement) {
        this.myStartElement = startElement;
        this.myStopElement = stopElement;
    }

    @NotNull
    public CssValueMatchData mapValue(@NotNull CssValueDescriptor descriptor) {
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(0);
        }
        try {
            return this.mapValue(this.myStartElement, descriptor);
        }
        catch (StackOverflowError e) {
            this.logSOE();
            return new CssValueMatchData(descriptor, false);
        }
    }

    private void logSOE() {
        CssTermList termList;
        StringBuilder message = new StringBuilder("StackOverflowError. ");
        Language language = CssPsiUtil.getStylesheetLanguage(this.myStartElement);
        if (language != null) {
            message.append(language);
        }
        if ((termList = (CssTermList)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myStartElement, (Class[])new Class[]{CssTermList.class})) != null) {
            PsiElement parent = termList.getParent();
            message.append(" [").append(parent.getText()).append("]");
            message.append(", offset=").append(this.myStartElement.getTextRange().getStartOffset() - parent.getTextRange().getStartOffset());
        }
        LOG.error(message.toString());
    }

    @NotNull
    private CssValueMatchData mapValue(@Nullable PsiElement current, @NotNull CssValueDescriptor descriptor) {
        CssValueMatchData firstMatchData;
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        current = CssPsiUtil.getFirstDeepestTerm(current);
        int maxOccur = descriptor.getMaxOccur();
        int minOccur = descriptor.getMinOccur();
        boolean matched = true;
        ArrayList<CssValueMatchData> matchData = new ArrayList<CssValueMatchData>();
        int attempt = 0;
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider(current);
        CssValueDescriptor separator = null;
        if (descriptorProvider != null) {
            separator = (CssValueDescriptor)ContainerUtil.getFirstItem(descriptorProvider.getNamedValueDescriptors("comma-separator", descriptor));
        }
        while (attempt++ < maxOccur || maxOccur == -1) {
            PsiElement[] fallbackTerms = CssValueDescriptorMapper.getVarFallbackTerms(current);
            if (fallbackTerms != null) {
                current = fallbackTerms[0];
            }
            boolean separatorMatched = true;
            if (attempt != 1 && descriptor.isCommaSeparated()) {
                assert (separator != null);
                CssValueMatchData separatorMatchData = this.mapValue(current, separator);
                matchData.add(separatorMatchData);
                separatorMatched = separatorMatchData.isMatched();
                if (separatorMatched) {
                    current = this.nextElement(separatorMatchData.getLastMatchedElement(), true, current);
                }
            }
            CssValueMatchData nodeMatch = this.match(descriptor, current);
            if (separatorMatched && nodeMatch.isMatched()) {
                PsiElement lastMatchedElement = nodeMatch.getLastMatchedElement();
                if (lastMatchedElement != null) {
                    current = lastMatchedElement;
                }
            } else {
                if (attempt > minOccur) break;
                matched = false;
                matchData.add(nodeMatch);
                break;
            }
            matchData.add(nodeMatch);
            if (attempt < maxOccur || maxOccur == -1) {
                current = this.nextElement(current, true);
            }
            if (current != null) continue;
            if (attempt >= minOccur) break;
            matched = false;
            break;
        }
        if (matchData.size() == 1 && (firstMatchData = (CssValueMatchData)ContainerUtil.getFirstItem(matchData)) != null) {
            CssValueMatchData cssValueMatchData = matched != firstMatchData.isMatched() ? new CssValueMatchData(firstMatchData.getDescriptor(), matched, firstMatchData.getChildren()) : firstMatchData;
            if (cssValueMatchData == null) {
                CssValueDescriptorMapper.$$$reportNull$$$0(2);
            }
            return cssValueMatchData;
        }
        return new CssValueMatchData(descriptor, matched, matchData);
    }

    private CssValueMatchData match(@NotNull CssValueDescriptor descriptor, @Nullable PsiElement element) {
        CssValueMatchData result;
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(3);
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider(element);
        if (descriptor instanceof CssGroupValue) {
            return this.matchGroupValue((CssGroupValue)descriptor, element);
        }
        if (descriptor instanceof CssInlineValue && descriptorProvider != null) {
            if (((CssInlineValue)descriptor).getRefId().equals("font-family")) {
                this.addDescriptorForCompletion(descriptor);
            }
            return this.matchInlineValue((CssInlineValue)descriptor, element, descriptorProvider);
        }
        if (descriptor instanceof CssPropertyReferenceValue && descriptorProvider != null) {
            return this.matchPropertyReferenceValue((CssPropertyReferenceValue)descriptor, element, descriptorProvider);
        }
        if (element == null) {
            return CssValueMatchData.fail(descriptor);
        }
        if (element instanceof CssTerm) {
            this.addTermForCompletion(descriptor, element);
        }
        if ((result = new CssValueMatchData(descriptor, CssValueDescriptorMapper.getValueValidator(element).isValid(element, descriptor))).isMatched()) {
            result.addMatchedElement(element);
        }
        return result;
    }

    protected void addDescriptorForCompletion(@NotNull CssValueDescriptor descriptor) {
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(4);
        }
    }

    protected void addTermForCompletion(@NotNull CssValueDescriptor descriptor, @NotNull PsiElement element) {
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(5);
        }
        if (element == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    private CssValueMatchData matchGroupValue(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(7);
        }
        CssValueMatchData cssValueMatchData = switch (descriptor.getType()) {
            case CssGroupValue.Type.OR -> this.mapGroupOrDescriptor(descriptor, element);
            case CssGroupValue.Type.AND -> this.mapGroupAndDescriptor(descriptor, element);
            case CssGroupValue.Type.ANY -> this.mapGroupAnyDescriptor(descriptor, element);
            case CssGroupValue.Type.ALL -> this.mapGroupAllDescriptor(descriptor, element);
            default -> throw new IllegalArgumentException("Unknown group type: " + String.valueOf((Object)descriptor.getType()));
        };
        if (cssValueMatchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(8);
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData matchInlineValue(@NotNull CssInlineValue descriptor, @Nullable PsiElement element, @NotNull CssElementDescriptorProvider descriptorProvider) {
        Collection<? extends CssValueDescriptor> inlineValues;
        CssValueMatchData matchData;
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(9);
        }
        if (descriptorProvider == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(10);
        }
        if ((matchData = this.matchFirstLongest(inlineValues = CssDescriptorsUtil.sortDescriptors(descriptorProvider.getNamedValueDescriptors(descriptor.getRefId(), descriptor)), element)) != null) {
            return new CssValueMatchData(descriptor, matchData.isMatched(), Collections.singletonList(matchData));
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor);
        if (cssValueMatchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(11);
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData matchPropertyReferenceValue(@NotNull CssPropertyReferenceValue descriptor, @Nullable PsiElement element, @NotNull CssElementDescriptorProvider descriptorProvider) {
        Collection<? extends CssPropertyDescriptor> propertyDescriptors;
        CssValueMatchData matchData;
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(12);
        }
        if (descriptorProvider == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(13);
        }
        if ((matchData = this.matchFirstLongest(ContainerUtil.map(propertyDescriptors = descriptorProvider.findPropertyDescriptors(descriptor.getPropertyName(), element), propertyDescriptor -> CssValueDescriptorModificator.withParent(propertyDescriptor.getValueDescriptor(), descriptor)), element)) != null) {
            return new CssValueMatchData(descriptor, matchData.isMatched(), Collections.singletonList(matchData));
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor);
        if (cssValueMatchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(14);
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData mapGroupAllDescriptor(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(15);
        }
        CssValueDescriptor separator = descriptor.getValuesSeparator();
        ArrayList<CssValueMatchData> childrenMatchData = new ArrayList<CssValueMatchData>();
        boolean whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        for (CssValueDescriptor child : descriptor.getChildren()) {
            boolean matched;
            boolean childIsRequired = CssValueDescriptorMapper.isRequired(child);
            if (separator != null && CssValueDescriptorMapper.lastIsNotSeparator(childrenMatchData, separator)) {
                CssValueMatchData separatorMatchData = this.mapValue(element, separator);
                if (separatorMatchData.isMatched()) {
                    childrenMatchData.add(separatorMatchData);
                } else if (childIsRequired) {
                    childrenMatchData.add(separatorMatchData);
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                    if (cssValueMatchData == null) {
                        CssValueDescriptorMapper.$$$reportNull$$$0(16);
                    }
                    return cssValueMatchData;
                }
                element = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
            }
            CssValueMatchData childMatchData = this.mapValue(element, child);
            boolean bl = matched = element != null && (whitespacesShouldBeIgnored || !(element instanceof PsiWhiteSpace)) && childMatchData.isMatched();
            if (matched) {
                childrenMatchData.add(childMatchData);
            } else if (childIsRequired) {
                childrenMatchData.add(childMatchData);
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                if (cssValueMatchData == null) {
                    CssValueDescriptorMapper.$$$reportNull$$$0(17);
                }
                return cssValueMatchData;
            }
            element = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
        }
        if (separator != null && CssValueDescriptorMapper.lastIsSeparator(childrenMatchData, separator)) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
            if (cssValueMatchData == null) {
                CssValueDescriptorMapper.$$$reportNull$$$0(18);
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.success(descriptor, childrenMatchData);
        if (cssValueMatchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(19);
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData mapGroupAnyDescriptor(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(20);
        }
        ArrayList<CssValueDescriptor> restChildrenDescriptors = new ArrayList<CssValueDescriptor>(descriptor.getChildren());
        CssValueDescriptor separator = descriptor.getValuesSeparator();
        ArrayList<CssValueMatchData> childrenMatchData = new ArrayList<CssValueMatchData>();
        boolean whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        boolean first = true;
        while (!restChildrenDescriptors.isEmpty() && (element != null || first)) {
            PsiElement nextElement;
            if (separator != null && CssValueDescriptorMapper.lastIsNotSeparator(childrenMatchData, separator)) {
                CssValueMatchData separatorMatchData = this.mapValue(element, separator);
                if (separatorMatchData.isMatched()) {
                    childrenMatchData.add(separatorMatchData);
                } else if (CssValueDescriptorMapper.isRequired(separatorMatchData.getDescriptor()) || CssValueDescriptorMapper.isRequired(restChildrenDescriptors)) {
                    childrenMatchData.add(separatorMatchData);
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                    if (cssValueMatchData == null) {
                        CssValueDescriptorMapper.$$$reportNull$$$0(21);
                    }
                    return cssValueMatchData;
                }
                element = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
            }
            if (element == null) {
                for (CssValueDescriptor requiredChild : CssValueDescriptorMapper.getAllRequired(restChildrenDescriptors)) {
                    childrenMatchData.add(this.match(requiredChild, null));
                }
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                if (cssValueMatchData == null) {
                    CssValueDescriptorMapper.$$$reportNull$$$0(22);
                }
                return cssValueMatchData;
            }
            Collection<CssValueMatchData> longestMatchedChildrenData = this.matchAllLongest(restChildrenDescriptors, element);
            if (longestMatchedChildrenData.isEmpty()) {
                if (!first) break;
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                if (cssValueMatchData == null) {
                    CssValueDescriptorMapper.$$$reportNull$$$0(23);
                }
                return cssValueMatchData;
            }
            CssValueMatchData childMatchData = (CssValueMatchData)ContainerUtil.getFirstItem(longestMatchedChildrenData);
            assert (childMatchData != null);
            if (longestMatchedChildrenData.size() > 1 && (nextElement = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, this.nextElement(element, whitespacesShouldBeIgnored))) != null) {
                for (CssValueDescriptor childDescriptor : restChildrenDescriptors) {
                    CssValueMatchData nextChildData = this.mapValue(nextElement, childDescriptor);
                    if (!nextChildData.isMatched()) continue;
                    CssValueDescriptor nextChildDataDescriptor = nextChildData.getDescriptor();
                    Iterator<CssValueMatchData> iterator = longestMatchedChildrenData.iterator();
                    while (iterator.hasNext()) {
                        CssValueMatchData matchData = iterator.next();
                        if (!matchData.getDescriptor().equals(nextChildDataDescriptor)) continue;
                        iterator.remove();
                    }
                }
                childMatchData = (CssValueMatchData)ContainerUtil.getFirstItem(longestMatchedChildrenData, (Object)childMatchData);
            }
            CssValueMatchData lastMatched = (CssValueMatchData)ContainerUtil.getLastItem(childrenMatchData);
            childrenMatchData.add(childMatchData);
            if (!childMatchData.isMatched()) {
                if (lastMatched == null) {
                    CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                    if (cssValueMatchData == null) {
                        CssValueDescriptorMapper.$$$reportNull$$$0(24);
                    }
                    return cssValueMatchData;
                }
                if (lastMatched.getDescriptor() != separator) {
                    CssValueMatchData cssValueMatchData = CssValueMatchData.success(descriptor, childrenMatchData);
                    if (cssValueMatchData == null) {
                        CssValueDescriptorMapper.$$$reportNull$$$0(25);
                    }
                    return cssValueMatchData;
                }
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                if (cssValueMatchData == null) {
                    CssValueDescriptorMapper.$$$reportNull$$$0(26);
                }
                return cssValueMatchData;
            }
            restChildrenDescriptors.remove(childMatchData.getDescriptor());
            element = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
            first = false;
        }
        if (separator != null && CssValueDescriptorMapper.lastIsSeparator(childrenMatchData, separator)) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
            if (cssValueMatchData == null) {
                CssValueDescriptorMapper.$$$reportNull$$$0(27);
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.success(descriptor, childrenMatchData);
        if (cssValueMatchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(28);
        }
        return cssValueMatchData;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private CssValueMatchData mapGroupAndDescriptor(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(29);
        }
        ArrayList<CssValueDescriptor> restChildrenDescriptors = new ArrayList<CssValueDescriptor>(descriptor.getChildren());
        CssValueDescriptor separator = descriptor.getValuesSeparator();
        ArrayList<CssValueMatchData> childrenMatchData = new ArrayList<CssValueMatchData>();
        boolean whitespacesShouldBeIgnored = descriptor.isWhitespacesShouldBeIgnored();
        boolean first = true;
        while (!restChildrenDescriptors.isEmpty() && (element != null || first)) {
            CssValueMatchData childMatchData;
            block18: {
                first = false;
                if (separator != null && CssValueDescriptorMapper.lastIsNotSeparator(childrenMatchData, separator)) {
                    CssValueMatchData separatorMatchData = this.mapValue(element, separator);
                    childrenMatchData.add(separatorMatchData);
                    if (!separatorMatchData.isMatched() && CssValueDescriptorMapper.isRequired(separatorMatchData.getDescriptor()) && CssValueDescriptorMapper.isRequired(restChildrenDescriptors)) {
                        CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                        if (cssValueMatchData == null) {
                            CssValueDescriptorMapper.$$$reportNull$$$0(30);
                        }
                        return cssValueMatchData;
                    }
                    element = this.nextElement(separatorMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
                }
                if (element == null) {
                    CssValueDescriptor optionalChild = CssValueDescriptorMapper.findFirstOptional(restChildrenDescriptors);
                    if (optionalChild != null) {
                        childMatchData = CssValueMatchData.success(optionalChild);
                        break block18;
                    } else {
                        CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                        if (cssValueMatchData == null) {
                            CssValueDescriptorMapper.$$$reportNull$$$0(31);
                        }
                        return cssValueMatchData;
                    }
                }
                childMatchData = this.matchFirstLongest(restChildrenDescriptors, element);
            }
            if (childMatchData == null) {
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                if (cssValueMatchData == null) {
                    CssValueDescriptorMapper.$$$reportNull$$$0(32);
                }
                return cssValueMatchData;
            }
            childrenMatchData.add(childMatchData);
            if (!childMatchData.isMatched() && CssValueDescriptorMapper.isRequired(childMatchData.getDescriptor())) {
                CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
                if (cssValueMatchData == null) {
                    CssValueDescriptorMapper.$$$reportNull$$$0(33);
                }
                return cssValueMatchData;
            }
            restChildrenDescriptors.remove(childMatchData.getDescriptor());
            element = this.nextElement(childMatchData.getLastMatchedElement(), whitespacesShouldBeIgnored, element);
        }
        if (!restChildrenDescriptors.isEmpty() && !CssValueDescriptorMapper.getAllRequired(restChildrenDescriptors).isEmpty()) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
            if (cssValueMatchData == null) {
                CssValueDescriptorMapper.$$$reportNull$$$0(34);
            }
            return cssValueMatchData;
        }
        if (separator != null && CssValueDescriptorMapper.lastIsSeparator(childrenMatchData, separator)) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.fail(descriptor, childrenMatchData);
            if (cssValueMatchData == null) {
                CssValueDescriptorMapper.$$$reportNull$$$0(35);
            }
            return cssValueMatchData;
        }
        CssValueMatchData cssValueMatchData = CssValueMatchData.success(descriptor, childrenMatchData);
        if (cssValueMatchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(36);
        }
        return cssValueMatchData;
    }

    @NotNull
    private CssValueMatchData mapGroupOrDescriptor(@NotNull CssGroupValue descriptor, @Nullable PsiElement element) {
        if (descriptor == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(37);
        }
        boolean required = CssValueDescriptorMapper.isRequired(descriptor.getChildren());
        if (element == null) {
            return new CssValueMatchData(descriptor, !required);
        }
        CssValueMatchData matchData = this.matchFirstLongest(descriptor.getChildren(), element);
        if (!(required || matchData != null && matchData.isMatched())) {
            CssValueMatchData cssValueMatchData = CssValueMatchData.success(descriptor);
            if (cssValueMatchData == null) {
                CssValueDescriptorMapper.$$$reportNull$$$0(38);
            }
            return cssValueMatchData;
        }
        return new CssValueMatchData(descriptor, matchData != null && matchData.isMatched(), Collections.singletonList(matchData));
    }

    @NotNull
    private Collection<CssValueMatchData> matchAllLongest(@NotNull Collection<? extends CssValueDescriptor> descriptors, @Nullable PsiElement element) {
        if (descriptors == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(39);
        }
        boolean somethingAlreadyMatched = false;
        LinkedList<CssValueMatchData> result = new LinkedList<CssValueMatchData>();
        int maxWeight = -1;
        for (CssValueDescriptor cssValueDescriptor : descriptors) {
            int weight;
            CssValueMatchData childData = this.mapValue(element, cssValueDescriptor);
            if (somethingAlreadyMatched && !childData.isMatched()) continue;
            if (!somethingAlreadyMatched && childData.isMatched()) {
                result.clear();
                somethingAlreadyMatched = true;
            }
            if ((weight = CssValueDescriptorMapper.weightMatchData(childData)) == maxWeight) {
                result.add(childData);
                continue;
            }
            if (weight <= maxWeight) continue;
            maxWeight = weight;
            result.clear();
            result.add(childData);
        }
        LinkedList<CssValueMatchData> linkedList = result;
        if (linkedList == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(40);
        }
        return linkedList;
    }

    @Nullable
    private CssValueMatchData matchFirstLongest(@NotNull Collection<? extends CssValueDescriptor> descriptors, @Nullable PsiElement element) {
        if (descriptors == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(41);
        }
        CssValueMatchData matchedLongestResult = null;
        CssValueMatchData unmatchedLongestResult = null;
        for (CssValueDescriptor cssValueDescriptor : descriptors) {
            CssValueMatchData data = this.mapValue(element, cssValueDescriptor);
            if (data.isMatched()) {
                matchedLongestResult = CssValueDescriptorMapper.compareAndGetMostMatched(matchedLongestResult, data);
                continue;
            }
            unmatchedLongestResult = CssValueDescriptorMapper.compareAndGetMostMatched(unmatchedLongestResult, data);
        }
        return (CssValueMatchData)ObjectUtils.chooseNotNull(matchedLongestResult, unmatchedLongestResult);
    }

    @Nullable
    private static CssValueMatchData compareAndGetMostMatched(@Nullable CssValueMatchData first, @Nullable CssValueMatchData second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        PsiElement firstLastMatchedElement = first.getLastMatchedElement();
        PsiElement secondLastMatchedElement = second.getLastMatchedElement();
        if (firstLastMatchedElement == null) {
            return second;
        }
        if (secondLastMatchedElement == null) {
            return first;
        }
        return firstLastMatchedElement.getTextRange().getEndOffset() >= secondLastMatchedElement.getTextRange().getEndOffset() ? first : second;
    }

    private static boolean lastIsNotSeparator(@NotNull List<CssValueMatchData> childrenMatchData, @NotNull CssValueDescriptor separator) {
        CssValueMatchData lastMatched;
        if (childrenMatchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(42);
        }
        if (separator == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(43);
        }
        return (lastMatched = (CssValueMatchData)ContainerUtil.getLastItem(childrenMatchData)) != null && lastMatched.getDescriptor() != separator;
    }

    private static boolean lastIsSeparator(@NotNull List<CssValueMatchData> childrenMatchData, @NotNull CssValueDescriptor separator) {
        CssValueMatchData lastMatched;
        if (childrenMatchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(44);
        }
        if (separator == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(45);
        }
        return (lastMatched = (CssValueMatchData)ContainerUtil.getLastItem(childrenMatchData)) != null && lastMatched.getDescriptor() == separator;
    }

    @Nullable
    private static CssValueDescriptor findFirstOptional(@NotNull Collection<CssValueDescriptor> descriptors) {
        if (descriptors == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(46);
        }
        return (CssValueDescriptor)ContainerUtil.find(descriptors, descriptor -> !CssValueDescriptorMapper.isRequired(descriptor));
    }

    @NotNull
    public static @Unmodifiable List<CssValueDescriptor> getAllRequired(@NotNull Collection<? extends CssValueDescriptor> descriptors) {
        if (descriptors == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(47);
        }
        List list = ContainerUtil.filter(descriptors, descriptor -> CssValueDescriptorMapper.isRequired(descriptor));
        if (list == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(48);
        }
        return list;
    }

    private static boolean isVarFunction(@Nullable PsiElement element) {
        return element instanceof CssFunction && ((CssFunction)element).getName().equals("var");
    }

    public static PsiElement[] getVarFallbackTerms(@Nullable PsiElement maybeVarTerm) {
        PsiElement maybeNestedVarFunction;
        CssTerm[] terms;
        if (maybeVarTerm == null) {
            return null;
        }
        PsiElement maybeVarFunction = maybeVarTerm.getFirstChild();
        if (!CssValueDescriptorMapper.isVarFunction(maybeVarFunction)) {
            return null;
        }
        CssTermList termList = ((CssFunction)maybeVarFunction).getValue();
        CssTerm[] cssTermArray = terms = termList != null ? termList.getTerms() : null;
        if (terms == null || terms.length < 2) {
            return null;
        }
        PsiElement[] fallbackTerms = Arrays.copyOfRange(terms, 1, terms.length);
        PsiElement maybeNestedVarTerm = fallbackTerms[0];
        PsiElement psiElement = maybeNestedVarFunction = maybeNestedVarTerm != null ? maybeNestedVarTerm.getFirstChild() : null;
        if (fallbackTerms.length == 1 && CssValueDescriptorMapper.isVarFunction(maybeNestedVarFunction)) {
            fallbackTerms = CssValueDescriptorMapper.getVarFallbackTerms(maybeNestedVarTerm);
        }
        return fallbackTerms;
    }

    @Nullable
    public static PsiElement getVarFunctionTermElementIfIsLastFallbackTerm(@Nullable PsiElement varFallbackTerm) {
        CssTerm[] terms;
        PsiElement maybeVarFunction;
        if (varFallbackTerm == null) {
            return null;
        }
        PsiElement termList = varFallbackTerm.getParent();
        PsiElement psiElement = maybeVarFunction = termList != null ? termList.getParent() : null;
        if (CssValueDescriptorMapper.isVarFunction(maybeVarFunction) && (terms = ((CssTermList)termList).getTerms()).length > 1 && terms[terms.length - 1].equals(varFallbackTerm)) {
            return CssValueDescriptorMapper.getVarFunctionTermElementIfIsLastFallbackTerm(maybeVarFunction.getParent());
        }
        if (CssValueDescriptorMapper.isVarFunction(varFallbackTerm.getFirstChild())) {
            return varFallbackTerm;
        }
        return null;
    }

    private static boolean isRequired(CssValueDescriptor descriptor) {
        return descriptor.getMinOccur() != 0;
    }

    private static boolean isRequired(@NotNull Collection<CssValueDescriptor> descriptors) {
        if (descriptors == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(49);
        }
        for (CssValueDescriptor child : descriptors) {
            if (child.getMinOccur() != 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private PsiElement nextElement(@Nullable PsiElement element, boolean whitespacesShouldBeIgnored) {
        return this.nextElement(element, whitespacesShouldBeIgnored, null);
    }

    @Nullable
    private PsiElement nextElement(@Nullable PsiElement element, boolean whitespacesShouldBeIgnored, @Nullable PsiElement defaultElement) {
        PsiElement firstChild;
        PsiElement parent;
        PsiElement parentTermList;
        if (element == null) {
            return defaultElement;
        }
        PsiElement nextSibling = this.nextVisibleSibling(element, whitespacesShouldBeIgnored);
        PsiElement varTerm = CssValueDescriptorMapper.getVarFunctionTermElementIfIsLastFallbackTerm(element);
        if (varTerm != null) {
            element = varTerm;
            nextSibling = this.nextVisibleSibling(varTerm, whitespacesShouldBeIgnored);
        }
        if (nextSibling == null && (parentTermList = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{CssTermList.class, CssTerm.class})) != null && (nextSibling = this.nextVisibleSibling(parentTermList, whitespacesShouldBeIgnored)) == null && (parent = parentTermList.getParent()) instanceof CssTerm) {
            nextSibling = this.nextVisibleSibling(parent, whitespacesShouldBeIgnored);
        }
        if (nextSibling instanceof CssTerm && (firstChild = nextSibling.getFirstChild()) instanceof CssTermList) {
            return CssPsiUtil.getFirstDeepestTerm(nextSibling.getFirstChild());
        }
        return CssPsiUtil.getFirstDeepestTerm(nextSibling);
    }

    @Nullable
    private PsiElement nextVisibleSibling(@NotNull PsiElement element, boolean whitespacesShouldBeIgnored) {
        if (element == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(50);
        }
        for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e == this.myStopElement) {
                return e;
            }
            if (this.myStopElement != null && e.getTextRange().getEndOffset() > this.myStopElement.getTextRange().getEndOffset()) {
                return null;
            }
            if (e instanceof PsiComment || whitespacesShouldBeIgnored && e instanceof PsiWhiteSpace) continue;
            return e;
        }
        return null;
    }

    @NotNull
    private static CssValueValidator getValueValidator(@NotNull PsiElement context) {
        CssElementDescriptorProvider provider;
        if (context == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(51);
        }
        if ((provider = CssDescriptorsUtil.findDescriptorProvider(context)) == null) {
            return new CssValueValidatorStub();
        }
        CssValueValidator cssValueValidator = provider.getValueValidator();
        if (cssValueValidator == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(52);
        }
        return cssValueValidator;
    }

    private static int weightMatchData(@NotNull CssValueMatchData matchData) {
        PsiElement lastMatchedElement;
        if (matchData == null) {
            CssValueDescriptorMapper.$$$reportNull$$$0(53);
        }
        return (lastMatchedElement = matchData.getLastMatchedElement()) != null ? lastMatchedElement.getTextRange().getEndOffset() : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 11, 14, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32, 33, 34, 35, 36, 38, 40, 48, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper";
                break;
            }
            case 6: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorProvider";
                break;
            }
            case 39: 
            case 41: 
            case 46: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenMatchData";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/descriptor/value/CssValueDescriptorMapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "mapValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "matchGroupValue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "matchInlineValue";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "matchPropertyReferenceValue";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mapGroupAllDescriptor";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "mapGroupAnyDescriptor";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "mapGroupAndDescriptor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "mapGroupOrDescriptor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "matchAllLongest";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRequired";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapValue";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 48: 
            case 52: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorForCompletion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addTermForCompletion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchGroupValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchInlineValue";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchPropertyReferenceValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mapGroupAllDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mapGroupAnyDescriptor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mapGroupAndDescriptor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "mapGroupOrDescriptor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "matchAllLongest";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "matchFirstLongest";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lastIsNotSeparator";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lastIsSeparator";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findFirstOptional";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getAllRequired";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isRequired";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "nextVisibleSibling";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getValueValidator";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "weightMatchData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 11, 14, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 30, 31, 32, 33, 34, 35, 36, 38, 40, 48, 52 -> new IllegalStateException(string);
        };
    }
}

