/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jinja.template.psi.DjangoFilterName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.python.django.lang.template.DjangoTagUtils;
import com.intellij.python.django.lang.template.inspection.DjangoAddLoadTagQuickFix;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class UnresolvedFilterInspection
extends DjangoTemplateLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "DjangoUnresolvedFilterInspection";
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static final class DjangoTagVisitor
    extends PsiRecursiveElementVisitor
    implements DjangoInspectionVisitor {
        private final List<ProblemDescriptor> myProblems = new ArrayList<ProblemDescriptor>();
        private final InspectionManager myManager;

        private DjangoTagVisitor(InspectionManager manager) {
            this.myManager = manager;
        }

        public void visitElement(@NotNull PsiElement element) {
            DjangoFilterName filter;
            if (element == null) {
                DjangoTagVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof DjangoFilterName && ((filter = (DjangoFilterName)element).getReference() == null || filter.getReference().resolve() == null)) {
                this.reportProblem(filter, DjangoBundle.message((String)"inspection.unresolved-filter.error-msg", (Object[])new Object[]{filter.getText()}));
            }
            super.visitElement(element);
        }

        private void reportProblem(DjangoFilterName filter, @InspectionMessage String msg) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)filter);
            DjangoAddLoadTagQuickFix fix = null;
            if (module != null) {
                fix = DjangoTagUtils.proposeLoadFixForFilter(filter, module);
            }
            ProblemDescriptor d = this.myManager.createProblemDescriptor((PsiElement)filter, new TextRange(0, filter.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[]{fix});
            this.myProblems.add(d);
        }

        @Override
        public void postprocess() {
        }

        @Override
        public List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/python/django/lang/template/inspection/UnresolvedFilterInspection$DjangoTagVisitor", "visitElement"));
        }
    }
}

