/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.ide.plugins.DynamicPluginVetoer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.LogWrapper;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.WebServerConfigsChangedListener;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManagerImpl;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionPool;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Pair;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class RemoteConnectionManager
implements WebServerConfigsChangedListener,
Disposable {
    @NonNls
    public static final String DEFAULT_IDE_FTP_SYSTEM_TYPE = "UNIX default system type provided by IDE";
    private static final Logger LOG = Logger.getInstance(RemoteConnectionManager.class);
    private final Collection<Object> blockingPluginUnloadElements = new ConcurrentLinkedQueue<Object>();
    private final Object LOCK = new Object();
    private final Map<ConnectionKey, RemoteConnectionPool> pools = new TreeMap<ConnectionKey, RemoteConnectionPool>();
    private DefaultFileSystemManager filesystemManager;

    public static RemoteConnectionManager getInstance() {
        return (RemoteConnectionManager)ApplicationManager.getApplication().getService(RemoteConnectionManager.class);
    }

    public RemoteConnectionManager() {
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        appConnection.subscribe(WebDeploymentTopics.WEB_SERVER_CONFIGS, (Object)this);
        if (System.getProperty("org.apache.commons.net.ftp.systemType.default") == null) {
            System.setProperty("org.apache.commons.net.ftp.systemType.default", DEFAULT_IDE_FTP_SYSTEM_TYPE);
        }
        this.serverConfigsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteConnection openConnection(@NotNull ConnectionOwner connectionOwner, @NotNull String title, @NotNull Connectable connectable, @NotNull FileTransferConfig.Origin origin, @Nullable EventDispatcher<ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        RemoteConnectionPool pool;
        if (connectionOwner == null) {
            RemoteConnectionManager.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RemoteConnectionManager.$$$reportNull$$$0(1);
        }
        if (connectable == null) {
            RemoteConnectionManager.$$$reportNull$$$0(2);
        }
        if (origin == null) {
            RemoteConnectionManager.$$$reportNull$$$0(3);
        }
        final ConnectionKey key = new ConnectionKey(connectable.getRootUri(), connectable.getConnectionOptions(connectionOwner, title, origin, forceDisconnectDispatcher, pi));
        Object object = this.LOCK;
        synchronized (object) {
            pool = this.pools.get(key);
            if (pool == null) {
                try {
                    connectionOwner.checkDisposed();
                }
                catch (IllegalStateException e) {
                    throw new FileSystemException(e);
                }
                pool = new RemoteConnectionPool(connectable, connectionOwner, title, origin, forceDisconnectDispatcher);
                this.pools.put(key, pool);
                Disposable disposable = new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        RemoteConnectionPool pool;
                        Object object = RemoteConnectionManager.this.LOCK;
                        synchronized (object) {
                            pool = RemoteConnectionManager.this.pools.remove(key);
                        }
                        if (pool != null) {
                            pool.close();
                        }
                    }
                };
                connectionOwner.registerDisposable(disposable);
                Project project = connectionOwner.getProjectForDialogCreation();
                Disposer.register((Disposable)GroupedServersConfigManager.getInstance(project), (Disposable)disposable);
            }
        }
        return pool.createConnection(forceDisconnectDispatcher, pi);
    }

    @Override
    public void serverConfigsChanged() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            @NotNull List<@NotNull Pair<@NotNull WebServerConfig, @Nullable Project>> newServers = GroupedServersConfigManagerImpl.getServersWithProjectsFromAllOpenProjects(false);
            RemoteConnectionPool[] remoteConnectionPoolArray = this.LOCK;
            synchronized (this.LOCK) {
                RemoteConnectionPool[] pools = this.pools.values().toArray(new RemoteConnectionPool[0]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (RemoteConnectionPool pool : pools) {
                    pool.notifyServersUpdated(newServers);
                }
                return;
            }
        });
    }

    public void dispose() {
        DefaultFileSystemManager filesystemManager = this.filesystemManager;
        if (filesystemManager != null) {
            filesystemManager.getFilesCache().close();
            this.filesystemManager = null;
        }
    }

    @NotNull
    public synchronized FileSystemManager getManager() {
        if (this.filesystemManager == null) {
            this.filesystemManager = new StandardFileSystemManager(){

                @Override
                public void init() throws FileSystemException {
                    this.setConfiguration(PublishUtils.class.getResource("commons-vfs-providers.xml"));
                    this.setCacheStrategy(PublishUtils.DISABLE_FILESYSTEM_CACHE ? CacheStrategy.ON_RESOLVE : CacheStrategy.MANUAL);
                    this.setFilesCache(new SoftRefFilesCache());
                    super.init();
                }
            };
            try {
                ClassLoaderUtil.runWithClassLoader((ClassLoader)RemoteConnectionManager.class.getClassLoader(), () -> this.filesystemManager.init());
            }
            catch (FileSystemException e) {
                throw new IllegalStateException("Failed to initialize filesystem manager", e);
            }
            this.filesystemManager.setLogger(new LogWrapper(LOG));
        }
        DefaultFileSystemManager defaultFileSystemManager = this.filesystemManager;
        if (defaultFileSystemManager == null) {
            RemoteConnectionManager.$$$reportNull$$$0(4);
        }
        return defaultFileSystemManager;
    }

    public void registerBlockingPluginUnloadElement(@NotNull Object element) {
        if (element == null) {
            RemoteConnectionManager.$$$reportNull$$$0(5);
        }
        this.blockingPluginUnloadElements.add(element);
    }

    public void unregisterBlockingPluginUnloadElement(@NotNull Object element) {
        if (element == null) {
            RemoteConnectionManager.$$$reportNull$$$0(6);
        }
        this.blockingPluginUnloadElements.remove(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openConnection";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerBlockingPluginUnloadElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unregisterBlockingPluginUnloadElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class ConnectionKey
    implements Comparable<ConnectionKey> {
        private final String myUri;
        private final FileSystemOptions myFileSystemOptions;

        private ConnectionKey(String uri, FileSystemOptions fileSystemOptions) {
            this.myUri = uri;
            this.myFileSystemOptions = fileSystemOptions;
        }

        @Override
        public int compareTo(ConnectionKey o) {
            int i = this.myUri.compareTo(o.myUri);
            if (i == 0) {
                i = this.myFileSystemOptions.compareTo(o.myFileSystemOptions);
            }
            return i;
        }
    }

    static class RemoteConnectionPluginVetoer
    implements DynamicPluginVetoer {
        RemoteConnectionPluginVetoer() {
        }

        @Nls
        @Nullable
        public String vetoPluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            RemoteConnectionManager manager;
            PluginId pluginId;
            if (pluginDescriptor == null) {
                RemoteConnectionPluginVetoer.$$$reportNull$$$0(0);
            }
            if ("com.jetbrains.plugins.webDeployment".equals((pluginId = pluginDescriptor.getPluginId()).getIdString()) && (manager = (RemoteConnectionManager)ApplicationManager.getApplication().getServiceIfCreated(RemoteConnectionManager.class)) != null && !manager.blockingPluginUnloadElements.isEmpty()) {
                return "Plugin is not unload-safe because of deployment tasks are currently running";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager$RemoteConnectionPluginVetoer", "vetoPluginUnload"));
        }
    }
}

