/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DefaultServerStatusBarWidgetFactory
implements StatusBarWidgetFactory {
    private static final String ID = "webDeployment.default.server.widget";

    DefaultServerStatusBarWidgetFactory() {
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = WDBundle.message("widget.name", new Object[0]);
        if (string == null) {
            DefaultServerStatusBarWidgetFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public StatusBarWidget createWidget(@NotNull Project project, @NotNull CoroutineScope scope) {
        if (project == null) {
            DefaultServerStatusBarWidgetFactory.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            DefaultServerStatusBarWidgetFactory.$$$reportNull$$$0(2);
        }
        return new DefaultServerWidget(project, scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/DefaultServerStatusBarWidgetFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/DefaultServerStatusBarWidgetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static final class DefaultServerWidget
    extends EditorBasedStatusBarPopup {
        private DefaultServerWidget(@NotNull Project project, @NotNull CoroutineScope scope) {
            if (project == null) {
                DefaultServerWidget.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                DefaultServerWidget.$$$reportNull$$$0(1);
            }
            super(project, false, scope);
        }

        @NotNull
        protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
            EditorBasedStatusBarPopup.WidgetState widgetState;
            if (GroupedServersConfigManager.getInstance(this.getProject()).getFlattenedServers().isEmpty()) {
                EditorBasedStatusBarPopup.WidgetState widgetState2 = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
                if (widgetState2 == null) {
                    DefaultServerWidget.$$$reportNull$$$0(2);
                }
                return widgetState2;
            }
            WebServerGroupingWrap defaultServerOrGroup = PublishConfig.getInstance(this.getProject()).findDefaultServerOrGroupAsWrap();
            EditorBasedStatusBarPopup.WidgetState widgetState3 = widgetState = defaultServerOrGroup != null ? new EditorBasedStatusBarPopup.WidgetState(WDBundle.message("widget.tooltip", new Object[0]), PublishConfig.getInstance(this.getProject()).getDefaultServerOrGroupName(), true) : new EditorBasedStatusBarPopup.WidgetState(WDBundle.message("widget.tooltip", new Object[0]), WDBundle.message("widget.no.default.server", new Object[0]), true);
            if (defaultServerOrGroup != null) {
                widgetState.setIcon(defaultServerOrGroup.isSingleServer() ? defaultServerOrGroup.getAsSingleServer().getIcon() : AllIcons.Webreferences.Server);
            }
            EditorBasedStatusBarPopup.WidgetState widgetState4 = widgetState;
            if (widgetState4 == null) {
                DefaultServerWidget.$$$reportNull$$$0(3);
            }
            return widgetState4;
        }

        @NotNull
        protected ListPopup createPopup(@NotNull DataContext context) {
            if (context == null) {
                DefaultServerWidget.$$$reportNull$$$0(4);
            }
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new DefaultDeploymentServerListPopupStep(this.getProject()));
            if (listPopup == null) {
                DefaultServerWidget.$$$reportNull$$$0(5);
            }
            return listPopup;
        }

        protected void registerCustomListeners(@NotNull MessageBusConnection connection) {
            if (connection == null) {
                DefaultServerWidget.$$$reportNull$$$0(6);
            }
            connection.subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

                @Override
                public void optionsChanged() {
                    DefaultServerWidget.super.update();
                }
            });
        }

        @NotNull
        protected StatusBarWidget createInstance(@NotNull Project project) {
            if (project == null) {
                DefaultServerWidget.$$$reportNull$$$0(7);
            }
            return new DefaultServerWidget(project, this.getScope());
        }

        @NotNull
        public String ID() {
            return DefaultServerStatusBarWidgetFactory.ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/DefaultServerStatusBarWidgetFactory$DefaultServerWidget";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/DefaultServerStatusBarWidgetFactory$DefaultServerWidget";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWidgetState";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createPopup";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "registerCustomListeners";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createInstance";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class DefaultDeploymentServerListPopupStep
    implements ListPopupStep<DefaultDeploymentServerStep> {
        private final Project myProject;
        private DefaultDeploymentServerStep mySelected;

        private DefaultDeploymentServerListPopupStep(Project project) {
            this.myProject = project;
            this.mySelected = new DefaultDeploymentServerStep(PublishConfig.getInstance(this.myProject).findDefaultServerOrGroupAsWrap());
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        @Nullable
        public PopupStep<?> onChosen(final DefaultDeploymentServerStep selectedValue, boolean finalChoice) {
            if (!selectedValue.isSingleServer() && !finalChoice) {
                return new DefaultDeploymentServerListPopupStep(this.myProject){

                    @Override
                    @NotNull
                    public List<DefaultDeploymentServerStep> getValues() {
                        List list = ContainerUtil.map(selectedValue.getServers(), it -> new DefaultDeploymentServerStep(WebServerGroupingWrap.wrap(it)));
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/DefaultServerStatusBarWidgetFactory$DefaultDeploymentServerListPopupStep$1", "getValues"));
                    }
                };
            }
            if (selectedValue.isUnmarkDefaultServerStep()) {
                PublishConfig.getInstance(this.myProject).setDefaultGroupOrServerName(null);
            } else {
                PublishConfig.getInstance(this.myProject).setDefaultGroupOrServerName(selectedValue.getName());
            }
            this.mySelected = selectedValue;
            ((DeploymentConfigChangeListener)this.myProject.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).optionsChanged();
            return FINAL_CHOICE;
        }

        @NotNull
        public List<DefaultDeploymentServerStep> getValues() {
            ArrayList<DefaultDeploymentServerStep> steps = new ArrayList<DefaultDeploymentServerStep>();
            steps.addAll(ContainerUtil.map((Collection)ContainerUtil.filter(GroupedServersConfigManager.getInstance(this.myProject).getGroupedServers(), groupedServer -> ContainerUtil.filter(groupedServer.getServers(), server -> ContainerUtil.filter(PublishConfig.getInstance(this.myProject).getPathMappings(server.getId()), mapping -> mapping.isDeployPathValid(false)).isEmpty()).isEmpty()), it -> new DefaultDeploymentServerStep((WebServerGroupingWrap)it)));
            steps.add(new DefaultDeploymentServerStep(null));
            ArrayList<DefaultDeploymentServerStep> arrayList = steps;
            if (arrayList == null) {
                DefaultDeploymentServerListPopupStep.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        public boolean isSelectable(DefaultDeploymentServerStep value) {
            return this.mySelected == null || !value.getName().equals(this.mySelected.getName()) || !value.isSingleServer();
        }

        @Nullable
        public Icon getIconFor(DefaultDeploymentServerStep value) {
            return value.getIcon();
        }

        public boolean hasSubstep(DefaultDeploymentServerStep selectedValue) {
            return !selectedValue.isSingleServer();
        }

        public void canceled() {
        }

        public boolean isMnemonicsNavigationEnabled() {
            return false;
        }

        @Nullable
        public MnemonicNavigationFilter<DefaultDeploymentServerStep> getMnemonicNavigationFilter() {
            return null;
        }

        public boolean isSpeedSearchEnabled() {
            return false;
        }

        @Nullable
        public SpeedSearchFilter<DefaultDeploymentServerStep> getSpeedSearchFilter() {
            return null;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        @Nullable
        public Runnable getFinalRunnable() {
            return null;
        }

        @NotNull
        public String getTextFor(DefaultDeploymentServerStep value) {
            String string = value.getName();
            if (string == null) {
                DefaultDeploymentServerListPopupStep.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(DefaultDeploymentServerStep value) {
            return null;
        }

        public int getDefaultOptionIndex() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/plugins/webDeployment/ui/DefaultServerStatusBarWidgetFactory$DefaultDeploymentServerListPopupStep";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class DefaultDeploymentServerStep {
        private final WebServerGroupingWrap myWebServerGroupingWrap;

        private DefaultDeploymentServerStep(WebServerGroupingWrap webServerGroupingWrap) {
            this.myWebServerGroupingWrap = webServerGroupingWrap;
        }

        public boolean isSingleServer() {
            return this.myWebServerGroupingWrap == null || this.myWebServerGroupingWrap.isSingleServer();
        }

        public List<WebServerConfig> getServers() {
            return this.myWebServerGroupingWrap.getServers();
        }

        @NotNull
        @NlsSafe
        public String getName() {
            String string = this.myWebServerGroupingWrap != null ? this.myWebServerGroupingWrap.getName() : WDBundle.message("widget.no.default.server", new Object[0]);
            if (string == null) {
                DefaultDeploymentServerStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.myWebServerGroupingWrap == null ? null : (this.myWebServerGroupingWrap.isSingleServer() ? this.myWebServerGroupingWrap.getAsSingleServer().getIcon() : AllIcons.Webreferences.Server);
        }

        public boolean isUnmarkDefaultServerStep() {
            return this.myWebServerGroupingWrap == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/DefaultServerStatusBarWidgetFactory$DefaultDeploymentServerStep", "getName"));
        }
    }
}

