/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.ProfilerProcessBase;
import com.intellij.profiler.SnapshotFile;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.ProfileHistoryConfiguration;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0004J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H$J\u0016\u0010$\u001a\u00020\u001f*\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0004J\b\u0010(\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/FileBasedProfilerProcess;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/ProfilerProcessBase;", "project", "Lcom/intellij/openapi/project/Project;", "targetProcess", "snapshotFile", "Lcom/intellij/profiler/SnapshotFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/ProfilerTargetProcess;Lcom/intellij/profiler/SnapshotFile;)V", "dumpFileWhenTargetProcessFinished", "Ljava/io/File;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/ProfilerTargetProcess;Ljava/io/File;)V", "getDumpFileWhenTargetProcessFinished", "()Ljava/io/File;", "dumpFileName", "", "getDumpFileName$intellij_profiler_common", "()Ljava/lang/String;", "couldNotDownloadDumpFromTargetException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getCouldNotDownloadDumpFromTargetException", "()Ljava/lang/Exception;", "setCouldNotDownloadDumpFromTargetException", "(Ljava/lang/Exception;)V", "onTargetProcessTerminated", "", "prepareDumpBeforeReading", "readPreparedDumpAndReportStatistics", "Lcom/intellij/profiler/api/ProfilerState;", "dump", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readPreparedDump", "asProfilerState", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "writer", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "dispose", "intellij.profiler.common"})
public abstract class FileBasedProfilerProcess<TargetProcess extends ProfilerTargetProcess>
extends ProfilerProcessBase<TargetProcess> {
    @NotNull
    private final SnapshotFile snapshotFile;
    @Nullable
    private Exception couldNotDownloadDumpFromTargetException;

    public FileBasedProfilerProcess(@NotNull Project project, @NotNull TargetProcess targetProcess, @NotNull SnapshotFile snapshotFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetProcess, (String)"targetProcess");
        Intrinsics.checkNotNullParameter((Object)snapshotFile, (String)"snapshotFile");
        super(project, targetProcess);
        this.snapshotFile = snapshotFile;
    }

    public FileBasedProfilerProcess(@NotNull Project project, @NotNull TargetProcess targetProcess, @NotNull File dumpFileWhenTargetProcessFinished) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(targetProcess, (String)"targetProcess");
        Intrinsics.checkNotNullParameter((Object)dumpFileWhenTargetProcessFinished, (String)"dumpFileWhenTargetProcessFinished");
        this(project, targetProcess, new SnapshotFile(dumpFileWhenTargetProcessFinished, false));
    }

    @NotNull
    public final File getDumpFileWhenTargetProcessFinished() {
        return this.snapshotFile.getDumpFile();
    }

    @NotNull
    public final String getDumpFileName$intellij_profiler_common() {
        String string = this.getDumpFileWhenTargetProcessFinished().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Nullable
    protected final Exception getCouldNotDownloadDumpFromTargetException() {
        return this.couldNotDownloadDumpFromTargetException;
    }

    protected final void setCouldNotDownloadDumpFromTargetException(@Nullable Exception exception) {
        this.couldNotDownloadDumpFromTargetException = exception;
    }

    @Override
    protected void onTargetProcessTerminated() {
        if (this.getState() != Attached.INSTANCE) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> FileBasedProfilerProcess.onTargetProcessTerminated$lambda$2(this));
    }

    protected void prepareDumpBeforeReading() {
    }

    @NotNull
    protected final ProfilerState readPreparedDumpAndReportStatistics(@NotNull File dump, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        long startTime = System.currentTimeMillis();
        ProfilerState result2 = this.readPreparedDump(dump, indicator);
        long readTime = System.currentTimeMillis() - startTime;
        if (result2 instanceof DataReady) {
            ProfilerUsageTriggerCollector.logSnapshotGenerated(this.getProject(), dump.length(), readTime, this.getProfilerConfiguration().getConfigurationTypeId());
            if (((DataReady)result2).getWriter() == null) {
                ProfileHistoryConfiguration.register$default(ProfileHistoryConfiguration.Companion.getInstance(this.getProject()), this.getDumpFileWhenTargetProcessFinished(), null, 2, null);
            }
        }
        return result2;
    }

    @NotNull
    protected abstract ProfilerState readPreparedDump(@NotNull File var1, @NotNull ProgressIndicator var2) throws ProcessCanceledException;

    @NotNull
    protected final ProfilerState asProfilerState(@NotNull ProfilerDumpFileParsingResult $this$asProfilerState, @Nullable ProfilerDumpWriter writer) {
        ProfilerState profilerState;
        Intrinsics.checkNotNullParameter((Object)$this$asProfilerState, (String)"<this>");
        ProfilerDumpFileParsingResult profilerDumpFileParsingResult = $this$asProfilerState;
        if (profilerDumpFileParsingResult instanceof Success) {
            profilerState = new DataReady(((Success)$this$asProfilerState).getData(), writer);
        } else if (profilerDumpFileParsingResult instanceof Failure) {
            profilerState = new ProfilerError(((Failure)$this$asProfilerState).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return profilerState;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.snapshotFile.getTemp()) {
            this.snapshotFile.getDumpFile().delete();
        }
    }

    private static final Unit onTargetProcessTerminated$lambda$2$lambda$1(FileBasedProfilerProcess this$0, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.changeStateAndNotifyAsync(this$0.readPreparedDumpAndReportStatistics(this$0.getDumpFileWhenTargetProcessFinished(), it));
        return Unit.INSTANCE;
    }

    private static final void onTargetProcessTerminated$lambda$2(FileBasedProfilerProcess this$0) {
        if (this$0.getState() != Attached.INSTANCE) {
            return;
        }
        this$0.prepareDumpBeforeReading();
        Exception exception = this$0.couldNotDownloadDumpFromTargetException;
        if (exception != null) {
            Exception e = exception;
            boolean bl = false;
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            this$0.changeStateAndNotifyAsync(new ProfilerError(string));
            return;
        }
        this$0.changeStateAndNotifyAsync(ReadingData.INSTANCE);
        this$0.runUnderDumpReadIndicator((Function1<ProgressIndicator, Unit>)((Function1)arg_0 -> FileBasedProfilerProcess.onTargetProcessTerminated$lambda$2$lambda$1(this$0, arg_0)));
    }
}

