/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.profiler.AbstractProfilerToolWindowPanel;
import com.intellij.profiler.PerformanceHintsManager;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpDescriptor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/ProfilerDumpPanel;", "Lcom/intellij/profiler/AbstractProfilerToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "dump", "Lcom/intellij/profiler/api/ProfilerData;", "tabName", "", "helpId", "dumpDescriptor", "Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "fileName", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/api/ProfilerData;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/profiler/api/ProfilerDumpDescriptor;Ljava/lang/String;)V", "getTabName", "()Ljava/lang/String;", "getFileName$intellij_profiler_common", "topLevelComponent", "Ljavax/swing/JComponent;", "getTopLevelComponent", "()Ljavax/swing/JComponent;", "topLevelComponent$delegate", "Lkotlin/Lazy;", "content", "Lcom/intellij/ui/content/Content;", "Lorg/jetbrains/annotations/NotNull;", "getContent", "()Lcom/intellij/ui/content/Content;", "time", "", "getTime", "()J", "fileExtension", "getFileExtension", "getSnapshotFile", "Ljava/io/File;", "dispose", "", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nProfilerDumpPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerDumpPanel.kt\ncom/intellij/profiler/ProfilerDumpPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class ProfilerDumpPanel
extends AbstractProfilerToolWindowPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final String tabName;
    @Nullable
    private final ProfilerDumpDescriptor dumpDescriptor;
    @Nullable
    private final String fileName;
    @NotNull
    private final Lazy topLevelComponent$delegate;
    @NotNull
    private final Content content;
    private final long time;

    /*
     * WARNING - void declaration
     */
    public ProfilerDumpPanel(@NotNull Project project, @NotNull ProfilerData dump, @NlsContexts.TabTitle @NotNull String tabName, @Nullable String helpId, @Nullable ProfilerDumpDescriptor dumpDescriptor, @Nullable String fileName) {
        long l;
        void $this$content_u24lambda_u241;
        Content content;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        this.project = project;
        this.tabName = tabName;
        this.dumpDescriptor = dumpDescriptor;
        this.fileName = fileName;
        this.topLevelComponent$delegate = LazyKt.lazy(() -> ProfilerDumpPanel.topLevelComponent_delegate$lambda$0(dump, this));
        Content content2 = content = ContentFactory.getInstance().createContent((JComponent)((Object)this), this.getTabName(), true);
        ProfilerDumpPanel profilerDumpPanel = this;
        boolean bl = false;
        $this$content_u24lambda_u241.setCloseable(true);
        $this$content_u24lambda_u241.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        $this$content_u24lambda_u241.setIcon(AllIcons.Actions.MenuOpen);
        Content content3 = content;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"apply(...)");
        profilerDumpPanel.content = content3;
        ProfilerDumpPanel profilerDumpPanel2 = this;
        Object object = this.dumpDescriptor;
        if (object != null && (object = ((ProfilerDumpDescriptor)object).getFile()) != null && (object = ((File)object).toPath()) != null) {
            void it;
            Object object2 = object;
            profilerDumpPanel = profilerDumpPanel2;
            boolean bl2 = false;
            BasicFileAttributes attrs = Files.readAttributes((Path)it, BasicFileAttributes.class, new LinkOption[0]);
            long l2 = attrs.lastModifiedTime().toMillis();
            profilerDumpPanel2 = profilerDumpPanel;
            l = l2;
        } else {
            l = -1L;
        }
        profilerDumpPanel2.time = l;
        String string = helpId;
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            this.getContent().setHelpId(it);
        }
        this.setContent(this.getTopLevelComponent());
        ProfilerDumpDescriptor profilerDumpDescriptor = this.dumpDescriptor;
        if (profilerDumpDescriptor != null) {
            profilerDumpDescriptor.markOpened();
        }
        PerformanceHintsManager.Companion.getInstance(this.project).onProfilerDumpOpen(dump, (Object)this);
    }

    public /* synthetic */ ProfilerDumpPanel(Project project, ProfilerData profilerData, String string, String string2, ProfilerDumpDescriptor profilerDumpDescriptor, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            profilerDumpDescriptor = null;
        }
        this(project, profilerData, string, string2, profilerDumpDescriptor, string3);
    }

    @Override
    @NotNull
    public String getTabName() {
        return this.tabName;
    }

    @Nullable
    public final String getFileName$intellij_profiler_common() {
        return this.fileName;
    }

    @NotNull
    public final JComponent getTopLevelComponent() {
        Lazy lazy = this.topLevelComponent$delegate;
        return (JComponent)lazy.getValue();
    }

    @Override
    @NotNull
    public Content getContent() {
        return this.content;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Nullable
    public final String getFileExtension() {
        String string;
        String string2 = this.fileName;
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            string = FileUtilRt.getExtension((String)p0);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public File getSnapshotFile() {
        Object object = this.dumpDescriptor;
        if (object == null || (object = ((ProfilerDumpDescriptor)object).getFile()) == null) {
            String string = this.fileName;
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                object = new File(p0);
            } else {
                object = null;
            }
        }
        return object;
    }

    @Override
    public void dispose() {
        super.dispose();
        ProfilerDumpDescriptor profilerDumpDescriptor = this.dumpDescriptor;
        if (profilerDumpDescriptor != null) {
            profilerDumpDescriptor.release();
        }
        PerformanceHintsManager.Companion.getInstance(this.project).onProfilerDumpClosed((Object)this);
    }

    private static final JComponent topLevelComponent_delegate$lambda$0(ProfilerData $dump, ProfilerDumpPanel this$0) {
        return $dump.createTopLevelComponent(this$0.project, this$0);
    }
}

