/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.ui.Messages;
import com.intellij.python.remoteInterpreter.PyCreateRemoteInterpreterDialog;
import com.intellij.python.remoteInterpreter.PyEditRemoteInterpreterDialog;
import com.intellij.python.remoteInterpreter.PyRemoteSdkEditor;
import com.intellij.python.remoteInterpreter.console.PyRemoteConsoleProcessHandler;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.CredentialsTypeUtil;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.python.console.PyConsoleProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteFilesChooser;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PythonSdkType;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyRemoteInterpreterManagerImpl
extends PythonRemoteInterpreterManager {
    public PyRemoteInterpreterManagerImpl() {
        CredentialsType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<CredentialsType<?>>(){

            public void extensionAdded(@NotNull CredentialsType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                CredentialsManager.recogniseCredentialType(this.getStream(), extension);
            }

            public void extensionRemoved(@NotNull CredentialsType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                CredentialsManager.forgetCredentialType(this.getStream(), extension);
            }

            private Stream<SdkAdditionalData> getStream() {
                return Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).map(sdk -> sdk.getSdkType() instanceof PythonSdkType ? sdk.getSdkAdditionalData() : null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteInterpreterManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    @NotNull
    public SdkAdditionalData loadRemoteSdkData(@NotNull Sdk sdk, @Nullable Element additional) {
        if (sdk == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = PyRemoteSdkAdditionalData.loadRemote((Sdk)sdk, (Element)additional);
        if (pyRemoteSdkAdditionalData == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        return pyRemoteSdkAdditionalData;
    }

    @ApiStatus.Obsolete
    @NotNull
    public PyConsoleProcessHandler createConsoleProcessHandler(@NotNull Process process, @NotNull PythonConsoleView view, @NotNull PydevConsoleCommunication consoleCommunication, @NotNull String commandLine, @NotNull Charset charset, @Nullable PyRemotePathMapper pathMapper, @NotNull PyRemoteSocketToLocalHostProvider remoteSocketProvider) {
        if (process == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        if (view == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        if (consoleCommunication == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        if (commandLine == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
        }
        if (charset == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
        }
        if (remoteSocketProvider == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        return new PyRemoteConsoleProcessHandler(process, view, consoleCommunication, commandLine, charset, pathMapper, remoteSocketProvider);
    }

    public boolean editSdk(@NotNull Project project, @NotNull SdkModificator sdkModificator, @NotNull Collection<Sdk> existingSdks) {
        if (project == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
        }
        if (sdkModificator == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        if (existingSdks == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        SdkAdditionalData sdkAdditionalData = sdkModificator.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PyRemoteSdkAdditionalData) {
            Sdk newSdk;
            PyRemoteSdkAdditionalData newData;
            PyRemoteSdkAdditionalData data = (PyRemoteSdkAdditionalData)sdkAdditionalData;
            CredentialsType credentialsType = data.connectionCredentials().getRemoteConnectionType();
            if (!CredentialsTypeUtil.isCredentialsTypeSupportedForLanguage((CredentialsType)credentialsType, PyCredentialsContribution.class)) {
                Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"remote.interpreter.cannot.load.interpreter.message", (Object[])new Object[]{credentialsType.getName()}), (String)ExecutionBundle.message((String)"remote.interpreter.cannot.load.interpreter.title", (Object[])new Object[0]));
                return false;
            }
            PyEditRemoteInterpreterDialog dialog = PyRemoteSdkEditor.Companion.sdkEditor(data, project, existingSdks);
            if (dialog == null) {
                dialog = new PyCreateRemoteInterpreterDialog(project, existingSdks);
            }
            dialog.setEditing(data);
            dialog.setSdkName(sdkModificator.getName());
            if (!(!dialog.showAndGet() || (newData = (PyRemoteSdkAdditionalData)(newSdk = dialog.getSdk()).getSdkAdditionalData()) == null || newData.equals(data) && newSdk.getName().equals(sdkModificator.getName()))) {
                newData.copyTo(data);
                sdkModificator.setName(newSdk.getName());
                sdkModificator.setHomePath(newSdk.getHomePath());
                return true;
            }
        } else {
            throw new IllegalStateException("Not implemented yet");
        }
        return false;
    }

    public void runVagrant(@NotNull String vagrantFolder, @Nullable String machineName) throws ExecutionException {
        VagrantSupport vs;
        if (vagrantFolder == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        if ((vs = VagrantSupport.getInstance()) == null) {
            throw new IllegalStateException("Vagrant Support unavailable");
        }
        vs.runVagrant(vagrantFolder, machineName);
    }

    public String @NotNull [] chooseRemoteFiles(@NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, boolean foldersOnly) throws ExecutionException, InterruptedException {
        PyRemoteFilesChooser chooser;
        if (project == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
        }
        if (data == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        if (data instanceof PyRemoteSdkAdditionalData && (chooser = PyRemoteSdkEditor.Companion.filesChooser((PyRemoteSdkAdditionalData)data)) != null) {
            String[] stringArray = chooser.chooseRemoteFiles(project, data, foldersOnly);
            if (stringArray == null) {
                PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            PyRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/PyRemoteInterpreterManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleCommunication";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSocketProvider";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteInterpreterManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemoteSdkData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseRemoteFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadRemoteSdkData";
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "editSdk";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runVagrant";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "chooseRemoteFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 14, 15 -> new IllegalStateException(string);
        };
    }
}

