/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterInlayProgressStatusManager;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.execution.ExecutionEvent;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.editor.Editor;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookCellInlayManagerJupyterCellExecutionListener;", "Lcom/intellij/jupyter/core/jupyter/actions/CellExecutionListener;", "manager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "jupyterInlayProgressStatusManager", "Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterInlayProgressStatusManager;", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterInlayProgressStatusManager;)V", "executionSubmitted", "", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "executionStarted", "startTime", "Ljava/time/ZonedDateTime;", "executionStopped", "jupyterStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "endTime", "executionStatusReset", "getCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cellNumber", "", "intellij.jupyter.core"})
final class NotebookCellInlayManagerJupyterCellExecutionListener
implements CellExecutionListener {
    @NotNull
    private final NotebookCellInlayManager manager;
    @NotNull
    private final JupyterInlayProgressStatusManager jupyterInlayProgressStatusManager;

    public NotebookCellInlayManagerJupyterCellExecutionListener(@NotNull NotebookCellInlayManager manager, @NotNull JupyterInlayProgressStatusManager jupyterInlayProgressStatusManager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)jupyterInlayProgressStatusManager, (String)"jupyterInlayProgressStatusManager");
        this.manager = manager;
        this.jupyterInlayProgressStatusManager = jupyterInlayProgressStatusManager;
    }

    @Override
    public void executionSubmitted(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.manager.getCell(cellPointer).onExecutionEvent((ExecutionEvent)new ExecutionEvent.ExecutionSubmitted(this.jupyterInlayProgressStatusManager.getProgressStatus(cellPointer)));
    }

    @Override
    public void executionStarted(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook, @NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        this.manager.getCell(cellPointer).onExecutionEvent((ExecutionEvent)new ExecutionEvent.ExecutionStarted(this.jupyterInlayProgressStatusManager.getProgressStatus(cellPointer), startTime));
    }

    @Override
    public void executionStopped(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook, @NotNull JupyterExecutionStatus jupyterStatus, @NotNull ZonedDateTime endTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        EditorCell editorCell = this.manager.getCell(cellPointer);
        ProgressStatus progressStatus = this.jupyterInlayProgressStatusManager.getProgressStatus(cellPointer);
        Editor editor = (Editor)this.manager.getEditor();
        NotebookCellLines.Interval interval = cellPointer.get();
        Intrinsics.checkNotNull((Object)interval);
        JupyterCell jupyterCell = this.getCell(editor, interval.getOrdinal());
        editorCell.onExecutionEvent((ExecutionEvent)new ExecutionEvent.ExecutionStopped(progressStatus, endTime, jupyterCell != null ? jupyterCell.getExecutionCount() : null));
    }

    @Override
    public void executionStatusReset(@NotNull NotebookIntervalPointer cellPointer, @NotNull BackedNotebookVirtualFile notebook) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        this.manager.getCell(cellPointer).onExecutionEvent((ExecutionEvent)new ExecutionEvent.ExecutionReset(this.jupyterInlayProgressStatusManager.getProgressStatus(cellPointer)));
    }

    private final JupyterCell getCell(Editor editor, int cellNumber) {
        Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        return object != null && (object = object.getNotebook()) != null ? object.getCellOrNull(cellNumber) : null;
    }
}

