/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.markdown;

import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdaterKt;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.markdown.MarkdownEditorCell;
import com.intellij.jupyter.core.editor.markdown.NotebookStructureElement;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterRunner;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/editor/markdown/RunMarkdownSectionEditorAction;", "Lcom/intellij/notebooks/ui/editor/actions/JupyterEditorAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getEditorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "getMarkdownIntervalIfAny", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nRunMarkdownSectionEditorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunMarkdownSectionEditorAction.kt\ncom/intellij/jupyter/core/editor/markdown/RunMarkdownSectionEditorAction\n+ 2 EditorCell.kt\ncom/intellij/notebooks/visualization/ui/EditorCell\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n139#2:75\n1557#3:76\n1628#3,3:77\n1#4:80\n*S KotlinDebug\n*F\n+ 1 RunMarkdownSectionEditorAction.kt\ncom/intellij/jupyter/core/editor/markdown/RunMarkdownSectionEditorAction\n*L\n41#1:75\n51#1:76\n51#1:77,3\n*E\n"})
public final class RunMarkdownSectionEditorAction
extends DumbAwareAction
implements JupyterEditorAction {
    @NotNull
    private final JupyterActonUpdater actionUpdater = JupyterActonUpdaterKt.getJupyterActionUpdater().derive((Function1<? super JupyterActonUpdater.Builder, Unit>)((Function1)arg_0 -> RunMarkdownSectionEditorAction.actionUpdater$lambda$2(this, arg_0)));

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$mapTo$iv$iv;
        Object object;
        BackedNotebookVirtualFile virtualFile2;
        NotebookIntervalPointerFactory ptrFactory;
        Editor editor;
        Project project;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.actionUpdater.isEnabled(this, e)) {
                    return;
                }
                Project project2 = e.getProject();
                if (project2 == null) {
                    return;
                }
                project = project2;
                Editor editor2 = JupyterAnActionEventExtensionsKt.getEditor(e);
                if (editor2 == null) {
                    return;
                }
                editor = editor2;
                ptrFactory = NotebookIntervalPointerFactory.Companion.get(editor);
                VirtualFile virtualFile3 = editor.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
                BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile3);
                if (backedNotebookVirtualFile == null) {
                    return;
                }
                virtualFile2 = backedNotebookVirtualFile;
                object = this.getEditorCell(e);
                if (object == null) break block11;
                EditorCell this_$iv = object;
                boolean $i$f$getExtension = false;
                object = (MarkdownEditorCell)this_$iv.getExtension(Reflection.getOrCreateKotlinClass(MarkdownEditorCell.class));
                if (object != null && (object = ((MarkdownEditorCell)object).getSection()) != null) break block12;
            }
            return;
        }
        Object section = object;
        EditorCell editorCell = ((NotebookStructureElement.NotebookSection)section).getFirst();
        if (editorCell == null || (editorCell = editorCell.getInterval()) == null) {
            return;
        }
        int firstOrdinal = editorCell.getOrdinal();
        EditorCell editorCell2 = ((NotebookStructureElement.NotebookSection)section).getLast();
        if (editorCell2 == null || (editorCell2 = editorCell2.getInterval()) == null) {
            return;
        }
        int lastOrdinal = editorCell2.getOrdinal();
        List intervals = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(firstOrdinal, lastOrdinal))), arg_0 -> RunMarkdownSectionEditorAction.actionPerformed$lambda$3(editor, arg_0)));
        if (intervals.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = intervals;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ptrFactory.create((NotebookCellLines.Interval)it));
        }
        List intervalPointers = (List)destination$iv$iv;
        JupyterRunner.runCells$default(JupyterRunner.INSTANCE, project, intervalPointers, editor, virtualFile2, null, null, 48, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JupyterActonUpdater.update$default(this.actionUpdater, this, e, null, 4, null);
    }

    private final EditorCell getEditorCell(AnActionEvent e) {
        NotebookCellLines.Interval interval = this.getMarkdownIntervalIfAny(e);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval markdownInterval = interval;
        Editor editor = JupyterAnActionEventExtensionsKt.getEditor(e);
        if (editor == null) {
            return null;
        }
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get(editor);
        if (notebookCellInlayManager == null) {
            return null;
        }
        NotebookCellInlayManager manager = notebookCellInlayManager;
        return manager.getCell(markdownInterval);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final NotebookCellLines.Interval getMarkdownIntervalIfAny(AnActionEvent e) {
        NotebookCellLines.Interval interval;
        NotebookCellLines.Interval interval2;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval3 = JupyterDataContextExtensionsKt.getSelectedIntervals(dataContext);
        if (interval3 == null) return null;
        NotebookCellLines.Interval it = interval2 = interval3;
        boolean bl = false;
        if (((Collection)it).size() != 1) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        NotebookCellLines.Interval interval4 = interval2;
        NotebookCellLines.Interval interval5 = interval4;
        if (interval5 == null) return null;
        interval2 = (NotebookCellLines.Interval)CollectionsKt.firstOrNull(interval5);
        if (interval2 == null) return null;
        NotebookCellLines.Interval it2 = interval = interval2;
        boolean bl3 = false;
        if (it2.getType() != NotebookCellLines.CellType.MARKDOWN) return null;
        boolean bl4 = true;
        if (!bl4) return null;
        NotebookCellLines.Interval interval6 = interval;
        return interval6;
    }

    private static final boolean actionUpdater$lambda$2$lambda$0(RunMarkdownSectionEditorAction this$0, JupyterEditorAction action, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EditorCell cell = this$0.getEditorCell(event);
        EditorCell editorCell = cell;
        return (editorCell != null && (editorCell = editorCell.getGutterAction()) != null ? (AnAction)editorCell.get() : null) != null;
    }

    private static final Unit actionUpdater$lambda$2$lambda$1(JupyterEditorAction action, AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setText(JupyterBundle.message("action.RunMarkdownSectionEditorAction.text", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit actionUpdater$lambda$2(RunMarkdownSectionEditorAction this$0, JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)(arg_0, arg_1) -> RunMarkdownSectionEditorAction.actionUpdater$lambda$2$lambda$0(this$0, arg_0, arg_1)));
        $this$derive.addVisualCustomizer((Function2<? super JupyterEditorAction, ? super AnActionEvent, Unit>)((Function2)RunMarkdownSectionEditorAction::actionUpdater$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    private static final NotebookCellLines.Interval actionPerformed$lambda$3(Editor $editor, int it) {
        return NotebookVisualizationUiUtilKt.safeGetCellByOrdinal((Editor)$editor, (int)it);
    }
}

