/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.DataConverter;
import com.intellij.database.data.types.DbConversionGraph;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataTypeConversionUtil {
    @Nullable
    public static Function<Object, Object> getConverter(@NotNull ConversionGraph graph, @NotNull Dbms firstDbms, @NotNull Dbms secondDbms, @Nullable DasDataSource firstSystem, @Nullable DasDataSource secondSystem, @NotNull ColumnDescriptor firstDescriptor, @NotNull ColumnDescriptor secondDescriptor, @Nullable Object o) {
        Domain to;
        if (graph == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(0);
        }
        if (firstDbms == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(1);
        }
        if (secondDbms == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(2);
        }
        if (firstDescriptor == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(3);
        }
        if (secondDescriptor == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(4);
        }
        Domain firstDomain = BaseDomainRegistry.getDomain(firstDbms, DbImplUtilCore.getDatabaseVersion(firstSystem), firstDescriptor, true);
        Domain secondDomain = BaseDomainRegistry.getDomain(secondDbms, DbImplUtilCore.getDatabaseVersion(secondSystem), secondDescriptor, false);
        if (secondDomain == null && !DataTypeConversionUtil.isSameTypes(firstDbms, secondDbms, firstDescriptor, secondDescriptor)) {
            return null;
        }
        Domain from = (Domain)ObjectUtils.chooseNotNull((Object)firstDomain, (Object)Domain.EMPTY);
        Function converter = DbConversionGraph.getConverter(graph, o, from, to = (Domain)ObjectUtils.chooseNotNull((Object)secondDomain, (Object)Domain.EMPTY));
        return converter == null ? null : (secondDomain == null ? converter : (firstDomain == null || o != null && !firstDomain.getPoint().getObjectClass().isAssignableFrom(o.getClass()) ? DataConverter.ObjectToText.tweak(converter, (ColumnDescriptor)firstDescriptor) : converter));
    }

    private static boolean isSameTypes(@NotNull Dbms firstDbms, @NotNull Dbms secondDbms, @NotNull ColumnDescriptor first2, @NotNull ColumnDescriptor second) {
        if (firstDbms == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(5);
        }
        if (secondDbms == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(6);
        }
        if (first2 == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(7);
        }
        if (second == null) {
            DataTypeConversionUtil.$$$reportNull$$$0(8);
        }
        return DbImplUtilCore.getDatabaseDialect(firstDbms) == DbImplUtilCore.getDatabaseDialect(secondDbms) && StringUtil.equals((CharSequence)first2.getTypeName(), (CharSequence)second.getTypeName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstDbms";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondDbms";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/data/types/DataTypeConversionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getConverter";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isSameTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

