/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import java.util.Objects;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportIndicatorUpdater {
    private static final double UNSET = -1.0;
    protected final ProgressIndicator myIndicator;
    protected final ImportInfo myInfo;
    protected final DoubleAdder mySize;
    protected double myCurrentSize;
    protected long myLines;
    protected long myFailedLines;
    protected long myStartTime;
    protected long myInsertingTime;
    protected long myReadingTime;

    public ImportIndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder size, @NotNull ImportInfo info2) {
        if (indicator == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(0);
        }
        if (size == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(1);
        }
        if (info2 == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(2);
        }
        this.myIndicator = indicator;
        this.mySize = size;
        this.myInfo = info2;
    }

    public void start() {
        this.myIndicator.setFraction(0.0);
        this.myIndicator.setText(this.getIndicatorTitle());
        this.myStartTime = System.currentTimeMillis();
        this.myIndicator.setText(this.getIndicatorTitle());
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull BatchRecords records, long lines, long l) {
        void failedLines;
        if (records == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(3);
        }
        this.myIndicator.checkCanceled();
        double value = this.mySize.doubleValue();
        this.myCurrentSize += records.getBatchSize();
        this.myLines += lines;
        this.myFailedLines += failedLines;
        this.myIndicator.setText2(this.getStatistics());
        if (Double.compare(value, -1.0) == 0) {
            return;
        }
        this.myIndicator.setFraction(Math.min(this.myCurrentSize / value, 1.0));
    }

    @NlsContexts.ProgressText
    @NotNull
    private String getIndicatorTitle() {
        DbDataSource source = Objects.requireNonNull(this.myInfo.getContext().getDataSource());
        String string = DatabaseBundle.message("progress.text.importing.to", this.myInfo.getProducerName(), this.myInfo.getTableName(), source.getName());
        if (string == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private String getStatistics() {
        long timeSpent = (System.currentTimeMillis() - this.myStartTime) / 1000L;
        if (this.myLines == 0L || timeSpent == 0L) {
            return "";
        }
        String speed = this.calculateSpeed(timeSpent);
        String string = String.format("%s %s", this.myLines, ImportUtilCore.pluralizeRows(this.myLines)) + (speed == null ? "" : String.format(" (%s)", speed));
        if (string == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public abstract String calculateSpeed(long var1);

    public void spentInserting(long span) {
        this.myInsertingTime += span;
    }

    public void spentReading(long span) {
        this.myReadingTime += span;
    }

    public long getInsertingTime() {
        return this.myInsertingTime;
    }

    public long getReadingTime() {
        return this.myReadingTime;
    }

    public long getLines() {
        return this.myLines;
    }

    public long getFailedLines() {
        return this.myFailedLines;
    }

    public double size() {
        return this.mySize.doubleValue();
    }

    public double getCurrentSize() {
        return this.myCurrentSize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportIndicatorUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportIndicatorUpdater";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicatorTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

