/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSMethod;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import com.intellij.sql.dialects.mongo.js.psi.resolve.types.MongoJSType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MongoDialect
extends AbstractDatabaseDialect {
    public MongoDialect() {
        super(new TypeHelper(){

            @Override
            public String getTypeName(int code, int length, int precision, int scale) {
                return null;
            }
        });
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MONGO;
        if (dbms == null) {
            MongoDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "MongoDB";
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MongoDialect.$$$reportNull$$$0(1);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getDisplayName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema);
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return false;
    }

    @Override
    public boolean triggersIntrospection(@NotNull PsiElement element) {
        ResolveResult[] results2;
        boolean isDatabaseMember;
        PsiElement qualifier;
        if (element == null) {
            MongoDialect.$$$reportNull$$$0(2);
        }
        if (super.triggersIntrospection(element)) {
            return true;
        }
        MongoJSResolveHelper helper = MongoJSResolveHelper.Companion.getInstance(element);
        if (helper == null) {
            return false;
        }
        if (!helper.isCalleeReference(element)) {
            return false;
        }
        PsiReference reference = element.getReference();
        if (!(reference instanceof PsiPolyVariantReference)) {
            return false;
        }
        PsiElement psiElement = qualifier = reference instanceof PsiQualifiedReference ? ((PsiQualifiedReference)reference).getQualifier() : null;
        if (qualifier == null) {
            return false;
        }
        MongoJSType type = helper.getMongoType(qualifier);
        boolean isCollectionMember = type == MongoJSType.COLLECTION;
        boolean bl = isDatabaseMember = type == MongoJSType.DATABASE;
        if (!isCollectionMember && !isDatabaseMember) {
            return false;
        }
        for (ResolveResult result2 : results2 = ((PsiPolyVariantReference)reference).multiResolve(false)) {
            String name2;
            MongoJSSymbol symbol = helper.getSymbol(result2);
            String string = name2 = symbol != null ? symbol.getName() : "";
            if (isCollectionMember && symbol instanceof MongoJSMethod && (name2.startsWith("insert") || name2.equals("drop"))) {
                return true;
            }
            if (!isDatabaseMember || !(symbol instanceof MongoJSMethod) || !name2.startsWith("create") && !name2.equals("dropDatabase")) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        DasObject schema;
        if (builder == null) {
            MongoDialect.$$$reportNull$$$0(3);
        }
        if (identifier == null) {
            MongoDialect.$$$reportNull$$$0(4);
        }
        if (qualifier == null) {
            MongoDialect.$$$reportNull$$$0(5);
        }
        DdlBuilder ddlBuilder = (schema = DasUtil.getSchemaObject(qualifier)) == null ? builder : builder.qualifiedRef(object, identifier, schema, DasUtil.getName(schema), null, null, null, null);
        if (ddlBuilder == null) {
            MongoDialect.$$$reportNull$$$0(6);
        }
        return ddlBuilder;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) {
        if (connection2 == null) {
            MongoDialect.$$$reportNull$$$0(7);
        }
        RemoteConnection remoteConnection = connection2.getRemoteConnection();
        String schema = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)remoteConnection).getSchema());
        return schema == null ? null : SearchPath.of(ObjectPath.create(StringUtil.notNullize((String)schema), ObjectKind.SCHEMA));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mongo/MongoDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mongo/MongoDialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7 -> new IllegalArgumentException(string);
        };
    }
}

