/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.oracle.debugger.CodeFlowFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.ColumnFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.FragmentInfo;
import com.intellij.database.dialects.oracle.debugger.OraFragmentAnalyzerKt;
import com.intellij.database.dialects.oracle.debugger.ScalarExpressionFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.UnknownFragmentInfo;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u000e\u0010\u001d\u001a\u00020\u001e*\u0004\u0018\u00010\u0016H\u0002J\f\u0010\u001f\u001a\u00020\u001e*\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraFragmentAnalyzer;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/util/SearchPath;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "analyze", "Lcom/intellij/database/dialects/oracle/debugger/FragmentInfo;", "fragment", "", "tryExpression", "tryColumn", "tryCodeFlow", "parseFragment", "Lcom/intellij/psi/PsiElement;", "candidateTemplate", "offset", "", "parse", "Lcom/intellij/sql/psi/SqlFile;", "text", "syntaxCorrect", "", "hasErrors", "Companion", "intellij.database.dialects.oracle.ex"})
public final class OraFragmentAnalyzer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final LocalDataSource dataSource;
    @Nullable
    private final SearchPath searchPath;
    @Deprecated
    @NotNull
    public static final String expressionCandidateText = "begin ? := (  @  ); end;";
    @Deprecated
    @NotNull
    public static final String columnCandidateText = "select ( @ ) bulk collect into ? from dual";
    @Deprecated
    @NotNull
    public static final String codeFlowCandidateText = "begin\n@\nend;";
    private static final int expressionCandidateOffset = StringsKt.indexOf$default((CharSequence)"begin ? := (  @  ); end;", (char)'@', (int)0, (boolean)false, (int)6, null);
    private static final int columnCandidateOffset = StringsKt.indexOf$default((CharSequence)"select ( @ ) bulk collect into ? from dual", (char)'@', (int)0, (boolean)false, (int)6, null);
    private static final int codeFlowCandidateOffset = StringsKt.indexOf$default((CharSequence)"begin\n@\nend;", (char)'@', (int)0, (boolean)false, (int)6, null);
    @NotNull
    private static final Logger log;

    public OraFragmentAnalyzer(@NotNull Project project, @Nullable LocalDataSource dataSource, @Nullable SearchPath searchPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dataSource = dataSource;
        this.searchPath = searchPath;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final LocalDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public final FragmentInfo analyze(@NotNull String fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        FragmentInfo fragmentInfo = this.tryExpression(fragment);
        if (fragmentInfo == null && (fragmentInfo = this.tryColumn(fragment)) == null && (fragmentInfo = this.tryCodeFlow(fragment)) == null) {
            fragmentInfo = UnknownFragmentInfo.INSTANCE;
        }
        return fragmentInfo;
    }

    private final FragmentInfo tryExpression(String fragment) {
        PsiElement psiElement = this.parseFragment(fragment, expressionCandidateText, expressionCandidateOffset);
        if (psiElement == null) {
            return null;
        }
        PsiElement fragmentElement = psiElement;
        SqlExpression sqlExpression = fragmentElement instanceof SqlExpression ? (SqlExpression)fragmentElement : null;
        if (sqlExpression == null) {
            return null;
        }
        SqlExpression sqlExpression2 = sqlExpression;
        DasType dasType = sqlExpression2.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        return new ScalarExpressionFragmentInfo(dasType2);
    }

    private final FragmentInfo tryColumn(String fragment) {
        PsiElement fragmentElement = this.parseFragment(fragment, columnCandidateText, columnCandidateOffset);
        return fragmentElement instanceof SqlExpression && this.syntaxCorrect(fragmentElement) ? (FragmentInfo)new ColumnFragmentInfo(((SqlExpression)fragmentElement).getDasType()) : null;
    }

    private final FragmentInfo tryCodeFlow(String fragment) {
        String text2;
        SqlFile file;
        Object f = ((Object)StringsKt.trim((CharSequence)fragment)).toString();
        if (!StringsKt.endsWith$default((CharSequence)((CharSequence)f), (char)';', (boolean)false, (int)2, null)) {
            f = (String)f + ";";
        }
        return this.syntaxCorrect((PsiElement)(file = this.parse(text2 = OraFragmentAnalyzerKt.replace(codeFlowCandidateText, codeFlowCandidateOffset, codeFlowCandidateOffset + 1, (CharSequence)f)))) ? (FragmentInfo)new CodeFlowFragmentInfo() : null;
    }

    private final PsiElement parseFragment(String fragment, String candidateTemplate, int offset) {
        PsiElement p2;
        int offset2;
        String text2 = OraFragmentAnalyzerKt.replace(candidateTemplate, offset, offset + 1, fragment);
        SqlFile sqlFile = this.parse(text2);
        if (sqlFile == null) {
            return null;
        }
        SqlFile file = sqlFile;
        if (this.hasErrors((PsiElement)file)) {
            return null;
        }
        PsiElement psiElement = file.findElementAt(expressionCandidateOffset);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        while (element.getParent() != null && (offset2 = p2.getTextOffset()) == expressionCandidateOffset) {
            element = p2;
        }
        return this.syntaxCorrect(element) ? element : null;
    }

    private final SqlFile parse(String text2) {
        try {
            SqlFile sqlFile = SqlPsiElementFactory.createROFileFromText("EvaluatingFragment.sql", (CharSequence)text2, OraDialect.INSTANCE, this.project, null);
            Intrinsics.checkNotNullExpressionValue((Object)sqlFile, (String)"createROFileFromText(...)");
            SqlFile f = sqlFile;
            if (this.dataSource != null) {
                DbDataSource dbds = DbImplUtil.getDbDataSource(this.project, this.dataSource);
                f.putUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY, (Object)dbds);
                f.putUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY, (Object)this.searchPath);
            }
            return f;
        }
        catch (Exception e) {
            log.trace("Exception when attempted to parse the code fragment: \n----8<----\n" + text2 + "\n---->8----\nException " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return null;
        }
    }

    private final boolean syntaxCorrect(PsiElement $this$syntaxCorrect) {
        return $this$syntaxCorrect != null && !this.hasErrors($this$syntaxCorrect);
    }

    private final boolean hasErrors(PsiElement $this$hasErrors) {
        return PsiTreeUtil.hasErrorElements((PsiElement)$this$hasErrors);
    }

    static {
        Logger logger2 = Logger.getInstance(OraFragmentAnalyzer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraFragmentAnalyzer$Companion;", "", "<init>", "()V", "expressionCandidateText", "", "columnCandidateText", "codeFlowCandidateText", "expressionCandidateOffset", "", "columnCandidateOffset", "codeFlowCandidateOffset", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.dialects.oracle.ex"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

