/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.spark;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.hivebase.HiveDialectBase;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import org.jetbrains.annotations.NotNull;

public final class SparkDialect
extends HiveDialectBase {
    public SparkDialect() {
        super(new TypeHelper.HiveTypeHelper());
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SPARK;
        if (dbms == null) {
            SparkDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Apache Spark";
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            SparkDialect.$$$reportNull$$$0(1);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA && current.kind != ObjectKind.DATABASE) {
            return null;
        }
        NamingService namingService = this.getNamingService();
        String qualifier = current.parent != null && current.parent.kind == ObjectKind.DATABASE ? namingService.catToScript(current.parent.name, ObjectKind.DATABASE, this.getCodeStyle().getQuotesPriority()) : null;
        String schema = namingService.catToScript(current.name, current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", qualifier == null ? schema : qualifier + "." + schema);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/spark/SparkDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/spark/SparkDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

