/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001f\u0010!\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\"J\u001c\u0010#\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b$2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010%R!\u0010\u0018\u001a\u0015\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\u0019\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010 \u001a\u0015\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\u0019\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/database/schemaEditor/ui/AutoSelectListener;", "Ljava/awt/event/FocusListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/ui/EditorSettingsProvider;", "<init>", "()V", "focusGained", "", "e", "Ljava/awt/event/FocusEvent;", "focusLost", "mouseDragged", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mousePressed", "event", "mouseReleased", "selectAll", "c", "Ljavax/swing/JComponent;", "customizeSettings", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "install", "lostByActivation", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "setLostByActivation", "state", "isLostByActivation", "delayed", "setDelayedState", "(Ljavax/swing/JComponent;Ljava/lang/Boolean;)V", "getDelayedState", "Lorg/jetbrains/annotations/Nullable;", "(Ljavax/swing/JComponent;)Ljava/lang/Boolean;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbEditorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/AutoSelectListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1#2:347\n*E\n"})
public final class AutoSelectListener
implements FocusListener,
EditorMouseMotionListener,
EditorMouseListener,
EditorSettingsProvider {
    @NotNull
    public static final AutoSelectListener INSTANCE = new AutoSelectListener();
    @NotNull
    private static final Key<Boolean> lostByActivation;
    @NotNull
    private static final Key<Boolean> delayed;

    private AutoSelectListener() {
    }

    @Override
    public void focusGained(@NotNull FocusEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Component component = e.getComponent();
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        if (jComponent == null) {
            return;
        }
        JComponent c2 = jComponent;
        if (Intrinsics.areEqual((Object)this.getDelayedState(c2), (Object)true)) {
            this.setDelayedState(c2, false);
            return;
        }
        if (e.getCause() == FocusEvent.Cause.ACTIVATION && this.isLostByActivation(c2) || e.isTemporary()) {
            return;
        }
        this.selectAll(c2);
    }

    @Override
    public void focusLost(@NotNull FocusEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Component component = e.getComponent();
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        if (jComponent == null) {
            return;
        }
        JComponent c2 = jComponent;
        this.setLostByActivation(c2, e.getCause() == FocusEvent.Cause.ACTIVATION);
    }

    public void mouseDragged(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JComponent jComponent = e.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        this.setDelayedState(jComponent, null);
    }

    public void mousePressed(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JComponent jComponent = event.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent c2 = jComponent;
        if (!c2.isFocusOwner()) {
            this.setDelayedState(c2, true);
        }
    }

    public void mouseReleased(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JComponent jComponent = event.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent c2 = jComponent;
        if (Intrinsics.areEqual((Object)this.getDelayedState(c2), (Object)false)) {
            this.setDelayedState(c2, null);
            this.selectAll(c2);
            Project project = event.getEditor().getProject();
            if (project != null && Intrinsics.areEqual((Object)true, (Object)event.getEditor().getUserData(AutoPopupController.AUTO_POPUP_ON_FOCUS_GAINED))) {
                ApplicationManager.getApplication().invokeLater(() -> AutoSelectListener.mouseReleased$lambda$0(project, event));
                return;
            }
        }
    }

    private final void selectAll(JComponent c2) {
        if (!c2.isEnabled()) {
            return;
        }
        JComponent jComponent = c2;
        if (jComponent instanceof EditorComponentImpl) {
            ((EditorComponentImpl)c2).getEditor().getSelectionModel().setSelection(0, ((EditorComponentImpl)c2).getEditor().getDocument().getTextLength());
        } else if (jComponent instanceof JTextComponent) {
            ((JTextComponent)c2).selectAll();
        }
    }

    public void customizeSettings(@NotNull EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        editor2.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        editor2.addEditorMouseListener((EditorMouseListener)this);
    }

    public final void install(@NotNull JComponent c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        c2.addFocusListener(this);
        if (c2 instanceof EditorTextField) {
            ((EditorTextField)c2).addSettingsProvider((EditorSettingsProvider)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setLostByActivation(JComponent c2, boolean state) {
        void it;
        Boolean bl = state;
        boolean bl2 = bl;
        Key<Boolean> key2 = lostByActivation;
        JComponent jComponent = c2;
        boolean bl3 = false;
        void var8_8 = it;
        ClientProperty.put((JComponent)jComponent, key2, (Object)(var8_8 != false ? bl : null));
    }

    private final boolean isLostByActivation(JComponent c2) {
        return Intrinsics.areEqual((Object)ClientProperty.get((Component)c2, lostByActivation), (Object)true);
    }

    private final void setDelayedState(JComponent c2, Boolean state) {
        ClientProperty.put((JComponent)c2, delayed, (Object)state);
    }

    private final Boolean getDelayedState(JComponent c2) {
        return (Boolean)ClientProperty.get((Component)c2, delayed);
    }

    private static final void mouseReleased$lambda$0(Project $project, EditorMouseEvent $event) {
        AutoPopupController.getInstance((Project)$project).scheduleAutoPopup($event.getEditor());
    }

    static {
        Key key2 = Key.create((String)"AUTO_SELECT_FOCUS_LOST_BY_ACTIVATION");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        lostByActivation = key2;
        Key key3 = Key.create((String)"AUTO_SELECT_DELAYED");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        delayed = key3;
    }
}

