/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPathNamespace;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0012\u0010\u0017\u001a\u00020\u0010*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0010*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u001b"}, d2={"parentOfKind", "Lcom/intellij/database/util/ObjectPath;", "kinds", "", "Lcom/intellij/database/model/ObjectKind;", "thisOrParentOfKind", "namespace", "Lcom/intellij/database/util/ObjectPathNamespace;", "getNamespace", "(Lcom/intellij/database/util/ObjectPath;)Lcom/intellij/database/util/ObjectPathNamespace;", "objectPathNamespaceKinds", "kotlin.jvm.PlatformType", "database", "getDatabase", "(Lcom/intellij/database/util/ObjectPath;)Lcom/intellij/database/util/ObjectPath;", "databaseName", "", "getDatabaseName", "(Lcom/intellij/database/util/ObjectPath;)Ljava/lang/String;", "schema", "getSchema", "schemaName", "getSchemaName", "toCatalogName", "Lcom/intellij/database/util/ObjectNamePart;", "casing", "Lcom/intellij/database/util/Casing;", "intellij.database"})
@JvmName(name="ObjectPathFun")
public final class ObjectPathFun {
    @NotNull
    private static final Set<ObjectKind> objectPathNamespaceKinds;

    @Nullable
    public static final ObjectPath parentOfKind(@NotNull ObjectPath $this$parentOfKind, @NotNull Set<? extends ObjectKind> kinds) {
        Intrinsics.checkNotNullParameter((Object)$this$parentOfKind, (String)"<this>");
        Intrinsics.checkNotNullParameter(kinds, (String)"kinds");
        ObjectPath p2 = $this$parentOfKind.parent;
        while (p2 != null) {
            if (kinds.contains(p2.kind)) {
                return p2;
            }
            p2 = p2.parent;
        }
        return null;
    }

    @Nullable
    public static final ObjectPath thisOrParentOfKind(@NotNull ObjectPath $this$thisOrParentOfKind, @NotNull Set<? extends ObjectKind> kinds) {
        Intrinsics.checkNotNullParameter((Object)$this$thisOrParentOfKind, (String)"<this>");
        Intrinsics.checkNotNullParameter(kinds, (String)"kinds");
        return kinds.contains($this$thisOrParentOfKind.kind) ? $this$thisOrParentOfKind : ObjectPathFun.parentOfKind($this$thisOrParentOfKind, kinds);
    }

    @NotNull
    public static final ObjectPathNamespace getNamespace(@NotNull ObjectPath $this$namespace) {
        ObjectPathNamespace objectPathNamespace;
        Intrinsics.checkNotNullParameter((Object)$this$namespace, (String)"<this>");
        ObjectKind objectKind = $this$namespace.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCHEMA)) {
            objectPathNamespace = new ObjectPathNamespace.InSchema($this$namespace);
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE)) {
            objectPathNamespace = new ObjectPathNamespace.InDatabase($this$namespace);
        } else {
            ObjectKind objectKind2;
            ObjectPath p2;
            ObjectPath objectPath = p2 = ObjectPathFun.parentOfKind($this$namespace, objectPathNamespaceKinds);
            ObjectKind objectKind3 = objectKind2 = objectPath != null ? objectPath.kind : null;
            if (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SCHEMA)) {
                ObjectPath objectPath2 = p2;
                Intrinsics.checkNotNull((Object)objectPath2);
                objectPathNamespace = new ObjectPathNamespace.InSchema(objectPath2);
            } else if (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.DATABASE)) {
                ObjectPath objectPath3 = p2;
                Intrinsics.checkNotNull((Object)objectPath3);
                objectPathNamespace = new ObjectPathNamespace.InDatabase(objectPath3);
            } else {
                objectPathNamespace = ObjectPathNamespace.InServer.INSTANCE;
            }
        }
        return objectPathNamespace;
    }

    @Nullable
    public static final ObjectPath getDatabase(@NotNull ObjectPath $this$database) {
        Intrinsics.checkNotNullParameter((Object)$this$database, (String)"<this>");
        return $this$database.findParent(ObjectKind.DATABASE, false);
    }

    @Nullable
    public static final String getDatabaseName(@NotNull ObjectPath $this$databaseName) {
        Intrinsics.checkNotNullParameter((Object)$this$databaseName, (String)"<this>");
        ObjectPath objectPath = ObjectPathFun.getDatabase($this$databaseName);
        return objectPath != null ? objectPath.name : null;
    }

    @Nullable
    public static final ObjectPath getSchema(@NotNull ObjectPath $this$schema) {
        Intrinsics.checkNotNullParameter((Object)$this$schema, (String)"<this>");
        return $this$schema.findParent(ObjectKind.SCHEMA, false);
    }

    @Nullable
    public static final String getSchemaName(@NotNull ObjectPath $this$schemaName) {
        Intrinsics.checkNotNullParameter((Object)$this$schemaName, (String)"<this>");
        ObjectPath objectPath = ObjectPathFun.getSchema($this$schemaName);
        return objectPath != null ? objectPath.name : null;
    }

    @NotNull
    public static final String toCatalogName(@NotNull ObjectNamePart $this$toCatalogName, @NotNull Casing casing) {
        Intrinsics.checkNotNullParameter((Object)$this$toCatalogName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)casing, (String)"casing");
        Case case_ = $this$toCatalogName.isQuoted() ? casing.quoted : casing.plain;
        String string = case_.apply($this$toCatalogName.name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apply(...)");
        return string;
    }

    static {
        Object[] objectArray = new ObjectKind[]{ObjectKind.ROOT, ObjectKind.DATABASE, ObjectKind.SCHEMA};
        objectPathNamespaceKinds = SetsKt.setOf((Object[])objectArray);
    }
}

