/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.lang.PerFileMappingsEx;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlResolveEditor;
import com.intellij.sql.dialects.SqlResolveMappings;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.PerFileConfigurableBase;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlResolveConfigurable
extends PerFileConfigurableBase<TreePattern> {
    private final PerFileConfigurableBase.Mapping<TreePattern> myProjectMapping;

    private SqlResolveConfigurable(@NotNull Project project) {
        if (project == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(0);
        }
        super(project, (PerFileMappingsEx)SqlResolveMappings.getInstance(project));
        this.myProjectMapping = new PerFileConfigurableBase.Mapping(DatabaseBundle.message("project.mapping", new Object[0]), () -> (TreePattern)SqlResolveMappings.getInstance(this.myProject).getConfiguredMapping(null), o -> SqlResolveMappings.getInstance(this.myProject).setMapping(null, o));
    }

    protected boolean isProjectMapping(PerFileConfigurableBase.Mapping<TreePattern> prop) {
        return prop == this.myProjectMapping || super.isProjectMapping(prop);
    }

    @Nullable
    protected <S> Object getParameter(@NotNull Key<S> key2) {
        if (key2 == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(1);
        }
        if (key2 == DESCRIPTION) {
            return SqlBundle.message((String)"dialog.sql.resolve.caption", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()});
        }
        if (key2 == MAPPING_TITLE) {
            return SqlBundle.message((String)"dialog.sql.resolve.value.title", (Object[])new Object[0]);
        }
        if (key2 == OVERRIDE_QUESTION) {
            return SqlBundle.message((String)"dialog.sql.resolve.override.question", (Object[])new Object[0]);
        }
        if (key2 == OVERRIDE_TITLE) {
            return SqlBundle.message((String)"dialog.sql.resolve.override.title", (Object[])new Object[0]);
        }
        if (key2 == ADD_PROJECT_MAPPING) {
            return false;
        }
        return null;
    }

    protected void renderDefaultValue(@Nullable Object target2, @NotNull ColoredTextContainer renderer2) {
        TreePattern t;
        if (renderer2 == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(2);
        }
        if ((t = (TreePattern)this.getNewMapping((VirtualFile)target2)) == null) {
            return;
        }
        this.renderValue(t, renderer2, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, 120);
    }

    @NotNull
    private TreePattern getDefaultMapping(@Nullable Object target2) {
        VirtualFile file = (VirtualFile)ObjectUtils.tryCast((Object)target2, VirtualFile.class);
        TreePattern treePattern = (TreePattern)ObjectUtils.chooseNotNull((Object)((TreePattern)this.getNewMapping(file)), (Object)SqlResolveMappings.ALL_DATA_SOURCES);
        if (treePattern == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(3);
        }
        return treePattern;
    }

    @Nullable
    protected String getNullValueText(@Nullable Object target2) {
        if (target2 == null) {
            return DatabaseBundle.message("SqlResolveConfigurable.label.default", new Object[0]);
        }
        return super.getNullValueText(target2);
    }

    @NotNull
    protected Collection<TreePattern> getValueVariants(@Nullable Object target2) {
        List<TreePattern> list = Collections.singletonList((TreePattern)this.myMappings.getMapping(null));
        if (list == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void renderValue(@Nullable Object target2, @NotNull TreePattern pattern, @NotNull ColoredTextContainer renderer2) {
        if (pattern == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(5);
        }
        if (renderer2 == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(6);
        }
        this.renderValue(pattern, renderer2, null, 120);
    }

    private void renderValue(@NotNull TreePattern pattern, @NotNull ColoredTextContainer renderer2, @Nullable SimpleTextAttributes forcedAttrs, int maxChars) {
        if (pattern == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(7);
        }
        if (renderer2 == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(8);
        }
        boolean[] first2 = new boolean[]{true};
        String[] ds = new String[]{null};
        int[] count = new int[]{0};
        this.format(pattern, (s, k, leaf, lvl) -> {
            if (count[0] == -1) {
                return;
            }
            if (k == SqlImportUtil.DATA_SOURCE) {
                ds[0] = s;
                if (!first2[0]) {
                    count[0] = count[0] + 2;
                    renderer2.append(", ", (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                }
                if (leaf) {
                    s = DatabaseBundle.message("SqlResolveConfigurable.label.default", new Object[0]);
                } else {
                    return;
                }
            }
            if (count[0] >= maxChars) {
                count[0] = -1;
                return;
            }
            String trimmed1 = StringUtil.first((String)s, (int)(maxChars - count[0]), (boolean)false);
            if (!leaf) {
                count[0] = count[0] + (trimmed1.length() + 1);
                renderer2.append(trimmed1 + ":", (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            } else {
                count[0] = count[0] + trimmed1.length();
                renderer2.append(trimmed1, (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                if (ds[0] != null && count[0] < maxChars) {
                    String trimmed2 = StringUtil.first((String)(" (" + ds[0] + ")"), (int)(maxChars - count[0]), (boolean)false);
                    count[0] = count[0] + trimmed2.length();
                    renderer2.append(trimmed2, (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.GRAY_ATTRIBUTES));
                }
                ds[0] = null;
            }
            first2[0] = false;
            if (count[0] >= maxChars) {
                count[0] = -1;
            }
        });
        if (count[0] == -1) {
            renderer2.append("...", (SimpleTextAttributes)ObjectUtils.notNull((Object)forcedAttrs, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
        }
    }

    private void format(@NotNull TreePattern pattern, final Formatter consumer) {
        if (pattern == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(9);
        }
        if (pattern.root.groups.length == 0) {
            consumer.consume(DatabaseBundle.message("SqlResolveConfigurable.label.nothing", new Object[0]), SqlImportUtil.DATA_SOURCE, true, 0);
            return;
        }
        if (SqlResolveConfigurable.isWildcard(pattern.root)) {
            consumer.consume(DatabaseBundle.message("SqlResolveConfigurable.label.everything", new Object[0]), SqlImportUtil.DATA_SOURCE, true, 0);
            return;
        }
        final DbPsiFacade facade = DbPsiFacade.getInstance(this.myProject);
        new Object(){

            public void visit(TreePatternNode root, ObjectKind kind, int lvl) {
                TreePatternNode.Group child = root.getGroup(ObjectKind.DATABASE);
                if (child == null) {
                    child = root.getGroup(ObjectKind.SCHEMA);
                }
                boolean ds = kind == SqlImportUtil.DATA_SOURCE;
                boolean neg = root.naming instanceof TreePatternNode.NegativeNaming;
                JBIterable names = ds ? JBIterable.of((Object[])root.naming.names).transform(o -> {
                    DbDataSource s = facade.findDataSource(o.name);
                    return s == null ? null : s.getName();
                }).filter(Conditions.notNull()) : JBIterable.of((Object[])root.naming.names).transform(o -> o.name);
                Object nm = !names.isEmpty() ? (String)(neg ? DatabaseBundle.message("SqlResolveConfigurable.label.all.excluding", new Object[0]) + " " : "") + StringUtil.join((Iterable)names, (String)", ") : DatabaseBundle.message(neg ? "SqlResolveConfigurable.label.all" : (ds ? "SqlResolveConfigurable.label.none" : "SqlResolveConfigurable.label.default"), new Object[0]);
                consumer.consume((String)nm, kind, child == null, lvl);
                this.visit(child, lvl + 1);
            }

            public void visit(TreePatternNode.Group root, int lvl) {
                if (root == null) {
                    return;
                }
                if (root.children != null) {
                    for (TreePatternNode p2 : root.children) {
                        this.visit(p2, root.kind, lvl);
                    }
                }
            }
        }.visit(pattern.root.getGroup(SqlImportUtil.DATA_SOURCE), 0);
    }

    private static boolean isWildcard(TreePatternNode node) {
        return node == null || TreePatternUtils.isWildcard(node.getGroup(SqlImportUtil.DATA_SOURCE));
    }

    @Nls
    public String getDisplayName() {
        return SqlBundle.message((String)"sql.resolve.configurable", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.sql.resolve";
    }

    @NotNull
    protected JBPopup createValueEditorPopup(@Nullable Object target2, @Nullable TreePattern value, @Nullable Runnable onDispose, @NotNull DataContext dataContext, final @NotNull Consumer<? super TreePattern> onChosen, @NotNull Runnable onCommit) {
        Project project;
        if (dataContext == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(10);
        }
        if (onChosen == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(11);
        }
        if (onCommit == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(12);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            JBPopup jBPopup = super.createValueEditorPopup(target2, (Object)value, onDispose, dataContext, onChosen, onCommit);
            if (jBPopup == null) {
                SqlResolveConfigurable.$$$reportNull$$$0(13);
            }
            return jBPopup;
        }
        final SqlResolveEditor editor2 = new SqlResolveEditor(project);
        editor2.getTree().getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent event) {
                onChosen.consume((Object)editor2.getPattern());
            }
        });
        if (value == null) {
            value = this.getDefaultMapping(target2);
        }
        editor2.setPatterns(value, value);
        final Ref popupRef = Ref.create(null);
        JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder(editor2.getComponent(), (JComponent)editor2.getTree()).setKeyEventHandler(event -> {
            if (event.getID() == 401) {
                if (event.getKeyCode() == 27 && !editor2.hasSpeedSearchActive()) {
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
                if (event.getKeyCode() == 10) {
                    ((JBPopup)popupRef.get()).cancel();
                    return true;
                }
            }
            return false;
        }).setDimensionServiceKey(project, "SqlResolveConfigurable", false).setRequestFocus(true).setResizable(true).addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                ((AbstractPopup)popupRef.get()).setShowHints(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sql/dialects/SqlResolveConfigurable$3", "beforeShown"));
            }
        }).createPopup();
        popupRef.set((Object)popup2);
        popup2.setFinalRunnable(() -> {
            onCommit.run();
            if (onDispose != null) {
                onDispose.run();
            }
        });
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(14);
        }
        return jBPopup;
    }

    @NotNull
    protected List<PerFileConfigurableBase.Mapping<TreePattern>> getDefaultMappings() {
        List<PerFileConfigurableBase.Mapping<TreePattern>> list = Collections.singletonList(this.myProjectMapping);
        if (list == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(15);
        }
        return list;
    }

    protected String getToolTipFor(TreePattern value) {
        if (value == null) {
            value = SqlResolveMappings.ALL_DATA_SOURCES;
        }
        SimpleColoredText renderer2 = new SimpleColoredText();
        this.renderValue(value, (ColoredTextContainer)renderer2, null, 200);
        @NlsSafe StringBuilder html = new StringBuilder("<html>");
        for (String s : renderer2.getTexts()) {
            if (s.equals(", ")) {
                html.append("<br>");
                continue;
            }
            html.append(StringUtil.escapeXmlEntities((String)s));
        }
        html.append("</html>");
        return html.toString();
    }

    public static void openResolveScopesConfigurable(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            SqlResolveConfigurable.$$$reportNull$$$0(16);
        }
        SqlResolveConfigurable configurable = new SqlResolveConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            if (virtualFile != null) {
                configurable.selectFile(virtualFile);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlResolveConfigurable";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlResolveConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMapping";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueVariants";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueEditorPopup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderDefaultValue";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createValueEditorPopup";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openResolveScopesConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    private static interface Formatter {
        public void consume(String var1, ObjectKind var2, boolean var3, int var4);
    }
}

