/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.selector;

import java.util.Objects;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

public final class OptionalDependencySelector
implements DependencySelector {
    private final int depth;

    public OptionalDependencySelector() {
        this.depth = 0;
    }

    private OptionalDependencySelector(int depth) {
        this.depth = depth;
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        Objects.requireNonNull(dependency, "dependency cannot be null");
        return this.depth < 2 || !dependency.isOptional();
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        if (this.depth >= 2) {
            return this;
        }
        return new OptionalDependencySelector(this.depth + 1);
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (null == obj2 || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        OptionalDependencySelector that = (OptionalDependencySelector)obj2;
        return this.depth == that.depth;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + this.depth;
        return hash;
    }

    public String toString() {
        return String.format("%s(depth: %d)", this.getClass().getSimpleName(), this.depth);
    }
}

