/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

public class GeometryMapper {
    public static Geometry map(Geometry geom, MapOp op) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry g = op.map(geom.getGeometryN(i2));
            if (g == null) continue;
            mapped.add(g);
        }
        return geom.getFactory().buildGeometry(mapped);
    }

    public static Collection map(Collection geoms, MapOp op) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        for (Geometry g : geoms) {
            Geometry gr = op.map(g);
            if (gr == null) continue;
            mapped.add(gr);
        }
        return mapped;
    }

    public static Geometry flatMap(Geometry geom, int emptyDim, MapOp op) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        GeometryMapper.flatMap(geom, op, mapped);
        if (mapped.size() == 0) {
            return geom.getFactory().createEmpty(emptyDim);
        }
        if (mapped.size() == 1) {
            return (Geometry)mapped.get(0);
        }
        return geom.getFactory().buildGeometry(mapped);
    }

    private static void flatMap(Geometry geom, MapOp op, List<Geometry> mapped) {
        for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
            Geometry g = geom.getGeometryN(i2);
            if (g instanceof GeometryCollection) {
                GeometryMapper.flatMap(g, op, mapped);
                continue;
            }
            Geometry res2 = op.map(g);
            if (res2 == null || res2.isEmpty()) continue;
            GeometryMapper.addFlat(res2, mapped);
        }
    }

    private static void addFlat(Geometry geom, List<Geometry> geomList) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof GeometryCollection) {
            for (int i2 = 0; i2 < geom.getNumGeometries(); ++i2) {
                GeometryMapper.addFlat(geom.getGeometryN(i2), geomList);
            }
        } else {
            geomList.add(geom);
        }
    }

    public static interface MapOp {
        public Geometry map(Geometry var1);
    }
}

