/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.cloud.inline.removals;

import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.InlineCompletionInstallListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u0000 \b2\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bJ\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory;", "", "getLastRemovedLine", "", "Impl", "RemovalsListener", "Initializer", "ActionHandler", "Companion", "intellij.ml.llm.completion"})
public interface EditorRemovalsHistory {
    @NotNull
    public static final Companion Companion = com.intellij.ml.llm.completion.cloud.inline.removals.EditorRemovalsHistory$Companion.$$INSTANCE;

    @RequiresReadLock
    @Nullable
    public String getLastRemovedLine();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$ActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "originalHandler", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "invokeOriginalHandler", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "doExecute", "intellij.ml.llm.completion"})
    @SourceDebugExtension(value={"SMAP\nEditorRemovalsHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorRemovalsHistory.kt\ncom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$ActionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
    private static final class ActionHandler
    extends EditorActionHandler {
        @NotNull
        private final EditorActionHandler originalHandler;

        public ActionHandler(@NotNull EditorActionHandler originalHandler) {
            Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
            this.originalHandler = originalHandler;
        }

        private final void invokeOriginalHandler(Editor editor2, Caret caret, DataContext dataContext) {
            if (this.originalHandler.isEnabled(editor2, caret, dataContext)) {
                this.originalHandler.execute(editor2, caret, dataContext);
            }
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            return this.originalHandler.isEnabled(editor2, caret, dataContext);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
            String lastRemovedFragment;
            TextRange textRange;
            Impl history;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            EditorRemovalsHistory editorRemovalsHistory = Companion.get(editor2);
            Impl impl = history = editorRemovalsHistory instanceof Impl ? (Impl)editorRemovalsHistory : null;
            if (history == null || editor2.getCaretModel().getCaretCount() > 1) {
                this.invokeOriginalHandler(editor2, caret, dataContext);
                return;
            }
            int initialCaretOffset = editor2.getCaretModel().getOffset();
            history.setSingleLastRemovedFragment(null);
            String initialSelection = editor2.getSelectionModel().getSelectedText();
            TextRange it = textRange = editor2.getCaretModel().getPrimaryCaret().getSelectionRange();
            boolean bl = false;
            TextRange initialSelectionRange = it.getLength() > 0 ? textRange : null;
            if (initialSelection != null != (initialSelectionRange != null)) {
                this.invokeOriginalHandler(editor2, caret, dataContext);
                return;
            }
            this.invokeOriginalHandler(editor2, caret, dataContext);
            String string = history.retrieveLastRemovedFragment();
            if (string != null) {
                String it2 = bl = string;
                boolean bl2 = false;
                v2 = ((CharSequence)it2).length() > 0 ? bl : null;
            } else {
                v2 = lastRemovedFragment = null;
            }
            if (lastRemovedFragment == null || editor2.getSelectionModel().getSelectedText() != null) {
                history.reset();
                return;
            }
            boolean addToRight = false;
            int removedFromOffset = 0;
            int finalCaretOffset = editor2.getCaretModel().getOffset();
            int finalLineNumber = editor2.getDocument().getLineNumber(finalCaretOffset);
            if (initialSelectionRange == null) {
                if (lastRemovedFragment.length() == initialCaretOffset - finalCaretOffset) {
                    addToRight = false;
                    removedFromOffset = initialCaretOffset;
                } else {
                    if (finalCaretOffset != initialCaretOffset) {
                        history.reset();
                        return;
                    }
                    addToRight = true;
                    removedFromOffset = initialCaretOffset;
                }
            } else {
                if (!Intrinsics.areEqual((Object)lastRemovedFragment, (Object)initialSelection)) {
                    history.reset();
                    return;
                }
                int n = initialCaretOffset;
                if (n == initialSelectionRange.getStartOffset()) {
                    addToRight = false;
                    removedFromOffset = initialSelectionRange.getEndOffset();
                } else {
                    if (n != initialSelectionRange.getEndOffset()) {
                        history.reset();
                        return;
                    }
                    addToRight = true;
                    removedFromOffset = initialSelectionRange.getStartOffset();
                }
            }
            history.updateWith(lastRemovedFragment, finalCaretOffset, finalLineNumber, removedFromOffset, addToRight);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$Companion;", "", "<init>", "()V", "MAX_LINE_SIZE", "", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "init", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "remove", "get", "intellij.ml.llm.completion"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int MAX_LINE_SIZE = 150;
        @NotNull
        private static final Key<EditorRemovalsHistory> KEY;

        private Companion() {
        }

        private final void init(Editor editor2) {
            editor2.putUserData(KEY, (Object)new Impl(editor2));
        }

        private final void remove(Editor editor2) {
            editor2.putUserData(KEY, null);
        }

        @Nullable
        public final EditorRemovalsHistory get(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (EditorRemovalsHistory)editor2.getUserData(KEY);
        }

        static {
            $$INSTANCE = new Companion();
            Key key = Key.create((String)"cloud.completion.removals.history");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            KEY = key;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bJ.\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0012J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$Impl;", "Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "lastCaretOffset", "", "Ljava/lang/Integer;", "lastLineNumber", "lastLine", "", "lastRemovedFragment", "lastTimestamp", "", "Ljava/lang/Long;", "getLastRemovedLine", "setSingleLastRemovedFragment", "", "fragment", "retrieveLastRemovedFragment", "updateWith", "removedFragment", "finalCaretOffset", "lineNumber", "initialCaretOffset", "addToRight", "", "reset", "initWith", "caretOffset", "intellij.ml.llm.completion"})
    @SourceDebugExtension(value={"SMAP\nEditorRemovalsHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorRemovalsHistory.kt\ncom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$Impl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
    private static final class Impl
    implements EditorRemovalsHistory {
        @NotNull
        private final Editor editor;
        @Nullable
        private Integer lastCaretOffset;
        @Nullable
        private Integer lastLineNumber;
        @Nullable
        private String lastLine;
        @Nullable
        private String lastRemovedFragment;
        @Nullable
        private Long lastTimestamp;

        public Impl(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
            Disposable disposable = Disposer.newDisposable((String)"cloud.completion.deletions.listener");
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable newDisposable = disposable;
            this.editor.getDocument().addDocumentListener((DocumentListener)new RemovalsListener(this), newDisposable);
            EditorUtil.disposeWithEditor((Editor)this.editor, (Disposable)newDisposable);
        }

        @Override
        @Nullable
        public String getLastRemovedLine() {
            block3: {
                block2: {
                    ThreadingAssertions.assertReadAccess();
                    int caretOffset = this.editor.getCaretModel().getOffset();
                    int lineNumber = this.editor.getDocument().getLineNumber(caretOffset);
                    Integer n = this.lastCaretOffset;
                    int n2 = caretOffset;
                    if (n == null || n != n2) break block2;
                    Integer n3 = this.lastLineNumber;
                    n2 = lineNumber;
                    if (n3 == null || n3 != n2) break block2;
                    Long l = this.lastTimestamp;
                    long l2 = this.editor.getDocument().getModificationStamp();
                    if (l != null && l == l2) break block3;
                }
                this.reset();
            }
            return this.lastLine;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSingleLastRemovedFragment(@Nullable String fragment) {
            ThreadingAssertions.assertEventDispatchThread();
            if (this.lastRemovedFragment == null) {
                String string;
                Impl impl = this;
                String string2 = fragment;
                if (string2 != null) {
                    void it;
                    String string3;
                    String string4 = string3 = string2;
                    Impl impl2 = impl;
                    boolean bl = false;
                    boolean bl2 = it.length() <= 150;
                    impl = impl2;
                    string = bl2 ? string3 : null;
                } else {
                    string = null;
                }
                impl.lastRemovedFragment = string;
            } else {
                this.lastRemovedFragment = null;
            }
        }

        @Nullable
        public final String retrieveLastRemovedFragment() {
            String string;
            ThreadingAssertions.assertEventDispatchThread();
            String it = string = this.lastRemovedFragment;
            boolean bl = false;
            this.lastRemovedFragment = null;
            return string;
        }

        public final void updateWith(@NotNull String removedFragment, int finalCaretOffset, int lineNumber, int initialCaretOffset, boolean addToRight) {
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)removedFragment, (String)"removedFragment");
                    ThreadingAssertions.assertEventDispatchThread();
                    if (StringsKt.contains$default((CharSequence)removedFragment, (char)'\n', (boolean)false, (int)2, null)) {
                        this.reset();
                        return;
                    }
                    Integer n = this.lastLineNumber;
                    int n2 = lineNumber;
                    if (n == null || n != n2) break block9;
                    Integer n3 = this.lastCaretOffset;
                    n2 = initialCaretOffset;
                    if (n3 != null && n3 == n2) break block10;
                }
                this.initWith(removedFragment, finalCaretOffset, lineNumber);
                return;
            }
            this.lastCaretOffset = finalCaretOffset;
            if (addToRight) {
                String string = this.lastLine;
                if (string == null) {
                    string = "";
                }
                this.lastLine = string + removedFragment;
            } else {
                String string = this.lastLine;
                if (string == null) {
                    string = "";
                }
                this.lastLine = removedFragment + string;
            }
            this.lastTimestamp = this.editor.getDocument().getModificationStamp();
            String string = this.lastLine;
            if ((string != null ? string.length() : 0) > 150) {
                this.reset();
            }
        }

        public final void reset() {
            ThreadingAssertions.assertReadAccess();
            this.lastCaretOffset = null;
            this.lastLineNumber = null;
            this.lastLine = null;
            this.lastRemovedFragment = null;
            this.lastTimestamp = null;
        }

        private final void initWith(String removedFragment, int caretOffset, int lineNumber) {
            if (StringsKt.contains$default((CharSequence)removedFragment, (char)'\n', (boolean)false, (int)2, null) || removedFragment.length() > 150) {
                return;
            }
            this.reset();
            this.lastCaretOffset = caretOffset;
            this.lastLineNumber = lineNumber;
            this.lastLine = removedFragment;
            this.lastRemovedFragment = null;
            this.lastTimestamp = this.editor.getDocument().getModificationStamp();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$Initializer;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionInstallListener;", "<init>", "()V", "handlerInstalled", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "handler", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionHandler;", "handlerUninstalled", "intellij.ml.llm.completion"})
    private static final class Initializer
    implements InlineCompletionInstallListener {
        public void handlerInstalled(@NotNull Editor editor2, @NotNull InlineCompletionHandler handler) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Companion.init(editor2);
        }

        public void handlerUninstalled(@NotNull Editor editor2, @NotNull InlineCompletionHandler handler) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Companion.remove(editor2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$RemovalsListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener;", "history", "Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$Impl;", "<init>", "(Lcom/intellij/ml/llm/completion/cloud/inline/removals/EditorRemovalsHistory$Impl;)V", "documentChangedNonBulk", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.ml.llm.completion"})
    private static final class RemovalsListener
    implements BulkAwareDocumentListener {
        @NotNull
        private final Impl history;

        public RemovalsListener(@NotNull Impl history) {
            Intrinsics.checkNotNullParameter((Object)history, (String)"history");
            this.history = history;
        }

        public void documentChangedNonBulk(@NotNull DocumentEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ActionsKt.runReadAction(() -> RemovalsListener.documentChangedNonBulk$lambda$0(event, this));
        }

        private static final Unit documentChangedNonBulk$lambda$0(DocumentEvent $event, RemovalsListener this$0) {
            if ($event.getNewLength() > 0 || $event.getOldLength() == 0) {
                this$0.history.reset();
            } else {
                String oldFragment = ((Object)$event.getOldFragment()).toString();
                this$0.history.setSingleLastRemovedFragment(oldFragment);
            }
            return Unit.INSTANCE;
        }
    }
}

