/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.draw;

import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.layout.ContentScale;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.layout.ScaleFactorKt;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.LayoutModifierNode;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSizeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b0\u00101J\u001a\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b5\u00101J\b\u00106\u001a\u000207H\u0016J\f\u00108\u001a\u000209*\u00020:H\u0016J\u0016\u0010;\u001a\u00020\u0007*\u00020.H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b<\u0010=J\u0016\u0010>\u001a\u00020\u0007*\u00020.H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b?\u0010=J\u001c\u0010@\u001a\u00020A*\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020AH\u0016J\u001c\u0010F\u001a\u00020A*\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010G\u001a\u00020AH\u0016J&\u0010H\u001a\u00020I*\u00020J2\u0006\u0010C\u001a\u00020K2\u0006\u00104\u001a\u000203H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\bL\u0010MJ\u001c\u0010N\u001a\u00020A*\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020AH\u0016J\u001c\u0010O\u001a\u00020A*\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010G\u001a\u00020AH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010'\"\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010'\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006P"}, d2={"Landroidx/compose/ui/draw/PainterNode;", "Landroidx/compose/ui/node/LayoutModifierNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/DrawModifierNode;", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "sizeToIntrinsics", "", "alignment", "Landroidx/compose/ui/Alignment;", "contentScale", "Landroidx/compose/ui/layout/ContentScale;", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "(Landroidx/compose/ui/graphics/painter/Painter;ZLandroidx/compose/ui/Alignment;Landroidx/compose/ui/layout/ContentScale;FLandroidx/compose/ui/graphics/ColorFilter;)V", "getAlignment", "()Landroidx/compose/ui/Alignment;", "setAlignment", "(Landroidx/compose/ui/Alignment;)V", "getAlpha", "()F", "setAlpha", "(F)V", "getColorFilter", "()Landroidx/compose/ui/graphics/ColorFilter;", "setColorFilter", "(Landroidx/compose/ui/graphics/ColorFilter;)V", "getContentScale", "()Landroidx/compose/ui/layout/ContentScale;", "setContentScale", "(Landroidx/compose/ui/layout/ContentScale;)V", "getPainter", "()Landroidx/compose/ui/graphics/painter/Painter;", "setPainter", "(Landroidx/compose/ui/graphics/painter/Painter;)V", "shouldAutoInvalidate", "getShouldAutoInvalidate", "()Z", "getSizeToIntrinsics", "setSizeToIntrinsics", "(Z)V", "useIntrinsicSize", "getUseIntrinsicSize", "calculateScaledSize", "Landroidx/compose/ui/geometry/Size;", "dstSize", "calculateScaledSize-E7KxVPU", "(J)J", "modifyConstraints", "Landroidx/compose/ui/unit/Constraints;", "constraints", "modifyConstraints-ZezNO4M", "toString", "", "draw", "", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "hasSpecifiedAndFiniteHeight", "hasSpecifiedAndFiniteHeight-uvyYCjk", "(J)Z", "hasSpecifiedAndFiniteWidth", "hasSpecifiedAndFiniteWidth-uvyYCjk", "maxIntrinsicHeight", "", "Landroidx/compose/ui/layout/IntrinsicMeasureScope;", "measurable", "Landroidx/compose/ui/layout/IntrinsicMeasurable;", "width", "maxIntrinsicWidth", "height", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "Landroidx/compose/ui/layout/Measurable;", "measure-3p2s80s", "(Landroidx/compose/ui/layout/MeasureScope;Landroidx/compose/ui/layout/Measurable;J)Landroidx/compose/ui/layout/MeasureResult;", "minIntrinsicHeight", "minIntrinsicWidth", "ui"})
@SourceDebugExtension(value={"SMAP\nPainterModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PainterModifier.kt\nandroidx/compose/ui/draw/PainterNode\n+ 2 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 3 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 4 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,362:1\n198#2:363\n26#3:364\n26#3:365\n26#3:366\n26#3:367\n26#3:368\n26#3:369\n128#4,7:370\n*S KotlinDebug\n*F\n+ 1 PainterModifier.kt\nandroidx/compose/ui/draw/PainterNode\n*L\n163#1:363\n273#1:364\n280#1:365\n299#1:366\n300#1:367\n329#1:368\n330#1:369\n341#1:370,7\n*E\n"})
final class PainterNode
extends Modifier.Node
implements LayoutModifierNode,
DrawModifierNode {
    @NotNull
    private Painter painter;
    private boolean sizeToIntrinsics;
    @NotNull
    private Alignment alignment;
    @NotNull
    private ContentScale contentScale;
    private float alpha;
    @Nullable
    private ColorFilter colorFilter;

    public PainterNode(@NotNull Painter painter, boolean sizeToIntrinsics, @NotNull Alignment alignment, @NotNull ContentScale contentScale, float alpha2, @Nullable ColorFilter colorFilter) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"contentScale");
        this.painter = painter;
        this.sizeToIntrinsics = sizeToIntrinsics;
        this.alignment = alignment;
        this.contentScale = contentScale;
        this.alpha = alpha2;
        this.colorFilter = colorFilter;
    }

    public /* synthetic */ PainterNode(Painter painter, boolean bl, Alignment alignment, ContentScale contentScale, float f, ColorFilter colorFilter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            alignment = Alignment.Companion.getCenter();
        }
        if ((n & 8) != 0) {
            contentScale = ContentScale.Companion.getInside();
        }
        if ((n & 0x10) != 0) {
            f = 1.0f;
        }
        if ((n & 0x20) != 0) {
            colorFilter = null;
        }
        this(painter, bl, alignment, contentScale, f, colorFilter);
    }

    @NotNull
    public final Painter getPainter() {
        return this.painter;
    }

    public final void setPainter(@NotNull Painter painter) {
        Intrinsics.checkNotNullParameter((Object)painter, (String)"<set-?>");
        this.painter = painter;
    }

    public final boolean getSizeToIntrinsics() {
        return this.sizeToIntrinsics;
    }

    public final void setSizeToIntrinsics(boolean bl) {
        this.sizeToIntrinsics = bl;
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.alignment;
    }

    public final void setAlignment(@NotNull Alignment alignment) {
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"<set-?>");
        this.alignment = alignment;
    }

    @NotNull
    public final ContentScale getContentScale() {
        return this.contentScale;
    }

    public final void setContentScale(@NotNull ContentScale contentScale) {
        Intrinsics.checkNotNullParameter((Object)contentScale, (String)"<set-?>");
        this.contentScale = contentScale;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(float f) {
        this.alpha = f;
    }

    @Nullable
    public final ColorFilter getColorFilter() {
        return this.colorFilter;
    }

    public final void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.colorFilter = colorFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getUseIntrinsicSize() {
        if (!this.sizeToIntrinsics) return false;
        long $this$isSpecified$iv = this.painter.getIntrinsicSize-NH-jbRc();
        boolean bl = false;
        if ($this$isSpecified$iv == 9205357640488583168L) return false;
        return true;
    }

    @Override
    public boolean getShouldAutoInvalidate() {
        return false;
    }

    @Override
    @NotNull
    public MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$measure_u2d3p2s80s, @NotNull Measurable measurable, long constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure_u2d3p2s80s, (String)"$this$measure");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Placeable placeable = measurable.measure-BRTryo0(this.modifyConstraints-ZezNO4M(constraints));
        return MeasureScope.layout$default($this$measure_u2d3p2s80s, placeable.getWidth(), placeable.getHeight(), null, (Function1)new Function1<Placeable.PlacementScope, Unit>(placeable){
            final /* synthetic */ Placeable $placeable;
            {
                this.$placeable = $placeable;
                super(1);
            }

            public final void invoke(@NotNull Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                Placeable.PlacementScope.placeRelative$default($this$layout, this.$placeable, 0, 0, 0.0f, 4, null);
            }
        }, 4, null);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            long constraints = this.modifyConstraints-ZezNO4M(ConstraintsKt.Constraints$default(0, 0, 0, height2, 7, null));
            int layoutWidth = measurable.minIntrinsicWidth(height2);
            n = Math.max(Constraints.getMinWidth-impl(constraints), layoutWidth);
        } else {
            n = measurable.minIntrinsicWidth(height2);
        }
        return n;
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicWidth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            long constraints = this.modifyConstraints-ZezNO4M(ConstraintsKt.Constraints$default(0, 0, 0, height2, 7, null));
            int layoutWidth = measurable.maxIntrinsicWidth(height2);
            n = Math.max(Constraints.getMinWidth-impl(constraints), layoutWidth);
        } else {
            n = measurable.maxIntrinsicWidth(height2);
        }
        return n;
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$minIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            long constraints = this.modifyConstraints-ZezNO4M(ConstraintsKt.Constraints$default(0, width2, 0, 0, 13, null));
            int layoutHeight = measurable.minIntrinsicHeight(width2);
            n = Math.max(Constraints.getMinHeight-impl(constraints), layoutHeight);
        } else {
            n = measurable.minIntrinsicHeight(width2);
        }
        return n;
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$maxIntrinsicHeight, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        if (this.getUseIntrinsicSize()) {
            long constraints = this.modifyConstraints-ZezNO4M(ConstraintsKt.Constraints$default(0, width2, 0, 0, 13, null));
            int layoutHeight = measurable.maxIntrinsicHeight(width2);
            n = Math.max(Constraints.getMinHeight-impl(constraints), layoutHeight);
        } else {
            n = measurable.maxIntrinsicHeight(width2);
        }
        return n;
    }

    private final long calculateScaledSize-E7KxVPU(long dstSize) {
        long l;
        if (!this.getUseIntrinsicSize()) {
            l = dstSize;
        } else {
            float srcWidth = !this.hasSpecifiedAndFiniteWidth-uvyYCjk(this.painter.getIntrinsicSize-NH-jbRc()) ? Size.getWidth-impl(dstSize) : Size.getWidth-impl(this.painter.getIntrinsicSize-NH-jbRc());
            float srcHeight = !this.hasSpecifiedAndFiniteHeight-uvyYCjk(this.painter.getIntrinsicSize-NH-jbRc()) ? Size.getHeight-impl(dstSize) : Size.getHeight-impl(this.painter.getIntrinsicSize-NH-jbRc());
            long srcSize = SizeKt.Size(srcWidth, srcHeight);
            l = !(Size.getWidth-impl(dstSize) == 0.0f) && !(Size.getHeight-impl(dstSize) == 0.0f) ? ScaleFactorKt.times-UQTWf7w(srcSize, this.contentScale.computeScaleFactor-H7hwNQA(srcSize, dstSize)) : Size.Companion.getZero-NH-jbRc();
        }
        return l;
    }

    private final long modifyConstraints-ZezNO4M(long constraints) {
        int n;
        int intrinsicWidth;
        int n2;
        boolean hasFixedDimens;
        boolean hasBoundedDimens = Constraints.getHasBoundedWidth-impl(constraints) && Constraints.getHasBoundedHeight-impl(constraints);
        boolean bl = hasFixedDimens = Constraints.getHasFixedWidth-impl(constraints) && Constraints.getHasFixedHeight-impl(constraints);
        if (!this.getUseIntrinsicSize() && hasBoundedDimens || hasFixedDimens) {
            return Constraints.copy-Zbe2FdA$default(constraints, Constraints.getMaxWidth-impl(constraints), 0, Constraints.getMaxHeight-impl(constraints), 0, 10, null);
        }
        long intrinsicSize = this.painter.getIntrinsicSize-NH-jbRc();
        if (this.hasSpecifiedAndFiniteWidth-uvyYCjk(intrinsicSize)) {
            float $this$fastRoundToInt$iv = Size.getWidth-impl(intrinsicSize);
            boolean $i$f$fastRoundToInt = false;
            n2 = Math.round($this$fastRoundToInt$iv);
        } else {
            n2 = intrinsicWidth = Constraints.getMinWidth-impl(constraints);
        }
        if (this.hasSpecifiedAndFiniteHeight-uvyYCjk(intrinsicSize)) {
            float $this$fastRoundToInt$iv = Size.getHeight-impl(intrinsicSize);
            boolean $i$f$fastRoundToInt = false;
            n = Math.round($this$fastRoundToInt$iv);
        } else {
            n = Constraints.getMinHeight-impl(constraints);
        }
        int intrinsicHeight = n;
        int constrainedWidth = ConstraintsKt.constrainWidth-K40F9xA(constraints, intrinsicWidth);
        int constrainedHeight = ConstraintsKt.constrainHeight-K40F9xA(constraints, intrinsicHeight);
        long scaledSize = this.calculateScaledSize-E7KxVPU(SizeKt.Size(constrainedWidth, constrainedHeight));
        float $this$fastRoundToInt$iv = Size.getWidth-impl(scaledSize);
        boolean $i$f$fastRoundToInt = false;
        int minWidth = ConstraintsKt.constrainWidth-K40F9xA(constraints, Math.round($this$fastRoundToInt$iv));
        float $this$fastRoundToInt$iv2 = Size.getHeight-impl(scaledSize);
        boolean $i$f$fastRoundToInt2 = false;
        int minHeight = ConstraintsKt.constrainHeight-K40F9xA(constraints, Math.round($this$fastRoundToInt$iv2));
        return Constraints.copy-Zbe2FdA$default(constraints, minWidth, 0, minHeight, 0, 10, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        long intrinsicSize = this.painter.getIntrinsicSize-NH-jbRc();
        float srcWidth = this.hasSpecifiedAndFiniteWidth-uvyYCjk(intrinsicSize) ? Size.getWidth-impl(intrinsicSize) : Size.getWidth-impl($this$draw.getSize-NH-jbRc());
        float srcHeight = this.hasSpecifiedAndFiniteHeight-uvyYCjk(intrinsicSize) ? Size.getHeight-impl(intrinsicSize) : Size.getHeight-impl($this$draw.getSize-NH-jbRc());
        long srcSize = SizeKt.Size(srcWidth, srcHeight);
        long scaledSize = !(Size.getWidth-impl($this$draw.getSize-NH-jbRc()) == 0.0f) && !(Size.getHeight-impl($this$draw.getSize-NH-jbRc()) == 0.0f) ? ScaleFactorKt.times-UQTWf7w(srcSize, this.contentScale.computeScaleFactor-H7hwNQA(srcSize, $this$draw.getSize-NH-jbRc())) : Size.Companion.getZero-NH-jbRc();
        float $this$fastRoundToInt$iv = Size.getWidth-impl(scaledSize);
        boolean $i$f$fastRoundToInt = false;
        int n = Math.round($this$fastRoundToInt$iv);
        $this$fastRoundToInt$iv = Size.getHeight-impl(scaledSize);
        $i$f$fastRoundToInt = false;
        long l = IntSizeKt.IntSize(n, Math.round($this$fastRoundToInt$iv));
        $this$fastRoundToInt$iv = Size.getWidth-impl($this$draw.getSize-NH-jbRc());
        $i$f$fastRoundToInt = false;
        int n2 = Math.round($this$fastRoundToInt$iv);
        $this$fastRoundToInt$iv = Size.getHeight-impl($this$draw.getSize-NH-jbRc());
        $i$f$fastRoundToInt = false;
        long alignedPosition = this.alignment.align-KFBX0sM(l, IntSizeKt.IntSize(n2, Math.round($this$fastRoundToInt$iv)), $this$draw.getLayoutDirection());
        float dx = IntOffset.getX-impl(alignedPosition);
        float dy = IntOffset.getY-impl(alignedPosition);
        DrawScope $this$translate$iv = $this$draw;
        boolean $i$f$translate = false;
        $this$translate$iv.getDrawContext().getTransform().translate(dx, dy);
        try {
            DrawScope $this$draw_u24lambda_u241 = $this$translate$iv;
            boolean bl = false;
            Painter $this$draw_u24lambda_u241_u24lambda_u240 = this.painter;
            boolean bl2 = false;
            $this$draw_u24lambda_u241_u24lambda_u240.draw-x_KDEd0($this$draw_u24lambda_u241, scaledSize, this.alpha, this.colorFilter);
        }
        finally {
            $this$translate$iv.getDrawContext().getTransform().translate(-dx, -dy);
        }
        $this$draw.drawContent();
    }

    private final boolean hasSpecifiedAndFiniteWidth-uvyYCjk(long $this$hasSpecifiedAndFiniteWidth_u2duvyYCjk) {
        float f;
        return !Size.equals-impl0($this$hasSpecifiedAndFiniteWidth_u2duvyYCjk, Size.Companion.getUnspecified-NH-jbRc()) && !Float.isInfinite(f = Size.getWidth-impl($this$hasSpecifiedAndFiniteWidth_u2duvyYCjk)) && !Float.isNaN(f);
    }

    private final boolean hasSpecifiedAndFiniteHeight-uvyYCjk(long $this$hasSpecifiedAndFiniteHeight_u2duvyYCjk) {
        float f;
        return !Size.equals-impl0($this$hasSpecifiedAndFiniteHeight_u2duvyYCjk, Size.Companion.getUnspecified-NH-jbRc()) && !Float.isInfinite(f = Size.getHeight-impl($this$hasSpecifiedAndFiniteHeight_u2duvyYCjk)) && !Float.isNaN(f);
    }

    @NotNull
    public String toString() {
        return "PainterModifier(painter=" + this.painter + ", sizeToIntrinsics=" + this.sizeToIntrinsics + ", alignment=" + this.alignment + ", alpha=" + this.alpha + ", colorFilter=" + this.colorFilter + ')';
    }
}

