/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.formatting.number;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.number.BigFloat;
import org.jetbrains.letsPlot.commons.formatting.number.FormatNotationUtil;
import org.jetbrains.letsPlot.commons.formatting.number.FormattedNumber;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;
import org.jetbrains.letsPlot.commons.formatting.number.SiPrefix;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00182\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat;", "", "spec", "", "(Ljava/lang/String;)V", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec;", "(Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec;)V", "apply", "num", "", "applyGroup", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Output;", "output", "computeBody", "res", "number", "Lorg/jetbrains/letsPlot/commons/formatting/number/BigFloat;", "computePadding", "computePrefix", "computeSign", "computeSuffix", "getAlignedString", "handleNonNumbers", "trimFraction", "Companion", "ExponentNotationType", "Output", "Spec", "commons"})
@SourceDebugExtension(value={"SMAP\nNumberFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,301:1\n1#2:302\n1224#3,2:303\n*S KotlinDebug\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat\n*L\n159#1:303,2\n*E\n"})
public final class NumberFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Spec spec;
    public static final int DEF_MIN_EXP = -7;
    public static final double TYPE_S_MAX = 1.0E26;
    @NotNull
    private static final String CURRENCY = "$";
    @NotNull
    private static final String PERCENT = "%";
    @NotNull
    private static final String COMMA = ",";
    @NotNull
    public static final String FRACTION_DELIMITER = ".";
    @NotNull
    public static final String MULT_SIGN = "\u00b7";
    private static final int GROUP_SIZE = 3;
    @NotNull
    private static final String EXPONENT_TYPES_REGEX = '[' + CollectionsKt.joinToString$default((Iterable)((Iterable)ExponentNotationType.getEntries()), (CharSequence)"", null, null, (int)0, null, (Function1)Companion.EXPONENT_TYPES_REGEX.1.INSTANCE, (int)30, null) + ']';
    @NotNull
    private static final Regex NUMBER_REGEX = new Regex("^(?:(?<fill>[^{}])?(?<align>[<>=^]))?(?<sign>[+ -])?(?<symbol>[#$])?(?<zero>0)?(?<width>\\d+)?(?<comma>,)?(?:\\.(?<precision>\\d+))?(?<trim>~)?(?<type>[%bcdefgosXx])?(?:&(?<exptype>" + EXPONENT_TYPES_REGEX + "))?(?:\\{(?<minexp>-?\\d+)?,(?<maxexp>-?\\d+)?\\})?$");
    private static final int DEF_WIDTH = -1;
    private static final int DEF_PRECISION = 6;
    @NotNull
    private static final ExponentNotationType DEF_EXPONENT_NOTATION_TYPE = ExponentNotationType.E;

    public NumberFormat(@NotNull Spec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = Companion.normalizeSpec$commons(spec);
    }

    public NumberFormat(@NotNull String spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this(Companion.parseSpec(spec));
    }

    @NotNull
    public final String apply(@NotNull Number num) {
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        String nonNumberString = this.handleNonNumbers(num);
        if (nonNumberString != null) {
            return nonNumberString;
        }
        BigFloat bigFloat = BigFloat.Companion.fromNumber(num);
        Intrinsics.checkNotNull((Object)bigFloat);
        BigFloat number = bigFloat;
        Output output = new Output(null, null, null, null, null, 31, null);
        output = this.computeBody(output, number);
        output = this.trimFraction(output);
        output = this.computeSign(output, number);
        output = this.computePrefix(output);
        output = this.computeSuffix(output);
        if (this.spec.getComma() && !this.spec.getZero()) {
            output = this.applyGroup(output);
        }
        output = this.computePadding(output);
        if (this.spec.getComma() && this.spec.getZero()) {
            output = this.applyGroup(output);
        }
        return this.getAlignedString(output);
    }

    private final String handleNonNumbers(Number num) {
        double number = num.doubleValue();
        return Double.isNaN(number) ? "NaN" : (number == Double.NEGATIVE_INFINITY ? "-Infinity" : (number == Double.POSITIVE_INFINITY ? "+Infinity" : null));
    }

    private final String getAlignedString(Output output) {
        String string;
        Output $this$getAlignedString_u24lambda_u240 = output;
        boolean bl = false;
        switch (this.spec.getAlign()) {
            case "<": {
                string = $this$getAlignedString_u24lambda_u240.getSign() + $this$getAlignedString_u24lambda_u240.getPrefix() + $this$getAlignedString_u24lambda_u240.getBody() + $this$getAlignedString_u24lambda_u240.getSuffix() + $this$getAlignedString_u24lambda_u240.getPadding();
                break;
            }
            case "=": {
                string = $this$getAlignedString_u24lambda_u240.getSign() + $this$getAlignedString_u24lambda_u240.getPrefix() + $this$getAlignedString_u24lambda_u240.getPadding() + $this$getAlignedString_u24lambda_u240.getBody() + $this$getAlignedString_u24lambda_u240.getSuffix();
                break;
            }
            case "^": {
                int stop2 = $this$getAlignedString_u24lambda_u240.getPadding().length() / 2;
                string = StringsKt.slice((String)$this$getAlignedString_u24lambda_u240.getPadding(), (IntRange)RangesKt.until((int)0, (int)stop2)) + $this$getAlignedString_u24lambda_u240.getSign() + $this$getAlignedString_u24lambda_u240.getPrefix() + $this$getAlignedString_u24lambda_u240.getBody() + $this$getAlignedString_u24lambda_u240.getSuffix() + StringsKt.slice((String)$this$getAlignedString_u24lambda_u240.getPadding(), (IntRange)RangesKt.until((int)stop2, (int)output.getPadding().length()));
                break;
            }
            default: {
                string = $this$getAlignedString_u24lambda_u240.getPadding() + $this$getAlignedString_u24lambda_u240.getSign() + $this$getAlignedString_u24lambda_u240.getPrefix() + $this$getAlignedString_u24lambda_u240.getBody() + $this$getAlignedString_u24lambda_u240.getSuffix();
            }
        }
        return string;
    }

    private final Output applyGroup(Output output) {
        String string;
        String string2;
        String it = string2 = output.getPadding();
        boolean bl = false;
        String string3 = this.spec.getZero() ? string2 : null;
        if (string3 == null) {
            string3 = "";
        }
        String zeroPadding = string3;
        FormattedNumber body = output.getBody();
        String fullIntStr = zeroPadding + body.getIntegerPart();
        int commas = (int)(Math.ceil((double)fullIntStr.length() / 3.0) - 1.0);
        int width2 = RangesKt.coerceAtLeast((int)(this.spec.getWidth() - body.getFractionalLength() - body.getExponentialLength()), (int)(body.getIntegerPart().length() + commas));
        if ((fullIntStr = NumberFormat.Companion.group(fullIntStr)).length() > width2) {
            String string4 = fullIntStr.substring(fullIntStr.length() - width2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            fullIntStr = string4;
            if (StringsKt.startsWith$default((CharSequence)fullIntStr, (char)',', (boolean)false, (int)2, null)) {
                fullIntStr = '0' + fullIntStr;
            }
        }
        String string5 = string = "";
        String string6 = null;
        String string7 = null;
        String string8 = null;
        FormattedNumber formattedNumber = FormattedNumber.copy$default(body, fullIntStr, null, null, null, 14, null);
        Output output2 = output;
        boolean bl2 = false;
        boolean bl3 = this.spec.getZero();
        String string9 = bl3 ? string : null;
        if (string9 == null) {
            string9 = output.getPadding();
        }
        return Output.copy$default(output2, formattedNumber, string8, string7, string6, string9, 14, null);
    }

    private final Output computeBody(Output res, BigFloat number) {
        FormattedNumber formattedNumber;
        switch (this.spec.getType()) {
            case "e": {
                formattedNumber = FormatNotationUtil.INSTANCE.formatExponentNotation$commons(number, this.spec.getPrecision(), this.spec.getMinExp(), this.spec.getMaxExp(), this.spec.getExpType());
                break;
            }
            case "f": {
                formattedNumber = FormatNotationUtil.INSTANCE.formatDecimalNotation$commons(number, this.spec.getPrecision());
                break;
            }
            case "g": {
                formattedNumber = FormatNotationUtil.INSTANCE.formatGeneralNotation$commons(number, this.spec.getPrecision(), this.spec.getMinExp(), this.spec.getMaxExp(), this.spec.getExpType());
                break;
            }
            case "s": {
                formattedNumber = FormatNotationUtil.INSTANCE.formatSiNotation$commons(number, this.spec.getPrecision());
                break;
            }
            case "%": {
                formattedNumber = FormatNotationUtil.INSTANCE.formatDecimalNotation$commons(number.shiftDecimalPoint(2), this.spec.getPrecision());
                break;
            }
            case "d": {
                formattedNumber = new FormattedNumber(number.toDecimalPrecision(0).getWholePart(), null, null, null, 14, null);
                break;
            }
            case "c": {
                formattedNumber = new FormattedNumber(number.getWholePart(), null, null, null, 14, null);
                break;
            }
            case "b": {
                String string = Long.toString(Long.parseLong(number.getWholePart()), CharsKt.checkRadix((int)2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                formattedNumber = new FormattedNumber(string, null, null, null, 14, null);
                break;
            }
            case "o": {
                String string = Long.toString(Long.parseLong(number.getWholePart()), CharsKt.checkRadix((int)8));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                formattedNumber = new FormattedNumber(string, null, null, null, 14, null);
                break;
            }
            case "X": {
                String string = Long.toString(Long.parseLong(number.getWholePart()), CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                formattedNumber = new FormattedNumber(string2, null, null, null, 14, null);
                break;
            }
            case "x": {
                String string = Long.toString(Long.parseLong(number.getWholePart()), CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                formattedNumber = new FormattedNumber(string, null, null, null, 14, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong type: " + this.spec.getType());
            }
        }
        FormattedNumber formattedNumber2 = formattedNumber;
        return Output.copy$default(res, formattedNumber2, null, null, null, null, 30, null);
    }

    private final Output trimFraction(Output output) {
        if (!this.spec.getTrim() || ((CharSequence)output.getBody().getFractionalPart()).length() == 0) {
            return output;
        }
        char[] cArray = new char[]{'0'};
        String trimmedFraction = StringsKt.trimEnd((String)output.getBody().getFractionalPart(), (char[])cArray);
        return Output.copy$default(output, FormattedNumber.copy$default(output.getBody(), null, trimmedFraction, null, null, 13, null), null, null, null, null, 30, null);
    }

    private final Output computeSign(Output output, BigFloat number) {
        boolean isNegative;
        boolean bl;
        block1: {
            FormattedNumber $this$computeSign_u24lambda_u244 = output.getBody();
            boolean bl2 = false;
            Sequence $this$all$iv = SequencesKt.plus((Sequence)StringsKt.asSequence((CharSequence)$this$computeSign_u24lambda_u244.getIntegerPart()), (Sequence)StringsKt.asSequence((CharSequence)$this$computeSign_u24lambda_u244.getFractionalPart()));
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                char it = ((Character)element$iv).charValue();
                boolean bl3 = false;
                if (it == '0') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        boolean isBodyZero = bl;
        boolean bl4 = isNegative = number.isNegative() && !isBodyZero;
        String signStr = isNegative ? "-" : (!Intrinsics.areEqual((Object)this.spec.getSign(), (Object)"-") ? this.spec.getSign() : "");
        return Output.copy$default(output, null, signStr, null, null, null, 29, null);
    }

    private final Output computePrefix(Output output) {
        String string;
        String string2 = this.spec.getSymbol();
        if (Intrinsics.areEqual((Object)string2, (Object)CURRENCY)) {
            string = CURRENCY;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"#")) {
            if (StringsKt.indexOf$default((CharSequence)"boxX", (String)this.spec.getType(), (int)0, (boolean)false, (int)6, null) > -1) {
                StringBuilder stringBuilder = new StringBuilder().append('0');
                String string3 = this.spec.getType().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = stringBuilder.append(string3).toString();
            } else {
                string = "";
            }
        } else {
            string = "";
        }
        String prefix = string;
        return Output.copy$default(output, null, null, prefix, null, null, 27, null);
    }

    private final Output computeSuffix(Output res) {
        String string;
        String string2 = string = PERCENT;
        String string3 = null;
        String string4 = null;
        FormattedNumber formattedNumber = null;
        Output output = res;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)this.spec.getType(), (Object)PERCENT);
        String string5 = bl2 ? string : null;
        if (string5 == null) {
            string5 = "";
        }
        return Output.copy$default(output, formattedNumber, string4, string3, string5, null, 23, null);
    }

    private final Output computePadding(Output output) {
        int length = output.getSign().length() + output.getPrefix().length() + output.getBody().getFullLength() + output.getSuffix().length();
        String padding = length < this.spec.getWidth() ? StringsKt.repeat((CharSequence)this.spec.getFill(), (int)(this.spec.getWidth() - length)) : "";
        return Output.copy$default(output, null, null, null, null, padding, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0004J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Companion;", "", "()V", "COMMA", "", "CURRENCY", "DEF_EXPONENT_NOTATION_TYPE", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "DEF_MIN_EXP", "", "DEF_PRECISION", "DEF_WIDTH", "EXPONENT_TYPES_REGEX", "FRACTION_DELIMITER", "GROUP_SIZE", "MULT_SIGN", "NUMBER_REGEX", "Lkotlin/text/Regex;", "PERCENT", "TYPE_S_MAX", "", "group", "str", "isValidPattern", "", "spec", "normalizeSpec", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec;", "normalizeSpec$commons", "parseSpec", "siPrefixFromExponent", "Lorg/jetbrains/letsPlot/commons/formatting/number/SiPrefix;", "e", "siPrefixFromExponent$commons", "commons"})
    @SourceDebugExtension(value={"SMAP\nNumberFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n1#2:302\n288#3,2:303\n2310#3,14:305\n1940#3,14:319\n*S KotlinDebug\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Companion\n*L\n258#1:303,2\n262#1:305,14\n264#1:319,14\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValidPattern(@NotNull String spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            return NUMBER_REGEX.matches((CharSequence)spec);
        }

        @NotNull
        public final Spec parseSpec(@NotNull String spec) {
            Object object;
            Object object2;
            boolean bl;
            boolean bl2;
            int n;
            boolean bl3;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            int precision;
            MatchResult matchResult;
            block10: {
                block9: {
                    Object object7;
                    Object object8;
                    Object object9;
                    Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                    MatchResult matchResult2 = Regex.find$default((Regex)NUMBER_REGEX, (CharSequence)spec, (int)0, (int)2, null);
                    if (matchResult2 == null) {
                        throw new IllegalArgumentException("Wrong number format pattern: '" + spec + '\'');
                    }
                    matchResult = matchResult2;
                    Object object10 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"precision");
                    int n2 = precision = object10 != null && (object10 = object10.getValue()) != null ? Integer.parseInt((String)object10) : 6;
                    Object object11 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"fill");
                    if (object11 == null || (object11 = object11.getValue()) == null) {
                        object11 = object6 = " ";
                    }
                    if ((object9 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"align")) == null || (object9 = object9.getValue()) == null) {
                        object9 = object5 = ">";
                    }
                    if ((object8 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"sign")) == null || (object8 = object8.getValue()) == null) {
                        object8 = object4 = "-";
                    }
                    if ((object7 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"symbol")) == null || (object7 = object7.getValue()) == null) {
                        object7 = "";
                    }
                    object3 = object7;
                    bl3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"zero") != null;
                    Object object12 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"width");
                    n = object12 != null && (object12 = object12.getValue()) != null ? Integer.parseInt((String)object12) : -1;
                    bl2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"comma") != null;
                    bl = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"trim") != null;
                    Object object13 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"type");
                    if (object13 == null || (object13 = object13.getValue()) == null) {
                        object13 = object2 = "";
                    }
                    if ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"exptype")) == null || (object = object.getValue()) == null) break block9;
                    Object it = object;
                    boolean bl4 = false;
                    ExponentNotationType exponentNotationType = ExponentNotationType.Companion.bySymbol((String)it);
                    object = exponentNotationType;
                    if (exponentNotationType != null) break block10;
                }
                object = DEF_EXPONENT_NOTATION_TYPE;
            }
            Object object14 = object;
            Object object15 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"minexp");
            int n3 = object15 != null && (object15 = object15.getValue()) != null ? Integer.parseInt((String)object15) : -7;
            Object object16 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"maxexp");
            int n4 = object16 != null && (object16 = object16.getValue()) != null ? Integer.parseInt((String)object16) : precision;
            Spec formatSpec = new Spec((String)object6, (String)object5, (String)object4, (String)object3, bl3, n, bl2, precision, (String)object2, bl, (ExponentNotationType)((Object)object14), n3, n4);
            return this.normalizeSpec$commons(formatSpec);
        }

        @NotNull
        public final SiPrefix siPrefixFromExponent$commons(int e) {
            SiPrefix siPrefix;
            SiPrefix it;
            Iterator iterator$iv;
            SiPrefix prefix;
            Object v1;
            SiPrefix it2;
            block12: {
                Iterable $this$firstOrNull$iv = (Iterable)SiPrefix.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it2 = (SiPrefix)((Object)element$iv);
                    boolean bl = false;
                    IntRange intRange = it2.getExponentRange();
                    int n = intRange.getFirst();
                    boolean bl2 = e <= intRange.getLast() ? n <= e : false;
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block12;
                }
                v1 = null;
            }
            SiPrefix siPrefix2 = prefix = (SiPrefix)v1;
            if (siPrefix2 != null) {
                return siPrefix2;
            }
            if (e < 0) {
                Object t;
                Iterable $this$minBy$iv = (Iterable)SiPrefix.getEntries();
                boolean $i$f$minByOrThrow = false;
                iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = minElem$iv;
                } else {
                    it2 = (SiPrefix)((Object)minElem$iv);
                    boolean bl = false;
                    int minValue$iv = it2.getExponentRange().getFirst();
                    do {
                        Object e$iv = iterator$iv.next();
                        it = (SiPrefix)((Object)e$iv);
                        $i$a$-minByOrThrow-NumberFormat$Companion$siPrefixFromExponent$1 = false;
                        int v$iv = it.getExponentRange().getFirst();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = minElem$iv;
                }
                siPrefix = (SiPrefix)((Object)t);
            } else {
                Object t;
                Iterable $this$maxBy$iv = (Iterable)SiPrefix.getEntries();
                boolean $i$f$maxByOrThrow = false;
                iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    t = maxElem$iv;
                } else {
                    it2 = (SiPrefix)((Object)maxElem$iv);
                    boolean bl = false;
                    int maxValue$iv = it2.getExponentRange().getLast();
                    do {
                        Object e$iv = iterator$iv.next();
                        it = (SiPrefix)((Object)e$iv);
                        $i$a$-maxByOrThrow-NumberFormat$Companion$siPrefixFromExponent$2 = false;
                        int v$iv = it.getExponentRange().getLast();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    t = maxElem$iv;
                }
                siPrefix = (SiPrefix)((Object)t);
            }
            return siPrefix;
        }

        @NotNull
        public final Spec normalizeSpec$commons(@NotNull Spec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            int precision = spec.getPrecision();
            String type = spec.getType();
            boolean trim = spec.getTrim();
            if (Intrinsics.areEqual((Object)type, (Object)"")) {
                if (precision == -1) {
                    precision = 12;
                }
                type = "g";
                trim = true;
            }
            boolean zero = spec.getZero();
            String fill2 = spec.getFill();
            String align = spec.getAlign();
            if (zero || Intrinsics.areEqual((Object)fill2, (Object)"0") && Intrinsics.areEqual((Object)align, (Object)"=")) {
                zero = true;
                fill2 = "0";
                align = "=";
            }
            return Spec.copy$default(spec, fill2, align, null, null, zero, 0, false, precision, type, trim, null, 0, 0, 7276, null);
        }

        private final String group(String str) {
            return ((Object)StringsKt.reversed((CharSequence)SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)StringsKt.asSequence((CharSequence)((Object)StringsKt.reversed((CharSequence)str)).toString()), (int)3), (Function1)group.1.INSTANCE), (CharSequence)NumberFormat.COMMA, null, null, (int)0, null, null, (int)62, null))).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "", "symbol", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSymbol", "()Ljava/lang/String;", "E", "POW", "POW_FULL", "Companion", "commons"})
    public static final class ExponentNotationType
    extends Enum<ExponentNotationType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String symbol;
        public static final /* enum */ ExponentNotationType E;
        public static final /* enum */ ExponentNotationType POW;
        public static final /* enum */ ExponentNotationType POW_FULL;
        private static final /* synthetic */ ExponentNotationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ExponentNotationType(String symbol) {
            this.symbol = symbol;
        }

        @NotNull
        public final String getSymbol() {
            return this.symbol;
        }

        public static ExponentNotationType[] values() {
            return (ExponentNotationType[])$VALUES.clone();
        }

        public static ExponentNotationType valueOf(String value) {
            return Enum.valueOf(ExponentNotationType.class, value);
        }

        @NotNull
        public static EnumEntries<ExponentNotationType> getEntries() {
            return $ENTRIES;
        }

        static {
            E = new ExponentNotationType("E");
            POW = new ExponentNotationType("P");
            POW_FULL = new ExponentNotationType("F");
            $VALUES = exponentNotationTypeArray = new ExponentNotationType[]{ExponentNotationType.E, ExponentNotationType.POW, ExponentNotationType.POW_FULL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType$Companion;", "", "()V", "bySymbol", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "symbol", "", "commons"})
        @SourceDebugExtension(value={"SMAP\nNumberFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n223#2,2:302\n*S KotlinDebug\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType$Companion\n*L\n206#1:302,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ExponentNotationType bySymbol(@NotNull String symbol) {
                Object element$iv2;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                    Iterable $this$first$iv = (Iterable)ExponentNotationType.getEntries();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ExponentNotationType it = (ExponentNotationType)((Object)element$iv2);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSymbol(), (Object)symbol)) continue;
                        break block1;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                return (ExponentNotationType)((Object)element$iv2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Output;", "", "body", "Lorg/jetbrains/letsPlot/commons/formatting/number/FormattedNumber;", "sign", "", "prefix", "suffix", "padding", "(Lorg/jetbrains/letsPlot/commons/formatting/number/FormattedNumber;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Lorg/jetbrains/letsPlot/commons/formatting/number/FormattedNumber;", "getPadding", "()Ljava/lang/String;", "getPrefix", "getSign", "getSuffix", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "commons"})
    private static final class Output {
        @NotNull
        private final FormattedNumber body;
        @NotNull
        private final String sign;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;
        @NotNull
        private final String padding;

        public Output(@NotNull FormattedNumber body, @NotNull String sign, @NotNull String prefix, @NotNull String suffix, @NotNull String padding) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            this.body = body;
            this.sign = sign;
            this.prefix = prefix;
            this.suffix = suffix;
            this.padding = padding;
        }

        public /* synthetic */ Output(FormattedNumber formattedNumber, String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                formattedNumber = new FormattedNumber(null, null, null, null, 15, null);
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                string3 = "";
            }
            if ((n & 0x10) != 0) {
                string4 = "";
            }
            this(formattedNumber, string, string2, string3, string4);
        }

        @NotNull
        public final FormattedNumber getBody() {
            return this.body;
        }

        @NotNull
        public final String getSign() {
            return this.sign;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @NotNull
        public final String getPadding() {
            return this.padding;
        }

        @NotNull
        public final FormattedNumber component1() {
            return this.body;
        }

        @NotNull
        public final String component2() {
            return this.sign;
        }

        @NotNull
        public final String component3() {
            return this.prefix;
        }

        @NotNull
        public final String component4() {
            return this.suffix;
        }

        @NotNull
        public final String component5() {
            return this.padding;
        }

        @NotNull
        public final Output copy(@NotNull FormattedNumber body, @NotNull String sign, @NotNull String prefix, @NotNull String suffix, @NotNull String padding) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            return new Output(body, sign, prefix, suffix, padding);
        }

        public static /* synthetic */ Output copy$default(Output output, FormattedNumber formattedNumber, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                formattedNumber = output.body;
            }
            if ((n & 2) != 0) {
                string = output.sign;
            }
            if ((n & 4) != 0) {
                string2 = output.prefix;
            }
            if ((n & 8) != 0) {
                string3 = output.suffix;
            }
            if ((n & 0x10) != 0) {
                string4 = output.padding;
            }
            return output.copy(formattedNumber, string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Output(body=" + this.body + ", sign=" + this.sign + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ", padding=" + this.padding + ')';
        }

        public int hashCode() {
            int result2 = this.body.hashCode();
            result2 = result2 * 31 + this.sign.hashCode();
            result2 = result2 * 31 + this.prefix.hashCode();
            result2 = result2 * 31 + this.suffix.hashCode();
            result2 = result2 * 31 + this.padding.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.body, (Object)output.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sign, (Object)output.sign)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)output.prefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suffix, (Object)output.suffix)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.padding, (Object)output.padding);
        }

        public Output() {
            this(null, null, null, null, null, 31, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b(\b\u0086\b\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\n\u0012\b\b\u0002\u0010\u0012\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\u0010H\u00c6\u0003J\t\u0010(\u001a\u00020\nH\u00c6\u0003J\t\u0010)\u001a\u00020\nH\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\bH\u00c6\u0003J\t\u0010.\u001a\u00020\nH\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\u008b\u0001\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\nH\u00c6\u0001J\u0013\u00103\u001a\u00020\b2\b\u00104\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00105\u001a\u00020\nH\u00d6\u0001J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J\u0006\u00107\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0015R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0017\u00a8\u00068"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec;", "", "fill", "", "align", "sign", "symbol", "zero", "", "width", "", "comma", "precision", "type", "trim", "expType", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "minExp", "maxExp", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZIZILjava/lang/String;ZLorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;II)V", "getAlign", "()Ljava/lang/String;", "getComma", "()Z", "getExpType", "()Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "getFill", "getMaxExp", "()I", "getMinExp", "getPrecision", "getSign", "getSymbol", "getTrim", "getType", "getWidth", "getZero", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "toStringPattern", "commons"})
    @SourceDebugExtension(value={"SMAP\nNumberFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormat.kt\norg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$Spec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n1#2:302\n*E\n"})
    public static final class Spec {
        @NotNull
        private final String fill;
        @NotNull
        private final String align;
        @NotNull
        private final String sign;
        @NotNull
        private final String symbol;
        private final boolean zero;
        private final int width;
        private final boolean comma;
        private final int precision;
        @NotNull
        private final String type;
        private final boolean trim;
        @NotNull
        private final ExponentNotationType expType;
        private final int minExp;
        private final int maxExp;

        public Spec(@NotNull String fill2, @NotNull String align, @NotNull String sign, @NotNull String symbol, boolean zero, int width2, boolean comma, int precision, @NotNull String type, boolean trim, @NotNull ExponentNotationType expType, int minExp, int maxExp) {
            Intrinsics.checkNotNullParameter((Object)fill2, (String)"fill");
            Intrinsics.checkNotNullParameter((Object)align, (String)"align");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)expType), (String)"expType");
            this.fill = fill2;
            this.align = align;
            this.sign = sign;
            this.symbol = symbol;
            this.zero = zero;
            this.width = width2;
            this.comma = comma;
            this.precision = precision;
            this.type = type;
            this.trim = trim;
            this.expType = expType;
            this.minExp = minExp;
            this.maxExp = maxExp;
        }

        public /* synthetic */ Spec(String string, String string2, String string3, String string4, boolean bl, int n, boolean bl2, int n2, String string5, boolean bl3, ExponentNotationType exponentNotationType, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                string = " ";
            }
            if ((n5 & 2) != 0) {
                string2 = ">";
            }
            if ((n5 & 4) != 0) {
                string3 = "-";
            }
            if ((n5 & 8) != 0) {
                string4 = "";
            }
            if ((n5 & 0x10) != 0) {
                bl = false;
            }
            if ((n5 & 0x20) != 0) {
                n = -1;
            }
            if ((n5 & 0x40) != 0) {
                bl2 = false;
            }
            if ((n5 & 0x80) != 0) {
                n2 = 6;
            }
            if ((n5 & 0x100) != 0) {
                string5 = "";
            }
            if ((n5 & 0x200) != 0) {
                bl3 = false;
            }
            if ((n5 & 0x400) != 0) {
                exponentNotationType = DEF_EXPONENT_NOTATION_TYPE;
            }
            if ((n5 & 0x800) != 0) {
                n3 = -7;
            }
            if ((n5 & 0x1000) != 0) {
                n4 = n2;
            }
            this(string, string2, string3, string4, bl, n, bl2, n2, string5, bl3, exponentNotationType, n3, n4);
        }

        @NotNull
        public final String getFill() {
            return this.fill;
        }

        @NotNull
        public final String getAlign() {
            return this.align;
        }

        @NotNull
        public final String getSign() {
            return this.sign;
        }

        @NotNull
        public final String getSymbol() {
            return this.symbol;
        }

        public final boolean getZero() {
            return this.zero;
        }

        public final int getWidth() {
            return this.width;
        }

        public final boolean getComma() {
            return this.comma;
        }

        public final int getPrecision() {
            return this.precision;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final boolean getTrim() {
            return this.trim;
        }

        @NotNull
        public final ExponentNotationType getExpType() {
            return this.expType;
        }

        public final int getMinExp() {
            return this.minExp;
        }

        public final int getMaxExp() {
            return this.maxExp;
        }

        @NotNull
        public final String toStringPattern() {
            String string;
            String it = string = NumberFormat.COMMA;
            boolean bl = false;
            String string2 = this.comma ? string : null;
            if (string2 == null) {
                string2 = "";
            }
            String commaStr = string2;
            it = "0";
            Object it2 = it;
            boolean bl2 = false;
            String string3 = this.zero ? it : null;
            if (string3 == null) {
                string3 = "";
            }
            String zeroStr = string3;
            it2 = this.width;
            int it3 = ((Number)it2).intValue();
            boolean bl3 = false;
            Object object = this.width != -1 ? it2 : null;
            if (object == null || (object = ((Integer)object).toString()) == null) {
                object = "";
            }
            Object widthStr = object;
            String it4 = it3 = "~";
            boolean bl4 = false;
            String string4 = this.trim ? it3 : null;
            if (string4 == null) {
                string4 = "";
            }
            String trimStr = string4;
            String expTypeStr = this.expType.getSymbol();
            Integer n = this.minExp;
            int it5 = ((Number)n).intValue();
            boolean bl5 = false;
            Object object2 = this.minExp != -7 ? n : null;
            if (object2 == null || (object2 = ((Integer)object2).toString()) == null) {
                object2 = "";
            }
            Object minExpStr = object2;
            Integer n2 = this.maxExp;
            int it6 = ((Number)n2).intValue();
            boolean bl6 = false;
            Object object3 = this.maxExp != this.precision ? n2 : null;
            if (object3 == null || (object3 = ((Integer)object3).toString()) == null) {
                object3 = "";
            }
            Object maxExpStr = object3;
            return this.fill + this.align + this.sign + this.symbol + zeroStr + (String)widthStr + commaStr + '.' + this.precision + trimStr + this.type + '&' + expTypeStr + '{' + (String)minExpStr + ',' + (String)maxExpStr + '}';
        }

        @NotNull
        public final String component1() {
            return this.fill;
        }

        @NotNull
        public final String component2() {
            return this.align;
        }

        @NotNull
        public final String component3() {
            return this.sign;
        }

        @NotNull
        public final String component4() {
            return this.symbol;
        }

        public final boolean component5() {
            return this.zero;
        }

        public final int component6() {
            return this.width;
        }

        public final boolean component7() {
            return this.comma;
        }

        public final int component8() {
            return this.precision;
        }

        @NotNull
        public final String component9() {
            return this.type;
        }

        public final boolean component10() {
            return this.trim;
        }

        @NotNull
        public final ExponentNotationType component11() {
            return this.expType;
        }

        public final int component12() {
            return this.minExp;
        }

        public final int component13() {
            return this.maxExp;
        }

        @NotNull
        public final Spec copy(@NotNull String fill2, @NotNull String align, @NotNull String sign, @NotNull String symbol, boolean zero, int width2, boolean comma, int precision, @NotNull String type, boolean trim, @NotNull ExponentNotationType expType, int minExp, int maxExp) {
            Intrinsics.checkNotNullParameter((Object)fill2, (String)"fill");
            Intrinsics.checkNotNullParameter((Object)align, (String)"align");
            Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)expType), (String)"expType");
            return new Spec(fill2, align, sign, symbol, zero, width2, comma, precision, type, trim, expType, minExp, maxExp);
        }

        public static /* synthetic */ Spec copy$default(Spec spec, String string, String string2, String string3, String string4, boolean bl, int n, boolean bl2, int n2, String string5, boolean bl3, ExponentNotationType exponentNotationType, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                string = spec.fill;
            }
            if ((n5 & 2) != 0) {
                string2 = spec.align;
            }
            if ((n5 & 4) != 0) {
                string3 = spec.sign;
            }
            if ((n5 & 8) != 0) {
                string4 = spec.symbol;
            }
            if ((n5 & 0x10) != 0) {
                bl = spec.zero;
            }
            if ((n5 & 0x20) != 0) {
                n = spec.width;
            }
            if ((n5 & 0x40) != 0) {
                bl2 = spec.comma;
            }
            if ((n5 & 0x80) != 0) {
                n2 = spec.precision;
            }
            if ((n5 & 0x100) != 0) {
                string5 = spec.type;
            }
            if ((n5 & 0x200) != 0) {
                bl3 = spec.trim;
            }
            if ((n5 & 0x400) != 0) {
                exponentNotationType = spec.expType;
            }
            if ((n5 & 0x800) != 0) {
                n3 = spec.minExp;
            }
            if ((n5 & 0x1000) != 0) {
                n4 = spec.maxExp;
            }
            return spec.copy(string, string2, string3, string4, bl, n, bl2, n2, string5, bl3, exponentNotationType, n3, n4);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Spec(fill=").append(this.fill).append(", align=").append(this.align).append(", sign=").append(this.sign).append(", symbol=").append(this.symbol).append(", zero=").append(this.zero).append(", width=").append(this.width).append(", comma=").append(this.comma).append(", precision=").append(this.precision).append(", type=").append(this.type).append(", trim=").append(this.trim).append(", expType=").append((Object)this.expType).append(", minExp=");
            stringBuilder.append(this.minExp).append(", maxExp=").append(this.maxExp).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result2 = this.fill.hashCode();
            result2 = result2 * 31 + this.align.hashCode();
            result2 = result2 * 31 + this.sign.hashCode();
            result2 = result2 * 31 + this.symbol.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.zero);
            result2 = result2 * 31 + Integer.hashCode(this.width);
            result2 = result2 * 31 + Boolean.hashCode(this.comma);
            result2 = result2 * 31 + Integer.hashCode(this.precision);
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.trim);
            result2 = result2 * 31 + this.expType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.minExp);
            result2 = result2 * 31 + Integer.hashCode(this.maxExp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spec)) {
                return false;
            }
            Spec spec = (Spec)other;
            if (!Intrinsics.areEqual((Object)this.fill, (Object)spec.fill)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.align, (Object)spec.align)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sign, (Object)spec.sign)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.symbol, (Object)spec.symbol)) {
                return false;
            }
            if (this.zero != spec.zero) {
                return false;
            }
            if (this.width != spec.width) {
                return false;
            }
            if (this.comma != spec.comma) {
                return false;
            }
            if (this.precision != spec.precision) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)spec.type)) {
                return false;
            }
            if (this.trim != spec.trim) {
                return false;
            }
            if (this.expType != spec.expType) {
                return false;
            }
            if (this.minExp != spec.minExp) {
                return false;
            }
            return this.maxExp == spec.maxExp;
        }

        public Spec() {
            this(null, null, null, null, false, 0, false, 0, null, false, null, 0, 0, 8191, null);
        }
    }
}

