/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl.layout;

import com.intellij.indexing.shared.platform.api.layout.SharedIndexLocation;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.indexing.shared.util.zipFs.UncompressedZipFileSystem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0002\u001a\u001bB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ0\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedIndexLocation;", "K", "V", "Lcom/intellij/indexing/shared/platform/api/layout/SharedIndexLocation;", "indexRoot", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getIndexRoot", "()Ljava/nio/file/Path;", "getStorageFileName", "extension", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexExtension;", "getStorageFileName$intellij_indexing_shared", "createStorage", "Lcom/intellij/util/indexing/impl/IndexStorage;", "sharedExtension", "hashToFileId", "Lcom/intellij/util/indexing/impl/ValueContainerInputRemapping;", "isPrebuilt", "", "createForwardIndex", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "readOnly", "toString", "", "MyMapIndexStorage", "Companion", "intellij.indexing.shared"})
public class FileBasedSharedIndexLocation<K, V>
implements SharedIndexLocation<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path indexRoot;

    public FileBasedSharedIndexLocation(@NotNull Path indexRoot) {
        Intrinsics.checkNotNullParameter((Object)indexRoot, (String)"indexRoot");
        this.indexRoot = indexRoot;
    }

    @NotNull
    protected final Path getIndexRoot() {
        return this.indexRoot;
    }

    @NotNull
    public final Path getStorageFileName$intellij_indexing_shared(@NotNull SharedIndexExtension<K, V> extension) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        String string = extension.getFileBasedIndexExtension().getName().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String other = string;
        Path path = this.indexRoot.resolve(other);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    @NotNull
    public IndexStorage<K, V> createStorage(@NotNull SharedIndexExtension<K, V> sharedExtension, @NotNull ValueContainerInputRemapping hashToFileId) throws IOException {
        Intrinsics.checkNotNullParameter(sharedExtension, (String)"sharedExtension");
        Intrinsics.checkNotNullParameter((Object)hashToFileId, (String)"hashToFileId");
        MapIndexStorage x = new MyMapIndexStorage<K, V>(this.getStorageFileName$intellij_indexing_shared(sharedExtension), sharedExtension, hashToFileId);
        return (IndexStorage)x;
    }

    @Override
    public boolean isPrebuilt() {
        FileSystem fs = this.indexRoot.getFileSystem();
        return fs instanceof UncompressedZipFileSystem && ((UncompressedZipFileSystem)fs).isPrebuilt();
    }

    @Override
    @NotNull
    public ForwardIndex createForwardIndex(@NotNull SharedIndexExtension<K, V> extension, boolean readOnly) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        Path storageFile = this.indexRoot.resolve(extension.getFileBasedIndexExtension().getName().getName());
        Intrinsics.checkNotNull((Object)storageFile);
        return (ForwardIndex)new PersistentMapBasedForwardIndex(Companion.getForwardIndexPath(storageFile), readOnly);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(indexRoot=" + this.indexRoot + ")";
    }

    @JvmStatic
    @NotNull
    public static final Path getForwardIndexPath(@NotNull Path storageFile) {
        return Companion.getForwardIndexPath(storageFile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedIndexLocation$Companion;", "", "<init>", "()V", "getForwardIndexPath", "Ljava/nio/file/Path;", "storageFile", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Path getForwardIndexPath(@NotNull Path storageFile) {
            Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
            Path path = storageFile.resolveSibling(storageFile.getFileName() + ".forward");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\u0012\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u0004B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ,\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/platform/impl/layout/FileBasedSharedIndexLocation$MyMapIndexStorage;", "Key", "Value", "Lcom/intellij/util/indexing/impl/MapIndexStorage;", "Lcom/intellij/util/indexing/VfsAwareIndexStorage;", "baseFile", "Ljava/nio/file/Path;", "sharedExtension", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexExtension;", "hashToFileIds", "Lcom/intellij/util/indexing/impl/ValueContainerInputRemapping;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/indexing/shared/platform/impl/SharedIndexExtension;Lcom/intellij/util/indexing/impl/ValueContainerInputRemapping;)V", "processKeys", "", "processor", "Lcom/intellij/util/Processor;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "idFilter", "Lcom/intellij/util/indexing/IdFilter;", "intellij.indexing.shared"})
    private static final class MyMapIndexStorage<Key, Value>
    extends MapIndexStorage<Key, Value>
    implements VfsAwareIndexStorage<Key, Value> {
        public MyMapIndexStorage(@NotNull Path baseFile, @NotNull SharedIndexExtension<Key, Value> sharedExtension, @NotNull ValueContainerInputRemapping hashToFileIds) {
            Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
            Intrinsics.checkNotNullParameter(sharedExtension, (String)"sharedExtension");
            Intrinsics.checkNotNullParameter((Object)hashToFileIds, (String)"hashToFileIds");
            super(baseFile, sharedExtension.getFileBasedIndexExtension().getKeyDescriptor(), sharedExtension.getFileBasedIndexExtension().getValueExternalizer(), sharedExtension.getFileBasedIndexExtension().getCacheSize(), sharedExtension.getFileBasedIndexExtension().keyIsUniqueForIndexedFile(), true, true, sharedExtension.getFileBasedIndexExtension().enableWal(), hashToFileIds);
        }

        public boolean processKeys(@NotNull Processor<? super Key> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            return super.processKeys(processor);
        }
    }
}

