/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.ReplaceSubstringFunction;
import com.jetbrains.python.console.completion.PydevConsoleElement;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u000eH\u0002\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u001a(\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u001a`\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00170\u00160\u001a2 \u0010\u001b\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016j\n\u0012\u0004\u0012\u00020\u0017\u0018\u0001`\u00182\u0006\u0010\u001c\u001a\u00020\u0017\u001a.\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001e2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001e\u001a\u001c\u0010 \u001a\u00020!2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u001eH\u0002\u001a\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#\u001a\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'\u001a\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002\u001a\u000e\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+\u001a\u0012\u0010,\u001a\u0004\u0018\u00010-2\b\u0010&\u001a\u0004\u0018\u00010.\u001a\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010&\u001a\u00020'H\u0002\u001a\u0010\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020'\u001a\u0016\u00102\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00103\u001a\u000204\u00a8\u00065"}, d2={"createTargetEnvironmentPathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "consoleSettings", "Lcom/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings;", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "getPathMapper", "data", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "appendBasicMappings", "Lcom/intellij/remote/RemoteSdkProperties;", "remoteSdkAdditionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "findPythonSdkAndModule", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/module/Module;", "contextModule", "constructPyPathAndWorkingDirCommand", "Ljava/util/function/Function;", "", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "pythonPath", "", "workingDirFunction", "command", "addDefaultEnvironments", "", "envs", "setCorrectStdOutEncoding", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "isInPydevConsole", "", "element", "Lcom/intellij/psi/PsiElement;", "hasConsoleKey", "isConsoleView", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPythonConsoleData", "Lcom/jetbrains/python/parsing/console/PythonConsoleData;", "Lcom/intellij/lang/ASTNode;", "getConsoleCommunication", "Lcom/jetbrains/python/console/pydev/ConsoleCommunication;", "getConsoleSdk", "getModuleToStartConsole", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "intellij.python.community.impl"})
@JvmName(name="PydevConsoleRunnerUtil")
@SourceDebugExtension(value={"SMAP\nPydevConsoleRunnerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PydevConsoleRunnerUtil.kt\ncom/jetbrains/python/console/PydevConsoleRunnerUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,270:1\n1310#2:271\n12364#2,2:272\n1311#2:274\n*S KotlinDebug\n*F\n+ 1 PydevConsoleRunnerUtil.kt\ncom/jetbrains/python/console/PydevConsoleRunnerUtil\n*L\n260#1:271\n262#1:272,2\n260#1:274\n*E\n"})
public final class PydevConsoleRunnerUtil {
    @NotNull
    public static final PyRemotePathMapper createTargetEnvironmentPathMapper(@NotNull Project project, @NotNull Sdk sdk2, @NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @NotNull TargetEnvironment targetEnvironment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)consoleSettings, (String)"consoleSettings");
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        PyRemotePathMapper pyRemotePathMapper = PydevConsoleRunnerUtil.getPathMapper(project, sdk2, consoleSettings);
        if (pyRemotePathMapper == null) {
            pyRemotePathMapper = new PyRemotePathMapper();
        }
        PyRemotePathMapper pathMapper = pyRemotePathMapper;
        for (TargetEnvironment.UploadableVolume volume : targetEnvironment.getUploadVolumes().values()) {
            pathMapper.addMapping(((Object)volume.getLocalRoot()).toString(), volume.getTargetRoot(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return pathMapper;
    }

    @Nullable
    public static final PyRemotePathMapper getPathMapper(@NotNull Project project, @Nullable Sdk sdk2, @NotNull PyConsoleOptions.PyConsoleSettings consoleSettings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleSettings, (String)"consoleSettings");
        if (sdk2 == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        return sdkAdditionalData instanceof PyTargetAwareAdditionalData ? PydevConsoleRunnerUtil.getPathMapper(project, consoleSettings, (PyTargetAwareAdditionalData)sdkAdditionalData) : (sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase ? PydevConsoleRunnerUtil.getPathMapper(project, consoleSettings, (PyRemoteSdkAdditionalDataBase)sdkAdditionalData) : null);
    }

    private static final PyRemotePathMapper getPathMapper(Project project, PyConsoleOptions.PyConsoleSettings consoleSettings, PyTargetAwareAdditionalData data) {
        PyRemotePathMapper remotePathMapper;
        block0: {
            remotePathMapper = PydevConsoleRunnerUtil.appendBasicMappings(project, data);
            PathMappingSettings pathMappingSettings = consoleSettings.getMappingSettings();
            if (pathMappingSettings == null) break block0;
            PathMappingSettings mappingSettings = pathMappingSettings;
            boolean bl = false;
            remotePathMapper.addAll(mappingSettings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return remotePathMapper;
    }

    private static final PyRemotePathMapper appendBasicMappings(Project project, RemoteSdkProperties data) {
        PyRemotePathMapper pathMapper = new PyRemotePathMapper();
        PythonRemoteInterpreterManager.addHelpersMapping(data, pathMapper);
        pathMapper.addAll(data.getPathMappings().getPathMappings(), PyRemotePathMapper.PyPathMappingType.SYS_PATH);
        RemoteMappingsManager.Mappings mappings = RemoteMappingsManager.getInstance((Project)project).getForServer("python", data.getSdkId());
        if (mappings != null) {
            pathMapper.addAll(mappings.getSettings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return pathMapper;
    }

    @NotNull
    public static final PyRemotePathMapper getPathMapper(@NotNull Project project, @NotNull PyConsoleOptions.PyConsoleSettings consoleSettings, @NotNull PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleSettings, (String)"consoleSettings");
        Intrinsics.checkNotNullParameter((Object)remoteSdkAdditionalData, (String)"remoteSdkAdditionalData");
        PyRemotePathMapper pyRemotePathMapper = PythonRemoteInterpreterManager.appendBasicMappings(project, null, remoteSdkAdditionalData);
        Intrinsics.checkNotNullExpressionValue((Object)pyRemotePathMapper, (String)"appendBasicMappings(...)");
        PyRemotePathMapper remotePathMapper = pyRemotePathMapper;
        PathMappingSettings mappingSettings = consoleSettings.getMappingSettings();
        if (mappingSettings != null) {
            remotePathMapper.addAll(mappingSettings.getPathMappings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        }
        return remotePathMapper;
    }

    @NotNull
    public static final Pair<Sdk, Module> findPythonSdkAndModule(@NotNull Project project, @Nullable Module contextModule) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk2 = null;
        Module module = null;
        PyConsoleOptions.PyConsoleSettings pyConsoleSettings = PyConsoleOptions.getInstance(project).getPythonConsoleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)pyConsoleSettings, (String)"getPythonConsoleSettings(...)");
        PyConsoleOptions.PyConsoleSettings settings = pyConsoleSettings;
        String sdkHome = settings.getSdkHome();
        if (sdkHome != null) {
            sdk2 = PythonSdkUtil.findSdkByPath(sdkHome);
            if (settings.getModuleName() != null) {
                ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
                String string = settings.getModuleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleName(...)");
                module = moduleManager.findModuleByName(string);
            } else {
                module = contextModule;
                if (module == null && !(ModuleManager.Companion.getInstance(project).getModules().length == 0)) {
                    module = ModuleManager.Companion.getInstance(project).getModules()[0];
                }
            }
        }
        if (sdk2 == null && settings.isUseModuleSdk()) {
            if (contextModule != null) {
                module = contextModule;
            } else if (settings.getModuleName() != null) {
                ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
                String string = settings.getModuleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleName(...)");
                module = moduleManager.findModuleByName(string);
            }
            if (module != null && PythonSdkUtil.findPythonSdk(module) != null) {
                sdk2 = PythonSdkUtil.findPythonSdk(module);
            }
        } else if (contextModule != null) {
            if (module == null) {
                module = contextModule;
            }
            if (sdk2 == null) {
                sdk2 = PythonSdkUtil.findPythonSdk(module);
            }
        }
        if (sdk2 == null) {
            for (Module m : ModuleManager.Companion.getInstance(project).getModules()) {
                if (PythonSdkUtil.findPythonSdk(m) == null) continue;
                sdk2 = PythonSdkUtil.findPythonSdk(m);
                module = m;
                break;
            }
        }
        if (sdk2 == null && PythonSdkUtil.getAllSdks().size() > 0) {
            sdk2 = PythonSdkUtil.getAllSdks().get(0);
        }
        Pair pair = Pair.create((Object)sdk2, (Object)module);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    @NotNull
    public static final Function<TargetEnvironment, String> constructPyPathAndWorkingDirCommand(@NotNull Collection<Function<TargetEnvironment, String>> pythonPath, @Nullable Function<TargetEnvironment, String> workingDirFunction, @NotNull String command) {
        Intrinsics.checkNotNullParameter(pythonPath, (String)"pythonPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (workingDirFunction != null) {
            pythonPath.add(workingDirFunction);
        }
        Function path2 = TargetEnvironmentFunctions.andThenJoinToString((Function)TargetEnvironmentFunctions.toLinkedSetFunction((Iterable)pythonPath), (CharSequence)", ", (Function1)constructPyPathAndWorkingDirCommand.path.1.INSTANCE);
        return (Function)((Object)new ReplaceSubstringFunction(command, "WORKING_DIR_AND_PYTHON_PATHS", path2));
    }

    @NotNull
    public static final Map<String, String> addDefaultEnvironments(@NotNull Sdk sdk2, @NotNull Map<String, String> envs) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        PydevConsoleRunnerUtil.setCorrectStdOutEncoding(envs);
        PythonEnvUtil.initPythonPath(envs, true, (Collection<String>)PythonCommandLineState.getAddedPaths(sdk2));
        return envs;
    }

    private static final void setCorrectStdOutEncoding(Map<String, String> envs) {
        Charset defaultCharset = PydevConsoleRunnerImpl.CONSOLE_CHARSET;
        String encoding = defaultCharset.name();
        PythonEnvUtil.setPythonIOEncoding(PythonEnvUtil.setPythonUnbuffered(envs), encoding);
    }

    public static final void setCorrectStdOutEncoding(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Charset defaultCharset = PydevConsoleRunnerImpl.CONSOLE_CHARSET;
        commandLine.setCharset(defaultCharset);
        PythonEnvUtil.setPythonIOEncoding(commandLine.getEnvironment(), defaultCharset.name());
    }

    public static final boolean isInPydevConsole(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PydevConsoleElement || PydevConsoleRunnerUtil.getConsoleCommunication(element) != null || PydevConsoleRunnerUtil.hasConsoleKey(element);
    }

    private static final boolean hasConsoleKey(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        if (psiFile2.getVirtualFile() == null) {
            return false;
        }
        Boolean inConsole = (Boolean)element.getContainingFile().getVirtualFile().getUserData(PythonConsoleView.CONSOLE_KEY);
        return inConsole != null && inConsole != false;
    }

    public static final boolean isConsoleView(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getUserData(PythonConsoleView.CONSOLE_KEY), (Object)true);
    }

    @Nullable
    public static final PythonConsoleData getPythonConsoleData(@Nullable ASTNode element) {
        if (element == null || element.getPsi() == null || element.getPsi().getContainingFile() == null) {
            return null;
        }
        VirtualFile virtualFile = PydevConsoleRunnerImpl.getConsoleFile(element.getPsi().getContainingFile());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return (PythonConsoleData)file.getUserData(PyConsoleUtil.PYTHON_CONSOLE_DATA);
    }

    private static final ConsoleCommunication getConsoleCommunication(PsiElement element) {
        PsiFile containingFile;
        PsiFile psiFile = containingFile = element.getContainingFile();
        return psiFile != null ? (ConsoleCommunication)psiFile.getCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY) : null;
    }

    @Nullable
    public static final Sdk getConsoleSdk(@NotNull PsiElement element) {
        PsiFile containingFile;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = containingFile = element.getContainingFile();
        return psiFile != null ? (Sdk)psiFile.getCopyableUserData(PydevConsoleRunner.CONSOLE_SDK) : null;
    }

    @NotNull
    public static final Module getModuleToStartConsole(@NotNull Project project, @NotNull ModuleManager moduleManager) {
        Module projectLocalModule;
        block9: {
            Module module;
            Module moduleForOpenedFile;
            Module module2;
            block7: {
                VirtualFile[] selectedFiles;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)moduleManager, (String)"moduleManager");
                VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getSelectedFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
                for (VirtualFile it : selectedFiles = virtualFileArray) {
                    boolean bl = false;
                    boolean isLocalFs = it.isInLocalFileSystem();
                    module2 = !isLocalFs ? null : ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)project);
                    if (module2 == null) {
                        continue;
                    }
                    break block7;
                }
                module2 = null;
            }
            if ((moduleForOpenedFile = module2) != null) {
                return moduleForOpenedFile;
            }
            Module[] $this$firstOrNull$iv = moduleManager.getModules();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                Module element$iv;
                block8: {
                    VirtualFile[] roots;
                    Module it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)BasePySdkExtKt.getRootManager(it).getContentRoots(), (String)"getContentRoots(...)");
                    VirtualFile[] $this$all$iv = roots;
                    boolean $i$f$all = false;
                    int n2 = $this$all$iv.length;
                    for (int j = 0; j < n2; ++j) {
                        VirtualFile element$iv2;
                        VirtualFile it2 = element$iv2 = $this$all$iv[j];
                        boolean bl3 = false;
                        if (it2.isInLocalFileSystem()) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
                if (!bl) continue;
                module = element$iv;
                break block9;
            }
            module = projectLocalModule = null;
        }
        if (projectLocalModule != null) {
            return projectLocalModule;
        }
        Module module = (Module)ArraysKt.firstOrNull((Object[])moduleManager.getModules());
        if (module == null) {
            throw new IllegalStateException("Module must not be null when running python console");
        }
        return module;
    }
}

