/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHintKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.model.ActionCallStrategyKind;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.actions.base.ActionContinuation;
import com.jetbrains.rdclient.actions.base.ActionContinuationHolder;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListener;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListenerKt;
import com.jetbrains.rdclient.actions.base.FrontendActionUpdateTrait;
import com.jetbrains.rdclient.actions.cwm.FrontendAsyncActionHost;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editorActions.cwm.EditorActionCommandInfo;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandler;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandlerKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendCallEditorActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionHandlerStrategyCustomizer;
import com.jetbrains.rdclient.editorActions.cwm.PhantomCallEditorActionRequest;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.requests.FrontendApplyPatchRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResultKt;
import com.jetbrains.rdclient.requests.FrontendSpeculativeRequestRecordingListener;
import com.jetbrains.rdclient.services.RdActionsSupport;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0003\u001b\u001c\u001dB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J*\u0010\u0019\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Lcom/jetbrains/rdclient/actions/base/FrontendActionUpdateTrait;", "frontendId", "", "baseHandler", "backendDeclaredStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;)V", "getBackendDeclaredStrategy", "()Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "getCallStrategy", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "backendIsEnabled", "", "isEnabledForCaret", "doExecute", "", "strategy", "doExecuteByStrategy", "tryFrontend", "CallEditorActionRequestFactory", "LocalCallEditorActionRequestFactory", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendAsyncEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,291:1\n107#2:292\n98#2,4:293\n103#2:297\n98#2,4:298\n106#2:324\n98#2,4:325\n45#3,2:302\n48#3,3:305\n51#3,2:313\n53#3,8:316\n25#4:304\n59#4:308\n37#4,2:309\n84#4,2:311\n86#4:315\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler\n*L\n114#1:292\n114#1:293,4\n118#1:297\n118#1:298,4\n171#1:324\n171#1:325,4\n146#1:302,2\n146#1:305,3\n146#1:313,2\n146#1:316,8\n146#1:304\n146#1:308\n146#1:309,2\n146#1:311,2\n146#1:315\n*E\n"})
public final class FrontendAsyncEditorActionHandler
extends EditorActionHandler
implements FrontendActionUpdateTrait {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String frontendId;
    @NotNull
    private final EditorActionHandler baseHandler;
    @NotNull
    private final ActionCallStrategyKind backendDeclaredStrategy;
    @NotNull
    private static final Set<String> TRAVERSAL_ACTIONS_IDS;
    private static boolean isExecuting;

    public FrontendAsyncEditorActionHandler(@NotNull String frontendId, @NotNull EditorActionHandler baseHandler, @NotNull ActionCallStrategyKind backendDeclaredStrategy) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        Intrinsics.checkNotNullParameter((Object)backendDeclaredStrategy, (String)"backendDeclaredStrategy");
        this.frontendId = frontendId;
        this.baseHandler = baseHandler;
        this.backendDeclaredStrategy = backendDeclaredStrategy;
    }

    @NotNull
    public final ActionCallStrategyKind getBackendDeclaredStrategy() {
        return this.backendDeclaredStrategy;
    }

    @NotNull
    public final ActionCallStrategyKind getCallStrategy(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ActionCallStrategyKind actionCallStrategyKind = Companion.getCallStrategy(this.frontendId, editor, caret, dataContext);
        if (actionCallStrategyKind == null) {
            actionCallStrategyKind = this.backendDeclaredStrategy;
        }
        return actionCallStrategyKind;
    }

    private final boolean backendIsEnabled(Editor editor, DataContext dataContext) {
        return DocumentExKt.getTextControlId(editor) != null && FrontendActionUpdateTrait.super.frontendUpdate(this.frontendId, dataContext, null, "unknown", null);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return this.baseHandler.isEnabled(editor, caret, dataContext);
        }
        if (DocumentExKt.getTextControlId(editor) == null) {
            return this.baseHandler.isEnabled(editor, caret, dataContext);
        }
        ActionCallStrategyKind strategy2 = this.getCallStrategy(editor, caret, dataContext);
        switch (WhenMappings.$EnumSwitchMapping$0[strategy2.ordinal()]) {
            case 1: 
            case 2: {
                return this.baseHandler.isEnabled(editor, caret, dataContext);
            }
            case 3: {
                return this.baseHandler.isEnabled(editor, caret, dataContext) && this.backendIsEnabled(editor, dataContext);
            }
            case 4: {
                return this.backendIsEnabled(editor, dataContext) || this.baseHandler.isEnabled(editor, caret, dataContext);
            }
            case 5: {
                Boolean actionAvailableByHint = EditorActionAvailabilityHintKt.isActionAvailableByHint$default((Editor)editor, (int)editor.getCaretModel().getOffset(), (String)this.frontendId, null, (int)4, null);
                return Intrinsics.areEqual((Object)actionAvailableByHint, (Object)true);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            this.baseHandler.execute(editor, caret, dataContext);
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        ActionCallStrategyKind strategy2 = this.getCallStrategy(editor, caret, dataContext);
        if (isExecuting) {
            void $this$log$iv$iv;
            if (strategy2 == ActionCallStrategyKind.FrontendOnly || strategy2 == ActionCallStrategyKind.FrontendFirst) {
                if (this.baseHandler.isEnabled(editor, caret, dataContext)) {
                    this.baseHandler.execute(editor, caret, dataContext);
                }
                return;
            }
            Logger $this$error$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
            boolean $i$f$error = false;
            Logger logger = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_18 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Nested action '" + this.frontendId + "' call: FrontendAsyncEditorActionHandler.doExecute";
                var11_18.log(logLevel, (Object)string, null);
            }
            return;
        }
        Logger $this$trace$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        Logger $this$log$iv$iv = $this$trace$iv;
        LogLevel level$iv$iv = LogLevel.Trace;
        boolean $i$f$log = false;
        if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
            LogLevel logLevel = level$iv$iv;
            Logger logger = $this$log$iv$iv;
            boolean bl = false;
            String string = "For action " + this.frontendId + " selected strategy is " + strategy2;
            logger.log(logLevel, (Object)string, null);
        }
        try {
            isExecuting = true;
            this.doExecute(editor, caret, dataContext, strategy2);
        }
        finally {
            isExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doExecute(Editor editor, Caret caret, DataContext dataContext, ActionCallStrategyKind strategy2) {
        switch (WhenMappings.$EnumSwitchMapping$0[strategy2.ordinal()]) {
            case 1: {
                RdPatch rdPatch;
                AutoCloseable $this$thisLogger$iv$iv;
                void $this$recordChanges$iv;
                ClientAppSession session = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
                if (session == null || FrontendPatchEngineKt.getEngine(session).getHasActivePatch()) {
                    FrontendAsyncEditorActionHandler.doExecute$executeFrontend(this, editor, caret, dataContext);
                    return;
                }
                ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor);
                PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(session);
                String description$iv = "Action handler " + this.frontendId;
                boolean $i$f$recordChanges = false;
                if ($this$recordChanges$iv.getHasActivePatch()) {
                    $this$thisLogger$iv$iv = $this$recordChanges$iv;
                    boolean $i$f$thisLogger = false;
                    com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(PatchEngine.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
                }
                try {
                    RdPatch rdPatch2;
                    $this$thisLogger$iv$iv = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
                    Throwable throwable = null;
                    try {
                        Object object;
                        void $this$runAndLogException$iv$iv;
                        RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)$this$thisLogger$iv$iv;
                        boolean bl5 = false;
                        boolean $i$f$fileLogger22 = false;
                        boolean $i$f$currentClassLogger = false;
                        Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(clazz$iv$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        com.intellij.openapi.diagnostic.Logger $i$f$fileLogger22 = logger;
                        boolean $i$f$runAndLogException = false;
                        void var17_29 = $this$runAndLogException$iv$iv;
                        try {
                            void $this$runAndLogException_u24lambda_u240$iv$iv = var17_29;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ChangeScope $this$doExecute_u24lambda_u242 = it$iv.getSession().getChangeScope();
                            boolean bl4 = false;
                            FrontendAsyncEditorActionHandler.doExecute$executeFrontend(this, editor, caret, dataContext);
                            object = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable2) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        LoggerKt.getOrLogException((Object)object, (com.intellij.openapi.diagnostic.Logger)$this$runAndLogException$iv$iv);
                        rdPatch2 = it$iv.getSession().getPatch();
                    }
                    catch (Throwable bl5) {
                        try {
                            throwable = bl5;
                            throw bl5;
                        }
                        catch (Throwable bl5) {
                            AutoCloseableKt.closeFinally((AutoCloseable)$this$thisLogger$iv$iv, throwable);
                            throw bl5;
                        }
                    }
                    AutoCloseableKt.closeFinally((AutoCloseable)$this$thisLogger$iv$iv, (Throwable)throwable);
                    rdPatch = rdPatch2;
                }
                finally {
                    if ($this$recordChanges$iv.getHasActivePatch()) {
                        void $this$thisLogger$iv$iv2 = $this$recordChanges$iv;
                        boolean $i$f$thisLogger = false;
                        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(PatchEngine.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                        while ($this$recordChanges$iv.getHasActivePatch()) {
                            $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                        }
                    }
                }
                RdPatch patch = rdPatch;
                if (patch != null) {
                    FrontendAsyncRequestExecutor.Companion.getInstance(session).submitRequest(new FrontendApplyPatchRequest(patch, session, resetUndoHistoryToken));
                }
                return;
            }
            case 3: {
                this.doExecuteByStrategy(editor, caret, dataContext, true);
                return;
            }
            case 2: 
            case 4: {
                this.doExecuteByStrategy(editor, caret, dataContext, false);
                break;
            }
            case 5: {
                void $this$log$iv$iv;
                Boolean availableByHint = EditorActionAvailabilityHintKt.isActionAvailableByHint$default((Editor)editor, (int)editor.getCaretModel().getOffset(), (String)this.frontendId, null, (int)4, null);
                if (Intrinsics.areEqual((Object)availableByHint, (Object)true)) {
                    this.doExecuteByStrategy(editor, caret, dataContext, false);
                    break;
                }
                Logger $this$warn$iv = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
                boolean $i$f$warn = false;
                Logger $this$recordChanges$iv = $this$warn$iv;
                LogLevel level$iv$iv = LogLevel.Warn;
                boolean $i$f$log = false;
                if (!$this$log$iv$iv.isEnabled(level$iv$iv)) break;
                LogLevel logLevel = level$iv$iv;
                void var27_43 = $this$log$iv$iv;
                boolean bl = false;
                String string = "Action '" + this.frontendId + "' is not available by availability hint but still was called for execution. Skipping.";
                var27_43.log(logLevel, (Object)string, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void doExecuteByStrategy(Editor editor, Caret caret, DataContext dataContext, boolean tryFrontend) {
        ClientAppSession clientAppSession = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
        if (clientAppSession == null) {
            this.baseHandler.execute(editor, caret, dataContext);
            return;
        }
        ClientAppSession session = clientAppSession;
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        if (textControlId == null) {
            this.baseHandler.execute(editor, caret, dataContext);
            return;
        }
        TextControlId editorId = textControlId;
        if (!((Boolean)FrontendSessionsUtilKt.isConnected(session).getValue()).booleanValue() || FrontendPatchEngineKt.getEngine(session).getHasActivePatch()) {
            this.baseHandler.execute(editor, caret, dataContext);
            return;
        }
        Object object = ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendActionExecutionListener.Companion.getTOPIC());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        FrontendActionExecutionListenerKt.beforeActionExecutedOnBackend((FrontendActionExecutionListener)object, this.frontendId);
        if (tryFrontend) {
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            Disposable disposable = ((EditorImpl)editor).getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            Lifetime lifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
            RdCoroutinesUtilKt.launchOnUi$default((Lifetime)lifetime, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor, dataContext, session, editorId, caret, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ FrontendAsyncEditorActionHandler this$0;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ DataContext $dataContext;
                final /* synthetic */ ClientAppSession $session;
                final /* synthetic */ TextControlId $editorId;
                final /* synthetic */ Caret $caret;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    this.$dataContext = $dataContext;
                    this.$session = $session;
                    this.$editorId = $editorId;
                    this.$caret = $caret;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launchOnUi = (CoroutineScope)this.L$0;
                            if (FrontendAsyncEditorActionHandler.access$getTRAVERSAL_ACTIONS_IDS$cp().contains(FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0))) {
                                v0 = DocumentExKt.getTextControlModel(this.$editor);
                                v1 = v0 != null && (v0 = TextControlModelExKt.getHasTemplateTraversalPolicyExtension((TextControlModel)v0)) != null ? v0.getHasTemplateTraversalPolicy() : false;
                                if (v1) {
                                    v2 = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)this.$dataContext);
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"createFromDataContext(...)");
                                    event = v2;
                                    FrontendAsyncActionHost.Companion.getInstance(this.$session).execute(FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0), event);
                                    return Unit.INSTANCE;
                                }
                            }
                            deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                            v3 = (ActionContinuationHolder)BackendActionDelegationKt.getBACKEND_ACTION_CONTINUATION_KEY().getData(this.$dataContext);
                            if (v3 != null) {
                                v3.setContinuation(new ActionContinuation((CompletableDeferred<Unit>)deferred){
                                    final /* synthetic */ CompletableDeferred<Unit> $deferred;
                                    {
                                        this.$deferred = $deferred;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object await(Continuation<? super Unit> $completion) {
                                        if (!($completion instanceof doExecuteByStrategy.await.1)) ** GOTO lbl-1000
                                        var3_2 = $completion;
                                        if ((var3_2.label & -2147483648) != 0) {
                                            var3_2.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            $continuation = new ContinuationImpl(this, $completion){
                                                /* synthetic */ Object result;
                                                final /* synthetic */ doExecuteByStrategy.1 this$0;
                                                int label;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.await((Continuation<? super Unit>)((Continuation)this));
                                                }
                                            };
                                        }
                                        $result = $continuation.result;
                                        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch ($continuation.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                $continuation.label = 1;
                                                v0 = this.$deferred.await((Continuation)$continuation);
                                                if (v0 == var4_4) {
                                                    return var4_4;
                                                }
                                                ** GOTO lbl20
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl20:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                });
                            }
                            $this$service$iv = (ComponentManager)this.$session;
                            $i$f$service = false;
                            serviceClass$iv = CallEditorActionRequestFactory.class;
                            v4 = $this$service$iv.getService(serviceClass$iv);
                            if (v4 == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                            }
                            editorActionRequestFactory = (CallEditorActionRequestFactory)v4;
                            this.L$0 = $this$launchOnUi;
                            this.L$1 = deferred;
                            this.label = 1;
                            v5 = editorActionRequestFactory.createRequest(this.$editor, this.$editorId, FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0), this.$caret, FrontendAsyncEditorActionHandler.access$getBaseHandler$p(this.this$0), this.$dataContext, (Continuation<? super FrontendAsyncRequest>)((Continuation)this));
                            if (v5 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl38
                        }
                        case 1: {
                            deferred = (CompletableDeferred)this.L$1;
                            $this$launchOnUi = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl38:
                            // 2 sources

                            v6 = (FrontendAsyncRequest)v5;
                            if (v6 == null) {
                                $i$a$-run-FrontendAsyncEditorActionHandler$doExecuteByStrategy$1$request$1 = false;
                                deferred.complete((Object)Unit.INSTANCE);
                                return Unit.INSTANCE;
                            }
                            request = v6;
                            this.L$0 = deferred;
                            this.L$1 = null;
                            this.label = 2;
                            v7 = FrontendAsyncRequestExecutor.Companion.getInstance(this.$session).executeRequest(request, (Continuation<? super Unit>)((Continuation)this));
                            ** if (v7 != var9_2) goto lbl54
lbl53:
                            // 1 sources

                            return var9_2;
lbl54:
                            // 1 sources

                            ** GOTO lbl65
                        }
                        case 2: {
                            deferred = (CompletableDeferred)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
                            }
                            catch (CancellationException ce) {
                                deferred.cancel(ce);
                                return Unit.INSTANCE;
                            }
lbl65:
                            // 2 sources

                            deferred.complete((Object)Unit.INSTANCE);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
            AnActionEvent event = anActionEvent;
            FrontendAsyncActionHost.Companion.getInstance(session).execute(this.frontendId, event);
        }
    }

    private static final void doExecute$executeFrontend(FrontendAsyncEditorActionHandler this$0, Editor $editor, Caret $caret, DataContext $dataContext) {
        if (this$0.baseHandler.isEnabled($editor, $caret, $dataContext)) {
            this$0.baseHandler.execute($editor, $caret, $dataContext);
        }
    }

    public static final /* synthetic */ Set access$getTRAVERSAL_ACTIONS_IDS$cp() {
        return TRAVERSAL_ACTIONS_IDS;
    }

    public static final /* synthetic */ String access$getFrontendId$p(FrontendAsyncEditorActionHandler $this) {
        return $this.frontendId;
    }

    public static final /* synthetic */ EditorActionHandler access$getBaseHandler$p(FrontendAsyncEditorActionHandler $this) {
        return $this.baseHandler;
    }

    static {
        Object[] objectArray = new String[]{"EditorTab", "BraceOrQuoteOut", "EditorUnindentSelection", "EditorIndentSelection"};
        TRAVERSAL_ACTIONS_IDS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001JB\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u00a6@\u00a2\u0006\u0002\u0010\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/editor/Caret;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
    public static interface CallEditorActionRequestFactory {
        @Nullable
        public Object createRequest(@NotNull Editor var1, @NotNull TextControlId var2, @NotNull String var3, @Nullable Caret var4, @NotNull EditorActionHandler var5, @NotNull DataContext var6, @NotNull Continuation<? super FrontendAsyncRequest> var7);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$Companion;", "", "<init>", "()V", "TRAVERSAL_ACTIONS_IDS", "", "", "value", "", "isExecuting", "()Z", "getCallStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "actionId", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isExecuting() {
            return isExecuting;
        }

        @Nullable
        public final ActionCallStrategyKind getCallStrategy(@NotNull String actionId, @NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return (ActionCallStrategyKind)FrontendEditorActionHandlerStrategyCustomizer.Companion.getEP().computeSafeIfAny(arg_0 -> Companion.getCallStrategy$lambda$0(actionId, editor, caret, dataContext, arg_0));
        }

        private static final ActionCallStrategyKind getCallStrategy$lambda$0(String $actionId, Editor $editor, Caret $caret, DataContext $dataContext, FrontendEditorActionHandlerStrategyCustomizer customizer) {
            Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
            return customizer.getCustomStrategy($actionId, $editor, $caret, $dataContext);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/editor/Caret;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendAsyncEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,291:1\n45#2,2:292\n48#2,3:295\n51#2,2:303\n53#2,8:306\n25#3:294\n59#3:298\n37#3,2:299\n84#3,2:301\n86#3:305\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory\n*L\n248#1:292,2\n248#1:295,3\n248#1:303,2\n248#1:306,8\n248#1:294\n248#1:298\n248#1:299,2\n248#1:301,2\n248#1:305\n*E\n"})
    public static final class LocalCallEditorActionRequestFactory
    implements CallEditorActionRequestFactory {
        @NotNull
        private final ClientAppSession session;

        public LocalCallEditorActionRequestFactory(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final ClientAppSession getSession() {
            return this.session;
        }

        @Override
        @Nullable
        public Object createRequest(@NotNull Editor editor, @NotNull TextControlId editorId, @NotNull String frontendActionId, @Nullable Caret caret, @NotNull EditorActionHandler baseHandler, @NotNull DataContext dataContext, @NotNull Continuation<? super FrontendAsyncRequest> $completion) {
            FrontendAsyncRequestExecutor frontendAsyncRequestExecutor = FrontendAsyncRequestExecutor.Companion.getInstance(this.session);
            if (frontendAsyncRequestExecutor.getSpeculativeExecutionEnabled()) {
                ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor);
                Pair pair = EditorActionCommandInfo.Companion.capture(() -> LocalCallEditorActionRequestFactory.createRequest$lambda$2(this, frontendActionId, baseHandler, editor, caret, dataContext));
                RdPatch patch = (RdPatch)pair.component1();
                EditorActionCommandInfo info2 = (EditorActionCommandInfo)pair.component2();
                if (patch == null) {
                    if ((Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorTab") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorIndentSelection") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorUnindentSelection") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorEnter") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorBackSpace")) && RdActionsSupport.Companion.getInstance().hasBackendAction(frontendActionId)) {
                        return new PhantomCallEditorActionRequest(frontendActionId, editorId, info2);
                    }
                    return null;
                }
                return new FrontendCallEditorActionRequest(patch, editorId, frontendActionId, this.session, resetUndoHistoryToken, info2);
            }
            return new PhantomCallEditorActionRequest(frontendActionId, editorId, EditorActionCommandInfo.Companion.captureForPhantomRequest());
        }

        private static final Unit createRequest$lambda$2$lambda$1$lambda$0(EditorActionHandler $baseHandler, Editor $editor, Caret $caret, DataContext $dataContext) {
            $baseHandler.execute($editor, $caret, $dataContext);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private static final RdPatch createRequest$lambda$2(LocalCallEditorActionRequestFactory this$0, String $frontendActionId, EditorActionHandler $baseHandler, Editor $editor, Caret $caret, DataContext $dataContext) {
            RdPatch rdPatch;
            void $this$recordChanges$iv;
            PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(this$0.session);
            String description$iv = "Call editor action " + $frontendActionId;
            boolean $i$f$recordChanges = false;
            if ($this$recordChanges$iv.getHasActivePatch()) {
                void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                boolean $i$f$thisLogger = false;
                com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(PatchEngine.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
            }
            try {
                RdPatch rdPatch2;
                AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
                Throwable throwable = null;
                try {
                    Object object;
                    void $this$runAndLogException$iv$iv;
                    RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                    boolean bl5 = false;
                    boolean $i$f$fileLogger22 = false;
                    boolean $i$f$currentClassLogger = false;
                    Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                    com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(clazz$iv$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    com.intellij.openapi.diagnostic.Logger $i$f$fileLogger22 = logger;
                    boolean $i$f$runAndLogException = false;
                    void var15_22 = $this$runAndLogException$iv$iv;
                    try {
                        void $this$runAndLogException_u24lambda_u240$iv$iv = var15_22;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        ChangeScope $this$createRequest_u24lambda_u242_u24lambda_u241 = it$iv.getSession().getChangeScope();
                        boolean bl4 = false;
                        FrontendSpeculativeRequestRecordingListener.Companion.withListener(this$0.session, () -> LocalCallEditorActionRequestFactory.createRequest$lambda$2$lambda$1$lambda$0($baseHandler, $editor, $caret, $dataContext));
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable2) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    LoggerKt.getOrLogException((Object)object, (com.intellij.openapi.diagnostic.Logger)$this$runAndLogException$iv$iv);
                    rdPatch2 = it$iv.getSession().getPatch();
                }
                catch (Throwable bl5) {
                    try {
                        throwable = bl5;
                        throw bl5;
                    }
                    catch (Throwable bl5) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                        throw bl5;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                rdPatch = rdPatch2;
            }
            finally {
                if ($this$recordChanges$iv.getHasActivePatch()) {
                    void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                    boolean $i$f$thisLogger = false;
                    com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(PatchEngine.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                    while ($this$recordChanges$iv.getHasActivePatch()) {
                        $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                    }
                }
            }
            return rdPatch;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionCallStrategyKind.values().length];
            try {
                nArray[ActionCallStrategyKind.FrontendOnly.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.BackendWithFrontendUpdate.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.FrontendFirst.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.Backend.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.BackendWhenAvailableByHint.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

